/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.common;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wso2.carbon.dataservices.common.DBConstants;

public class RDBMSUtils {
    public static String getRDBMSEngine(String jdbcUrl) {
        Pattern p = Pattern.compile("jdbc:[a-zA-Z0-9]+");
        Matcher m = p.matcher(jdbcUrl);
        while (m.find()) {
            if ("jdbc:mysql".equals(m.group())) {
                return "mysql";
            }
            if ("jdbc:derby".equals(m.group())) {
                return "derby";
            }
            if ("jdbc:sqlserver".equals(m.group())) {
                return "mssqlserver";
            }
            if ("jdbc:oracle".equals(m.group())) {
                return "oracle";
            }
            if ("jdbc:db2".equals(m.group())) {
                return "db2";
            }
            if ("jdbc:hsqldb".equals(m.group())) {
                return "hsqldb";
            }
            if ("jdbc:postgresql".equals(m.group())) {
                return "postgresql";
            }
            if ("jdbc:sybase".equals(m.group())) {
                return "sybase";
            }
            if ("jdbc:h2".equals(m.group())) {
                return "h2";
            }
            if (!"jdbc:informix-sqli".equals(m.group())) continue;
            return "informix-sqli";
        }
        return "Generic";
    }

    public static int toIntTransactionIsolation(String isolation) {
        if (isolation != null && !"".equals(isolation)) {
            if ("TRANSACTION_NONE".equals(isolation)) {
                return 0;
            }
            if ("TRANSACTION_READ_COMMITTED".equals(isolation.trim())) {
                return 2;
            }
            if ("TRANSACTION_READ_UNCOMMITTED".equals(isolation.trim())) {
                return 1;
            }
            if ("TRANSACTION_REPEATABLE_READ".equals(isolation.trim())) {
                return 4;
            }
            if ("TRANSACTION_SERIALIZABLE".equals(isolation.trim())) {
                return 8;
            }
            return -1;
        }
        return -1;
    }

    public static String getRDBMSEngine4XADataSource(String xaDatasourceClass) {
        if ("com.mysql.jdbc.jdbc2.optional.MysqlXADataSource".indexOf(xaDatasourceClass) > -1) {
            return "mysql";
        }
        if ("org.apache.derby.jdbc.EmbeddedXADataSource".indexOf(xaDatasourceClass) > -1) {
            return "derby";
        }
        if ("com.microsoft.sqlserver.jdbc.SQLServerXADataSource".indexOf(xaDatasourceClass) > -1) {
            return "mssqlserver";
        }
        if ("oracle.jdbc.xa.client.OracleXADataSource".indexOf(xaDatasourceClass) > -1) {
            return "oracle";
        }
        if ("com.ibm.db2.jcc.DB2XADataSource".indexOf(xaDatasourceClass) > -1) {
            return "db2";
        }
        if ("org.hsqldb.jdbc.pool.JDBCXADataSource".indexOf(xaDatasourceClass) > -1) {
            return "hsqldb";
        }
        if ("org.postgresql.xa.PGXADataSource".indexOf(xaDatasourceClass) > -1) {
            return "postgresql";
        }
        if ("com.sybase.jdbc3.jdbc.SybXADataSource".indexOf(xaDatasourceClass) > -1) {
            return "sybase";
        }
        if ("org.h2.jdbcx.JdbcDataSource".indexOf(xaDatasourceClass) > -1) {
            return "h2";
        }
        if ("com.informix.jdbc.jdbc2.optional.InformixXADataSource".indexOf(xaDatasourceClass) > -1) {
            return "informix-sqli";
        }
        return "Generic";
    }

    public static boolean configPropContainsInV2(String propName) {
        return DBConstants.RDBMSv2ToV3Map.containsKey(propName);
    }

    public static String convertConfigPropFromV2toV3(String propName) {
        return DBConstants.RDBMSv2ToV3Map.get(propName);
    }

    public static Map<String, String> convertConfigPropsFromV2toV3(Map<String, String> props) {
        HashMap<String, String> newValueMap = new HashMap<String, String>();
        Iterator<Map.Entry<String, String>> itr = props.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<String, String> entry = itr.next();
            String oldPropName = entry.getKey();
            if (!RDBMSUtils.configPropContainsInV2(oldPropName)) continue;
            String newPropName = RDBMSUtils.convertConfigPropFromV2toV3(oldPropName);
            if (newPropName != null) {
                newValueMap.put(newPropName, props.get(oldPropName));
            }
            itr.remove();
        }
        props.putAll(newValueMap);
        return props;
    }
}

