/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.java2wsdl.TypeTable;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAny;
import org.apache.ws.commons.schema.XmlSchemaAttribute;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaForm;
import org.apache.ws.commons.schema.XmlSchemaImport;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.apache.ws.commons.schema.XmlSchemaUse;
import org.apache.ws.commons.schema.constants.Constants;
import org.apache.ws.commons.schema.utils.NamespaceMap;
import org.apache.ws.commons.schema.utils.NamespacePrefixList;
import org.wso2.carbon.dataservices.common.DBConstants;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.description.operation.Operation;
import org.wso2.carbon.dataservices.core.description.query.Query;
import org.wso2.carbon.dataservices.core.description.resource.Resource;
import org.wso2.carbon.dataservices.core.engine.CallQuery;
import org.wso2.carbon.dataservices.core.engine.CallableRequest;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.engine.OutputElement;
import org.wso2.carbon.dataservices.core.engine.OutputElementGroup;
import org.wso2.carbon.dataservices.core.engine.QueryParam;
import org.wso2.carbon.dataservices.core.engine.Result;
import org.wso2.carbon.dataservices.core.engine.StaticOutputElement;

public class DataServiceDocLitWrappedSchemaGenerator {
    private static final String DUMMY_NAME = "__dummy__";

    public static void populateServiceSchema(AxisService axisService) throws DataServiceFault {
        DataService dataservice = (DataService)axisService.getParameter("org.wso2.ws.dataservice.dataservice.obj").getValue();
        CommonParams cparams = new CommonParams(axisService, dataservice);
        List<List<Operation>> allOps = DataServiceDocLitWrappedSchemaGenerator.extractOperations(dataservice);
        List<Operation> normalOperations = allOps.get(0);
        List<Operation> batchOperations = allOps.get(1);
        List<List<Resource>> allResources = DataServiceDocLitWrappedSchemaGenerator.extractResources(dataservice);
        List<Resource> normalResources = allResources.get(0);
        List<Resource> batchResources = allResources.get(1);
        DataServiceDocLitWrappedSchemaGenerator.createAndStoreFaultElement(cparams);
        DataServiceDocLitWrappedSchemaGenerator.createAndStoreRequestStatusElement(cparams);
        DataServiceDocLitWrappedSchemaGenerator.createAndStoreDataServiceResponseElement(cparams);
        for (Operation normalOp : normalOperations) {
            DataServiceDocLitWrappedSchemaGenerator.processRequest(cparams, normalOp);
        }
        for (Operation batchOp : batchOperations) {
            DataServiceDocLitWrappedSchemaGenerator.processRequest(cparams, batchOp);
        }
        for (Resource resource : normalResources) {
            DataServiceDocLitWrappedSchemaGenerator.processRequest(cparams, resource);
        }
        for (Resource resource : batchResources) {
            DataServiceDocLitWrappedSchemaGenerator.processRequest(cparams, resource);
        }
        axisService.addSchema(cparams.getSchemaMap().values());
    }

    private static void processRequest(CommonParams cparams, CallableRequest request) throws DataServiceFault {
        DataServiceDocLitWrappedSchemaGenerator.processRequestInput(cparams, request);
        DataServiceDocLitWrappedSchemaGenerator.processRequestOutput(cparams, request);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void processRequestInput(CommonParams cparams, CallableRequest request) throws DataServiceFault {
        String requestName = request.getRequestName();
        AxisOperation axisOp = cparams.getAxisService().getOperation(new QName(requestName));
        CallQuery callQuery = request.getCallQuery();
        Query query = callQuery.getQuery();
        AxisMessage inMessage = axisOp.getMessage("In");
        if (inMessage == null) return;
        inMessage.setName(requestName + "Request");
        XmlSchemaElement inputElement = DataServiceDocLitWrappedSchemaGenerator.createElement(cparams, query.getInputNamespace(), requestName, true);
        XmlSchemaComplexType inputComplexType = DataServiceDocLitWrappedSchemaGenerator.createComplexType(cparams, query.getInputNamespace(), requestName, false);
        inputElement.setType((XmlSchemaType)inputComplexType);
        if (request.isBatchRequest()) {
            XmlSchemaElement nestedEl = new XmlSchemaElement();
            CallableRequest parentReq = request.getParentRequest();
            if (parentReq == null) throw new DataServiceFault("No parent operation for batch request: " + request.getRequestName());
            nestedEl.setRefName(cparams.getRequestInputElementMap().get(parentReq.getRequestName()));
            nestedEl.setMaxOccurs(Long.MAX_VALUE);
            DataServiceDocLitWrappedSchemaGenerator.addElementToComplexTypeSequence(cparams, inputComplexType, query.getInputNamespace(), nestedEl, false, false, false);
        } else {
            Map<String, CallQuery.WithParam> withParams = callQuery.getWithParams();
            if (callQuery.getWithParams().size() > 0) {
                for (QueryParam queryParam : query.getQueryParams()) {
                    CallQuery.WithParam tmpWithParam;
                    if (!"IN".equals(queryParam.getType()) && !"INOUT".equals(queryParam.getType()) || (tmpWithParam = withParams.get(queryParam.getName())) == null) continue;
                    XmlSchemaElement tmpEl = DataServiceDocLitWrappedSchemaGenerator.createInputEntryElement(cparams, query, queryParam, tmpWithParam);
                    DataServiceDocLitWrappedSchemaGenerator.addElementToComplexTypeSequence(cparams, inputComplexType, query.getInputNamespace(), tmpEl, false, false, false);
                }
            } else {
                XmlSchemaSequence emptySeq = new XmlSchemaSequence();
                inputComplexType.setParticle((XmlSchemaParticle)emptySeq);
            }
        }
        inMessage.setElementQName(inputElement.getQName());
        cparams.getRequestInputElementMap().put(request.getRequestName(), inMessage.getElementQName());
    }

    private static XmlSchemaElement createInputEntryElement(CommonParams cparams, Query query, QueryParam queryParam, CallQuery.WithParam withParam) {
        XmlSchemaElement element = DataServiceDocLitWrappedSchemaGenerator.createElement(cparams, query.getInputNamespace(), withParam.getOriginalName(), false);
        element.setSchemaTypeName(DBUtils.getSimpleSchemaTypeName(cparams.getTypeTable(), DBUtils.getJavaTypeFromSQLType(queryParam.getSqlType())));
        if ("ARRAY".equals(queryParam.getParamType())) {
            element.setMaxOccurs(Long.MAX_VALUE);
            element.setMinOccurs(0L);
        } else if (queryParam.getDefaultValue() != null) {
            element.setMinOccurs(0L);
        }
        element.setNillable(true);
        return element;
    }

    private static void processRequestOutput(CommonParams cparams, CallableRequest request) throws DataServiceFault {
        CallQuery callQuery = request.getCallQuery();
        if (!callQuery.getQuery().hasResult() && !request.isReturnRequestStatus()) {
            return;
        }
        AxisOperation axisOp = cparams.getAxisService().getOperation(new QName(request.getRequestName()));
        AxisMessage outMessage = axisOp.getMessage("Out");
        outMessage.setName(request.getRequestName() + "Response");
        if (request.isReturnRequestStatus()) {
            outMessage.setElementQName(new QName("http://ws.wso2.org/dataservice", "REQUEST_STATUS"));
            return;
        }
        Result result = callQuery.getQuery().getResult();
        if (result.isXsAny() || result.getResultType() == 1) {
            outMessage.setElementQName(new QName("http://ws.wso2.org/dataservice", "DATA_SERVICE_RESPONSE"));
            return;
        }
        XmlSchemaElement dummyParentElement = new XmlSchemaElement();
        dummyParentElement.setQName(new QName(result.getNamespace(), DUMMY_NAME));
        XmlSchema dummySchema = DataServiceDocLitWrappedSchemaGenerator.retrieveSchema(cparams, result.getNamespace());
        XmlSchemaComplexType dummyType = new XmlSchemaComplexType(dummySchema);
        dummyType.setName(DUMMY_NAME);
        dummyParentElement.setType((XmlSchemaType)dummyType);
        DataServiceDocLitWrappedSchemaGenerator.processCallQuery(cparams, dummyParentElement, callQuery);
        XmlSchemaElement resultEl = (XmlSchemaElement)((XmlSchemaSequence)dummyType.getParticle()).getItems().getItem(0);
        outMessage.setElementQName(resultEl.getRefName());
    }

    private static void processCallQuery(CommonParams cparams, XmlSchemaElement parentElement, CallQuery callQuery) throws DataServiceFault {
        XmlSchemaElement tmpElement;
        if (!callQuery.getQuery().hasResult()) {
            return;
        }
        Result result = callQuery.getQuery().getResult();
        XmlSchemaElement activeElement = parentElement;
        if (!DBUtils.isEmptyString(result.getElementName())) {
            tmpElement = DataServiceDocLitWrappedSchemaGenerator.getElement(cparams, result.getNamespace(), result.getElementName());
            if (tmpElement != null) {
                DataServiceDocLitWrappedSchemaGenerator.addToElement(cparams, activeElement, tmpElement, true, false, callQuery.isOptional());
                return;
            }
            activeElement = DataServiceDocLitWrappedSchemaGenerator.createAndAddToElement(cparams, activeElement, result.getElementName(), result.getNamespace(), true, false, callQuery.isOptional());
        }
        if (!DBUtils.isEmptyString(result.getRowName())) {
            tmpElement = DataServiceDocLitWrappedSchemaGenerator.getElement(cparams, result.getNamespace(), result.getRowName());
            if (tmpElement != null) {
                DataServiceDocLitWrappedSchemaGenerator.addToElement(cparams, activeElement, tmpElement, true, false, false);
                return;
            }
            activeElement = DataServiceDocLitWrappedSchemaGenerator.createAndAddToElement(cparams, activeElement, result.getRowName(), result.getNamespace(), false, false, callQuery.isOptional());
            activeElement.setMinOccurs(0L);
            activeElement.setMaxOccurs(Long.MAX_VALUE);
        }
        DataServiceDocLitWrappedSchemaGenerator.processElementGroup(cparams, activeElement, result.getDefaultElementGroup());
    }

    private static void processElementGroup(CommonParams cparams, XmlSchemaElement parentElement, OutputElementGroup elementGroup) throws DataServiceFault {
        XmlSchemaElement activeElement = parentElement;
        if (!DBUtils.isEmptyString(elementGroup.getName())) {
            XmlSchemaElement tmpElement = DataServiceDocLitWrappedSchemaGenerator.getElement(cparams, elementGroup.getNamespace(), elementGroup.getName());
            if (tmpElement != null) {
                if (elementGroup.getArrayName() == null) {
                    DataServiceDocLitWrappedSchemaGenerator.addToElement(cparams, activeElement, tmpElement, true, false, elementGroup.isOptional());
                } else {
                    DataServiceDocLitWrappedSchemaGenerator.addToElement(cparams, activeElement, tmpElement, true, true, elementGroup.isOptional());
                }
                return;
            }
            activeElement = elementGroup.getArrayName() != null ? DataServiceDocLitWrappedSchemaGenerator.createAndAddToElement(cparams, activeElement, elementGroup.getName(), elementGroup.getNamespace(), true, true, elementGroup.isOptional()) : DataServiceDocLitWrappedSchemaGenerator.createAndAddToElement(cparams, activeElement, elementGroup.getName(), elementGroup.getNamespace(), true, false, elementGroup.isOptional());
            if (elementGroup.getArrayName() != null) {
                activeElement.setMinOccurs(0L);
                activeElement.setMaxOccurs(Long.MAX_VALUE);
            }
        }
        for (StaticOutputElement attribute : elementGroup.getAttributeEntries()) {
            DataServiceDocLitWrappedSchemaGenerator.addAttributeToComplexType(DataServiceDocLitWrappedSchemaGenerator.extractElementSchemaType(cparams, activeElement), attribute.getName(), attribute.getXsdType());
        }
        for (OutputElement outEl : elementGroup.getAllElements()) {
            if (outEl instanceof StaticOutputElement) {
                StaticOutputElement tmpStaticEl = (StaticOutputElement)outEl;
                DataServiceDocLitWrappedSchemaGenerator.processStaticOutputElement(cparams, activeElement, tmpStaticEl);
                continue;
            }
            if (outEl instanceof CallQuery) {
                DataServiceDocLitWrappedSchemaGenerator.processCallQuery(cparams, activeElement, (CallQuery)outEl);
                continue;
            }
            if (!(outEl instanceof OutputElementGroup)) continue;
            DataServiceDocLitWrappedSchemaGenerator.processElementGroup(cparams, activeElement, (OutputElementGroup)outEl);
        }
    }

    private static void processStaticOutputElement(CommonParams cparams, XmlSchemaElement parentElement, StaticOutputElement staticEl) {
        XmlSchemaComplexType parentType = DataServiceDocLitWrappedSchemaGenerator.extractElementSchemaType(cparams, parentElement);
        boolean global = !parentElement.getQName().getNamespaceURI().equals(staticEl.getNamespace());
        XmlSchemaElement tmpSchemaEl = DataServiceDocLitWrappedSchemaGenerator.createElement(cparams, staticEl.getNamespace(), staticEl.getName(), global);
        if (staticEl.getArrayName() != null) {
            tmpSchemaEl.setMaxOccurs(Long.MAX_VALUE);
        } else {
            tmpSchemaEl.setMaxOccurs(1L);
        }
        tmpSchemaEl.setNillable(true);
        tmpSchemaEl.setSchemaTypeName(staticEl.getXsdType());
        if (staticEl.getArrayName() == null) {
            DataServiceDocLitWrappedSchemaGenerator.addElementToComplexTypeSequence(cparams, parentType, parentElement.getQName().getNamespaceURI(), tmpSchemaEl, global, false, staticEl.isOptional());
        } else {
            DataServiceDocLitWrappedSchemaGenerator.addElementToComplexTypeSequence(cparams, parentType, parentElement.getQName().getNamespaceURI(), tmpSchemaEl, global, true, staticEl.isOptional());
        }
    }

    private static XmlSchemaComplexType extractElementSchemaType(CommonParams cparams, XmlSchemaElement element) {
        XmlSchemaComplexType type = (XmlSchemaComplexType)element.getSchemaType();
        if (type == null) {
            type = cparams.getTypeMap().get(element.getSchemaTypeName());
        }
        return type;
    }

    private static XmlSchemaElement createAndAddToElement(CommonParams cparams, XmlSchemaElement parentElement, String name, String namespace, boolean global, boolean isArrayElement, boolean optional) {
        XmlSchemaElement tmpElement = DataServiceDocLitWrappedSchemaGenerator.createElement(cparams, namespace, name, global);
        XmlSchemaComplexType type = DataServiceDocLitWrappedSchemaGenerator.createComplexType(cparams, namespace, name, true);
        tmpElement.setSchemaTypeName(type.getQName());
        if (isArrayElement) {
            DataServiceDocLitWrappedSchemaGenerator.addToElement(cparams, parentElement, tmpElement, global, true, optional);
        } else {
            DataServiceDocLitWrappedSchemaGenerator.addToElement(cparams, parentElement, tmpElement, global, false, optional);
        }
        return tmpElement;
    }

    private static void addToElement(CommonParams cparams, XmlSchemaElement parentElement, XmlSchemaElement element, boolean elementRef, boolean isArrayElement, boolean optional) {
        if (!parentElement.getQName().getNamespaceURI().equals(element.getQName().getNamespaceURI())) {
            elementRef = true;
        }
        XmlSchemaComplexType type = DataServiceDocLitWrappedSchemaGenerator.extractElementSchemaType(cparams, parentElement);
        if (isArrayElement) {
            DataServiceDocLitWrappedSchemaGenerator.addElementToComplexTypeSequence(cparams, type, parentElement.getQName().getNamespaceURI(), element, elementRef, true, optional);
        } else {
            DataServiceDocLitWrappedSchemaGenerator.addElementToComplexTypeSequence(cparams, type, parentElement.getQName().getNamespaceURI(), element, elementRef, false, optional);
        }
    }

    private static void createAndStoreFaultElement(CommonParams cparams) {
        XmlSchemaElement element = DataServiceDocLitWrappedSchemaGenerator.createElement(cparams, "http://ws.wso2.org/dataservice", "DataServiceFault", true);
        XmlSchemaComplexType type = DataServiceDocLitWrappedSchemaGenerator.createComplexType(cparams, "http://ws.wso2.org/dataservice", "DataServiceFault", false);
        element.setType((XmlSchemaType)type);
        DataServiceDocLitWrappedSchemaGenerator.createAndAddSimpleStringElements(cparams, element, DBConstants.FaultParams.CURRENT_PARAMS, DBConstants.FaultParams.CURRENT_REQUEST_NAME, DBConstants.FaultParams.NESTED_EXCEPTION);
        XmlSchemaElement dataServiceElement = DataServiceDocLitWrappedSchemaGenerator.createElement(cparams, "http://ws.wso2.org/dataservice", DBConstants.FaultParams.SOURCE_DATA_SERVICE, false);
        XmlSchemaComplexType dataServiceComplexType = DataServiceDocLitWrappedSchemaGenerator.createComplexType(cparams, "http://ws.wso2.org/dataservice", DBConstants.FaultParams.SOURCE_DATA_SERVICE, false);
        DataServiceDocLitWrappedSchemaGenerator.addToElement(cparams, element, dataServiceElement, false, false, false);
        dataServiceElement.setType((XmlSchemaType)dataServiceComplexType);
        DataServiceDocLitWrappedSchemaGenerator.createAndAddSimpleStringElements(cparams, dataServiceElement, DBConstants.FaultParams.LOCATION, DBConstants.FaultParams.DEFAULT_NAMESPACE, DBConstants.FaultParams.DESCRIPTION, DBConstants.FaultParams.DATA_SERVICE_NAME);
        DataServiceDocLitWrappedSchemaGenerator.createAndAddSimpleStringElements(cparams, element, DBConstants.FaultParams.DS_CODE);
    }

    private static void createAndAddSimpleStringElements(CommonParams cparams, XmlSchemaElement parentElement, String ... elementNames) {
        for (String elementName : elementNames) {
            XmlSchemaElement tmpSchemaEl = DataServiceDocLitWrappedSchemaGenerator.createElement(cparams, "http://ws.wso2.org/dataservice", elementName, false);
            tmpSchemaEl.setNillable(false);
            tmpSchemaEl.setSchemaTypeName(Constants.XSD_STRING);
            DataServiceDocLitWrappedSchemaGenerator.addToElement(cparams, parentElement, tmpSchemaEl, false, false, false);
        }
    }

    private static void createAndStoreRequestStatusElement(CommonParams cparams) {
        XmlSchemaElement element = DataServiceDocLitWrappedSchemaGenerator.createElement(cparams, "http://ws.wso2.org/dataservice", "REQUEST_STATUS", true);
        element.setSchemaTypeName(Constants.XSD_STRING);
    }

    private static void createAndStoreDataServiceResponseElement(CommonParams cparams) {
        XmlSchemaElement element = DataServiceDocLitWrappedSchemaGenerator.createElement(cparams, "http://ws.wso2.org/dataservice", "DATA_SERVICE_RESPONSE", true);
        XmlSchemaComplexType type = DataServiceDocLitWrappedSchemaGenerator.createComplexType(cparams, "http://ws.wso2.org/dataservice", "DATA_SERVICE_RESPONSE", false);
        element.setType((XmlSchemaType)type);
        XmlSchemaAny anyEl = new XmlSchemaAny();
        anyEl.setMinOccurs(0L);
        XmlSchemaSequence seq = new XmlSchemaSequence();
        seq.getItems().add((XmlSchemaObject)anyEl);
        type.setParticle((XmlSchemaParticle)seq);
    }

    private static XmlSchemaElement createElement(CommonParams cparams, String namespace, String name, boolean global) {
        Map<QName, XmlSchemaElement> elementMap = cparams.getElementMap();
        if (name == null || namespace == null) {
            return new XmlSchemaElement();
        }
        QName qname = new QName(namespace, name);
        if (global && elementMap.containsKey(qname)) {
            int suffix = 1;
            while (elementMap.containsKey(new QName(namespace, name + ++suffix))) {
            }
            name = name + suffix;
            qname = new QName(namespace, name);
        }
        XmlSchemaElement element = new XmlSchemaElement();
        element.setQName(qname);
        element.setName(name);
        if (global) {
            elementMap.put(qname, element);
            XmlSchema schema = DataServiceDocLitWrappedSchemaGenerator.retrieveSchema(cparams, namespace);
            schema.getItems().add((XmlSchemaObject)element);
            schema.getElements().add(qname, (XmlSchemaObject)element);
        }
        return element;
    }

    private static XmlSchemaElement getElement(CommonParams cparams, String namespace, String name) {
        for (Map.Entry<QName, XmlSchemaElement> entry : cparams.getElementMap().entrySet()) {
            if (!entry.getKey().getLocalPart().equals(name) || !entry.getKey().getNamespaceURI().equals(namespace)) continue;
            return entry.getValue();
        }
        return null;
    }

    private static XmlSchemaComplexType createComplexType(CommonParams cparams, String namespace, String name, boolean global) {
        XmlSchema schema = DataServiceDocLitWrappedSchemaGenerator.retrieveSchema(cparams, namespace);
        XmlSchemaComplexType type = new XmlSchemaComplexType(schema);
        Map<QName, XmlSchemaComplexType> typeMap = cparams.getTypeMap();
        if (global) {
            QName qname = new QName(namespace, name);
            if (typeMap.containsKey(qname)) {
                int suffix = 1;
                while (typeMap.containsKey(new QName(namespace, name + ++suffix))) {
                }
                name = name + suffix;
                qname = new QName(namespace, name);
            }
            type.setName(name);
            cparams.getTypeMap().put(qname, type);
            schema.getItems().add((XmlSchemaObject)type);
            schema.getSchemaTypes().add(qname, (XmlSchemaObject)type);
        }
        return type;
    }

    private static void addAttributeToComplexType(XmlSchemaComplexType complexType, String name, QName xsdType) {
        XmlSchemaAttribute attr = new XmlSchemaAttribute();
        attr.setName(name);
        attr.setSchemaTypeName(xsdType);
        attr.setUse(new XmlSchemaUse("optional"));
        Iterator itr = complexType.getAttributes().getIterator();
        while (itr.hasNext()) {
            XmlSchemaAttribute tmpAttr = (XmlSchemaAttribute)itr.next();
            if (!tmpAttr.getName().equals(attr.getName())) continue;
            return;
        }
        complexType.getAttributes().add((XmlSchemaObject)attr);
    }

    private static void addElementToComplexTypeSequence(CommonParams cparams, XmlSchemaComplexType complexType, String complexTypeNS, XmlSchemaElement element, boolean elementRef, boolean isArrayElement, boolean optional) {
        XmlSchemaElement tmpElement;
        XmlSchemaSequence sequence;
        XmlSchemaParticle particle = complexType.getParticle();
        if (particle instanceof XmlSchemaSequence) {
            sequence = (XmlSchemaSequence)particle;
        } else {
            sequence = new XmlSchemaSequence();
            complexType.setParticle((XmlSchemaParticle)sequence);
        }
        if (elementRef) {
            tmpElement = new XmlSchemaElement();
            if (isArrayElement) {
                tmpElement.setMaxOccurs(Long.MAX_VALUE);
            }
            tmpElement.setRefName(element.getQName());
            DataServiceDocLitWrappedSchemaGenerator.resolveSchemaImports(cparams.getSchemaMap().get(complexTypeNS), tmpElement.getRefName().getNamespaceURI());
        } else {
            tmpElement = element;
        }
        tmpElement.setMinOccurs(optional ? 0L : 1L);
        sequence.getItems().add((XmlSchemaObject)tmpElement);
    }

    private static void resolveSchemaImports(XmlSchema hostSchema, String refNamespace) {
        if (!hostSchema.getTargetNamespace().equals(refNamespace)) {
            XmlSchemaImport schemaImport = new XmlSchemaImport();
            schemaImport.setNamespace(refNamespace);
            if (!DataServiceDocLitWrappedSchemaGenerator.containsSchemaImport(hostSchema, schemaImport)) {
                hostSchema.getItems().add((XmlSchemaObject)schemaImport);
            }
        }
    }

    private static boolean containsSchemaImport(XmlSchema schema, XmlSchemaImport schemaImport) {
        XmlSchemaObjectCollection list = schema.getItems();
        int c = list.getCount();
        for (int i = 0; i < c; ++i) {
            XmlSchemaObject obj = list.getItem(i);
            if (!(obj instanceof XmlSchemaImport) || !((XmlSchemaImport)obj).getNamespace().equals(schemaImport.getNamespace())) continue;
            return true;
        }
        return false;
    }

    private static List<List<Operation>> extractOperations(DataService dataservice) {
        ArrayList<Operation> normalOperations = new ArrayList<Operation>();
        ArrayList<Operation> batchOperations = new ArrayList<Operation>();
        for (String opName : dataservice.getOperationNames()) {
            Operation tmpOp = dataservice.getOperation(opName);
            if (tmpOp.isBatchRequest()) {
                batchOperations.add(tmpOp);
                continue;
            }
            normalOperations.add(tmpOp);
        }
        ArrayList<List<Operation>> allOps = new ArrayList<List<Operation>>();
        allOps.add(normalOperations);
        allOps.add(batchOperations);
        return allOps;
    }

    private static List<List<Resource>> extractResources(DataService dataservice) {
        ArrayList<Resource> normalResources = new ArrayList<Resource>();
        ArrayList<Resource> batchResources = new ArrayList<Resource>();
        for (Resource.ResourceID rid : dataservice.getResourceIds()) {
            Resource tmpRes = dataservice.getResource(rid);
            if (tmpRes.isBatchRequest()) {
                batchResources.add(tmpRes);
                continue;
            }
            normalResources.add(tmpRes);
        }
        ArrayList<List<Resource>> allResourses = new ArrayList<List<Resource>>();
        allResourses.add(normalResources);
        allResourses.add(batchResources);
        return allResourses;
    }

    private static XmlSchema retrieveSchema(CommonParams cparams, String namespace) {
        Map<String, XmlSchema> schemaMap = cparams.getSchemaMap();
        if (!schemaMap.containsKey(namespace)) {
            XmlSchema schema = new XmlSchema(namespace, cparams.getXmlSchemaCollection());
            schema.setNamespaceContext((NamespacePrefixList)new NamespaceMap());
            schemaMap.put(namespace, schema);
            schema.setElementFormDefault(new XmlSchemaForm("qualified"));
            schema.setAttributeFormDefault(new XmlSchemaForm("unqualified"));
        }
        return schemaMap.get(namespace);
    }

    public static class CommonParams {
        private AxisService axisService;
        private DataService dataservice;
        private Map<String, XmlSchema> schemaMap;
        private XmlSchemaCollection xmlSchemaCollection;
        private Map<QName, XmlSchemaElement> elementMap;
        private Map<QName, XmlSchemaComplexType> typeMap;
        private TypeTable typeTable = new TypeTable();
        private Map<String, QName> requestInputElementMap = new HashMap<String, QName>();

        public CommonParams(AxisService axisService, DataService dataservice) {
            this.schemaMap = new HashMap<String, XmlSchema>();
            this.xmlSchemaCollection = new XmlSchemaCollection();
            this.elementMap = new HashMap<QName, XmlSchemaElement>();
            this.typeMap = new HashMap<QName, XmlSchemaComplexType>();
            this.axisService = axisService;
            this.dataservice = dataservice;
        }

        public Map<String, QName> getRequestInputElementMap() {
            return this.requestInputElementMap;
        }

        public TypeTable getTypeTable() {
            return this.typeTable;
        }

        public AxisService getAxisService() {
            return this.axisService;
        }

        public DataService getDataService() {
            return this.dataservice;
        }

        public Map<String, XmlSchema> getSchemaMap() {
            return this.schemaMap;
        }

        public XmlSchemaCollection getXmlSchemaCollection() {
            return this.xmlSchemaCollection;
        }

        public Map<QName, XmlSchemaElement> getElementMap() {
            return this.elementMap;
        }

        public Map<QName, XmlSchemaComplexType> getTypeMap() {
            return this.typeMap;
        }
    }
}

