/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.wso2.carbon.dataservices.common.DBConstants;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.engine.ParamValue;

public class DataServiceFault
extends Exception {
    private static final long serialVersionUID = 1L;
    private String code;
    private String dsFaultMessage;
    private DataService sourceDataService;
    private String currentRequestName;
    private Map<String, ParamValue> currentParams;
    private Map<String, Object> propertyMap = new HashMap<String, Object>();

    public DataServiceFault(Exception nestedException, String code, String dsFaultMessage) {
        super(nestedException);
        this.code = code;
        this.dsFaultMessage = dsFaultMessage;
        if (this.code == null) {
            this.code = DataServiceFault.extractFaultCode(nestedException);
        }
    }

    public static OMElement extractFaultMessage(Throwable throwable) {
        if (throwable instanceof DataServiceFault) {
            if (throwable.getCause() instanceof XMLStreamException) {
                return DataServiceFault.extractFaultMessage(((XMLStreamException)throwable.getCause()).getNestedException());
            }
            OMFactory fac = OMAbstractFactory.getOMFactory();
            OMElement root = fac.createOMElement(new QName("http://ws.wso2.org/dataservice", "DataServiceFault"));
            OMNamespace ns = root.getNamespace();
            for (Map.Entry<String, Object> rootEntry : ((DataServiceFault)throwable).getPropertyMap().entrySet()) {
                OMElement keyElement = fac.createOMElement(rootEntry.getKey(), ns);
                if (rootEntry.getValue() instanceof Map) {
                    for (Map.Entry dataServiceEntry : ((Map)rootEntry.getValue()).entrySet()) {
                        OMElement dataServiceKeyElement = fac.createOMElement(dataServiceEntry.getKey().toString(), ns);
                        OMText dataServiceValueElement = fac.createOMText((OMContainer)dataServiceKeyElement, dataServiceEntry.getValue().toString());
                        dataServiceKeyElement.addChild((OMNode)dataServiceValueElement);
                        keyElement.addChild((OMNode)dataServiceKeyElement);
                    }
                } else {
                    OMText valueElement = fac.createOMText((OMContainer)keyElement, rootEntry.getValue().toString());
                    keyElement.addChild((OMNode)valueElement);
                }
                root.addChild((OMNode)keyElement);
            }
            return root;
        }
        if (throwable instanceof XMLStreamException) {
            return DataServiceFault.extractFaultMessage(((XMLStreamException)throwable).getNestedException());
        }
        if (throwable != null) {
            Throwable cause = throwable.getCause();
            if (cause != null) {
                return DataServiceFault.extractFaultMessage(cause);
            }
            return null;
        }
        return null;
    }

    public static String extractFaultCode(Throwable throwable) {
        if (throwable instanceof DataServiceFault) {
            return ((DataServiceFault)throwable).getCode();
        }
        if (throwable instanceof XMLStreamException) {
            return DataServiceFault.extractFaultCode(((XMLStreamException)throwable).getNestedException());
        }
        if (throwable != null) {
            Throwable cause = throwable.getCause();
            if (cause != null) {
                return DataServiceFault.extractFaultCode(cause);
            }
            return DBConstants.FaultCodes.UNKNOWN_ERROR;
        }
        return DBConstants.FaultCodes.UNKNOWN_ERROR;
    }

    public DataServiceFault(Exception nestedException) {
        this(nestedException, null, null);
    }

    public DataServiceFault(Exception nestedException, String dsFaultMessage) {
        this(nestedException, null, dsFaultMessage);
    }

    public DataServiceFault(String code, String dsFaultMessage) {
        this(null, code, dsFaultMessage);
    }

    public DataServiceFault(String dsFaultMessage) {
        this(null, null, dsFaultMessage);
    }

    public String getCode() {
        return this.code;
    }

    public String getDsFaultMessage() {
        return this.dsFaultMessage;
    }

    @Override
    public String getMessage() {
        return this.getFullMessage();
    }

    public String getFullMessage() {
        StringBuffer buff = new StringBuffer();
        if (this.getDsFaultMessage() != null) {
            buff.append("DS Fault Message: " + this.getDsFaultMessage() + "\n");
        }
        if (this.getCode() != null) {
            buff.append("DS Code: " + this.getCode() + "\n");
            this.getPropertyMap().put(DBConstants.FaultParams.DS_CODE, this.getCode());
        }
        if (this.getSourceDataService() != null) {
            buff.append("Source Data Service:-\n");
            buff.append(this.getSourceDataService().toString());
            HashMap<String, String> sourcePropertyMap = new HashMap<String, String>();
            sourcePropertyMap.put(DBConstants.FaultParams.DATA_SERVICE_NAME, this.getSourceDataService().getName());
            sourcePropertyMap.put(DBConstants.FaultParams.LOCATION, this.getSourceDataService().getRelativeDsLocation());
            sourcePropertyMap.put(DBConstants.FaultParams.DESCRIPTION, this.getSourceDataService().getDescription() != null ? this.getSourceDataService().getDescription() : "N/A");
            sourcePropertyMap.put(DBConstants.FaultParams.DEFAULT_NAMESPACE, this.getSourceDataService().getDefaultNamespace());
            this.getPropertyMap().put(DBConstants.FaultParams.SOURCE_DATA_SERVICE, sourcePropertyMap);
        }
        if (this.getCurrentRequestName() != null) {
            buff.append("Current Request Name: " + this.getCurrentRequestName() + "\n");
            this.getPropertyMap().put(DBConstants.FaultParams.CURRENT_REQUEST_NAME, this.getCurrentRequestName());
        }
        if (this.getCurrentParams() != null) {
            buff.append("Current Params: " + this.getCurrentParams() + "\n");
            this.getPropertyMap().put(DBConstants.FaultParams.CURRENT_PARAMS, this.getCurrentParams().toString());
        }
        if (this.getCause() != null) {
            buff.append("Nested Exception:-\n" + this.getCause() + "\n");
            this.getPropertyMap().put(DBConstants.FaultParams.NESTED_EXCEPTION, this.getCause().toString());
        }
        return buff.toString();
    }

    @Override
    public String toString() {
        return this.getFullMessage();
    }

    public Map<String, ParamValue> getCurrentParams() {
        return this.currentParams;
    }

    public void setCurrentParams(Map<String, ParamValue> currentParams) {
        this.currentParams = currentParams;
    }

    public String getCurrentRequestName() {
        return this.currentRequestName;
    }

    public void setCurrentRequestName(String currentRequestName) {
        this.currentRequestName = currentRequestName;
    }

    public DataService getSourceDataService() {
        return this.sourceDataService;
    }

    public void setSourceDataService(DataService sourceDataService) {
        this.sourceDataService = sourceDataService;
    }

    public Map<String, Object> getPropertyMap() {
        return this.propertyMap;
    }
}

