/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.dataservices.core.DataServiceConnection;

public class TLConnectionStore {
    private static final Log log = LogFactory.getLog(TLConnectionStore.class);
    private static ThreadLocal<Map<String, DataServiceConnection>> tlCons = new ThreadLocal<Map<String, DataServiceConnection>>(){

        @Override
        protected synchronized Map<String, DataServiceConnection> initialValue() {
            return new HashMap<String, DataServiceConnection>();
        }
    };

    private static String generateDataServiceConnectionMapId(String confidId, String user, int queryLevel) {
        String userSuffix = user != null ? " # " + user : " # #NULL#";
        return confidId + userSuffix + " # " + queryLevel;
    }

    public static void addConnection(String configId, String user, int queryLevel, DataServiceConnection connection) {
        Map<String, DataServiceConnection> conns = tlCons.get();
        conns.put(TLConnectionStore.generateDataServiceConnectionMapId(configId, user, queryLevel), connection);
    }

    public static DataServiceConnection getConnection(String configId, String user, int queryLevel) {
        Map<String, DataServiceConnection> conns = tlCons.get();
        return conns.get(TLConnectionStore.generateDataServiceConnectionMapId(configId, user, queryLevel));
    }

    public static void commitAll() {
        Map<String, DataServiceConnection> conns = tlCons.get();
        for (DataServiceConnection conn : conns.values()) {
            try {
                conn.commit();
            }
            catch (Exception e) {
                log.warn((Object)("Error in committing connection: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public static void commitNonXAConns() {
        Map<String, DataServiceConnection> conns = tlCons.get();
        for (DataServiceConnection conn : conns.values()) {
            if (conn.isXA()) continue;
            try {
                conn.commit();
            }
            catch (Exception e) {
                log.warn((Object)("Error in committing non-XA connection: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public static void rollbackAll() {
        Map<String, DataServiceConnection> conns = tlCons.get();
        for (DataServiceConnection conn : conns.values()) {
            try {
                conn.rollback();
            }
            catch (Exception e) {
                log.warn((Object)("Error in rolling back connection: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public static void rollbackNonXAConns() {
        Map<String, DataServiceConnection> conns = tlCons.get();
        for (DataServiceConnection conn : conns.values()) {
            if (conn.isXA()) continue;
            try {
                conn.rollback();
            }
            catch (Exception e) {
                log.warn((Object)("Error in rolling back non-XA connection: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public static void closeAll() {
        Map<String, DataServiceConnection> conns = tlCons.get();
        for (DataServiceConnection conn : conns.values()) {
            try {
                conn.close();
            }
            catch (Exception e) {
                log.error((Object)("Error in closing connection: " + e.getMessage()), (Throwable)e);
            }
        }
        conns.clear();
    }
}

