/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.admin;

import com.google.gdata.client.spreadsheet.SpreadsheetService;
import com.google.gdata.data.spreadsheet.CellFeed;
import com.google.gdata.util.AuthenticationException;
import com.google.gdata.util.ServiceException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.description.config.GSpreadConfig;
import org.wso2.carbon.dataservices.core.description.config.SQLCarbonDataSourceConfig;
import org.wso2.carbon.dataservices.core.description.query.QueryFactory;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.engine.DataServiceSerializer;
import org.wso2.carbon.dataservices.core.script.DSGenerator;
import org.wso2.carbon.dataservices.core.script.PaginatedTableInfo;
import org.wso2.carbon.dataservices.core.sqlparser.SQLParserUtil;
import org.wso2.carbon.utils.Pageable;

public class DataServiceAdmin
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(DataServiceAdmin.class);

    public String getDataServiceContentAsString(String serviceId) throws AxisFault {
        String filePath;
        AxisService axisService = this.getAxisConfig().getServiceForActivation(serviceId);
        StringBuffer fileContents = new StringBuffer();
        if (axisService != null) {
            filePath = ((DataService)axisService.getParameter("org.wso2.ws.dataservice.dataservice.obj").getValue()).getDsLocation();
        } else {
            URL repositoryURL = this.getAxisConfig().getRepository();
            String repositoryURLPath = repositoryURL.getPath();
            if (repositoryURLPath != null && !repositoryURLPath.endsWith("/")) {
                repositoryURLPath = repositoryURLPath + "/";
            }
            filePath = repositoryURLPath + "dataservices" + File.separator + serviceId + "." + "dbs";
        }
        if (filePath != null) {
            File config = new File(filePath);
            try {
                String str;
                FileReader fileReader = new FileReader(config);
                BufferedReader in = new BufferedReader(fileReader);
                while ((str = in.readLine()) != null) {
                    fileContents.append(str + "\n");
                }
                in.close();
            }
            catch (IOException e) {
                throw new AxisFault("Error while reading the contents from the service config file for service '" + serviceId + "'", (Throwable)e);
            }
        }
        return fileContents.toString();
    }

    protected String getDataServiceFileExtension() {
        ConfigurationContext configCtx = this.getConfigContext();
        String fileExtension = (String)configCtx.getProperty("local_org.wso2.ws.dataservice.db_service_extension");
        return fileExtension;
    }

    public void saveDataService(String serviceName, String serviceHierarchy, String serviceContents) throws AxisFault {
        String dataServiceFilePath;
        ConfigurationContext configCtx = this.getConfigContext();
        AxisConfiguration axisConfig = configCtx.getAxisConfiguration();
        AxisService axisService = axisConfig.getServiceForActivation(serviceName);
        if (serviceHierarchy == null) {
            serviceHierarchy = "";
        }
        if (axisService == null) {
            String axis2RepoDirectory = axisConfig.getRepository().getPath();
            String repoDirectory = (String)configCtx.getProperty("local_org.wso2.ws.dataservice.db_service_repo");
            String fileExtension = this.getDataServiceFileExtension();
            String dataServiceDirectory = axis2RepoDirectory + File.separator + repoDirectory + File.separator + serviceHierarchy;
            dataServiceFilePath = dataServiceDirectory + File.separator + serviceName + "." + fileExtension;
            File directory = new File(dataServiceDirectory);
            if (!directory.exists() && !directory.mkdirs()) {
                throw new AxisFault("Cannot create directory: " + directory.getAbsolutePath());
            }
        } else {
            dataServiceFilePath = ((DataService)axisService.getParameter("org.wso2.ws.dataservice.dataservice.obj").getValue()).getDsLocation();
            AxisServiceGroup axisServiceGroup = axisService.getAxisServiceGroup();
            axisServiceGroup.addParameter("keepServiceHistory", (Object)Boolean.TRUE.toString());
            axisServiceGroup.addParameter("preserveServiceHistory", (Object)Boolean.TRUE.toString());
            axisService.addParameter("keepServiceHistory", (Object)Boolean.TRUE.toString());
            axisService.addParameter("preserveServiceHistory", (Object)Boolean.TRUE.toString());
        }
        serviceContents = DBUtils.prettifyXML(serviceContents);
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(dataServiceFilePath));
            out.write(serviceContents);
            out.close();
        }
        catch (IOException e) {
            log.error((Object)("Error while saving " + serviceName), (Throwable)e);
            throw new AxisFault("Error occurred while writing the contents for the service config file for the new service " + serviceName, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String testJDBCConnection(String driverClass, String jdbcURL, String username, String password, String passwordAlias) {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        Connection connection = null;
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(tenantId);
            String resolvePwd = "";
            if (driverClass == null || driverClass.length() == 0) {
                String message = "Driver class is missing";
                log.debug((Object)message);
                String string = message;
                return string;
            }
            if (jdbcURL == null || jdbcURL.length() == 0) {
                String message = "Driver connection URL is missing";
                log.debug((Object)message);
                String string = message;
                return string;
            }
            resolvePwd = passwordAlias != null && !passwordAlias.equals("") ? DBUtils.loadFromSecureVault(passwordAlias) : password;
            Class.forName(driverClass.trim());
            connection = DriverManager.getConnection(jdbcURL, username, resolvePwd);
            String message = "Database connection is successfull with driver class " + driverClass + " , jdbc url " + jdbcURL + " and user name " + username;
            log.debug((Object)message);
            String string = message;
            return string;
        }
        catch (SQLException e) {
            String message = "Could not connect to database " + jdbcURL + " with username " + username;
            log.error((Object)message, (Throwable)e);
            String string = message;
            return string;
        }
        catch (ClassNotFoundException e) {
            String message = "Driver class " + driverClass + " can not be loaded";
            log.error((Object)message, (Throwable)e);
            String string = message;
            return string;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException ignored) {}
            }
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    public String testGSpreadConnection(String user, String password, String visibility, String documentURL, String passwordAlias) {
        String key;
        if (DBUtils.isEmptyString(documentURL)) {
            String message = "Document URL is empty";
            log.debug((Object)message);
            return message;
        }
        SpreadsheetService service = new SpreadsheetService("GSpread Connection Service");
        try {
            key = GSpreadConfig.extractKey(documentURL);
        }
        catch (DataServiceFault e) {
            String message = "Invalid documentURL:" + documentURL;
            log.error((Object)message, (Throwable)e);
            return message;
        }
        String resolvePwd = passwordAlias != null && !passwordAlias.equals("") ? DBUtils.loadFromSecureVault(passwordAlias) : password;
        if (!visibility.equals("public")) {
            if (DBUtils.isEmptyString(user)) {
                String message = "User name field is empty";
                log.error((Object)message);
                return message;
            }
            if (DBUtils.isEmptyString(resolvePwd)) {
                String message = "Password field is empty";
                log.error((Object)message);
                return message;
            }
            try {
                service.setUserCredentials(user, resolvePwd);
            }
            catch (AuthenticationException e) {
                String message = "Invalid User Credentials";
                log.error((Object)message, (Throwable)e);
                return message;
            }
        }
        String worksheetFeedURL = "https://spreadsheets.google.com/feeds/worksheets/" + key + "/" + visibility + "/basic";
        try {
            URL url = new URL(worksheetFeedURL);
            try {
                service.getFeed(url, CellFeed.class);
                String message = "Google spreadsheet connection is successfull ";
                log.debug((Object)message);
                return message;
            }
            catch (IOException e) {
                String message = "URL Not found:" + documentURL;
                log.error((Object)message, (Throwable)e);
                return message;
            }
            catch (ServiceException e) {
                String message = "URL Not found:" + documentURL;
                log.error((Object)message, (Throwable)e);
                return message;
            }
        }
        catch (MalformedURLException e) {
            String message = "Invalid documentURL:" + documentURL;
            log.error((Object)message, (Throwable)e);
            return message;
        }
    }

    public String[] getAvailableDS() throws AxisFault {
        ArrayList<String> serviceList = new ArrayList<String>();
        HashMap map = this.getAxisConfig().getServices();
        Set set = map.keySet();
        for (String serviceName : set) {
            AxisService axisService = this.getAxisConfig().getService(serviceName);
            Parameter parameter = axisService.getParameter("serviceType");
            if (parameter == null || !"data_service".equals(parameter.getValue().toString())) continue;
            serviceList.add(serviceName);
        }
        return serviceList.toArray(new String[serviceList.size()]);
    }

    public String[] getCarbonDataSourceNames() {
        List<String> list = SQLCarbonDataSourceConfig.getCarbonDataSourceNames();
        return list.toArray(new String[list.size()]);
    }

    public String[] getCarbonDataSourceNamesForTypes(String[] types) {
        List<String> list = SQLCarbonDataSourceConfig.getCarbonDataSourceNamesForType(types);
        return list.toArray(new String[list.size()]);
    }

    public String getCarbonDataSourceType(String dsName) {
        return SQLCarbonDataSourceConfig.getCarbonDataSourceType(dsName);
    }

    public String[] getOutputColumnNames(String sql) throws Exception {
        try {
            List<String> columns = SQLParserUtil.extractOutputColumns(sql);
            return columns.toArray(new String[columns.size()]);
        }
        catch (Exception e) {
            throw new AxisFault("Error occurred while generating response for the query " + sql + ".", (Throwable)e);
        }
    }

    public String[] getInputMappingNames(String sql) throws Exception {
        try {
            List<String> inputMappings = SQLParserUtil.extractInputMappingNames(sql);
            return inputMappings.toArray(new String[inputMappings.size()]);
        }
        catch (Exception e) {
            throw new AxisFault("Error occurred while generating input mappings for the query " + sql + ".", (Throwable)e);
        }
    }

    public String[] getdbSchemaList(String datasourceId) throws Exception {
        return DSGenerator.getSchemas(datasourceId);
    }

    public PaginatedTableInfo getPaginatedSchemaInfo(int pageNumber, String datasourceId) throws Exception {
        ArrayList temp = new ArrayList();
        Collections.addAll(temp, this.getdbSchemaList(datasourceId));
        PaginatedTableInfo paginatedTableInfo = new PaginatedTableInfo();
        DataServiceAdmin.doPaging(pageNumber, temp, paginatedTableInfo);
        return paginatedTableInfo;
    }

    public String[] getTableList(String datasourceId, String dbName, String[] schemas) throws AxisFault {
        try {
            return DSGenerator.getTableList(datasourceId, dbName, schemas);
        }
        catch (Exception e) {
            throw new AxisFault("Error in retrieving table list: " + e.getMessage(), (Throwable)e);
        }
    }

    public PaginatedTableInfo getPaginatedTableInfo(int pageNumber, String datasourceId, String dbName, String[] schemas) throws Exception {
        List<String> tableInfoList = Arrays.asList(this.getTableList(datasourceId, dbName, schemas));
        PaginatedTableInfo paginatedTableInfo = new PaginatedTableInfo();
        DataServiceAdmin.doPaging(pageNumber, tableInfoList, paginatedTableInfo);
        return paginatedTableInfo;
    }

    public String[] getDSServiceList(String dataSourceId, String dbName, String[] schemas, String[] tableNames, boolean singleService, String serviceNamespace) throws Exception {
        DSGenerator generator = new DSGenerator(dataSourceId, dbName, schemas, tableNames, false, serviceNamespace, "");
        ArrayList<String> serviceNames = new ArrayList<String>();
        List<DataService> dsList = generator.getGeneratedServiceList();
        for (DataService ds : dsList) {
            OMElement element = DataServiceSerializer.serializeDataService(ds);
            this.saveDataService(ds.getName(), null, element.toString());
            serviceNames.add(ds.getName());
        }
        return serviceNames.toArray(new String[serviceNames.size()]);
    }

    public String getDSService(String dataSourceId, String dbName, String[] schemas, String[] tableNames, boolean singleService, String serviceName, String serviceNamespace) throws Exception {
        DSGenerator generator = new DSGenerator(dataSourceId, dbName, schemas, tableNames, true, serviceNamespace, serviceName);
        DataService dataservice = generator.getGeneratedService();
        OMElement element = DataServiceSerializer.serializeDataService(dataservice);
        this.saveDataService(dataservice.getName(), null, element.toString());
        return generator.getGeneratedService().getName();
    }

    private static <C> List<C> doPaging(int pageNumber, List<C> sourceList, Pageable pageable) {
        if (pageNumber < 0 || pageNumber == Integer.MAX_VALUE) {
            pageNumber = 0;
        }
        if (sourceList.size() == 0) {
            return sourceList;
        }
        if (pageNumber < 0) {
            throw new RuntimeException("Page number should be a positive integer. Page numbers begin at 0.");
        }
        int itemsPerPageInt = 60;
        int numberOfPages = (int)Math.ceil((double)sourceList.size() / (double)itemsPerPageInt);
        if (pageNumber > numberOfPages - 1) {
            pageNumber = numberOfPages - 1;
        }
        int startIndex = pageNumber * itemsPerPageInt;
        int endIndex = (pageNumber + 1) * itemsPerPageInt;
        ArrayList<C> returnList = new ArrayList<C>();
        for (int i = startIndex; i < endIndex && i < sourceList.size(); ++i) {
            returnList.add(sourceList.get(i));
        }
        pageable.setNumberOfPages(numberOfPages);
        pageable.set(returnList);
        return returnList;
    }

    public String validateJSONMapping(String jsonMapping) {
        try {
            QueryFactory.getJSONResultFromText(jsonMapping);
            return "";
        }
        catch (DataServiceFault e) {
            return e.getDsFaultMessage();
        }
    }
}

