/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.custom.datasource;

import com.hp.hpl.jena.sparql.lib.org.json.JSONArray;
import com.hp.hpl.jena.sparql.lib.org.json.JSONObject;
import com.hp.hpl.jena.sparql.lib.org.json.JSONTokener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.custom.datasource.DataColumn;
import org.wso2.carbon.dataservices.core.custom.datasource.DataRow;
import org.wso2.carbon.dataservices.core.custom.datasource.DataTable;
import org.wso2.carbon.dataservices.core.custom.datasource.FixedDataRow;
import org.wso2.carbon.dataservices.core.custom.datasource.TabularDataBasedDS;

public class InMemoryDataSource
implements TabularDataBasedDS {
    public static final String IN_MEMORY_DATASOURCE_SCHEMA = "inmemory_datasource_schema";
    public static final String IN_MEMORY_DATASOURCE_RECORDS = "inmemory_datasource_records";
    private Map<String, InMemoryDataTable> dataTables = new ConcurrentHashMap<String, InMemoryDataTable>();
    private String dataSourceId;

    public Map<String, InMemoryDataTable> getDataTables() {
        return this.dataTables;
    }

    @Override
    public void init(Map<String, String> props) throws DataServiceFault {
        this.dataSourceId = props.get("__DATASOURCE_ID__");
        String schemaContents = props.get(IN_MEMORY_DATASOURCE_SCHEMA);
        if (!DBUtils.isEmptyString(schemaContents)) {
            this.createInitialSchema(schemaContents);
        }
        String recordContents = props.get(IN_MEMORY_DATASOURCE_RECORDS);
        if (!DBUtils.isEmptyString(schemaContents)) {
            this.populateInitialData(recordContents);
        }
    }

    private void createInitialSchema(String schemaContents) throws DataServiceFault {
        try {
            JSONObject obj = new JSONObject(new JSONTokener(schemaContents));
            for (String table : JSONObject.getNames((JSONObject)obj)) {
                ArrayList<DataColumn> columns = new ArrayList<DataColumn>();
                JSONArray colArray = obj.getJSONArray(table);
                for (int i = 0; i < colArray.length(); ++i) {
                    columns.add(new DataColumn(colArray.getString(i)));
                }
                this.createDataTable(table, columns);
            }
        }
        catch (Exception e) {
            throw new DataServiceFault(e, "Error in creating initial schema for In-Memory data source: " + e.getMessage());
        }
    }

    private void populateInitialData(String recordContents) throws DataServiceFault {
        try {
            JSONObject obj = new JSONObject(new JSONTokener(recordContents));
            for (String table : JSONObject.getNames((JSONObject)obj)) {
                JSONArray entryArray = obj.getJSONArray(table);
                for (int i = 0; i < entryArray.length(); ++i) {
                    JSONArray recordArray = entryArray.getJSONArray(i);
                    HashMap<String, String> rowValues = new HashMap<String, String>();
                    for (int j = 0; j < recordArray.length(); ++j) {
                        rowValues.put(this.getDataTable(table).getDataColumns().get(j).getName(), recordArray.get(j).toString());
                    }
                    this.getDataTable(table).insertData(new FixedDataRow(rowValues));
                }
            }
        }
        catch (Exception e) {
            throw new DataServiceFault(e, "Error in populating data for In-Memory data source: " + e.getMessage());
        }
    }

    public String getDataSourceId() {
        return this.dataSourceId;
    }

    @Override
    public Set<String> getDataTableNames() throws DataServiceFault {
        return this.getDataTables().keySet();
    }

    @Override
    public DataTable getDataTable(String name) throws DataServiceFault {
        return this.getDataTables().get(name);
    }

    @Override
    public void createDataTable(String name, List<DataColumn> columns) {
        this.getDataTables().put(name, new InMemoryDataTable(columns));
    }

    @Override
    public void dropDataTable(String name) {
        this.getDataTables().remove(name);
    }

    @Override
    public void close() {
    }

    public class InMemoryDataTable
    implements DataTable {
        private List<DataColumn> columns;
        private Map<Long, DataRow> data;
        private Lock writeLock = new ReentrantLock();
        private long currentRowId = 0L;

        public InMemoryDataTable(List<DataColumn> columns) {
            this.columns = columns;
            this.data = new HashMap<Long, DataRow>();
        }

        @Override
        public List<DataColumn> getDataColumns() {
            return this.columns;
        }

        public List<DataColumn> getColumns() {
            return this.columns;
        }

        public Map<Long, DataRow> getData() {
            return this.data;
        }

        @Override
        public Map<Long, DataRow> getData(long start, long length) throws DataServiceFault {
            int endIndex;
            HashMap<Long, DataRow> result = new HashMap<Long, DataRow>(this.getData());
            int rsize = result.size();
            if (length == -1L || length == Integer.MAX_VALUE) {
                endIndex = rsize;
            } else {
                endIndex = (int)(start + length);
                if (endIndex > rsize) {
                    endIndex = rsize;
                }
            }
            if (start == 0L && endIndex == rsize) {
                return result;
            }
            return this.subDataRowMap(result, start, endIndex);
        }

        private Map<Long, DataRow> subDataRowMap(Map<Long, DataRow> data, long start, long end) {
            ArrayList<Long> keys = new ArrayList<Long>(data.keySet());
            Collections.sort(keys);
            HashMap<Long, DataRow> result = new HashMap<Long, DataRow>();
            for (int i = (int)start; i < (int)end; ++i) {
                long key = (Long)keys.get(i);
                result.put(key, data.get(key));
            }
            return result;
        }

        @Override
        public Map<Long, DataRow> filterData(String column, Object value, TabularDataBasedDS.FilterOperator operator) throws DataServiceFault {
            HashMap<Long, DataRow> result = new HashMap<Long, DataRow>();
            for (Map.Entry<Long, DataRow> entry : this.data.entrySet()) {
                if (!this.evaluateCriteria(entry.getValue(), column, value, operator)) continue;
                result.put(entry.getKey(), entry.getValue());
            }
            return result;
        }

        private boolean evaluateCriteria(DataRow row, String column, Object value, TabularDataBasedDS.FilterOperator operator) throws DataServiceFault {
            String colValue = row.getValueAt(column);
            if (colValue == null) {
                return false;
            }
            switch (operator) {
                case EQUALS: {
                    if (colValue.equals(value)) break;
                    return false;
                }
                case GREATER_THAN: {
                    double lhs = Double.parseDouble(colValue.toString());
                    double rhs = Double.parseDouble(value.toString());
                    if (lhs > rhs) break;
                    return false;
                }
                case LESS_THAN: {
                    double lhs = Double.parseDouble(colValue.toString());
                    double rhs = Double.parseDouble(value.toString());
                    if (lhs < rhs) break;
                    return false;
                }
                default: {
                    throw new DataServiceFault("Unsupported operator: " + operator.toString());
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateData(Map<Long, DataRow> values) {
            this.writeLock.lock();
            try {
                this.getData().putAll(values);
            }
            finally {
                this.writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertData(DataRow ... values) {
            this.writeLock.lock();
            try {
                for (DataRow value : values) {
                    this.getData().put(this.currentRowId++, value);
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void deleteData(long ... ids) {
            this.writeLock.lock();
            try {
                for (long i : ids) {
                    this.getData().remove(i);
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }
}

