/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.description.config;

import au.com.bytecode.opencsv.CSVReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.description.config.Config;
import org.wso2.carbon.dataservices.core.engine.DataService;

public class CSVConfig
extends Config {
    private static final Log log = LogFactory.getLog(CSVConfig.class);
    public static final char DEFAULT_QUOTE_CHAR = '\"';
    private String csvDataSourcePath = this.getProperty("csv_datasource");
    private char columnSeparator;
    private int startingRow;
    private int headerRow;
    private int maxRowCount;
    private boolean hasHeader;
    private Map<Integer, String> columnMappings;

    public CSVConfig(DataService dataService, String configId, Map<String, String> properties) throws DataServiceFault {
        super(dataService, configId, "CSV", properties);
        String columnSeparatorStr = this.getProperty("csv_columnseperator");
        this.columnSeparator = this.extractColumnSeparator(columnSeparatorStr);
        String tmpStartingRow = this.getProperty("csv_startingrow");
        this.startingRow = tmpStartingRow != null ? Integer.parseInt(tmpStartingRow) : 1;
        String tmpMaxRowCount = this.getProperty("csv_maxrowcount");
        this.maxRowCount = tmpMaxRowCount != null ? Integer.parseInt(tmpMaxRowCount) : -1;
        String tmpHasHeader = this.getProperty("csv_hasheader");
        this.hasHeader = tmpHasHeader != null ? Boolean.parseBoolean(tmpHasHeader) : false;
        String tmpHeaderRow = this.getProperty("csv_headerrow");
        this.headerRow = tmpHeaderRow != null ? Integer.parseInt(tmpHeaderRow) : 1;
        try {
            this.columnMappings = DBUtils.createColumnMappings(this.getHeader());
        }
        catch (IOException e) {
            throw new DataServiceFault("Error in creating CSV column mappings.");
        }
    }

    private char extractColumnSeparator(String value) {
        if (DBUtils.isEmptyString(value)) {
            return ',';
        }
        if ((value = value.trim()).equals("\\t")) {
            return '\t';
        }
        if (value.equals("\\s")) {
            return ' ';
        }
        if (value.startsWith("\\u")) {
            try {
                return (char)Integer.parseInt(value.substring(2), 16);
            }
            catch (NumberFormatException e) {
                return ',';
            }
        }
        if (value.length() > 1) {
            return ',';
        }
        return value.charAt(0);
    }

    public CSVReader createCSVReader() throws IOException, DataServiceFault {
        return this.createCSVReader(this.getStartingRow() - 1);
    }

    private CSVReader createCSVReader(int skipLineNo) throws IOException, DataServiceFault {
        InputStream ins = DBUtils.getInputStreamFromPath(this.getCsvDataSourcePath());
        InputStreamReader insr = new InputStreamReader(ins);
        return new CSVReader((Reader)insr, this.getColumnSeparator(), '\"', skipLineNo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getHeader() throws IOException, DataServiceFault {
        if (!this.isHasHeader()) {
            return null;
        }
        CSVReader reader = null;
        try {
            reader = this.createCSVReader(this.getHeaderRow() - 1);
            String[] stringArray = reader.readNext();
            return stringArray;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error in closing CSV reader", (Throwable)e);
                }
            }
        }
    }

    public char getColumnSeparator() {
        return this.columnSeparator;
    }

    public String getCsvDataSourcePath() {
        return this.csvDataSourcePath;
    }

    public boolean isHasHeader() {
        return this.hasHeader;
    }

    public int getMaxRowCount() {
        return this.maxRowCount;
    }

    public int getStartingRow() {
        return this.startingRow;
    }

    public int getHeaderRow() {
        return this.headerRow;
    }

    public Map<Integer, String> getColumnMappings() {
        return this.columnMappings;
    }

    @Override
    public boolean isActive() {
        try {
            CSVReader reader = this.createCSVReader();
            reader.close();
            return true;
        }
        catch (Exception e) {
            log.error((Object)"Error in checking CSV config availability", (Throwable)e);
            return false;
        }
    }

    @Override
    public void close() {
    }
}

