/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.description.config;

import java.util.HashMap;
import java.util.Map;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.custom.datasource.CustomQueryBasedDS;
import org.wso2.carbon.dataservices.core.description.config.CustomQueryBasedDSConfig;
import org.wso2.carbon.dataservices.core.engine.DataService;

public class InlineCustomQueryBasedDSConfig
extends CustomQueryBasedDSConfig {
    private static final Log log = LogFactory.getLog(InlineCustomQueryBasedDSConfig.class);
    private CustomQueryBasedDS dataSource;

    public InlineCustomQueryBasedDSConfig(DataService dataService, String configId, Map<String, String> properties) throws DataServiceFault {
        super(dataService, configId, "CUSTOM_QUERY", properties);
        String dsClass = properties.get("custom_query_datasource_class");
        try {
            this.dataSource = (CustomQueryBasedDS)Class.forName(dsClass).newInstance();
            String dataSourcePropsString = properties.get("custom_datasource_props");
            Map<String, String> dsProps = dataSourcePropsString != null ? DBUtils.extractProperties(AXIOMUtil.stringToOM((String)dataSourcePropsString)) : new HashMap<String, String>();
            DBUtils.populateStandardCustomDSProps(dsProps, this.getDataService(), this);
            this.dataSource.init(dsProps);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating custom data source with info: #" + this.getDataService().getTenantId() + "#" + this.getDataService() + "#" + this.getConfigId()));
            }
        }
        catch (Exception e) {
            throw new DataServiceFault(e, "Error in creating custom data source config: " + e.getMessage());
        }
    }

    @Override
    public CustomQueryBasedDS getDataSource() {
        return this.dataSource;
    }

    @Override
    public boolean isActive() {
        return true;
    }
}

