/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.description.config;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jongo.Jongo;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.description.config.Config;
import org.wso2.carbon.dataservices.core.engine.DataService;

public class MongoConfig
extends Config {
    private static final Log log = LogFactory.getLog(MongoConfig.class);
    private MongoClient mongoClient;
    private String[] servers;
    private MongoClientOptions mongoClientOptions;
    private Jongo jongo;

    public MongoConfig(DataService dataService, String configId, Map<String, String> properties) throws DataServiceFault {
        super(dataService, configId, "MongoDB", properties);
        String serversParam = properties.get("mongoDB_servers");
        if (DBUtils.isEmptyString(serversParam)) {
            throw new DataServiceFault("The data source param 'mongoDB_servers' is required");
        }
        this.servers = serversParam.split(",");
        String database = properties.get("mongoDB_database");
        if (DBUtils.isEmptyString(database)) {
            throw new DataServiceFault("The data source param 'mongoDB_database' is required");
        }
        try {
            String readPref;
            this.mongoClientOptions = this.extractMongoOptions(properties);
            this.mongoClient = this.createNewMongo();
            String writeConcern = properties.get("mongoDB_write_concern");
            if (!DBUtils.isEmptyString(writeConcern)) {
                this.getMongoClient().setWriteConcern(WriteConcern.valueOf((String)writeConcern));
            }
            if (!DBUtils.isEmptyString(readPref = properties.get("mongoDB_read_preference"))) {
                this.getMongoClient().setReadPreference(ReadPreference.valueOf((String)readPref));
            }
            this.jongo = new Jongo(this.getMongoClient().getDB(database));
        }
        catch (Exception e) {
            throw new DataServiceFault(e);
        }
    }

    public MongoClient createNewMongo() throws DataServiceFault {
        try {
            return new MongoClient(this.createServerAddresses(this.getServers()), this.getMongoClientOptions());
        }
        catch (Exception e) {
            throw new DataServiceFault(e);
        }
    }

    @Override
    public boolean isActive() {
        try {
            MongoClient mon = this.createNewMongo();
            return mon != null;
        }
        catch (Exception e) {
            log.error((Object)"Error in checking Mongo config availability", (Throwable)e);
            return false;
        }
    }

    @Override
    public void close() {
    }

    private MongoClientOptions extractMongoOptions(Map<String, String> properties) {
        String threadsAllowedToBlockForConnectionMultiplier;
        String socketTimeout;
        String connectTimeout;
        String maxWaitTime;
        String connectionsPerHost;
        MongoClientOptions.Builder builder = new MongoClientOptions.Builder();
        String autoConnectRetry = properties.get("mongoDB_autoConnectRetry");
        if (!DBUtils.isEmptyString(autoConnectRetry)) {
            builder.autoConnectRetry(Boolean.parseBoolean(autoConnectRetry));
        }
        if (!DBUtils.isEmptyString(connectionsPerHost = properties.get("mongoDB_connectionsPerHost"))) {
            builder.connectionsPerHost(Integer.parseInt(connectionsPerHost));
        }
        if (!DBUtils.isEmptyString(maxWaitTime = properties.get("mongoDB_maxWaitTime"))) {
            builder.maxWaitTime(Integer.parseInt(maxWaitTime));
        }
        if (!DBUtils.isEmptyString(connectTimeout = properties.get("mongoDB_connectTimeout"))) {
            builder.connectTimeout(Integer.parseInt(connectTimeout));
        }
        if (!DBUtils.isEmptyString(socketTimeout = properties.get("mongoDB_socketTimeout"))) {
            builder.socketTimeout(Integer.parseInt(socketTimeout));
        }
        if (!DBUtils.isEmptyString(threadsAllowedToBlockForConnectionMultiplier = properties.get("mongoDB_threadsAllowedToBlockForConnectionMultiplier"))) {
            builder.threadsAllowedToBlockForConnectionMultiplier(Integer.parseInt(threadsAllowedToBlockForConnectionMultiplier));
        }
        return builder.build();
    }

    public MongoClient getMongoClient() {
        return this.mongoClient;
    }

    private List<ServerAddress> createServerAddresses(String[] servers) throws Exception {
        ArrayList<ServerAddress> result = new ArrayList<ServerAddress>();
        for (String server : servers) {
            String[] tmpAddr = server.split(":");
            if (tmpAddr.length == 2) {
                result.add(new ServerAddress(tmpAddr[0], Integer.parseInt(tmpAddr[1])));
                continue;
            }
            result.add(new ServerAddress(tmpAddr[0]));
        }
        return result;
    }

    public String[] getServers() {
        return this.servers;
    }

    public MongoClientOptions getMongoClientOptions() {
        return this.mongoClientOptions;
    }

    public Jongo getJongo() {
        return this.jongo;
    }
}

