/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.description.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.custom.datasource.CustomQueryDataSourceReader;
import org.wso2.carbon.dataservices.core.custom.datasource.CustomTabularDataSourceReader;
import org.wso2.carbon.dataservices.core.custom.datasource.TabularDataBasedDS;
import org.wso2.carbon.dataservices.core.description.config.SQLConfig;
import org.wso2.carbon.dataservices.core.description.config.TabularDataBasedConfig;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.internal.DataServicesDSComponent;
import org.wso2.carbon.ndatasource.common.DataSourceException;
import org.wso2.carbon.ndatasource.core.CarbonDataSource;
import org.wso2.carbon.ndatasource.core.DataSourceService;

public class SQLCarbonDataSourceConfig
extends SQLConfig {
    private static final Log log = LogFactory.getLog(SQLCarbonDataSourceConfig.class);
    private DataSource dataSource;
    private String dataSourceName;

    public SQLCarbonDataSourceConfig(DataService dataService, String configId, Map<String, String> properties) throws DataServiceFault {
        super(dataService, configId, "CARBON_DATASOURCE", properties);
        this.dataSourceName = properties.get("carbon_datasource_name");
        this.dataSource = this.initDataSource();
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    private DataSource initDataSource() throws DataServiceFault {
        DataSourceService dataSourceService = DataServicesDSComponent.getDataSourceService();
        if (dataSourceService == null) {
            throw new DataServiceFault("Carbon DataSource Service is not initialized properly");
        }
        try {
            CarbonDataSource cds = dataSourceService.getDataSource(this.getDataSourceName());
            if (cds == null) {
                throw new DataServiceFault("Cannot find data source with the name: " + this.getDataSourceName());
            }
            String dsType = cds.getDSMInfo().getDefinition().getType();
            if ("RDBMS".equals(dsType)) {
                Object result = cds.getDSObject();
                if (!(result instanceof DataSource)) {
                    throw new DataServiceFault("The data source '" + this.getDataSourceName() + "' is not of type RDBMS");
                }
                return (DataSource)result;
            }
            if (CustomTabularDataSourceReader.DATA_SOURCE_TYPE.equals(dsType)) {
                return new TabularDataBasedConfig.CustomSQLDataSource((TabularDataBasedDS)cds.getDSObject());
            }
            throw new DataServiceFault("The type '" + dsType + "' of data source '" + this.getDataSourceName() + "' is not supported in SQLCarbonDataSourceConfig");
        }
        catch (DataSourceException e) {
            throw new DataServiceFault((Exception)((Object)e), "Error in retrieving data source: " + e.getMessage());
        }
    }

    public static List<String> getCarbonDataSourceNames() {
        DataSourceService dataSourceService = DataServicesDSComponent.getDataSourceService();
        if (dataSourceService == null) {
            log.error((Object)"CarbonDataSourceConfig.getCarbonDataSourceNames(): Carbon data source service is not available, returning empty list");
            return new ArrayList<String>();
        }
        try {
            List dsList = dataSourceService.getAllDataSourcesForType("RDBMS");
            dsList.addAll(dataSourceService.getAllDataSourcesForType(CustomTabularDataSourceReader.DATA_SOURCE_TYPE));
            dsList.addAll(dataSourceService.getAllDataSourcesForType(CustomQueryDataSourceReader.DATA_SOURCE_TYPE));
            ArrayList<String> result = new ArrayList<String>(dsList.size());
            for (CarbonDataSource cds : dsList) {
                result.add(cds.getDSMInfo().getName());
            }
            return result;
        }
        catch (Exception e) {
            log.error((Object)("Error retrieving data source list, returning empty list: " + e.getMessage()), (Throwable)e);
            return new ArrayList<String>();
        }
    }

    public static List<String> getCarbonDataSourceNamesForType(String[] types) {
        DataSourceService dataSourceService = DataServicesDSComponent.getDataSourceService();
        if (dataSourceService == null) {
            log.error((Object)"CarbonDataSourceConfig.getCarbonDataSourceNames(): Carbon data source service is not available, returning empty list");
            return new ArrayList<String>();
        }
        try {
            ArrayList dsList = new ArrayList();
            for (String type : types) {
                dsList.addAll(dataSourceService.getAllDataSourcesForType(type));
            }
            ArrayList<String> result = new ArrayList<String>(dsList.size());
            for (CarbonDataSource cds : dsList) {
                result.add(cds.getDSMInfo().getName());
            }
            return result;
        }
        catch (Exception e) {
            log.error((Object)("Error retrieving data source list, returning empty list: " + e.getMessage()), (Throwable)e);
            return new ArrayList<String>();
        }
    }

    public static String getCarbonDataSourceType(String dsName) {
        DataSourceService dataSourceService = DataServicesDSComponent.getDataSourceService();
        if (dataSourceService == null) {
            log.error((Object)"CarbonDataSourceConfig.getCarbonDataSourceNames(): Carbon data source service is not available, returning empty type");
            return null;
        }
        try {
            CarbonDataSource carbonDataSource = dataSourceService.getDataSource(dsName);
            if (carbonDataSource == null) {
                log.error((Object)("Carbon datasource [" + dsName + "] is null"));
                return null;
            }
            return carbonDataSource.getDSMInfo().getDefinition().getType();
        }
        catch (Exception e) {
            log.error((Object)("Error retrieving data source type, returning empty type: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    @Override
    public int getActiveConnectionCount() {
        return -1;
    }

    @Override
    public int getIdleConnectionCount() {
        return -1;
    }

    @Override
    public boolean isStatsAvailable() {
        return false;
    }

    @Override
    public void close() {
    }
}

