/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.description.config;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.axiom.om.util.AXIOMUtil;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.custom.datasource.DataColumn;
import org.wso2.carbon.dataservices.core.custom.datasource.DataTable;
import org.wso2.carbon.dataservices.core.custom.datasource.FixedDataRow;
import org.wso2.carbon.dataservices.core.custom.datasource.TabularDataBasedDS;
import org.wso2.carbon.dataservices.core.description.config.SQLConfig;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.sql.driver.TConnectionFactory;
import org.wso2.carbon.dataservices.sql.driver.TCustomConnection;
import org.wso2.carbon.dataservices.sql.driver.processor.reader.DataCell;
import org.wso2.carbon.dataservices.sql.driver.processor.reader.DataRow;
import org.wso2.carbon.dataservices.sql.driver.query.ColumnInfo;

public class TabularDataBasedConfig
extends SQLConfig {
    private CustomSQLDataSource dataSource;

    public TabularDataBasedConfig(DataService dataService, String configId, Map<String, String> properties) throws DataServiceFault {
        super(dataService, configId, "CUSTOM_TABULAR", properties);
        String dsClass = properties.get("custom_tabular_datasource_class");
        try {
            TabularDataBasedDS customDS = (TabularDataBasedDS)Class.forName(dsClass).newInstance();
            String dataSourcePropsString = properties.get("custom_datasource_props");
            Map<String, String> dsProps = dataSourcePropsString != null ? DBUtils.extractProperties(AXIOMUtil.stringToOM((String)dataSourcePropsString)) : new HashMap<String, String>();
            DBUtils.populateStandardCustomDSProps(dsProps, this.getDataService(), this);
            customDS.init(dsProps);
            this.dataSource = new CustomSQLDataSource(customDS);
        }
        catch (Exception e) {
            throw new DataServiceFault(e, "Error in creating custom data source config: " + e.getMessage());
        }
    }

    @Override
    public DataSource getDataSource() throws DataServiceFault {
        return this.dataSource;
    }

    @Override
    public boolean isStatsAvailable() throws DataServiceFault {
        return false;
    }

    @Override
    public int getActiveConnectionCount() throws DataServiceFault {
        return -1;
    }

    @Override
    public int getIdleConnectionCount() throws DataServiceFault {
        return -1;
    }

    @Override
    public void close() {
        this.dataSource.close();
    }

    public static class CustomSQLDataSource
    implements DataSource {
        private PrintWriter logWriter;
        private int loginTimeout;
        private SQLParserCustomDataSourceAdapter dataSource;
        private Properties customDSProps;

        public CustomSQLDataSource(TabularDataBasedDS dataSource) {
            this.dataSource = new SQLParserCustomDataSourceAdapter(dataSource);
            this.customDSProps = new Properties();
            this.customDSProps.put("dsType", "CUSTOM");
            this.customDSProps.put("__CUSTOM_DATASOURCE__", this.dataSource);
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            return this.logWriter;
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return this.loginTimeout;
        }

        @Override
        public void setLogWriter(PrintWriter logWriter) throws SQLException {
            this.logWriter = logWriter;
        }

        @Override
        public void setLoginTimeout(int loginTimeout) throws SQLException {
            this.loginTimeout = loginTimeout;
        }

        @Override
        public boolean isWrapperFor(Class<?> arg0) throws SQLException {
            return false;
        }

        @Override
        public <T> T unwrap(Class<T> arg0) throws SQLException {
            return null;
        }

        @Override
        public Connection getConnection() throws SQLException {
            return TConnectionFactory.createConnection((String)"CUSTOM", (Properties)this.customDSProps);
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            return this.getConnection();
        }

        public void close() {
            this.dataSource.close();
        }

        public class SQLParserCustomDataSourceAdapter
        implements TCustomConnection.CustomDataSource {
            private TabularDataBasedDS customDS;

            public SQLParserCustomDataSourceAdapter(TabularDataBasedDS customDS) {
                this.customDS = customDS;
            }

            public void createDataTable(String name, Map<String, Integer> columns) throws SQLException {
                ArrayList<DataColumn> dataColumns = new ArrayList<DataColumn>();
                for (String key : columns.keySet()) {
                    dataColumns.add(new DataColumn(key));
                }
                this.customDS.createDataTable(name, dataColumns);
            }

            public void dropDataTable(String name) throws SQLException {
                this.customDS.dropDataTable(name);
            }

            public org.wso2.carbon.dataservices.sql.driver.processor.reader.DataTable getDataTable(String name) throws SQLException {
                try {
                    DataTable dataTable = this.customDS.getDataTable(name);
                    if (dataTable == null) {
                        throw new SQLException("The custom data table '" + name + "' does not exist");
                    }
                    return new SQLParserDataTableAdapter(name, dataTable);
                }
                catch (DataServiceFault e) {
                    throw new SQLException(e);
                }
            }

            public Set<String> getDataTableNames() throws SQLException {
                try {
                    return this.customDS.getDataTableNames();
                }
                catch (DataServiceFault e) {
                    throw new SQLException(e);
                }
            }

            public void init(Properties props) throws SQLException {
                try {
                    HashMap<String, String> dsProps = new HashMap<String, String>();
                    for (Map.Entry entry : dsProps.entrySet()) {
                        dsProps.put((String)entry.getKey(), (String)entry.getValue());
                    }
                    this.customDS.init(dsProps);
                }
                catch (DataServiceFault e) {
                    throw new SQLException(e);
                }
            }

            public void close() {
                this.customDS.close();
            }

            public class SQLParserDataTableAdapter
            extends org.wso2.carbon.dataservices.sql.driver.processor.reader.DataTable {
                private DataTable customDataTable;
                private String[] columns;
                private int[] types;

                public SQLParserDataTableAdapter(String tableName, DataTable customDataTable) throws DataServiceFault {
                    super(tableName, true);
                    this.customDataTable = customDataTable;
                    this.columns = new String[this.customDataTable.getDataColumns().size()];
                    this.types = new int[this.columns.length];
                    for (int i = 0; i < this.columns.length; ++i) {
                        this.columns[i] = this.customDataTable.getDataColumns().get(i).getName();
                        this.types[i] = 12;
                    }
                    this.setHeaders(this.generateHeaders());
                }

                public void addRow(DataRow row) throws SQLException {
                    try {
                        this.customDataTable.insertData(this.convertDataRow(row));
                    }
                    catch (DataServiceFault e) {
                        throw new SQLException(e);
                    }
                }

                private org.wso2.carbon.dataservices.core.custom.datasource.DataRow convertDataRow(DataRow row) {
                    HashMap<String, String> values = new HashMap<String, String>();
                    for (DataCell cell : row.getCells().values()) {
                        values.put(this.columns[cell.getColumnId()], cell.getCellValue().toString());
                    }
                    return new FixedDataRow(values);
                }

                private DataRow convertDataRow(int rowId, org.wso2.carbon.dataservices.core.custom.datasource.DataRow row) {
                    DataRow result = new DataRow(rowId);
                    for (int i = 0; i < this.types.length; ++i) {
                        int colId = i + 1;
                        result.addCell(colId, new DataCell(colId, this.types[i], (Object)row.getValueAt(this.columns[i])));
                    }
                    return result;
                }

                private TabularDataBasedDS.FilterOperator convertOperator(String operator) throws SQLException {
                    if ("=".equals(operator)) {
                        return TabularDataBasedDS.FilterOperator.EQUALS;
                    }
                    if (">".equals(operator)) {
                        return TabularDataBasedDS.FilterOperator.GREATER_THAN;
                    }
                    if ("<".equals(operator)) {
                        return TabularDataBasedDS.FilterOperator.LESS_THAN;
                    }
                    throw new SQLException("The operator '" + operator + "' is not supported by DS custom data sources");
                }

                public Map<Integer, DataRow> applyCondition(String column, String value, String operator) throws SQLException {
                    try {
                        TabularDataBasedDS.FilterOperator dsOp = this.convertOperator(operator);
                        HashMap<Integer, DataRow> result = new HashMap<Integer, DataRow>();
                        for (Map.Entry<Long, org.wso2.carbon.dataservices.core.custom.datasource.DataRow> row : this.customDataTable.filterData(column, value, dsOp).entrySet()) {
                            result.put(row.getKey().intValue(), this.convertDataRow(row.getKey().intValue(), row.getValue()));
                        }
                        return result;
                    }
                    catch (DataServiceFault e) {
                        throw new SQLException(e);
                    }
                }

                private ColumnInfo[] generateHeaders() throws DataServiceFault {
                    ColumnInfo[] headers = new ColumnInfo[this.customDataTable.getDataColumns().size()];
                    int i = 1;
                    for (DataColumn column : this.customDataTable.getDataColumns()) {
                        headers[i - 1] = new ColumnInfo(i, column.getName(), this.getTableName(), 12, i);
                        ++i;
                    }
                    return headers;
                }

                public Map<Integer, DataRow> getRows() throws SQLException {
                    try {
                        HashMap<Integer, DataRow> result = new HashMap<Integer, DataRow>();
                        for (Map.Entry<Long, org.wso2.carbon.dataservices.core.custom.datasource.DataRow> row : this.customDataTable.getData(0L, -1L).entrySet()) {
                            result.put(row.getKey().intValue(), this.convertDataRow(row.getKey().intValue(), row.getValue()));
                        }
                        return result;
                    }
                    catch (DataServiceFault e) {
                        throw new SQLException(e);
                    }
                }

                public void deleteRows(int ... rowIds) throws SQLException {
                    try {
                        long[] longIds = new long[rowIds.length];
                        for (int i = 0; i < rowIds.length; ++i) {
                            longIds[i] = rowIds[i];
                        }
                        this.customDataTable.deleteData(longIds);
                    }
                    catch (DataServiceFault e) {
                        throw new SQLException(e);
                    }
                }

                public void updateRows(DataRow ... data) throws SQLException {
                    HashMap<Long, org.wso2.carbon.dataservices.core.custom.datasource.DataRow> updateValues = new HashMap<Long, org.wso2.carbon.dataservices.core.custom.datasource.DataRow>();
                    for (DataRow row : data) {
                        updateValues.put(Long.valueOf(row.getRowId()), this.convertDataRow(row));
                    }
                    try {
                        this.customDataTable.updateData(updateValues);
                    }
                    catch (DataServiceFault e) {
                        throw new SQLException(e);
                    }
                }
            }
        }
    }
}

