/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.description.operation;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.description.operation.Operation;
import org.wso2.carbon.dataservices.core.description.query.QueryFactory;
import org.wso2.carbon.dataservices.core.engine.CallQuery;
import org.wso2.carbon.dataservices.core.engine.DataService;

public class OperationFactory {
    private OperationFactory() {
    }

    public static Operation createOperation(DataService dataService, OMElement opEl) throws DataServiceFault {
        String name = opEl.getAttributeValue(new QName("name"));
        OMElement descEl = opEl.getFirstChildWithName(new QName("description"));
        String description = null;
        if (descEl != null) {
            description = descEl.getText();
        }
        CallQuery callQuery = null;
        List<CallQuery> callQueries = QueryFactory.createCallQueries(dataService, opEl.getChildrenWithName(new QName("call-query")));
        if (callQueries.size() > 0) {
            callQuery = callQueries.get(0);
        }
        String disableStreamingRequestStr = opEl.getAttributeValue(new QName("disableStreaming"));
        boolean disableStreamingRequest = false;
        if (disableStreamingRequestStr != null) {
            disableStreamingRequest = Boolean.parseBoolean(disableStreamingRequestStr);
        }
        boolean disableStreamingEffective = disableStreamingRequest | dataService.isDisableStreaming();
        Operation operation = new Operation(dataService, name, description, callQuery, false, null, disableStreamingRequest, disableStreamingEffective);
        String returnReqStatusStr = opEl.getAttributeValue(new QName("returnRequestStatus"));
        boolean returnReqStatus = false;
        if (returnReqStatusStr != null) {
            returnReqStatus = Boolean.parseBoolean(returnReqStatusStr);
        }
        operation.setReturnRequestStatus(returnReqStatus);
        return operation;
    }

    public static Operation createBeginBoxcarOperation(DataService dataService) {
        CallQuery callQueries = QueryFactory.createEmptyBoxcarCallQuery(dataService);
        return new Operation(dataService, "begin_boxcar", "Control operation for beginning a boxcarring session", callQueries, false, null, false, false);
    }

    public static Operation createEndBoxcarOperation(DataService dataService) {
        CallQuery callQuery = QueryFactory.createEmptyBoxcarCallQuery(dataService);
        return new Operation(dataService, "end_boxcar", "Control operation for ending a boxcarring session", callQuery, false, null, false, false);
    }

    public static Operation createAbortBoxcarOperation(DataService dataService) {
        CallQuery callQuery = QueryFactory.createEmptyCallQuery(dataService);
        return new Operation(dataService, "abort_boxcar", "Control operation for aborting a boxcarring session", callQuery, false, null, false, false);
    }
}

