/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.description.query;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.apache.commons.codec.binary.Base64;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.description.config.CassandraConfig;
import org.wso2.carbon.dataservices.core.description.event.EventTrigger;
import org.wso2.carbon.dataservices.core.description.query.Query;
import org.wso2.carbon.dataservices.core.dispatch.DispatchStatus;
import org.wso2.carbon.dataservices.core.engine.DataEntry;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.engine.InternalParam;
import org.wso2.carbon.dataservices.core.engine.InternalParamCollection;
import org.wso2.carbon.dataservices.core.engine.ParamValue;
import org.wso2.carbon.dataservices.core.engine.QueryParam;
import org.wso2.carbon.dataservices.core.engine.Result;

public class CassandraQuery
extends Query {
    private CassandraConfig config;
    private PreparedStatement statement;
    private String query;
    private ThreadLocal<BatchStatement> batchStatement = new ThreadLocal<BatchStatement>(){

        @Override
        protected synchronized BatchStatement initialValue() {
            return null;
        }
    };

    public CassandraQuery(DataService dataService, String queryId, String query, List<QueryParam> queryParams, Result result, String configId, EventTrigger inputEventTrigger, EventTrigger outputEventTrigger, Map<String, String> advancedProperties, String inputNamespace) throws DataServiceFault {
        super(dataService, queryId, queryParams, result, configId, inputEventTrigger, outputEventTrigger, advancedProperties, inputNamespace);
        this.query = query;
        try {
            this.config = (CassandraConfig)this.getDataService().getConfig(this.getConfigId());
        }
        catch (ClassCastException e) {
            throw new DataServiceFault(e, "Configuration is not a Cassandra config:" + this.getConfigId());
        }
    }

    public String getQuery() {
        return this.query;
    }

    public PreparedStatement getStatement() {
        return this.statement;
    }

    public Session getSession() {
        return this.config.getSession();
    }

    public boolean isNativeBatchRequestsSupported() {
        return this.config.isNativeBatchRequestsSupported();
    }

    private BoundStatement bindParams(InternalParamCollection params) throws DataServiceFault {
        int count = params.getSize();
        ArrayList<Object> values = new ArrayList<Object>(count);
        for (int i = 1; i <= count; ++i) {
            InternalParam param = params.getParam(i);
            if (param.getSqlType().equals("STRING")) {
                values.add(param.getValue().toString());
                continue;
            }
            if (param.getSqlType().equals("BIGINT")) {
                values.add(Long.parseLong(param.getValue().getValueAsString()));
                continue;
            }
            if (param.getSqlType().equals("BINARY")) {
                values.add(this.base64DecodeByteBuffer(param.getValue().getValueAsString()));
                continue;
            }
            if (param.getSqlType().equals("BIT")) {
                values.add(Boolean.parseBoolean(param.getValue().getValueAsString()));
                continue;
            }
            if (param.getSqlType().equals("BLOB")) {
                values.add(this.base64DecodeByteBuffer(param.getValue().getValueAsString()));
                continue;
            }
            if (param.getSqlType().equals("BOOLEAN")) {
                values.add(Boolean.parseBoolean(param.getValue().getValueAsString()));
                continue;
            }
            if (param.getSqlType().equals("CHAR")) {
                values.add(param.getValue().getValueAsString());
                continue;
            }
            if (param.getSqlType().equals("CLOB")) {
                values.add(param.getValue().getValueAsString());
                continue;
            }
            if (param.getSqlType().equals("DATE")) {
                values.add(DBUtils.getDate(param.getValue().getValueAsString()));
                continue;
            }
            if (param.getSqlType().equals("DECIMAL")) {
                values.add(new BigDecimal(param.getValue().getValueAsString()));
                continue;
            }
            if (param.getSqlType().equals("DOUBLE")) {
                values.add(Double.parseDouble(param.getValue().getValueAsString()));
                continue;
            }
            if (param.getSqlType().equals("FLOAT")) {
                values.add(Float.valueOf(Float.parseFloat(param.getValue().getValueAsString())));
                continue;
            }
            if (param.getSqlType().equals("INTEGER")) {
                values.add(Integer.parseInt(param.getValue().getValueAsString()));
                continue;
            }
            if (param.getSqlType().equals("LONG")) {
                values.add(Long.parseLong(param.getValue().getValueAsString()));
                continue;
            }
            if (param.getSqlType().equals("LONG VARBINARY")) {
                values.add(this.base64DecodeByteBuffer(param.getValue().getValueAsString()));
                continue;
            }
            if (param.getSqlType().equals("NUMERIC")) {
                values.add(new BigDecimal(param.getValue().getValueAsString()));
                continue;
            }
            if (param.getSqlType().equals("NVARCHAR")) {
                values.add(param.getValue().getValueAsString());
                continue;
            }
            if (param.getSqlType().equals("QUERY_STRING")) {
                values.add(param.getValue().getValueAsString());
                continue;
            }
            if (param.getSqlType().equals("REAL")) {
                values.add(Float.valueOf(Float.parseFloat(param.getValue().getValueAsString())));
                continue;
            }
            if (param.getSqlType().equals("SMALLINT")) {
                values.add(Integer.parseInt(param.getValue().getValueAsString()));
                continue;
            }
            if (param.getSqlType().equals("TEXT")) {
                values.add(param.getValue().getValueAsString());
                continue;
            }
            if (param.getSqlType().equals("TIME")) {
                values.add(DBUtils.getDate(param.getValue().getValueAsString()));
                continue;
            }
            if (param.getSqlType().equals("TIMESTAMP")) {
                values.add(DBUtils.getDate(param.getValue().getValueAsString()));
                continue;
            }
            if (param.getSqlType().equals("TINYINT")) {
                values.add(Integer.parseInt(param.getValue().getValueAsString()));
                continue;
            }
            if (param.getSqlType().equals("VARBINARY")) {
                values.add(this.base64DecodeByteBuffer(param.getValue().getValueAsString()));
                continue;
            }
            if (param.getSqlType().equals("VARCHAR")) {
                values.add(param.getValue().getValueAsString());
                continue;
            }
            if (param.getSqlType().equals("VARINT")) {
                values.add(new BigInteger(param.getValue().getValueAsString()));
                continue;
            }
            if (param.getSqlType().equals("UUID")) {
                values.add(UUID.fromString(param.getValue().getValueAsString()));
                continue;
            }
            if (!param.getSqlType().equals("INETADDRESS")) continue;
            try {
                values.add(InetAddress.getByName(param.getValue().getValueAsString()));
                continue;
            }
            catch (UnknownHostException e) {
                throw new DataServiceFault(e);
            }
        }
        return this.getStatement().bind(values.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndCreateStatement() throws DataServiceFault {
        if (this.statement == null) {
            CassandraQuery cassandraQuery = this;
            synchronized (cassandraQuery) {
                if (this.statement == null) {
                    Session session = this.getSession();
                    this.statement = session.prepare(this.getQuery());
                }
            }
        }
    }

    @Override
    public Object runPreQuery(InternalParamCollection params, int queryLevel) throws DataServiceFault {
        ResultSet rs = null;
        this.checkAndCreateStatement();
        if (DispatchStatus.isBatchRequest() && this.isNativeBatchRequestsSupported()) {
            if (DispatchStatus.isFirstBatchRequest()) {
                this.batchStatement.set(new BatchStatement());
            }
            this.batchStatement.get().add((Statement)this.bindParams(params));
            if (DispatchStatus.isLastBatchRequest()) {
                this.getSession().execute((Statement)this.batchStatement.get());
            }
        } else {
            rs = this.getSession().execute((Statement)this.bindParams(params));
        }
        return rs;
    }

    @Override
    public void runPostQuery(Object result, XMLStreamWriter xmlWriter, InternalParamCollection params, int queryLevel) throws DataServiceFault {
        ResultSet rs = (ResultSet)result;
        if (this.hasResult()) {
            Iterator itr = rs.iterator();
            ColumnDefinitions defs = rs.getColumnDefinitions();
            while (itr.hasNext()) {
                Row row = (Row)itr.next();
                DataEntry dataEntry = this.getDataEntryFromRow(row, defs);
                this.writeResultEntry(xmlWriter, dataEntry, params, queryLevel);
            }
        }
    }

    private DataEntry getDataEntryFromRow(Row row, ColumnDefinitions defs) throws DataServiceFault {
        boolean useColumnNumbers = this.isUsingColumnNumbers();
        DataEntry entry = new DataEntry();
        ParamValue paramValue = null;
        for (int i = 0; i < defs.size(); ++i) {
            DataType columnType = defs.getType(i);
            if (columnType.getName().equals((Object)DataType.Name.ASCII)) {
                paramValue = new ParamValue(row.getString(i));
            } else if (columnType.getName().equals((Object)DataType.Name.VARCHAR)) {
                paramValue = new ParamValue(row.getString(i));
            } else if (columnType.getName().equals((Object)DataType.Name.TEXT)) {
                paramValue = new ParamValue(row.getString(i));
            } else if (columnType.getName().equals((Object)DataType.Name.BIGINT)) {
                paramValue = new ParamValue(Long.toString(row.getLong(i)));
            } else if (columnType.getName().equals((Object)DataType.Name.BLOB)) {
                paramValue = new ParamValue(this.base64EncodeByteBuffer(row.getBytes(i)));
            } else if (columnType.getName().equals((Object)DataType.Name.BOOLEAN)) {
                paramValue = new ParamValue(Boolean.toString(row.getBool(i)));
            } else if (columnType.getName().equals((Object)DataType.Name.COUNTER)) {
                paramValue = new ParamValue(Long.toString(row.getLong(i)));
            } else if (columnType.getName().equals((Object)DataType.Name.CUSTOM)) {
                paramValue = new ParamValue(this.base64EncodeByteBuffer(row.getBytes(i)));
            } else if (columnType.getName().equals((Object)DataType.Name.DECIMAL)) {
                paramValue = new ParamValue(row.getDecimal(i).toString());
            } else if (columnType.getName().equals((Object)DataType.Name.DOUBLE)) {
                paramValue = new ParamValue(Double.toString(row.getDouble(i)));
            } else if (columnType.getName().equals((Object)DataType.Name.FLOAT)) {
                paramValue = new ParamValue(Float.toString(row.getFloat(i)));
            } else if (columnType.getName().equals((Object)DataType.Name.INET)) {
                paramValue = new ParamValue(row.getInet(i).toString());
            } else if (columnType.getName().equals((Object)DataType.Name.INT)) {
                paramValue = new ParamValue(Integer.toString(row.getInt(i)));
            } else if (columnType.getName().equals((Object)DataType.Name.LIST)) {
                paramValue = new ParamValue(Arrays.toString(row.getList(i, Object.class).toArray()));
            } else if (columnType.getName().equals((Object)DataType.Name.MAP)) {
                paramValue = new ParamValue(row.getMap(i, Object.class, Object.class).toString());
            } else if (columnType.getName().equals((Object)DataType.Name.SET)) {
                paramValue = new ParamValue(row.getSet(i, Object.class).toString());
            } else if (columnType.getName().equals((Object)DataType.Name.TIMESTAMP)) {
                paramValue = new ParamValue(ConverterUtil.convertToString((Date)row.getDate(i)));
            } else if (columnType.getName().equals((Object)DataType.Name.TIMEUUID)) {
                paramValue = new ParamValue(row.getUUID(i).toString());
            } else if (columnType.getName().equals((Object)DataType.Name.UUID)) {
                paramValue = new ParamValue(row.getUUID(i).toString());
            } else if (columnType.getName().equals((Object)DataType.Name.VARINT)) {
                paramValue = new ParamValue(row.getVarint(i).toString());
            }
            entry.addValue(useColumnNumbers ? Integer.toString(i) : defs.getName(i), paramValue);
        }
        return entry;
    }

    private String base64EncodeByteBuffer(ByteBuffer byteBuffer) throws DataServiceFault {
        byte[] data = byteBuffer.array();
        byte[] base64Data = Base64.encodeBase64((byte[])data);
        try {
            return new String(base64Data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new DataServiceFault(e, "Error in encoding result binary data: " + e.getMessage());
        }
    }

    private ByteBuffer base64DecodeByteBuffer(String data) throws DataServiceFault {
        try {
            byte[] buff = Base64.decodeBase64((byte[])data.getBytes("UTF-8"));
            ByteBuffer result = ByteBuffer.allocate(buff.length);
            result.put(buff);
            return result;
        }
        catch (UnsupportedEncodingException e) {
            throw new DataServiceFault(e, "Error in decoding input base64 data: " + e.getMessage());
        }
    }
}

