/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.description.query;

import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamWriter;
import org.jongo.Jongo;
import org.jongo.MongoCollection;
import org.jongo.ResultHandler;
import org.jongo.Update;
import org.wso2.carbon.dataservices.common.DBConstants;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.custom.datasource.DataColumn;
import org.wso2.carbon.dataservices.core.custom.datasource.DataRow;
import org.wso2.carbon.dataservices.core.custom.datasource.FixedDataRow;
import org.wso2.carbon.dataservices.core.custom.datasource.QueryResult;
import org.wso2.carbon.dataservices.core.description.config.MongoConfig;
import org.wso2.carbon.dataservices.core.description.event.EventTrigger;
import org.wso2.carbon.dataservices.core.description.query.Query;
import org.wso2.carbon.dataservices.core.engine.DataEntry;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.engine.InternalParam;
import org.wso2.carbon.dataservices.core.engine.InternalParamCollection;
import org.wso2.carbon.dataservices.core.engine.ParamValue;
import org.wso2.carbon.dataservices.core.engine.QueryParam;
import org.wso2.carbon.dataservices.core.engine.Result;

public class MongoQuery
extends Query {
    private MongoConfig config;
    private String expression;

    public MongoQuery(DataService dataService, String queryId, String configId, String expression, List<QueryParam> queryParams, Result result, EventTrigger inputEventTrigger, EventTrigger outputEventTrigger, Map<String, String> advancedProperties, String inputNamespace) throws DataServiceFault {
        super(dataService, queryId, queryParams, result, configId, inputEventTrigger, outputEventTrigger, advancedProperties, inputNamespace);
        try {
            this.expression = expression;
            this.config = (MongoConfig)this.getDataService().getConfig(this.getConfigId());
        }
        catch (ClassCastException e) {
            throw new DataServiceFault(e, "Configuration is not a Mongo config:" + this.getConfigId());
        }
    }

    @Override
    public Object runPreQuery(InternalParamCollection params, int queryLevel) throws DataServiceFault {
        try {
            return new MongoQueryResult(this.getExpression(), new ArrayList<InternalParam>(params.getParams()));
        }
        catch (Exception e) {
            throw new DataServiceFault(e, "Error in MongoQuery.runQuery: " + e.getMessage());
        }
    }

    @Override
    public void runPostQuery(Object result, XMLStreamWriter xmlWriter, InternalParamCollection params, int queryLevel) throws DataServiceFault {
        QueryResult queryResult = (QueryResult)result;
        List<DataColumn> columns = queryResult != null ? queryResult.getDataColumns() : null;
        String[] columnMappings = this.createColumnsMappings(columns);
        int count = columns != null ? columns.size() : 0;
        boolean useColumnNumbers = this.isUsingColumnNumbers();
        while (queryResult != null && queryResult.hasNext()) {
            DataEntry dataEntry = new DataEntry();
            DataRow currentRow = queryResult.next();
            for (int i = 0; i < count; ++i) {
                String columnName = useColumnNumbers ? Integer.toString(i + 1) : columnMappings[i];
                String tmpVal = currentRow.getValueAt(columnName);
                dataEntry.addValue(columnName, new ParamValue(tmpVal));
            }
            this.writeResultEntry(xmlWriter, dataEntry, params, queryLevel);
        }
    }

    private String[] createColumnsMappings(List<DataColumn> columns) {
        String[] result = new String[columns.size()];
        int count = columns.size();
        for (int i = 0; i < count; ++i) {
            result[i] = columns.get(i).getName();
        }
        return result;
    }

    public MongoConfig getConfig() {
        return this.config;
    }

    public String getExpression() {
        return this.expression;
    }

    private Object[] decodeQuery(String query) throws DataServiceFault {
        DBConstants.MongoDB.MongoOperation mongoOp;
        int i1 = query.indexOf(46);
        if (i1 == -1) {
            throw new DataServiceFault("The MongoDB Collection not specified in the query '" + query + "'");
        }
        String collection = query.substring(0, i1).trim();
        int i2 = query.indexOf(40, i1);
        if (i2 == -1 || i2 - i1 <= 1) {
            throw new DataServiceFault("Invalid MongoDB operation in the query '" + query + "'");
        }
        String operation = query.substring(i1 + 1, i2).trim();
        int i3 = query.lastIndexOf(41);
        if (i3 == -1) {
            throw new DataServiceFault("Invalid MongoDB operation in the query '" + query + "'");
        }
        String opQuery = null;
        if (i3 - i2 > 1) {
            opQuery = query.substring(i2 + 1, i3).trim();
        }
        if ((mongoOp = this.convertToMongoOp(operation)) == DBConstants.MongoDB.MongoOperation.UPDATE) {
            ArrayList<Object> result = new ArrayList<Object>();
            result.add(collection);
            result.add(mongoOp);
            result.addAll(this.parseInsertQuery(opQuery));
            return result.toArray();
        }
        return new Object[]{collection, mongoOp, this.checkAndCleanOpQuery(opQuery)};
    }

    private String checkAndCleanOpQuery(String opQuery) throws DataServiceFault {
        if (opQuery == null) {
            return null;
        }
        int a = 0;
        int b = 0;
        if (opQuery.startsWith("'") || opQuery.startsWith("\"")) {
            a = 1;
        }
        if (opQuery.endsWith("'") || opQuery.endsWith("\"")) {
            b = 1;
        }
        return opQuery.substring(a, opQuery.length() - b);
    }

    private List<Object> parseInsertQuery(String opQuery) throws DataServiceFault {
        ArrayList<Object> tokens = new ArrayList<Object>();
        int bracketCount = 0;
        StringBuilder buff = new StringBuilder(100);
        for (char ch : opQuery.toCharArray()) {
            if (ch == ',' && bracketCount == 0) {
                tokens.add(this.checkAndCleanOpQuery(buff.toString().trim()));
                buff.delete(0, buff.length());
                continue;
            }
            buff.append(ch);
            if (ch == '{') {
                ++bracketCount;
                continue;
            }
            if (ch != '}') continue;
            --bracketCount;
        }
        String lastToken = buff.toString().trim();
        if (lastToken.length() > 0) {
            tokens.add(this.checkAndCleanOpQuery(lastToken));
        }
        return tokens;
    }

    private DBConstants.MongoDB.MongoOperation convertToMongoOp(String operation) throws DataServiceFault {
        if ("count".equals(operation)) {
            return DBConstants.MongoDB.MongoOperation.COUNT;
        }
        if ("drop".equals(operation)) {
            return DBConstants.MongoDB.MongoOperation.DROP;
        }
        if ("find".equals(operation)) {
            return DBConstants.MongoDB.MongoOperation.FIND;
        }
        if ("findOne".equals(operation)) {
            return DBConstants.MongoDB.MongoOperation.FIND_ONE;
        }
        if ("insert".equals(operation)) {
            return DBConstants.MongoDB.MongoOperation.INSERT;
        }
        if ("remove".equals(operation)) {
            return DBConstants.MongoDB.MongoOperation.REMOVE;
        }
        if ("update".equals(operation)) {
            return DBConstants.MongoDB.MongoOperation.UPDATE;
        }
        throw new DataServiceFault("Unknown MongoDB operation '" + operation + "'");
    }

    private Jongo getJongo() {
        return this.config.getJongo();
    }

    public class MongoQueryResult
    implements QueryResult {
        private Iterator<?> dataIterator;

        public MongoQueryResult(String query, List<InternalParam> params) throws DataServiceFault {
            Object[] request = MongoQuery.this.decodeQuery(query);
            MongoCollection collection = MongoQuery.this.getJongo().getCollection((String)request[0]);
            String opQuery = (String)request[2];
            Object[] mongoParams = DBUtils.convertInputParamValues(params);
            switch ((DBConstants.MongoDB.MongoOperation)request[1]) {
                case COUNT: {
                    this.dataIterator = this.doCount(collection, opQuery, mongoParams);
                    break;
                }
                case FIND: {
                    this.dataIterator = this.doFind(collection, opQuery, mongoParams);
                    break;
                }
                case FIND_ONE: {
                    this.dataIterator = this.doFindOne(collection, opQuery, mongoParams);
                    break;
                }
                case DROP: {
                    this.doDrop(collection);
                    break;
                }
                case INSERT: {
                    this.doInsert(collection, opQuery, mongoParams);
                    break;
                }
                case REMOVE: {
                    this.doRemove(collection, opQuery, mongoParams);
                    break;
                }
                case UPDATE: {
                    if (request.length < 4) {
                        throw new DataServiceFault("An MongoDB update statement must contain a modifier");
                    }
                    String modifier = (String)request[3];
                    boolean upsert = false;
                    if (request.length > 4) {
                        upsert = Boolean.parseBoolean((String)request[4]);
                    }
                    boolean multi = false;
                    if (request.length > 5) {
                        multi = Boolean.parseBoolean((String)request[5]);
                    }
                    this.doUpdate(collection, opQuery, mongoParams, modifier, upsert, multi);
                }
            }
        }

        private Iterator<Long> doCount(MongoCollection collection, String opQuery, Object[] parameters) {
            long count = opQuery != null ? (parameters.length > 0 ? collection.count(opQuery, parameters) : collection.count(opQuery)) : collection.count();
            ArrayList<Long> countResult = new ArrayList<Long>();
            countResult.add(count);
            return countResult.iterator();
        }

        private Iterator<String> doFind(MongoCollection collection, String opQuery, Object[] parameters) {
            if (opQuery != null) {
                if (parameters.length > 0) {
                    return collection.find(opQuery, parameters).map((ResultHandler)MongoResultMapper.getInstance()).iterator();
                }
                return collection.find(opQuery).map((ResultHandler)MongoResultMapper.getInstance()).iterator();
            }
            return collection.find().map((ResultHandler)MongoResultMapper.getInstance()).iterator();
        }

        private Iterator<String> doFindOne(MongoCollection collection, String opQuery, Object[] parameters) {
            String value = opQuery != null ? (parameters.length > 0 ? (String)collection.findOne(opQuery, parameters).map((ResultHandler)MongoResultMapper.getInstance()) : (String)collection.findOne(opQuery).map((ResultHandler)MongoResultMapper.getInstance())) : (String)collection.findOne().map((ResultHandler)MongoResultMapper.getInstance());
            ArrayList<String> result = new ArrayList<String>();
            result.add(value);
            return result.iterator();
        }

        private void doInsert(MongoCollection collection, String opQuery, Object[] parameters) throws DataServiceFault {
            String error;
            if (opQuery != null) {
                error = parameters.length > 0 ? (opQuery.equals("#") ? collection.save(JSON.parse((String)parameters[0].toString())).getError() : collection.insert(opQuery, parameters).getError()) : collection.insert(opQuery).getError();
            } else {
                throw new DataServiceFault("Mongo insert statements must contain a query");
            }
            if (!DBUtils.isEmptyString(error)) {
                throw new DataServiceFault(error);
            }
        }

        private void doRemove(MongoCollection collection, String opQuery, Object[] parameters) throws DataServiceFault {
            String error;
            if (opQuery != null) {
                error = parameters.length > 0 ? collection.remove(opQuery, parameters).getError() : collection.remove(opQuery).getError();
            } else {
                throw new DataServiceFault("Mongo remove statements must contain a query");
            }
            if (!DBUtils.isEmptyString(error)) {
                throw new DataServiceFault(error);
            }
        }

        private void doUpdate(MongoCollection collection, String opQuery, Object[] parameters, String modifier, boolean upsert, boolean multi) throws DataServiceFault {
            String error;
            if (opQuery != null) {
                if (parameters.length > 0) {
                    Update update = collection.update(opQuery);
                    if (upsert) {
                        update = update.upsert();
                    }
                    if (multi) {
                        update = update.multi();
                    }
                    error = update.with(modifier, parameters).getError();
                } else {
                    Update update = collection.update(opQuery);
                    if (upsert) {
                        update = update.upsert();
                    }
                    if (multi) {
                        update = update.multi();
                    }
                    error = update.with(modifier).getError();
                }
            } else {
                throw new DataServiceFault("Mongo update statements must contain a query");
            }
            if (!DBUtils.isEmptyString(error)) {
                throw new DataServiceFault(error);
            }
        }

        private void doDrop(MongoCollection collection) {
            collection.drop();
        }

        @Override
        public List<DataColumn> getDataColumns() throws DataServiceFault {
            ArrayList<DataColumn> result = new ArrayList<DataColumn>();
            result.add(new DataColumn("Document"));
            return result;
        }

        @Override
        public boolean hasNext() throws DataServiceFault {
            return this.dataIterator != null && this.dataIterator.hasNext();
        }

        @Override
        public DataRow next() throws DataServiceFault {
            if (this.dataIterator == null) {
                throw new DataServiceFault("No Mongo data result available");
            }
            Object data = this.dataIterator.next();
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("Document", data.toString());
            return new FixedDataRow(values);
        }
    }

    public static final class MongoResultMapper
    implements ResultHandler<String> {
        private static final MongoResultMapper instance = new MongoResultMapper();

        private MongoResultMapper() {
        }

        public static MongoResultMapper getInstance() {
            return instance;
        }

        public String map(DBObject dbo) {
            return dbo.toString();
        }
    }
}

