/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.description.query;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.XSLTTransformer;
import org.wso2.carbon.dataservices.core.description.event.EventTrigger;
import org.wso2.carbon.dataservices.core.description.query.ExcelQuery;
import org.wso2.carbon.dataservices.core.description.query.GSpreadQuery;
import org.wso2.carbon.dataservices.core.description.query.Query;
import org.wso2.carbon.dataservices.core.description.query.RdfFileQuery;
import org.wso2.carbon.dataservices.core.description.query.SQLQuery;
import org.wso2.carbon.dataservices.core.description.query.SparqlEndpointQuery;
import org.wso2.carbon.dataservices.core.description.query.SparqlQueryBase;
import org.wso2.carbon.dataservices.core.description.query.WebQuery;
import org.wso2.carbon.dataservices.core.engine.CallQuery;
import org.wso2.carbon.dataservices.core.engine.OutputElement;
import org.wso2.carbon.dataservices.core.engine.OutputElementGroup;
import org.wso2.carbon.dataservices.core.engine.ParamValue;
import org.wso2.carbon.dataservices.core.engine.QueryParam;
import org.wso2.carbon.dataservices.core.engine.Result;
import org.wso2.carbon.dataservices.core.engine.StaticOutputElement;
import org.wso2.carbon.dataservices.core.validation.Validator;
import org.wso2.carbon.dataservices.core.validation.standard.ArrayTypeValidator;
import org.wso2.carbon.dataservices.core.validation.standard.DoubleRangeValidator;
import org.wso2.carbon.dataservices.core.validation.standard.LengthValidator;
import org.wso2.carbon.dataservices.core.validation.standard.LongRangeValidator;
import org.wso2.carbon.dataservices.core.validation.standard.PatternValidator;
import org.wso2.carbon.dataservices.core.validation.standard.ScalarTypeValidator;

public class QuerySerializer {
    public static OMElement serializeQuery(Query query) {
        OMFactory fac = DBUtils.getOMFactory();
        OMElement queryEl = fac.createOMElement(new QName("query"));
        queryEl.addAttribute("id", query.getQueryId(), null);
        String configId = query.getConfigId();
        if (configId != null) {
            queryEl.addAttribute("useConfig", configId, null);
        } else {
            queryEl.addAttribute("useConfig", "default", null);
        }
        if (query instanceof SQLQuery) {
            QuerySerializer.serializeSQLQueryProps((SQLQuery)query, queryEl, fac);
        } else if (query instanceof ExcelQuery) {
            QuerySerializer.serializeExcelQueryProps((ExcelQuery)query, queryEl, fac);
        } else if (query instanceof GSpreadQuery) {
            QuerySerializer.serializeGSpreadQueryProps((GSpreadQuery)query, queryEl, fac);
        } else if (query instanceof RdfFileQuery) {
            QuerySerializer.serializeRdfFileQueryProps((RdfFileQuery)query, queryEl, fac);
        } else if (query instanceof SparqlEndpointQuery) {
            QuerySerializer.serializeSparqlEndpointQueryProps((SparqlEndpointQuery)query, queryEl, fac);
        } else if (query instanceof WebQuery) {
            QuerySerializer.serializeWebQueryProps((WebQuery)query, queryEl, fac);
        }
        QuerySerializer.serializeQueryParams(query.getQueryParams(), queryEl, fac);
        QuerySerializer.serializeEventTriggers(query, queryEl, fac);
        QuerySerializer.serializeAdvancedProps(query, queryEl, fac);
        Result result = query.getResult();
        if (result != null) {
            QuerySerializer.serializeResult(result, queryEl, fac);
        }
        return queryEl;
    }

    private static void serializeEventTriggers(Query query, OMElement queryEl, OMFactory fac) {
        EventTrigger inputTrigger = query.getInputEventTrigger();
        EventTrigger outputTrigger = query.getOutputEventTrigger();
        if (inputTrigger != null) {
            queryEl.addAttribute("input-event-trigger", inputTrigger.getTriggerId(), null);
        }
        if (outputTrigger != null) {
            queryEl.addAttribute("output-event-trigger", outputTrigger.getTriggerId(), null);
        }
    }

    private static void serializeAdvancedProps(Query query, OMElement queryEl, OMFactory fac) {
        Map<String, String> props = query.getAdvancedProperties();
        if (props.size() > 0) {
            OMElement propsEl = fac.createOMElement(new QName("properties"));
            for (Map.Entry<String, String> entry : props.entrySet()) {
                OMElement propEl = fac.createOMElement(new QName("property"));
                propEl.addAttribute("name", entry.getKey(), null);
                propEl.setText(entry.getValue());
                propsEl.addChild((OMNode)propEl);
            }
            queryEl.addChild((OMNode)propsEl);
        }
    }

    private static void serializeSQLQueryProps(SQLQuery sqlQuery, OMElement queryEl, OMFactory fac) {
        OMElement sqlEl = fac.createOMElement(new QName("sql"));
        sqlEl.setText(sqlQuery.getSql());
        queryEl.addChild((OMNode)sqlEl);
        if (sqlQuery.isReturnGeneratedKeys()) {
            queryEl.addAttribute("returnGeneratedKeys", Boolean.TRUE.toString(), null);
        }
    }

    private static void serializeExcelQueryProps(ExcelQuery excelQuery, OMElement queryEl, OMFactory fac) {
        OMElement excelEl = fac.createOMElement(new QName("excel"));
        OMElement workbookNameEl = fac.createOMElement(new QName("workbookname"));
        OMElement hasheaderEl = fac.createOMElement(new QName("hasheader"));
        OMElement startingrowEl = fac.createOMElement(new QName("startingrow"));
        OMElement maxrowcountEl = fac.createOMElement(new QName("maxrowcount"));
        workbookNameEl.setText(excelQuery.getWorkbookName());
        hasheaderEl.setText(String.valueOf(excelQuery.isHasHeader()));
        startingrowEl.setText(String.valueOf(excelQuery.getStartingRow()));
        maxrowcountEl.setText(String.valueOf(excelQuery.getMaxRowCount()));
        excelEl.addChild((OMNode)workbookNameEl);
        excelEl.addChild((OMNode)hasheaderEl);
        excelEl.addChild((OMNode)startingrowEl);
        excelEl.addChild((OMNode)maxrowcountEl);
        queryEl.addChild((OMNode)excelEl);
    }

    private static void serializeGSpreadQueryProps(GSpreadQuery gspreadQuery, OMElement queryEl, OMFactory fac) {
        OMElement gspreadEl = fac.createOMElement(new QName("gspread"));
        OMElement worksheetnumberEl = fac.createOMElement(new QName("worksheetnumber"));
        OMElement hasheaderEl = fac.createOMElement(new QName("hasheader"));
        OMElement startingrowEl = fac.createOMElement(new QName("startingrow"));
        OMElement maxrowcountEl = fac.createOMElement(new QName("maxrowcount"));
        worksheetnumberEl.setText(String.valueOf(gspreadQuery.getWorksheetNumber()));
        hasheaderEl.setText(String.valueOf(gspreadQuery.isHasHeader()));
        startingrowEl.setText(String.valueOf(gspreadQuery.getStartingRow()));
        maxrowcountEl.setText(String.valueOf(gspreadQuery.getMaxRowCount()));
        gspreadEl.addChild((OMNode)worksheetnumberEl);
        gspreadEl.addChild((OMNode)hasheaderEl);
        gspreadEl.addChild((OMNode)startingrowEl);
        gspreadEl.addChild((OMNode)maxrowcountEl);
        queryEl.addChild((OMNode)gspreadEl);
    }

    private static void serializeSparqlQueryProps(SparqlQueryBase sparqlQuery, OMElement queryEl, OMFactory fac) {
        OMElement sparqlEl = fac.createOMElement(new QName("sparql"));
        sparqlEl.setText(sparqlQuery.getQuery());
        queryEl.addChild((OMNode)sparqlEl);
    }

    private static void serializeRdfFileQueryProps(RdfFileQuery sparqlQuery, OMElement queryEl, OMFactory fac) {
        QuerySerializer.serializeSparqlQueryProps(sparqlQuery, queryEl, fac);
    }

    private static void serializeSparqlEndpointQueryProps(SparqlEndpointQuery sparqlQuery, OMElement queryEl, OMFactory fac) {
        QuerySerializer.serializeSparqlQueryProps(sparqlQuery, queryEl, fac);
    }

    private static void serializeWebQueryProps(WebQuery webQuery, OMElement queryEl, OMFactory fac) {
        OMElement weblEl = fac.createOMElement(new QName("scraperVariable"));
        weblEl.setText(webQuery.getScraperVariable());
        queryEl.addChild((OMNode)weblEl);
    }

    private static void serializeResult(Result result, OMElement queryEl, OMFactory fac) {
        XSLTTransformer transformer;
        OMElement resEl = fac.createOMElement(new QName("result"));
        int resultType = result.getResultType();
        if (resultType == 1) {
            resEl.addAttribute("outputType", "RDF", null);
            resEl.addAttribute("rdfBaseURI", result.getRDFBaseURI(), null);
        } else {
            resEl.addAttribute("element", result.getElementName(), null);
            String rowName = result.getRowName();
            if (rowName != null) {
                resEl.addAttribute("rowName", rowName, null);
            }
        }
        String defaultNamespace = result.getNamespace();
        if (defaultNamespace != null) {
            resEl.addAttribute("defaultNamespace", defaultNamespace, null);
        }
        if ((transformer = result.getXsltTransformer()) != null) {
            resEl.addAttribute("xsltPath", transformer.getXsltPath(), null);
        }
        OutputElementGroup defGroup = result.getDefaultElementGroup();
        for (StaticOutputElement soe : defGroup.getAttributeEntries()) {
            QuerySerializer.serializeStaticOutputElement(soe, resEl, fac);
        }
        for (OutputElement oe : defGroup.getAllElements()) {
            if (oe instanceof StaticOutputElement) {
                QuerySerializer.serializeStaticOutputElement((StaticOutputElement)oe, resEl, fac);
                continue;
            }
            if (!(oe instanceof CallQuery)) continue;
            QuerySerializer.serializeCallQuery((CallQuery)oe, resEl, fac);
        }
        queryEl.addChild((OMNode)resEl);
    }

    private static void serializeStaticOutputElement(StaticOutputElement soe, OMElement resEl, OMFactory fac) {
        QName xsdType;
        OMElement outEl = fac.createOMElement(new QName(soe.getElementType()));
        outEl.addAttribute("name", soe.getName(), null);
        outEl.addAttribute(soe.getParamType(), soe.getOriginalParam(), null);
        Set<String> requiredRoles = soe.getRequiredRoles();
        if (requiredRoles != null && requiredRoles.size() > 0) {
            outEl.addAttribute("requiredRoles", QuerySerializer.getRequiredRolesString(requiredRoles), null);
        }
        if ((xsdType = soe.getXsdType()) != null) {
            outEl.addAttribute("xsdType", "xs:" + xsdType.getLocalPart(), null);
        } else {
            outEl.addAttribute("xsdType", "xs:string", null);
        }
        resEl.addChild((OMNode)outEl);
    }

    private static String getRequiredRolesString(Set<String> roles) {
        int c = roles.size();
        int i = 0;
        StringBuilder builder = new StringBuilder();
        for (String role : roles) {
            builder.append(role);
            if (++i >= c) continue;
            builder.append(',');
        }
        return builder.toString();
    }

    public static void serializeCallQuery(CallQuery callQuery, OMElement parentEl, OMFactory fac) {
        OMElement callQueryEl = fac.createOMElement(new QName("call-query"));
        callQueryEl.addAttribute("href", callQuery.getQueryId(), null);
        Set<String> requiredRoles = callQuery.getRequiredRoles();
        if (requiredRoles != null && requiredRoles.size() > 0) {
            callQueryEl.addAttribute("requiredRoles", QuerySerializer.getRequiredRolesString(requiredRoles), null);
        }
        for (CallQuery.WithParam withParam : callQuery.getWithParams().values()) {
            OMElement withParamEl = fac.createOMElement(new QName("with-param"));
            withParamEl.addAttribute("name", withParam.getName(), null);
            withParamEl.addAttribute(withParam.getParamType(), withParam.getParam(), null);
            callQueryEl.addChild((OMNode)withParamEl);
        }
        parentEl.addChild((OMNode)callQueryEl);
    }

    private static void serializeQueryParams(List<QueryParam> queryParams, OMElement queryEl, OMFactory fac) {
        for (QueryParam queryParam : queryParams) {
            ParamValue defaultValue;
            int ordinal;
            String type;
            String sqlType;
            OMElement queryParamEl = fac.createOMElement(new QName("param"));
            queryParamEl.addAttribute("name", queryParam.getName(), null);
            String paramType = queryParam.getParamType();
            if (paramType != null) {
                queryParamEl.addAttribute("paramType", paramType, null);
            }
            if ((sqlType = queryParam.getSqlType()) != null) {
                queryParamEl.addAttribute("sqlType", sqlType, null);
            }
            if ((type = queryParam.getType()) != null) {
                queryParamEl.addAttribute("type", type, null);
            }
            if ((ordinal = queryParam.getOrdinal()) > 0) {
                queryParamEl.addAttribute("ordinal", String.valueOf(ordinal), null);
            }
            if ((defaultValue = queryParam.getDefaultValue()) != null && defaultValue.getScalarValue() != null) {
                queryParamEl.addAttribute("ordinal", defaultValue.getScalarValue(), null);
            }
            QuerySerializer.serializeValidators(queryParam.getValidators(), queryParamEl, fac);
            queryEl.addChild((OMNode)queryParamEl);
        }
    }

    private static void serializeValidators(List<Validator> validators, OMElement queryParamEl, OMFactory fac) {
        for (Validator validator : validators) {
            if (validator instanceof LengthValidator) {
                QuerySerializer.serializeLengthValidator((LengthValidator)validator, queryParamEl, fac);
                continue;
            }
            if (validator instanceof PatternValidator) {
                QuerySerializer.serializePatternValidator((PatternValidator)validator, queryParamEl, fac);
                continue;
            }
            if (validator instanceof LongRangeValidator) {
                QuerySerializer.serializeLongRangeValidator((LongRangeValidator)validator, queryParamEl, fac);
                continue;
            }
            if (validator instanceof DoubleRangeValidator) {
                QuerySerializer.serializeDoubleRangeValidator((DoubleRangeValidator)validator, queryParamEl, fac);
                continue;
            }
            if (validator instanceof ArrayTypeValidator || validator instanceof ScalarTypeValidator) continue;
            QuerySerializer.serializeCustomValidator(validator, queryParamEl, fac);
        }
    }

    private static void serializeLengthValidator(LengthValidator validator, OMElement queryParamEl, OMFactory fac) {
        OMElement valEl = fac.createOMElement(new QName("validateLength"));
        if (validator.isHasMin()) {
            valEl.addAttribute("minimum", String.valueOf(validator.getMinLength()), null);
        }
        if (validator.isHasMax()) {
            valEl.addAttribute("maximum", String.valueOf(validator.getMaxLength()), null);
        }
        queryParamEl.addChild((OMNode)valEl);
    }

    private static void serializePatternValidator(PatternValidator validator, OMElement queryParamEl, OMFactory fac) {
        OMElement valEl = fac.createOMElement(new QName("validatePattern"));
        valEl.addAttribute("pattern", validator.getPattern().pattern(), null);
        queryParamEl.addChild((OMNode)valEl);
    }

    private static void serializeLongRangeValidator(LongRangeValidator validator, OMElement queryParamEl, OMFactory fac) {
        OMElement valEl = fac.createOMElement(new QName("validateLongRange"));
        if (validator.isHasMin()) {
            valEl.addAttribute("minimum", String.valueOf(validator.getMinimum()), null);
        }
        if (validator.isHasMax()) {
            valEl.addAttribute("maximum", String.valueOf(validator.getMaximum()), null);
        }
        queryParamEl.addChild((OMNode)valEl);
    }

    private static void serializeDoubleRangeValidator(DoubleRangeValidator validator, OMElement queryParamEl, OMFactory fac) {
        OMElement valEl = fac.createOMElement(new QName("validateDoubleRange"));
        if (validator.isHasMin()) {
            valEl.addAttribute("minimum", String.valueOf(validator.getMinimum()), null);
        }
        if (validator.isHasMax()) {
            valEl.addAttribute("maximum", String.valueOf(validator.getMaximum()), null);
        }
        queryParamEl.addChild((OMNode)valEl);
    }

    private static void serializeCustomValidator(Validator validator, OMElement queryParamEl, OMFactory fac) {
        OMElement valEl = fac.createOMElement(new QName("validateCustom"));
        valEl.addAttribute("class", validator.getClass().getName(), null);
        queryParamEl.addChild((OMNode)valEl);
    }
}

