/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.description.query;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.XAConnection;
import org.wso2.carbon.dataservices.core.DataServiceConnection;
import org.wso2.carbon.dataservices.core.DataServiceFault;

public class SQLDataServicesConnection
implements DataServiceConnection {
    private Connection jdbcConn;

    public SQLDataServicesConnection(Connection jdbcConn) {
        this.jdbcConn = jdbcConn;
    }

    @Override
    public void commit() throws DataServiceFault {
        try {
            if (!this.jdbcConn.isClosed() && !this.getAutoCommit(this.jdbcConn)) {
                this.jdbcConn.commit();
            }
        }
        catch (SQLException e) {
            throw new DataServiceFault(e);
        }
    }

    @Override
    public void rollback() throws DataServiceFault {
        try {
            if (!this.jdbcConn.isClosed() && !this.getAutoCommit(this.jdbcConn)) {
                this.jdbcConn.rollback();
            }
        }
        catch (SQLException e) {
            throw new DataServiceFault(e);
        }
    }

    @Override
    public void close() throws DataServiceFault {
        try {
            if (!this.jdbcConn.isClosed()) {
                this.jdbcConn.close();
            }
        }
        catch (SQLException e) {
            throw new DataServiceFault(e);
        }
    }

    @Override
    public boolean isXA() {
        return this.jdbcConn instanceof XAConnection;
    }

    public Connection getJDBCConnection() {
        return this.jdbcConn;
    }

    private boolean getAutoCommit(Connection conn) {
        try {
            return conn.getAutoCommit();
        }
        catch (SQLException ignore) {
            return true;
        }
    }
}

