/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.description.query;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.log4j.Logger;
import org.webharvest.runtime.variables.Variable;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.description.config.WebConfig;
import org.wso2.carbon.dataservices.core.description.event.EventTrigger;
import org.wso2.carbon.dataservices.core.description.query.Query;
import org.wso2.carbon.dataservices.core.engine.DataEntry;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.engine.InternalParamCollection;
import org.wso2.carbon.dataservices.core.engine.ParamValue;
import org.wso2.carbon.dataservices.core.engine.QueryParam;
import org.wso2.carbon.dataservices.core.engine.Result;

public class WebQuery
extends Query {
    private WebConfig config;
    private String scraperVariable;
    private static Logger log = Logger.getLogger(WebQuery.class);

    public WebQuery(DataService dataService, String queryId, List<QueryParam> queryParams, String configId, Result result, EventTrigger inputEventTrigger, EventTrigger outputEventTrigger, Map<String, String> advancedProperties, String scraperVariable, String inputNamespace) throws DataServiceFault {
        super(dataService, queryId, queryParams, result, configId, inputEventTrigger, outputEventTrigger, advancedProperties, inputNamespace);
        try {
            this.config = (WebConfig)this.getDataService().getConfig(this.getConfigId());
        }
        catch (ClassCastException e) {
            throw new DataServiceFault(e, "Configuration is not an Web config:" + this.getConfigId());
        }
        this.scraperVariable = scraperVariable;
    }

    public WebConfig getConfig() {
        return this.config;
    }

    public String getScraperVariable() {
        return this.scraperVariable;
    }

    @Override
    public Object runPreQuery(InternalParamCollection params, int queryLevel) throws DataServiceFault {
        return this.getConfig().getScrapedResult(this.getScraperVariable());
    }

    @Override
    public void runPostQuery(Object result, XMLStreamWriter xmlWriter, InternalParamCollection params, int queryLevel) throws DataServiceFault {
        Variable scrapedOutput = (Variable)result;
        try {
            OMElement resultEl = AXIOMUtil.stringToOM((String)(scrapedOutput != null ? scrapedOutput.toString() : null));
            boolean useColumnNumbers = this.isUsingColumnNumbers();
            Iterator recordItr = resultEl.getChildElements();
            while (recordItr.hasNext()) {
                OMElement entryEl = (OMElement)recordItr.next();
                DataEntry dataEntry = new DataEntry();
                int i = 1;
                Iterator fieldItr = entryEl.getChildElements();
                while (fieldItr.hasNext()) {
                    OMElement fieldEl = (OMElement)fieldItr.next();
                    dataEntry.addValue(useColumnNumbers ? Integer.toString(i) : fieldEl.getLocalName(), new ParamValue(fieldEl.getText()));
                    ++i;
                }
                this.writeResultEntry(xmlWriter, dataEntry, params, queryLevel);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error in executing web scraping query", (Throwable)e);
            throw new DataServiceFault(e);
        }
    }
}

