/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.dispatch;

import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.llom.OMSourcedElementImpl;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.XSLTTransformer;
import org.wso2.carbon.dataservices.core.description.event.EventTrigger;
import org.wso2.carbon.dataservices.core.description.query.Query;
import org.wso2.carbon.dataservices.core.dispatch.DataServiceRequest;
import org.wso2.carbon.dataservices.core.engine.DSOMDataSource;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.engine.ParamValue;
import org.wso2.carbon.dataservices.core.engine.Result;

public class SingleDataServiceRequest
extends DataServiceRequest {
    private Map<String, ParamValue> params;

    public SingleDataServiceRequest(DataService dataService, String requestName, Map<String, ParamValue> params) throws DataServiceFault {
        super(dataService, requestName);
        this.params = params;
    }

    public Map<String, ParamValue> getParams() {
        return this.params;
    }

    @Override
    public OMElement processRequest() throws DataServiceFault {
        Query.resetQueryPreprocessing();
        Query.setQueryPreprocessingInitial(true);
        Query.setQueryPreprocessingSecondary(false);
        OMElement result = this.processSingleRequest();
        if (result instanceof OMSourcedElementImpl) {
            DSOMDataSource dsomDS = (DSOMDataSource)((OMSourcedElementImpl)result).getDataSource();
            Query.setQueryPreprocessingSecondary(false);
            try {
                dsomDS.execute(null);
            }
            catch (XMLStreamException e) {
                throw new DataServiceFault(e);
            }
            Query.setQueryPreprocessingInitial(false);
            Query.setQueryPreprocessingSecondary(true);
            Query defQuery = this.getDataService().getCallableRequest(this.getRequestName()).getCallQuery().getQuery();
            if (defQuery.isPreBuildResult()) {
                result = DBUtils.cloneAndReturnBuiltElement(result);
            }
            result = this.executeXsltTranformation(result, defQuery);
            this.processOutputEvents(result, defQuery);
        }
        return result;
    }

    private OMElement processSingleRequest() throws DataServiceFault {
        DataService dataService = this.getDataService();
        String requestName = this.getRequestName();
        DSOMDataSource ds = new DSOMDataSource(dataService, requestName, this.getParams());
        if (dataService.hasResultForRequest(this.getRequestName())) {
            String resultWrapper = dataService.getResultWrapperForRequest(requestName);
            String ns = dataService.getNamespaceForRequest(requestName);
            return new OMSourcedElementImpl(new QName(ns, resultWrapper), DBUtils.getOMFactory(), (OMDataSource)ds);
        }
        try {
            ds.executeInOnly();
        }
        catch (XMLStreamException e) {
            throw new DataServiceFault(e, "Error in DS non result invoke.");
        }
        return null;
    }

    private OMElement executeXsltTranformation(OMElement input, Query query) throws DataServiceFault {
        Result result = query.getResult();
        XSLTTransformer transformer = result.getXsltTransformer();
        if (transformer == null) {
            return input;
        }
        try {
            return transformer.transform(input);
        }
        catch (Exception e) {
            throw new DataServiceFault(e, "Error in result XSLT transformation");
        }
    }

    private void processOutputEvents(OMElement input, Query query) throws DataServiceFault {
        EventTrigger trigger = query.getOutputEventTrigger();
        if (trigger != null) {
            trigger.execute(input, query.getQueryId());
        }
    }
}

