/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.transaction.TransactionManager;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.DataServiceUser;
import org.wso2.carbon.dataservices.core.description.config.Config;
import org.wso2.carbon.dataservices.core.description.event.EventTrigger;
import org.wso2.carbon.dataservices.core.description.operation.Operation;
import org.wso2.carbon.dataservices.core.description.operation.OperationFactory;
import org.wso2.carbon.dataservices.core.description.query.Query;
import org.wso2.carbon.dataservices.core.description.resource.Resource;
import org.wso2.carbon.dataservices.core.description.xa.DSSXATransactionManager;
import org.wso2.carbon.dataservices.core.engine.CallQuery;
import org.wso2.carbon.dataservices.core.engine.CallableRequest;
import org.wso2.carbon.dataservices.core.engine.ExternalParam;
import org.wso2.carbon.dataservices.core.engine.ExternalParamCollection;
import org.wso2.carbon.dataservices.core.engine.InternalParamCollection;
import org.wso2.carbon.dataservices.core.engine.OutputElementGroup;
import org.wso2.carbon.dataservices.core.engine.ParamValue;
import org.wso2.carbon.dataservices.core.engine.Result;
import org.wso2.carbon.dataservices.core.internal.DataServicesDSComponent;
import org.wso2.carbon.event.core.EventBroker;
import org.wso2.carbon.event.core.exception.EventBrokerException;
import org.wso2.carbon.event.core.subscription.Subscription;
import org.wso2.securevault.SecretResolver;

public class DataService {
    private static final Log log = LogFactory.getLog(DataService.class);
    private String name;
    private String serviceNamespace;
    private Map<String, CallableRequest> callableRequests;
    private Map<String, Operation> operations;
    private Map<Resource.ResourceID, Resource> resourceMap;
    private Map<String, Config> configs;
    private Map<String, Query> queries;
    private Map<String, EventTrigger> eventTriggers;
    private String description;
    private SecretResolver secretResolver;
    private String defaultNamespace;
    private String dsLocation;
    private String dsRelativeLocation;
    private String serviceStatus;
    private boolean batchRequestsEnabled;
    private boolean boxcarringEnabled;
    private static ThreadLocal<DataServiceUser> currentUser = new ThreadLocal();
    private String containerUserTxName;
    private DSSXATransactionManager txManager;
    private boolean disableStreaming;
    private int tenantId;

    public DataService(String name, String description, String defaultNamespace, String dsLocation, String serviceStatus, boolean batchRequestsEnabled, boolean boxcarringEnabled, String containerUserTxName) throws DataServiceFault {
        this.name = name;
        this.callableRequests = new HashMap<String, CallableRequest>();
        this.operations = new HashMap<String, Operation>();
        this.resourceMap = new HashMap<Resource.ResourceID, Resource>();
        this.configs = new HashMap<String, Config>();
        this.eventTriggers = new HashMap<String, EventTrigger>();
        this.queries = new HashMap<String, Query>();
        this.description = description;
        this.defaultNamespace = defaultNamespace;
        this.dsLocation = dsLocation;
        this.setRelativeDsLocation(this.dsLocation);
        this.serviceStatus = serviceStatus;
        this.batchRequestsEnabled = batchRequestsEnabled;
        this.boxcarringEnabled = boxcarringEnabled;
        this.containerUserTxName = containerUserTxName;
        if (this.isBoxcarringEnabled()) {
            this.initBoxcarring();
        }
        this.initXA();
        this.tenantId = DBUtils.getCurrentTenantId();
    }

    private void initXA() throws DataServiceFault {
        TransactionManager txManager = DBUtils.getContainerTransactionManager(this.getContainerUserTransactionName());
        this.txManager = new DSSXATransactionManager(txManager);
    }

    private void initBoxcarring() throws DataServiceFault {
        this.addQuery(new Query(this, "__dataservices_empty_query__", new ArrayList(), null, null, null, null, null, this.getDefaultNamespace()){

            @Override
            public Object runPreQuery(InternalParamCollection params, int queryLevel) {
                return null;
            }

            @Override
            public void runPostQuery(Object result, XMLStreamWriter xmlWriter, InternalParamCollection params, int queryLevel) throws DataServiceFault {
            }
        });
        Result endBoxcarResult = new Result("dummy", "dummy", "http://ws.wso2.org/dataservice", null, 2);
        endBoxcarResult.setXsAny(true);
        endBoxcarResult.setDefaultElementGroup(new OutputElementGroup(null, null, null, null));
        this.addQuery(new Query(this, "__dataservices_empty_end_boxcar_query__", new ArrayList(), endBoxcarResult, null, null, null, null, this.getDefaultNamespace()){

            @Override
            public Object runPreQuery(InternalParamCollection params, int queryLevel) {
                return null;
            }

            @Override
            public void runPostQuery(Object result, XMLStreamWriter xmlWriter, InternalParamCollection params, int queryLevel) throws DataServiceFault {
            }
        });
        this.addOperation(OperationFactory.createBeginBoxcarOperation(this));
        this.addOperation(OperationFactory.createEndBoxcarOperation(this));
        this.addOperation(OperationFactory.createAbortBoxcarOperation(this));
    }

    public void init() throws DataServiceFault {
        for (CallableRequest callableRequest : this.getCallableRequests().values()) {
            callableRequest.getCallQuery().init();
        }
        for (Query query : this.getQueries().values()) {
            if (!query.hasResult()) continue;
            query.getResult().getDefaultElementGroup().init();
        }
    }

    public int getTenantId() {
        return this.tenantId;
    }

    public boolean isDisableStreaming() {
        return this.disableStreaming;
    }

    public void setDisableStreaming(boolean disableStreaming) {
        this.disableStreaming = disableStreaming;
    }

    public DSSXATransactionManager getDSSTxManager() {
        return this.txManager;
    }

    public String getContainerUserTransactionName() {
        return this.containerUserTxName;
    }

    public void cleanup() throws DataServiceFault {
        EventBroker eventBroker;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Data Service '" + this.getName() + "' cleanup start.."));
        }
        if ((eventBroker = DataServicesDSComponent.getEventBroker()) != null) {
            this.clearDataServicesEventSubscriptions(eventBroker);
        }
        for (Config config : this.getConfigs().values()) {
            config.close();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Data Service '" + this.getName() + "' cleanup end."));
        }
    }

    private void clearDataServicesEventSubscriptions(EventBroker eventBroker) throws DataServiceFault {
        try {
            for (Subscription subs : eventBroker.getAllSubscriptions(null)) {
                String dsName = (String)subs.getProperties().get("dataServiceName");
                if (dsName == null || !this.getName().equals(dsName)) continue;
                eventBroker.unsubscribe(subs.getId());
            }
        }
        catch (EventBrokerException e) {
            throw new DataServiceFault((Exception)((Object)e));
        }
    }

    public String getServiceNamespace() {
        return this.serviceNamespace;
    }

    public void setServiceNamespace(String serviceNamespace) {
        this.serviceNamespace = serviceNamespace;
    }

    public Map<String, EventTrigger> getEventTriggers() {
        return this.eventTriggers;
    }

    public EventTrigger getEventTrigger(String triggerId) {
        return this.getEventTriggers().get(triggerId);
    }

    public void addEventTrigger(EventTrigger eventTrigger) {
        this.getEventTriggers().put(eventTrigger.getTriggerId(), eventTrigger);
    }

    public boolean isBatchRequestsEnabled() {
        return this.batchRequestsEnabled;
    }

    public boolean isBoxcarringEnabled() {
        return this.boxcarringEnabled;
    }

    public static DataServiceUser getCurrentUser() {
        return currentUser.get();
    }

    public static void setCurrentUser(DataServiceUser user) {
        currentUser.set(user);
    }

    public String getDsLocation() {
        return this.dsLocation;
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public Map<String, CallableRequest> getCallableRequests() {
        return this.callableRequests;
    }

    public CallableRequest getCallableRequest(String requestName) {
        return this.getCallableRequests().get(requestName);
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    private Map<String, Operation> getOperations() {
        return this.operations;
    }

    public Set<String> getOperationNames() {
        return this.getOperations().keySet();
    }

    private Map<Resource.ResourceID, Resource> getResourceMap() {
        return this.resourceMap;
    }

    public Set<Resource.ResourceID> getResourceIds() {
        return this.getResourceMap().keySet();
    }

    public Map<String, Config> getConfigs() {
        return this.configs;
    }

    public Config getConfig(String configId) {
        return this.getConfigs().get(configId);
    }

    public void addConfig(Config config) {
        this.getConfigs().put(config.getConfigId(), config);
    }

    public Operation getOperation(String opName) {
        return this.getOperations().get(opName);
    }

    public Resource getResource(Resource.ResourceID resourceId) {
        return this.getResourceMap().get(resourceId);
    }

    private void addCallableRequest(CallableRequest callableRequest) {
        this.getCallableRequests().put(callableRequest.getRequestName(), callableRequest);
    }

    public void addOperation(Operation operation) {
        this.getOperations().put(operation.getName(), operation);
        this.addCallableRequest(operation);
    }

    public void addResource(Resource resource) {
        this.getResourceMap().put(resource.getResourceId(), resource);
        this.addCallableRequest(resource);
    }

    public Map<String, Query> getQueries() {
        return this.queries;
    }

    public Query getQuery(String queryId) {
        return this.getQueries().get(queryId);
    }

    public void addQuery(Query query) {
        this.getQueries().put(query.getQueryId(), query);
    }

    public SecretResolver getSecretResolver() {
        return this.secretResolver;
    }

    public void setSecretResolver(SecretResolver secretResolver) {
        this.secretResolver = secretResolver;
    }

    public String getRelativeDsLocation() {
        return this.dsRelativeLocation;
    }

    private void setRelativeDsLocation(String location) {
        if (location != null && !"".equals(location)) {
            String[] dsPathContents = location.trim().split("dataservices");
            this.dsRelativeLocation = dsPathContents[dsPathContents.length - 1];
        }
    }

    public void invoke(XMLStreamWriter xmlWriter, String requestName, Map<String, ParamValue> params) throws DataServiceFault {
        try {
            this.getCallableRequest(requestName).execute(xmlWriter, this.extractParams(params));
        }
        catch (DataServiceFault e) {
            this.fillInDataServiceFault(e, requestName, params);
            log.error((Object)e.getFullMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            DataServiceFault dsf = new DataServiceFault(e);
            this.fillInDataServiceFault(dsf, requestName, params);
            log.error((Object)dsf.getFullMessage(), (Throwable)e);
            throw dsf;
        }
    }

    private void fillInDataServiceFault(DataServiceFault dsf, String requestName, Map<String, ParamValue> params) {
        dsf.setSourceDataService(this);
        dsf.setCurrentRequestName(requestName);
        dsf.setCurrentParams(params);
    }

    private ExternalParamCollection extractParams(Map<String, ParamValue> params) {
        ExternalParamCollection epc = new ExternalParamCollection();
        for (Map.Entry<String, ParamValue> entry : params.entrySet()) {
            epc.addParam(new ExternalParam(entry.getKey().toLowerCase(), entry.getValue(), "query-param"));
        }
        return epc;
    }

    public String getResultWrapperForRequest(String requestName) {
        return this.getCallableRequest(requestName).getCallQuery().getResultWrapper();
    }

    public String getNamespaceForRequest(String requestName) {
        CallQuery callQuery = this.getCallableRequest(requestName).getCallQuery();
        return callQuery.getNamespace();
    }

    public boolean hasResultForRequest(String requestName) {
        return this.getCallableRequest(requestName).getCallQuery().isHasResult();
    }

    public boolean isReturningRequestStatus(String requestName) {
        return this.getCallableRequest(requestName).isReturnRequestStatus();
    }

    public String getServiceStatus() {
        return this.serviceStatus;
    }

    public void setServiceStatus(String serviceStatus) {
        this.serviceStatus = serviceStatus;
    }

    public boolean isServiceInactive() {
        return this.getServiceStatus() != null && this.getServiceStatus().equals("inactive");
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("Name: " + this.getName() + "\n");
        buff.append("Location: " + this.getRelativeDsLocation() + "\n");
        buff.append("Description: " + (this.getDescription() != null ? this.getDescription() : "N/A") + "\n");
        buff.append("Default Namespace: " + this.getDefaultNamespace() + "\n");
        return buff.toString();
    }

    public boolean isInDTX() {
        return this.getDSSTxManager().isInDTX();
    }
}

