/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.validation.standard;

import java.util.regex.Pattern;
import org.wso2.carbon.dataservices.core.validation.standard.GenericValidator;

public class PatternValidator
extends GenericValidator {
    private Pattern pattern;

    public PatternValidator(String regEx) {
        super("Pattern {" + regEx + "} is expected");
        this.pattern = Pattern.compile(regEx);
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    protected boolean validateScalar(String value) {
        try {
            return this.getPattern().matcher(value).matches();
        }
        catch (Exception e) {
            return false;
        }
    }
}

