/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.AbstractDeployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisBinding;
import org.apache.axis2.description.AxisBindingMessage;
import org.apache.axis2.description.AxisBindingOperation;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.InOnlyAxisOperation;
import org.apache.axis2.description.InOutAxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.wsdl.WSDLUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.ws.commons.schema.utils.NamespaceMap;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.dataservices.common.DBConstants;
import org.wso2.carbon.dataservices.core.DBInOnlyMessageReceiver;
import org.wso2.carbon.dataservices.core.DBInOutMessageReceiver;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceDocLitWrappedSchemaGenerator;
import org.wso2.carbon.dataservices.core.DataServiceFactory;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.FaultyServiceRectifier;
import org.wso2.carbon.dataservices.core.description.config.Config;
import org.wso2.carbon.dataservices.core.description.operation.Operation;
import org.wso2.carbon.dataservices.core.description.query.Query;
import org.wso2.carbon.dataservices.core.description.resource.Resource;
import org.wso2.carbon.dataservices.core.engine.CallQuery;
import org.wso2.carbon.dataservices.core.engine.CallableRequest;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.engine.QueryParam;
import org.wso2.carbon.dataservices.core.internal.DataServicesDSComponent;
import org.wso2.carbon.dataservices.core.jmx.DataServiceInstance;
import org.wso2.carbon.dataservices.core.odata.ODataServiceHandler;
import org.wso2.carbon.dataservices.core.odata.ODataServiceRegistry;
import org.wso2.carbon.ndatasource.common.DataSourceException;
import org.wso2.carbon.ndatasource.core.DataSourceManager;
import org.wso2.carbon.utils.CarbonUtils;

public class DBDeployer
extends AbstractDeployer {
    public static final String HTTP_TRANSPORT = "http";
    public static final String HTTPS_TRANSPORT = "https";
    private static final Log log = LogFactory.getLog(DBDeployer.class);
    public static final String DEPLOYMENT_FOLDER_NAME = "dataservices";
    private AxisConfiguration axisConfig;
    private ConfigurationContext configCtx;
    private String repoDir;
    private String extension;
    private Map<String, AxisOperation> httpLocationTable;
    private Map<Pattern, AxisOperation> httpLocationTableForResource;
    private static TransactionManager cachedTransactionManager = null;

    public ConfigurationContext getConfigContext() {
        return this.configCtx;
    }

    public void deploy(DeploymentFileData deploymentFileData) throws DeploymentException {
        String serviceHierarchy;
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setApplicationName(deploymentFileData.getName());
        if (this.isFaultyService(deploymentFileData)) {
            this.axisConfig.removeFaultyService(deploymentFileData.getFile().getAbsolutePath());
        }
        if ((serviceHierarchy = Utils.getServiceHierarchy((String)deploymentFileData.getAbsolutePath(), (String)this.repoDir)) == null) {
            serviceHierarchy = "";
        }
        boolean successfullyDeployed = false;
        String errorMessage = null;
        AxisService service = null;
        try {
            String serviceGroupName = serviceHierarchy + this.getServiceNameFromDSContents(deploymentFileData.getFile());
            if (DBUtils.isAvailableDSServiceGroup(this.axisConfig, serviceGroupName)) {
                throw new DataServiceFault("Data Service name is already exists. Please choose different name for '" + this.getServiceNameFromDSContents(deploymentFileData.getFile()) + "' data service.");
            }
            AxisServiceGroup serviceGroup = new AxisServiceGroup();
            serviceGroup.setServiceGroupName(serviceGroupName);
            service = this.processService(deploymentFileData, serviceGroup, this.configCtx);
            service.setName(serviceHierarchy + service.getName());
            boolean serviceActive = service.isActive();
            ArrayList<AxisService> services = new ArrayList<AxisService>();
            services.add(service);
            boolean secEnabled = this.handleSecurityProxy(deploymentFileData, service);
            DeploymentEngine.addServiceGroup((AxisServiceGroup)serviceGroup, services, (URL)deploymentFileData.getFile().toURI().toURL(), (DeploymentFileData)deploymentFileData, (AxisConfiguration)this.axisConfig);
            if (secEnabled) {
                service.engageModule(this.configCtx.getAxisConfiguration().getModule("rampart"), (AxisDescription)this.configCtx.getAxisConfiguration());
            }
            service.setActive(serviceActive);
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage((String)"deployingws", (String)deploymentFileData.getName(), (String)deploymentFileData.getAbsolutePath()));
            }
            super.deploy(deploymentFileData);
            successfullyDeployed = true;
        }
        catch (DataServiceFault e) {
            errorMessage = DBUtils.getStacktraceFromException(e);
            log.error((Object)Messages.getMessage((String)"invalidservice", (String)deploymentFileData.getName()), (Throwable)e);
            if (DBConstants.FaultCodes.CONNECTION_UNAVAILABLE_ERROR.equals(e.getCode())) {
                this.sheduleRedeploy(deploymentFileData, service);
            }
            DataService ds = e.getSourceDataService();
            try {
                if (ds != null) {
                    ds.cleanup();
                }
            }
            catch (DataServiceFault e2) {
                log.warn((Object)("Error in data service cleanup: " + e2.getMessage()), (Throwable)e2);
            }
            throw new DeploymentException(Messages.getMessage((String)"invalidservice", (String)deploymentFileData.getName()), (Throwable)e);
        }
        catch (Throwable e) {
            errorMessage = DBUtils.getStacktraceFromException(e);
            log.error((Object)Messages.getMessage((String)"invalidservice", (String)deploymentFileData.getName()), e);
            throw new DeploymentException(Messages.getMessage((String)"invalidservice", (String)deploymentFileData.getName()), e);
        }
        finally {
            if (!successfullyDeployed) {
                String deploymentFilePath = deploymentFileData.getFile().getAbsolutePath();
                this.axisConfig.getFaultyServices().put(deploymentFilePath, errorMessage);
                try {
                    CarbonUtils.registerFaultyService((String)deploymentFilePath, (String)"data_service", (ConfigurationContext)this.configCtx);
                }
                catch (Exception e) {
                    log.error((Object)"Cannot register faulty service with Carbon", (Throwable)e);
                }
            }
        }
    }

    private boolean isFaultyService(DeploymentFileData deploymentFileData) {
        String faultyServiceFilePath = deploymentFileData.getFile().getAbsolutePath();
        AxisService faultyService = CarbonUtils.getFaultyService((String)faultyServiceFilePath, (ConfigurationContext)this.configCtx);
        return faultyService != null;
    }

    private String getServiceNameFromDSContents(File file) throws Exception {
        StAXOMBuilder builder = new StAXOMBuilder((InputStream)new FileInputStream(file.getAbsoluteFile()));
        OMElement serviceEl = builder.getDocumentElement();
        String serviceName = serviceEl.getAttributeValue(new QName("name"));
        builder.close();
        if (DBUtils.isEmptyString(serviceName)) {
            throw new DataServiceFault("Service group cannot be determined for the data service at '" + file.getAbsolutePath() + "'");
        }
        return serviceName;
    }

    private void sheduleRedeploy(DeploymentFileData deploymentFileData, AxisService service) {
        FaultyServiceRectifier faultyServiceRectifier = new FaultyServiceRectifier(service, deploymentFileData, this.configCtx);
        long retryIn = 60000L;
        DBUtils.scheduleTask(faultyServiceRectifier, retryIn);
    }

    public void init(ConfigurationContext configCtx) {
        int tid;
        this.configCtx = configCtx;
        this.axisConfig = this.configCtx.getAxisConfiguration();
        configCtx.setProperty("local_org.wso2.ws.dataservice.db_service_repo", (Object)this.repoDir);
        configCtx.setProperty("local_org.wso2.ws.dataservice.db_service_extension", (Object)this.extension);
        configCtx.setProperty("org.wso2.ws.dataservice.dataservice.deployer", (Object)this);
        try {
            tid = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        }
        catch (ExceptionInInitializerError e) {
            tid = -1234;
        }
        try {
            DataServicesDSComponent.getTenantRegistryLoader().loadTenantRegistry(tid);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.doExtractTransactionManager();
        try {
            DataSourceManager.getInstance().initTenant(tid);
        }
        catch (DataSourceException e) {
            log.error((Object)("Error in intializing Carbon data sources for tenant: " + tid + " from data services"));
        }
        catch (NoClassDefFoundError e) {
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    private void doExtractTransactionManager() {
        block8: {
            block7: {
                if (cachedTransactionManager != null) {
                    return;
                }
                try {
                    Object txObj = InitialContext.doLookup("java:comp/UserTransaction");
                    if (txObj instanceof TransactionManager) {
                        cachedTransactionManager = (TransactionManager)txObj;
                    }
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block7;
                    log.debug((Object)"Cannot find transaction manager at: java:comp/UserTransaction", (Throwable)e);
                }
            }
            if (cachedTransactionManager == null) {
                try {
                    cachedTransactionManager = (TransactionManager)InitialContext.doLookup("java:comp/TransactionManager");
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block8;
                    log.debug((Object)"Cannot find transaction manager at: java:comp/TransactionManager", (Throwable)e);
                }
            }
        }
    }

    public static TransactionManager getCachedTransactionManager() {
        return cachedTransactionManager;
    }

    public void setDirectory(String repoDir) {
        this.repoDir = repoDir;
    }

    public String getRepoDir() {
        return this.repoDir;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getExtension() {
        return this.extension;
    }

    private DataService getDataServiceByServicePath(String servicePath) throws Exception {
        String canonicalServicePath = new File(servicePath).getCanonicalPath();
        for (AxisService axisService : this.axisConfig.getServices().values()) {
            DataService tmpDS;
            Parameter tmpParam = axisService.getParameter("org.wso2.ws.dataservice.dataservice.obj");
            if (tmpParam == null || !new File((tmpDS = (DataService)tmpParam.getValue()).getDsLocation()).getCanonicalPath().equals(canonicalServicePath)) continue;
            return tmpDS;
        }
        return null;
    }

    public void undeploy(String servicePath) throws DeploymentException {
        try {
            DataService dataService = this.getDataServiceByServicePath(servicePath);
            if (dataService == null) {
                this.axisConfig.removeFaultyService(servicePath);
                return;
            }
            String serviceHierarchy = Utils.getServiceHierarchy((String)servicePath, (String)this.repoDir);
            if (serviceHierarchy == null) {
                serviceHierarchy = "";
            }
            String serviceName = serviceHierarchy + dataService.getName();
            AxisServiceGroup serviceGroup = this.axisConfig.getServiceGroup(serviceName);
            CarbonContext cCtx = CarbonContext.getThreadLocalCarbonContext();
            if (serviceGroup == null) {
                this.axisConfig.removeFaultyService(servicePath);
                for (String configID : dataService.getConfigs().keySet()) {
                    if (!dataService.getConfig(configID).isODataEnabled()) continue;
                    this.removeODataHandler(cCtx.getTenantDomain(), dataService.getName() + configID);
                }
            } else {
                for (String configID : dataService.getConfigs().keySet()) {
                    if (!dataService.getConfig(configID).isODataEnabled()) continue;
                    this.removeODataHandler(cCtx.getTenantDomain(), dataService.getName() + configID);
                }
                dataService.cleanup();
                this.axisConfig.removeService(serviceName);
                if (!serviceGroup.getServices().hasNext()) {
                    this.axisConfig.removeServiceGroup(serviceGroup.getServiceGroupName());
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage((String)"serviceremoved", (String)serviceName));
            }
            super.undeploy(servicePath);
        }
        catch (Exception e) {
            String msg = "Error in undeploying service";
            log.error((Object)msg, (Throwable)e);
            throw new DeploymentException(msg, (Throwable)e);
        }
    }

    private void convertConfigToMultipleDSFormat(String configFilePath) throws DataServiceFault {
        FileInputStream fis = null;
        boolean changed = false;
        try {
            fis = new FileInputStream(configFilePath);
            OMElement configElement = new StAXOMBuilder((InputStream)fis).getDocumentElement();
            configElement.build();
            Iterator configElements = configElement.getChildrenWithName(new QName("config"));
            int emptyConfigs = 0;
            while (configElements.hasNext()) {
                OMElement config = (OMElement)configElements.next();
                String configId = config.getAttributeValue(new QName("id"));
                if (configId != null && configId.trim().length() != 0) continue;
                config.addAttribute("id", "default", null);
                changed = true;
                if (++emptyConfigs <= 1) continue;
                throw new DataServiceFault("More than one config elements found in " + configFilePath);
            }
            Iterator queryElements = configElement.getChildrenWithName(new QName("query"));
            while (queryElements.hasNext()) {
                OMElement query = (OMElement)queryElements.next();
                String useConfig = query.getAttributeValue(new QName("useConfig"));
                if (useConfig != null && useConfig.trim().length() != 0) continue;
                query.addAttribute("useConfig", "default", null);
                changed = true;
            }
            if (changed) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Converting " + configFilePath + " to support multiple data sources."));
                }
                BufferedWriter out = new BufferedWriter(new FileWriter(configFilePath));
                configElement.serialize((Writer)out);
                out.close();
                DBUtils.prettifyXMLFile(configFilePath);
            }
        }
        catch (Exception e) {
            throw new DataServiceFault(e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error in closing data service configuration file", (Throwable)e);
                }
            }
        }
    }

    private AxisOperation createAxisOperationFromDSOperation(Operation operation, AxisBinding soap11Binding, AxisBinding soap12Binding, AxisBinding httpBinding) throws AxisFault {
        String opName = operation.getName();
        String requestName = operation.getRequestName();
        int index = opName.indexOf(":");
        if (index > -1) {
            opName = opName.substring(index + 1);
        }
        boolean hasResult = operation.getCallQuery().isHasResult() || operation.isReturnRequestStatus();
        String description = operation.getDescription();
        return this.createAxisOperation(requestName, opName, "POST", hasResult, soap11Binding, soap12Binding, httpBinding, description);
    }

    private AxisOperation createAxisOperationFromDSResource(Resource resource, AxisBinding soap11Binding, AxisBinding soap12Binding, AxisBinding httpBinding) {
        Resource.ResourceID resourceId = resource.getResourceId();
        String method = resourceId.getMethod();
        String path = resourceId.getPath();
        String requestName = resource.getRequestName();
        String description = resource.getDescription();
        boolean hasResult = resource.getCallQuery().isHasResult() || resource.isReturnRequestStatus();
        return this.createAxisOperation(requestName, path, method, hasResult, soap11Binding, soap12Binding, httpBinding, description);
    }

    private AxisOperation createAxisOperation(String operationName, String httpLocation, String method, boolean hasResult, AxisBinding soap11Binding, AxisBinding soap12Binding, AxisBinding httpBinding, String description) {
        AxisMessage outMessage;
        InOutAxisOperation axisOperation;
        if (hasResult) {
            axisOperation = new InOutAxisOperation(new QName(operationName));
            DBInOutMessageReceiver inoutMsgReceiver = new DBInOutMessageReceiver();
            axisOperation.setMessageReceiver((MessageReceiver)inoutMsgReceiver);
            axisOperation.setMessageExchangePattern("http://www.w3.org/ns/wsdl/in-out");
        } else {
            axisOperation = new InOnlyAxisOperation(new QName(operationName));
            DBInOnlyMessageReceiver inonlyMsgReceiver = new DBInOnlyMessageReceiver();
            axisOperation.setMessageReceiver((MessageReceiver)inonlyMsgReceiver);
            axisOperation.setMessageExchangePattern("http://www.w3.org/ns/wsdl/robust-in-only");
        }
        axisOperation.setStyle("document");
        String opName = axisOperation.getName().getLocalPart();
        AxisBindingOperation soap11BindingOperation = this.createDefaultSOAP11BindingOperation((AxisOperation)axisOperation, httpLocation, "urn:" + opName, soap11Binding);
        AxisBindingOperation soap12BindingOperation = this.createDefaultSOAP12BindingOperation((AxisOperation)axisOperation, httpLocation, "urn:" + opName, soap12Binding);
        AxisBindingOperation httpBindingOperation = this.createDefaultHTTPBindingOperation((AxisOperation)axisOperation, httpLocation, method, httpBinding);
        if (httpLocation.startsWith("/")) {
            httpLocation = httpLocation.substring(1);
        }
        Pattern httpLocationPattern = WSDLUtil.getConstantFromHTTPLocationForResource((String)httpLocation, (String)method);
        this.httpLocationTableForResource.put(httpLocationPattern, (AxisOperation)axisOperation);
        AxisMessage inMessage = axisOperation.getMessage("In");
        if (inMessage != null) {
            inMessage.setName(operationName + "Request");
            this.createAxisBindingMessage(soap11BindingOperation, inMessage, "In", false);
            this.createAxisBindingMessage(soap12BindingOperation, inMessage, "In", false);
            this.createAxisBindingMessage(httpBindingOperation, inMessage, "In", false);
        }
        if (axisOperation instanceof InOutAxisOperation && (outMessage = axisOperation.getMessage("Out")) != null) {
            outMessage.setName(operationName + "ResponseMessage");
            this.createAxisBindingMessage(soap11BindingOperation, outMessage, "Out", false);
            this.createAxisBindingMessage(soap12BindingOperation, outMessage, "Out", false);
            this.createAxisBindingMessage(httpBindingOperation, outMessage, "Out", false);
        }
        if (hasResult) {
            AxisMessage faultMessage = new AxisMessage();
            faultMessage.setName("DataServiceFault");
            faultMessage.setElementQName(new QName("http://ws.wso2.org/dataservice", "DataServiceFault"));
            axisOperation.setFaultMessages(faultMessage);
            this.createAxisBindingMessage(soap11BindingOperation, faultMessage, "Fault", true);
            this.createAxisBindingMessage(soap12BindingOperation, faultMessage, "Fault", true);
            this.createAxisBindingMessage(httpBindingOperation, faultMessage, "Fault", true);
        }
        axisOperation.setDocumentation(description);
        return axisOperation;
    }

    private void createDSSchema(AxisService axisService, DataService dataService) throws DataServiceFault {
        NamespaceMap map = new NamespaceMap();
        map.put((Object)"xs", (Object)"http://www.w3.org/2001/XMLSchema");
        axisService.setNamespaceMap(map);
        DataServiceDocLitWrappedSchemaGenerator.populateServiceSchema(axisService);
    }

    private void validateDataService(DataService dataService) throws DataServiceFault {
        this.validateRequestCallQuery(dataService);
        this.validateRequestQueryParams(dataService);
        this.validateRequestQueryResults(dataService);
    }

    private void validateRequestCallQuery(DataService dataService) throws DataServiceFault {
        for (CallableRequest cr : dataService.getCallableRequests().values()) {
            CallQuery callQuery = cr.getCallQuery();
            if (callQuery.getQuery() != null) continue;
            DataServiceFault dsf = new DataServiceFault("Invalid DBS", "Call query with id: " + callQuery.getQueryId() + " doesn't exist as referenced by the operation/resource: " + cr.getRequestName());
            dsf.setSourceDataService(dataService);
            throw dsf;
        }
    }

    private void validateRequestQueryParams(DataService dataService) throws DataServiceFault {
        for (CallableRequest cr : dataService.getCallableRequests().values()) {
            CallQuery callQuery = cr.getCallQuery();
            Query query = callQuery.getQuery();
            for (CallQuery.WithParam withParam : callQuery.getWithParams().values()) {
                boolean found = false;
                for (QueryParam queryParam : query.getQueryParams()) {
                    if (!withParam.getName().equals(queryParam.getName())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                DataServiceFault dsf = new DataServiceFault("Invalid DBS", "with-param with name: " + withParam.getName() + " doesn't exist in query with id: " + query.getQueryId() + " as referenced by the operation/resource: " + cr.getRequestName());
                dsf.setSourceDataService(dataService);
                throw dsf;
            }
        }
    }

    private void validateRequestQueryResults(DataService dataService) throws DataServiceFault {
        for (CallableRequest request : dataService.getCallableRequests().values()) {
            Query query;
            CallQuery callQuery = request.getCallQuery();
            if (callQuery == null || (query = callQuery.getQuery()) == null || query.getResult() == null || query.getResult().getResultType() == 3 || !DBUtils.isEmptyString(query.getResult().getElementName())) continue;
            throw new DataServiceFault("The request '" + request.getRequestName() + "' contains the query with id '" + query.getQueryId() + "' contains an XML result with no element wrapper.");
        }
    }

    private AxisService createDBService(String configFilePath, AxisConfiguration axisConfiguration) throws DataServiceFault {
        FileInputStream fis = null;
        try {
            this.convertConfigToMultipleDSFormat(configFilePath);
            fis = new FileInputStream(configFilePath);
            OMElement dbsElement = new StAXOMBuilder((InputStream)fis).getDocumentElement();
            dbsElement.build();
            this.secureVaultResolve(dbsElement);
            DataService dataService = DataServiceFactory.createDataService(dbsElement, configFilePath);
            String serviceName = dataService.getName();
            for (String configId : dataService.getConfigs().keySet()) {
                Config config = dataService.getConfig(configId);
                if (!config.isODataEnabled()) continue;
                ODataServiceHandler serviceHandler = new ODataServiceHandler(config.createODataHandler(), dataService.getServiceNamespace(), configId);
                CarbonContext cCtx = CarbonContext.getThreadLocalCarbonContext();
                this.registerODataHandler(dataService.getName(), serviceHandler, cCtx.getTenantDomain(), configId);
            }
            this.validateDataService(dataService);
            String interfaceName = serviceName + "Interface";
            AxisService axisService = new AxisService(serviceName);
            try {
                axisService.setFileName(new URL("file://" + configFilePath));
            }
            catch (MalformedURLException e) {
                throw new DataServiceFault(e);
            }
            axisService.setTargetNamespace(dataService.getServiceNamespace());
            axisService.addParameter(new Parameter("serviceType", (Object)"data_service"));
            axisService.addParameter("org.wso2.ws.dataservice.dataservice.obj", (Object)dataService);
            axisService.setDocumentation(dataService.getDescription());
            this.httpLocationTable = new TreeMap<String, AxisOperation>(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return -1 * o1.compareTo(o2);
                }
            });
            this.httpLocationTableForResource = new TreeMap<Pattern, AxisOperation>(new Comparator<Pattern>(){

                @Override
                public int compare(Pattern o1, Pattern o2) {
                    return -1 * o1.pattern().compareTo(o2.pattern());
                }
            });
            AxisBinding soap11Binding = this.createDefaultSOAP11Binding(serviceName, interfaceName);
            AxisBinding soap12Binding = this.createDefaultSOAP12Binding(serviceName, interfaceName);
            AxisBinding httpBinding = this.createDefaultHTTPBinding(serviceName, interfaceName);
            Set<Resource.ResourceID> resourceIds = dataService.getResourceIds();
            NavigableSet<Resource.ResourceID> sortedResourceIds = new TreeSet<Resource.ResourceID>(resourceIds).descendingSet();
            for (Resource.ResourceID resourceId : sortedResourceIds) {
                Resource resource = dataService.getResource(resourceId);
                AxisOperation axisOperation = this.createAxisOperationFromDSResource(resource, soap11Binding, soap12Binding, httpBinding);
                axisService.addOperation(axisOperation);
                this.axisConfig.getPhasesInfo().setOperationPhases(axisOperation);
            }
            Iterator<String> opPathItr = dataService.getOperationNames().iterator();
            while (opPathItr.hasNext()) {
                Operation operation = dataService.getOperation(opPathItr.next());
                AxisOperation axisOperation = this.createAxisOperationFromDSOperation(operation, soap11Binding, soap12Binding, httpBinding);
                axisService.addOperation(axisOperation);
                this.axisConfig.getPhasesInfo().setOperationPhases(axisOperation);
            }
            this.createDefaultEndpoints(axisService, soap11Binding, soap12Binding, httpBinding);
            this.createDSSchema(axisService, dataService);
            if (dataService.isBoxcarringEnabled() && !dataService.isDisableLegacyBoxcarringMode()) {
                axisService.setScope("transportsession");
            }
            this.registerMBean(dataService);
            axisService.setActive(!dataService.isServiceInactive());
            AxisService axisService2 = axisService;
            return axisService2;
        }
        catch (FileNotFoundException e) {
            throw new DataServiceFault(e, "Error reading service configuration file.");
        }
        catch (XMLStreamException e) {
            throw new DataServiceFault(e, "Error while parsing the service configuration file.");
        }
        catch (AxisFault e) {
            throw new DataServiceFault(e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"Error in closing data services configuration file", (Throwable)e);
            }
        }
    }

    private void registerMBean(DataService dataService) {
        DataServiceInstance dsMBean = new DataServiceInstance(dataService);
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        if (server != null) {
            try {
                ObjectName objectName = new ObjectName("org.wso2.carbon.dataservices.jmx:section=Services,service=" + dsMBean.getServiceName());
                try {
                    server.unregisterMBean(objectName);
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                server.registerMBean(dsMBean, objectName);
            }
            catch (Exception e) {
                log.error((Object)"Error in Registering Data Services MBean", (Throwable)e);
            }
        }
    }

    private void createAxisBindingMessage(AxisBindingOperation bindingOperation, AxisMessage inMessage, String label, boolean isFault) {
        AxisBindingMessage soap11InBindingMessage = new AxisBindingMessage();
        soap11InBindingMessage.setName(inMessage.getName());
        soap11InBindingMessage.setAxisMessage(inMessage);
        soap11InBindingMessage.setParent((AxisDescription)bindingOperation);
        if (isFault) {
            soap11InBindingMessage.setFault(true);
            bindingOperation.addFault(soap11InBindingMessage);
        } else {
            soap11InBindingMessage.setFault(false);
            bindingOperation.addChild((Object)label, (AxisDescription)soap11InBindingMessage);
        }
    }

    private AxisBindingOperation createDefaultHTTPBindingOperation(AxisOperation axisOp, String httpLocation, String httpMethod, AxisBinding httpBinding) {
        AxisBindingOperation httpBindingOperation = new AxisBindingOperation();
        httpBindingOperation.setAxisOperation(axisOp);
        httpBindingOperation.setName(axisOp.getName());
        httpBindingOperation.setParent((AxisDescription)httpBinding);
        httpBindingOperation.setProperty("whttp:location", (Object)httpLocation);
        httpBindingOperation.setProperty("whttp:method", (Object)httpMethod);
        httpBinding.addChild((Object)httpBindingOperation.getName(), (AxisDescription)httpBindingOperation);
        return httpBindingOperation;
    }

    private AxisBindingOperation createDefaultSOAP12BindingOperation(AxisOperation axisOp, String httpLocation, String inputAction, AxisBinding soap12Binding) {
        AxisBindingOperation soap12BindingOperation = new AxisBindingOperation();
        soap12BindingOperation.setAxisOperation(axisOp);
        soap12BindingOperation.setName(axisOp.getName());
        soap12BindingOperation.setParent((AxisDescription)soap12Binding);
        soap12BindingOperation.setProperty("whttp:location", (Object)httpLocation);
        soap12Binding.addChild((Object)soap12BindingOperation.getName(), (AxisDescription)soap12BindingOperation);
        soap12BindingOperation.setProperty("wsoap:action", (Object)inputAction);
        return soap12BindingOperation;
    }

    private AxisBindingOperation createDefaultSOAP11BindingOperation(AxisOperation axisOp, String httpLocation, String inputAction, AxisBinding soap11Binding) {
        AxisBindingOperation soap11BindingOperation = new AxisBindingOperation();
        soap11BindingOperation.setAxisOperation(axisOp);
        soap11BindingOperation.setName(axisOp.getName());
        soap11BindingOperation.setParent((AxisDescription)soap11Binding);
        soap11BindingOperation.setProperty("whttp:location", (Object)httpLocation);
        soap11Binding.addChild((Object)soap11BindingOperation.getName(), (AxisDescription)soap11BindingOperation);
        soap11BindingOperation.setProperty("wsoap:action", (Object)inputAction);
        return soap11BindingOperation;
    }

    private AxisBinding createDefaultSOAP11Binding(String name, String interfaceName) {
        AxisBinding soap11Binding = new AxisBinding();
        soap11Binding.setName(new QName(name + "SOAP11Binding"));
        soap11Binding.setType("http://www.w3.org/ns/wsdl/soap");
        soap11Binding.setProperty("wsoap:protocol", (Object)"http://www.w3.org/2003/05/soap/bindings/HTTP");
        soap11Binding.setProperty("wsoap:version", (Object)"http://schemas.xmlsoap.org/soap/envelope/");
        soap11Binding.setProperty("interface", (Object)interfaceName);
        soap11Binding.setProperty("HTTPLocationTable", this.httpLocationTable);
        soap11Binding.setProperty("HTTPLocationTableForResource", this.httpLocationTableForResource);
        return soap11Binding;
    }

    private AxisBinding createDefaultHTTPBinding(String name, String interfaceName) {
        AxisBinding httpBinding = new AxisBinding();
        httpBinding.setName(new QName(name + "HttpBinding"));
        httpBinding.setType("http://www.w3.org/ns/wsdl/http");
        httpBinding.setProperty("interface", (Object)interfaceName);
        httpBinding.setProperty("HTTPLocationTable", this.httpLocationTable);
        httpBinding.setProperty("HTTPLocationTableForResource", this.httpLocationTableForResource);
        return httpBinding;
    }

    private AxisBinding createDefaultSOAP12Binding(String name, String interfaceName) {
        AxisBinding soap12Binding = new AxisBinding();
        soap12Binding.setName(new QName(name + "SOAP12Binding"));
        soap12Binding.setType("http://www.w3.org/ns/wsdl/soap");
        soap12Binding.setProperty("wsoap:protocol", (Object)"http://www.w3.org/2003/05/soap/bindings/HTTP");
        soap12Binding.setProperty("wsoap:version", (Object)"http://www.w3.org/2003/05/soap-envelope");
        soap12Binding.setProperty("interface", (Object)interfaceName);
        soap12Binding.setProperty("HTTPLocationTable", this.httpLocationTable);
        soap12Binding.setProperty("HTTPLocationTableForResource", this.httpLocationTableForResource);
        return soap12Binding;
    }

    private void createDefaultEndpoints(AxisService axisService, AxisBinding soap11Binding, AxisBinding soap12Binding, AxisBinding httpBinding) {
        HashMap transportsIn = this.axisConfig.getTransportsIn();
        Iterator iterator = transportsIn.values().iterator();
        while (iterator.hasNext()) {
            boolean needHttp = false;
            String prefix = "";
            TransportInDescription transportIn = (TransportInDescription)iterator.next();
            String transportInName = transportIn.getName();
            if (HTTP_TRANSPORT.equalsIgnoreCase(transportInName)) {
                needHttp = true;
            } else if (HTTPS_TRANSPORT.equalsIgnoreCase(transportInName)) {
                needHttp = true;
                prefix = "Secure";
            } else if (transportInName != null) {
                prefix = transportInName.toUpperCase();
            }
            AxisEndpoint soap11Endpoint = new AxisEndpoint();
            String soap11EndpointName = prefix + "SOAP11Endpoint";
            soap11Endpoint.setName(soap11EndpointName);
            soap11Endpoint.setBinding(soap11Binding);
            soap11Endpoint.setParent(axisService);
            soap11Endpoint.setTransportInDescription(transportInName);
            soap11Endpoint.setProperty("HTTPLocationTable", this.httpLocationTable);
            soap11Endpoint.setProperty("HTTPLocationTableForResource", this.httpLocationTableForResource);
            axisService.addEndpoint(soap11EndpointName, soap11Endpoint);
            axisService.setEndpointName(soap11EndpointName);
            AxisEndpoint soap12Endpoint = new AxisEndpoint();
            String soap12EndpointName = prefix + "SOAP12Endpoint";
            soap12Endpoint.setName(soap12EndpointName);
            soap12Endpoint.setBinding(soap12Binding);
            soap12Endpoint.setParent(axisService);
            soap12Endpoint.setTransportInDescription(transportInName);
            soap12Endpoint.setProperty("HTTPLocationTable", this.httpLocationTable);
            soap12Endpoint.setProperty("HTTPLocationTableForResource", this.httpLocationTableForResource);
            axisService.addEndpoint(soap12EndpointName, soap12Endpoint);
            if (!needHttp) continue;
            AxisEndpoint httpEndpoint = new AxisEndpoint();
            String httpEndpointName = prefix + "HTTPEndpoint";
            httpEndpoint.setName(httpEndpointName);
            httpEndpoint.setBinding(httpBinding);
            httpEndpoint.setParent(axisService);
            httpEndpoint.setTransportInDescription(transportInName);
            httpEndpoint.setProperty("HTTPLocationTable", this.httpLocationTable);
            httpEndpoint.setProperty("HTTPLocationTableForResource", this.httpLocationTableForResource);
            axisService.addEndpoint(httpEndpointName, httpEndpoint);
        }
    }

    private AxisService handleTransports(DeploymentFileData file, AxisService axisService) throws DataServiceFault {
        try {
            StAXOMBuilder builder = new StAXOMBuilder((InputStream)new FileInputStream(file.getFile().getAbsoluteFile()));
            OMElement documentElement = builder.getDocumentElement();
            OMAttribute transports = documentElement.getAttribute(new QName("transports"));
            if (transports != null) {
                String[] transportArr = transports.getAttributeValue().split(" ");
                axisService.setExposedTransports(Arrays.asList(transportArr));
            }
        }
        catch (Exception e) {
            throw new DataServiceFault(e, "Error in processing transports info");
        }
        return axisService;
    }

    private AxisService processService(DeploymentFileData currentFile, AxisServiceGroup axisServiceGroup, ConfigurationContext configCtx) throws DataServiceFault {
        AxisService axisService = this.createDBService(currentFile.getAbsolutePath(), configCtx.getAxisConfiguration());
        axisService.setParent(axisServiceGroup);
        axisService.setClassLoader(this.axisConfig.getServiceClassLoader());
        this.handleTransports(currentFile, axisService);
        return axisService;
    }

    private boolean handleSecurityProxy(DeploymentFileData file, AxisService axisService) throws DataServiceFault {
        try {
            OMElement policyElement;
            boolean secEnabled = false;
            StAXOMBuilder builder = new StAXOMBuilder((InputStream)new FileInputStream(file.getFile().getAbsoluteFile()));
            OMElement documentElement = builder.getDocumentElement();
            OMElement enableSecElement = documentElement.getFirstChildWithName(new QName("enableSec"));
            if (enableSecElement != null) {
                secEnabled = true;
            }
            if ((policyElement = documentElement.getFirstChildWithName(new QName("policy"))) != null) {
                String policyKey = policyElement.getAttributeValue(new QName("key"));
                if (null == policyKey) {
                    throw new DataServiceFault("Policy key element should contain a policy key in " + file.getFile().getName());
                }
                Policy policy = PolicyEngine.getPolicy((InputStream)DBUtils.getInputStreamFromPath(policyKey));
                axisService.getPolicySubject().attachPolicy(policy);
            }
            return secEnabled;
        }
        catch (Exception e) {
            throw new DataServiceFault(e, "Error in processing security policy");
        }
    }

    private void secureVaultResolve(OMElement dbsElement) {
        String secretAliasAttr = dbsElement.getAttributeValue(new QName("http://org.wso2.securevault/configuration", "secretAlias"));
        if (secretAliasAttr != null) {
            dbsElement.setText(DBUtils.loadFromSecureVault(secretAliasAttr));
        }
        Iterator childEls = dbsElement.getChildElements();
        while (childEls.hasNext()) {
            this.secureVaultResolve((OMElement)childEls.next());
        }
    }

    private void removeODataHandler(String tenantDomain, String dataServiceName) throws DataServiceFault {
        ODataServiceRegistry registry = ODataServiceRegistry.getInstance();
        registry.removeODataService(tenantDomain, dataServiceName);
    }

    private void registerODataHandler(String dataServiceName, ODataServiceHandler handler, String tenantDomain, String configId) throws DataServiceFault {
        ODataServiceRegistry registry = ODataServiceRegistry.getInstance();
        registry.registerODataService(dataServiceName + configId, handler, tenantDomain);
    }
}

