/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.jaxp.OMSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XSLTTransformer {
    private static final Log log = LogFactory.getLog(DBUtils.class);
    private String xsltPath;
    private Transformer transformer;
    private XMLInputFactory xmlInputFactory;

    public XSLTTransformer(String xsltPath) throws TransformerConfigurationException, DataServiceFault, IOException {
        this.xsltPath = xsltPath;
        TransformerFactory tFactory = TransformerFactory.newInstance();
        try {
            XSLTTransformer.getSecuredDocumentBuilder(false).parse(DBUtils.getInputStreamFromPath(this.getXsltPath()));
        }
        catch (SAXException e) {
            throw new DataServiceFault(e, "Error in parsing XSLT file " + xsltPath + " Possible XML External entity attack, Error - " + e.getMessage());
        }
        catch (ParserConfigurationException e) {
            throw new DataServiceFault(e, "Error initializing secure document builder, Error - " + e.getMessage());
        }
        this.transformer = tFactory.newTransformer(new StreamSource(DBUtils.getInputStreamFromPath(this.getXsltPath())));
        this.xmlInputFactory = DBUtils.getXMLInputFactory();
    }

    public String getXsltPath() {
        return this.xsltPath;
    }

    public Transformer getTransformer() {
        return this.transformer;
    }

    public XMLInputFactory getXmlInputFactory() {
        return this.xmlInputFactory;
    }

    public OMElement transform(OMElement inputXML) throws DataServiceFault {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            OMSource xmlSource = new OMSource(inputXML);
            this.getTransformer().transform((Source)xmlSource, new StreamResult(outputStream));
            ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            XMLStreamReader reader = this.getXmlInputFactory().createXMLStreamReader(inputStream);
            StAXOMBuilder builder = new StAXOMBuilder(reader);
            return builder.getDocumentElement();
        }
        catch (Exception e) {
            String msg = "Error in transforming with XSLT: " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new DataServiceFault(e, msg);
        }
    }

    private static DocumentBuilder getSecuredDocumentBuilder(boolean setIgnoreComments) throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringComments(setIgnoreComments);
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setExpandEntityReferences(false);
        documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                throw new SAXException("Possible XML External Entity (XXE) attack. Skip resolving entity");
            }
        });
        return documentBuilder;
    }
}

