/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.admin;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.gdata.client.spreadsheet.SpreadsheetService;
import com.google.gdata.data.spreadsheet.CellFeed;
import com.google.gdata.util.AuthenticationException;
import com.google.gdata.util.ServiceException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.description.config.GSpreadConfig;
import org.wso2.carbon.dataservices.core.description.config.SQLCarbonDataSourceConfig;
import org.wso2.carbon.dataservices.core.description.query.QueryFactory;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.engine.DataServiceSerializer;
import org.wso2.carbon.dataservices.core.script.DSGenerator;
import org.wso2.carbon.dataservices.core.script.PaginatedTableInfo;
import org.wso2.carbon.dataservices.core.sqlparser.SQLParserUtil;
import org.wso2.carbon.utils.Pageable;

public class DataServiceAdmin
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(DataServiceAdmin.class);

    public String getDataServiceContentAsString(String serviceId) throws AxisFault {
        String filePath;
        String[] splitArray;
        AxisService axisService = this.getAxisConfig().getServiceForActivation(serviceId);
        StringBuffer fileContents = new StringBuffer();
        if (serviceId.contains("/") && (splitArray = serviceId.split("\\/")).length >= 1) {
            serviceId = splitArray[splitArray.length - 1];
        }
        if (axisService != null) {
            filePath = ((DataService)axisService.getParameter("org.wso2.ws.dataservice.dataservice.obj").getValue()).getDsLocation();
        } else {
            URL repositoryURL = this.getAxisConfig().getRepository();
            String repositoryURLPath = repositoryURL.getPath();
            if (repositoryURLPath != null && !repositoryURLPath.endsWith("/")) {
                repositoryURLPath = repositoryURLPath + "/";
            }
            filePath = repositoryURLPath + "dataservices" + File.separator + serviceId + "." + "dbs";
        }
        if (filePath != null) {
            File config = new File(filePath);
            try {
                String str;
                FileReader fileReader = new FileReader(config);
                BufferedReader in = new BufferedReader(fileReader);
                while ((str = in.readLine()) != null) {
                    fileContents.append(str + "\n");
                }
                in.close();
            }
            catch (IOException e) {
                throw new AxisFault("Error while reading the contents from the service config file for service '" + serviceId + "'", (Throwable)e);
            }
        }
        return fileContents.toString();
    }

    protected String getDataServiceFileExtension() {
        ConfigurationContext configCtx = this.getConfigContext();
        String fileExtension = (String)configCtx.getProperty("local_org.wso2.ws.dataservice.db_service_extension");
        return fileExtension;
    }

    public void saveDataService(String serviceName, String serviceHierarchy, String serviceContents) throws AxisFault {
        String dataServiceFilePath;
        String[] splitArray;
        ConfigurationContext configCtx = this.getConfigContext();
        AxisConfiguration axisConfig = configCtx.getAxisConfiguration();
        AxisService axisService = DBUtils.getActiveAxisServiceAccordingToDataServiceGroup(axisConfig, serviceName);
        if (serviceName.contains("/") && (splitArray = serviceName.split("\\/")).length >= 1) {
            String fullServiceName = serviceName;
            serviceName = splitArray[splitArray.length - 1];
            serviceHierarchy = splitArray[splitArray.length - 2];
            serviceContents = serviceContents.replace(fullServiceName, serviceName);
        }
        if (serviceHierarchy == null) {
            serviceHierarchy = "";
        }
        if (axisService == null) {
            String axis2RepoDirectory = axisConfig.getRepository().getPath();
            String repoDirectory = (String)configCtx.getProperty("local_org.wso2.ws.dataservice.db_service_repo");
            String fileExtension = this.getDataServiceFileExtension();
            String dataServiceDirectory = axis2RepoDirectory + File.separator + repoDirectory + File.separator + serviceHierarchy;
            dataServiceFilePath = dataServiceDirectory + File.separator + serviceName + "." + fileExtension;
            File directory = new File(dataServiceDirectory);
            if (!directory.exists() && !directory.mkdirs()) {
                throw new AxisFault("Cannot create directory: " + directory.getAbsolutePath());
            }
        } else {
            dataServiceFilePath = ((DataService)axisService.getParameter("org.wso2.ws.dataservice.dataservice.obj").getValue()).getDsLocation();
            AxisServiceGroup axisServiceGroup = axisService.getAxisServiceGroup();
            axisServiceGroup.addParameter("keepServiceHistory", (Object)Boolean.TRUE.toString());
            axisServiceGroup.addParameter("preserveServiceHistory", (Object)Boolean.TRUE.toString());
            axisService.addParameter("keepServiceHistory", (Object)Boolean.TRUE.toString());
            axisService.addParameter("preserveServiceHistory", (Object)Boolean.TRUE.toString());
        }
        serviceContents = DBUtils.prettifyXML(serviceContents);
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(dataServiceFilePath));
            out.write(serviceContents);
            out.close();
        }
        catch (IOException e) {
            log.error((Object)("Error while saving " + serviceName), (Throwable)e);
            throw new AxisFault("Error occurred while writing the contents for the service config file for the new service " + serviceName, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String testJDBCConnection(String driverClass, String jdbcURL, String username, String password, String passwordAlias) {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        Connection connection = null;
        try {
            String message;
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(tenantId);
            if (driverClass == null || driverClass.length() == 0) {
                String message2 = "Driver class is missing";
                if (log.isDebugEnabled()) {
                    log.debug((Object)message2);
                }
                String string = message2;
                return string;
            }
            if (jdbcURL == null || jdbcURL.length() == 0) {
                String message3 = "Driver connection URL is missing";
                if (log.isDebugEnabled()) {
                    log.debug((Object)message3);
                }
                String string = message3;
                return string;
            }
            String resolvePwd = null != passwordAlias && !passwordAlias.isEmpty() ? DBUtils.loadFromSecureVault(passwordAlias) : password;
            Class.forName(driverClass.trim());
            if (null != username && !username.isEmpty()) {
                connection = DriverManager.getConnection(jdbcURL, username, resolvePwd);
                message = "Database connection is successful with driver class " + driverClass + " , jdbc url " + jdbcURL + " and user name " + username;
            } else {
                connection = DriverManager.getConnection(jdbcURL);
                message = "Database connection is successful with driver class " + driverClass + " , jdbc url " + jdbcURL;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)message);
            }
            String string = message;
            return string;
        }
        catch (SQLException e) {
            String message = null != username && !username.isEmpty() ? "Could not connect to database " + jdbcURL + " with username " + username : "Could not connect to database " + jdbcURL;
            log.error((Object)message, (Throwable)e);
            String string = message;
            return string;
        }
        catch (ClassNotFoundException e) {
            String message = "Driver class " + driverClass + " can not be loaded";
            log.error((Object)message, (Throwable)e);
            String string = message;
            return string;
        }
        catch (Exception e) {
            String message;
            String string = message = "Could not connect to database " + jdbcURL + ", Error message - " + e.getMessage();
            return string;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException ignored) {}
            }
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    public String testGSpreadConnection(String clientId, String clientSecret, String refreshToken, String visibility, String documentURL) {
        String message;
        String key;
        if (DBUtils.isEmptyString(documentURL)) {
            String message2 = "Document URL is empty";
            log.debug((Object)message2);
            return message2;
        }
        SpreadsheetService service = new SpreadsheetService("GSpread Connection Service");
        try {
            key = GSpreadConfig.extractKey(documentURL);
        }
        catch (DataServiceFault e) {
            String message3 = "Invalid documentURL:" + documentURL;
            log.error((Object)message3, (Throwable)e);
            return message3;
        }
        if (!visibility.equals("public")) {
            if (DBUtils.isEmptyString(clientId)) {
                String message4 = "clientId field is empty";
                log.error((Object)message4);
                return message4;
            }
            if (DBUtils.isEmptyString(clientSecret)) {
                String message5 = "clientSecret field is empty";
                log.error((Object)message5);
                return message5;
            }
            if (DBUtils.isEmptyString(refreshToken)) {
                String message6 = "refreshToken field is empty";
                log.error((Object)message6);
                return message6;
            }
            NetHttpTransport httpTransport = new NetHttpTransport();
            JacksonFactory jsonFactory = new JacksonFactory();
            GoogleCredential credential = new GoogleCredential.Builder().setClientSecrets(clientId, clientSecret).setTransport((HttpTransport)httpTransport).setJsonFactory((JsonFactory)jsonFactory).build();
            credential.setRefreshToken(refreshToken);
            try {
                credential.refreshToken();
            }
            catch (IOException e) {
                String message7 = "Google spreadsheet connection failed, Error refreshing the token ";
                log.debug((Object)message7);
                return message7;
            }
            service.setOAuth2Credentials((Credential)credential);
        }
        String worksheetFeedURL = "https://spreadsheets.google.com/feeds/worksheets/" + key + "/" + visibility + "/basic";
        try {
            URL url = new URL(worksheetFeedURL);
            try {
                service.getFeed(url, CellFeed.class);
                message = "Google spreadsheet connection is successfull ";
                log.debug((Object)message);
                return message;
            }
            catch (AuthenticationException e) {
                String message8 = "Invalid Credentials";
                log.error((Object)message8, (Throwable)e);
                return message8;
            }
            catch (IOException e) {
                String message9 = "URL Not found:" + documentURL;
                log.error((Object)message9, (Throwable)e);
                return message9;
            }
            catch (ServiceException e) {
                String message10 = "URL Not found:" + documentURL;
                log.error((Object)message10, (Throwable)e);
                return message10;
            }
        }
        catch (MalformedURLException e) {
            message = "Invalid documentURL:" + documentURL;
            log.error((Object)message, (Throwable)e);
            return message;
        }
    }

    public String[] getAvailableDS() throws AxisFault {
        return DBUtils.getAvailableDS(this.getAxisConfig());
    }

    public boolean isDSNameAvailable(String dataService) throws AxisFault {
        return DBUtils.isAvailableDS(this.getAxisConfig(), dataService);
    }

    public String[] getCarbonDataSourceNames() {
        List<String> list = SQLCarbonDataSourceConfig.getCarbonDataSourceNames();
        return list.toArray(new String[list.size()]);
    }

    public String[] getCarbonDataSourceNamesForTypes(String[] types) {
        List<String> list = SQLCarbonDataSourceConfig.getCarbonDataSourceNamesForType(types);
        return list.toArray(new String[list.size()]);
    }

    public String getCarbonDataSourceType(String dsName) {
        return SQLCarbonDataSourceConfig.getCarbonDataSourceType(dsName);
    }

    public String[] getOutputColumnNames(String sql) throws Exception {
        try {
            List<String> columns = SQLParserUtil.extractOutputColumns(sql);
            return columns.toArray(new String[columns.size()]);
        }
        catch (Exception e) {
            throw new AxisFault("Error occurred while generating response for the query " + sql + ".", (Throwable)e);
        }
    }

    public String[] getInputMappingNames(String sql) throws Exception {
        try {
            List<String> inputMappings = SQLParserUtil.extractInputMappingNames(sql);
            return inputMappings.toArray(new String[inputMappings.size()]);
        }
        catch (Exception e) {
            throw new AxisFault("Error occurred while generating input mappings for the query " + sql + ".", (Throwable)e);
        }
    }

    public String[] getdbSchemaList(String datasourceId) throws Exception {
        return DSGenerator.getSchemas(datasourceId);
    }

    public PaginatedTableInfo getPaginatedSchemaInfo(int pageNumber, String datasourceId) throws Exception {
        ArrayList temp = new ArrayList();
        Collections.addAll(temp, this.getdbSchemaList(datasourceId));
        PaginatedTableInfo paginatedTableInfo = new PaginatedTableInfo();
        DataServiceAdmin.doPaging(pageNumber, temp, paginatedTableInfo);
        return paginatedTableInfo;
    }

    public String[] getTableList(String datasourceId, String dbName, String[] schemas) throws AxisFault {
        try {
            return DSGenerator.getTableList(datasourceId, dbName, schemas);
        }
        catch (Exception e) {
            throw new AxisFault("Error in retrieving table list: " + e.getMessage(), (Throwable)e);
        }
    }

    public PaginatedTableInfo getPaginatedTableInfo(int pageNumber, String datasourceId, String dbName, String[] schemas) throws Exception {
        List<String> tableInfoList = Arrays.asList(this.getTableList(datasourceId, dbName, schemas));
        PaginatedTableInfo paginatedTableInfo = new PaginatedTableInfo();
        DataServiceAdmin.doPaging(pageNumber, tableInfoList, paginatedTableInfo);
        return paginatedTableInfo;
    }

    public String[] getDSServiceList(String dataSourceId, String dbName, String[] schemas, String[] tableNames, boolean singleService, String serviceNamespace) throws Exception {
        DSGenerator generator = new DSGenerator(dataSourceId, dbName, schemas, tableNames, false, serviceNamespace, "");
        ArrayList<String> serviceNames = new ArrayList<String>();
        List<DataService> dsList = generator.getGeneratedServiceList();
        for (DataService ds : dsList) {
            OMElement element = DataServiceSerializer.serializeDataService(ds);
            this.saveDataService(ds.getName(), null, element.toString());
            serviceNames.add(ds.getName());
        }
        return serviceNames.toArray(new String[serviceNames.size()]);
    }

    public String getDSService(String dataSourceId, String dbName, String[] schemas, String[] tableNames, boolean singleService, String serviceName, String serviceNamespace) throws Exception {
        DSGenerator generator = new DSGenerator(dataSourceId, dbName, schemas, tableNames, true, serviceNamespace, serviceName);
        DataService dataservice = generator.getGeneratedService();
        OMElement element = DataServiceSerializer.serializeDataService(dataservice);
        this.saveDataService(dataservice.getName(), null, element.toString());
        return generator.getGeneratedService().getName();
    }

    private static <C> List<C> doPaging(int pageNumber, List<C> sourceList, Pageable pageable) {
        if (pageNumber < 0 || pageNumber == Integer.MAX_VALUE) {
            pageNumber = 0;
        }
        if (sourceList.size() == 0) {
            return sourceList;
        }
        if (pageNumber < 0) {
            throw new RuntimeException("Page number should be a positive integer. Page numbers begin at 0.");
        }
        int itemsPerPageInt = 60;
        int numberOfPages = (int)Math.ceil((double)sourceList.size() / (double)itemsPerPageInt);
        if (pageNumber > numberOfPages - 1) {
            pageNumber = numberOfPages - 1;
        }
        int startIndex = pageNumber * itemsPerPageInt;
        int endIndex = (pageNumber + 1) * itemsPerPageInt;
        ArrayList<C> returnList = new ArrayList<C>();
        for (int i = startIndex; i < endIndex && i < sourceList.size(); ++i) {
            returnList.add(sourceList.get(i));
        }
        pageable.setNumberOfPages(numberOfPages);
        pageable.set(returnList);
        return returnList;
    }

    public String validateJSONMapping(String jsonMapping) {
        try {
            QueryFactory.getJSONResultFromText(jsonMapping);
            return "";
        }
        catch (DataServiceFault e) {
            return e.getDsFaultMessage();
        }
    }

    public String[] getAllRoles(String authProviderConfig) throws AxisFault {
        try {
            return DBUtils.getAllRolesUsingAuthorizationProvider(authProviderConfig);
        }
        catch (DataServiceFault e) {
            throw new AxisFault("Error in retrieving role list: " + e.getMessage(), (Throwable)e);
        }
    }
}

