/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.auth;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.axiom.om.util.Base64;
import org.apache.axiom.util.base64.Base64Utils;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.core.util.KeyStoreManager;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.auth.AuthorizationProvider;

public class JWTAuthorizationProvider
implements AuthorizationProvider {
    private static final Log log = LogFactory.getLog(JWTAuthorizationProvider.class);
    private static final String HTTP_SERVLET_REQUEST = "transport.http.servletRequest";
    private static final String JWT_TOKEN_HEADER_NAME = "X-JWT-Assertion";
    private static final String UTF_8_ENCODING = "UTF-8";
    private String endUserClaim = null;
    private static final String ENDUSER_CLAIM = "http://wso2.org/claims/enduser";
    private static final String ENDUSER_CLAIM_PROPERTY_KEY = "claimUri";
    private static final String CLAIM_VALUE_SEPARATOR = "\":\"";
    private static final String ESCAPED_DOUBLE_QUOTATION = "\"";
    private static final String USERNAME = "username";
    private static ConcurrentHashMap<KeyStore, Certificate> publicCerts = new ConcurrentHashMap();
    private static ConcurrentHashMap<Integer, KeyStore> keyStores = new ConcurrentHashMap();

    @Override
    public String[] getUserRoles(MessageContext msgContext) throws DataServiceFault {
        return DBUtils.getUserRoles(this.getUsername(msgContext));
    }

    @Override
    public String[] getAllRoles() throws DataServiceFault {
        int tenantId = DBUtils.getCurrentUserTenantId();
        return DBUtils.getAllRoles(tenantId);
    }

    @Override
    public String getUsername(MessageContext msgContext) throws DataServiceFault {
        try {
            return this.extractUsernameFromJWT(msgContext);
        }
        catch (UnsupportedEncodingException e) {
            log.debug((Object)("Error in retrieving user name from message context - " + e.getMessage()), (Throwable)e);
            throw new DataServiceFault(e, "Error in retrieving user name from message context - " + e.getMessage());
        }
        catch (AxisFault axisFault) {
            log.debug((Object)("Error in retrieving user name from message context - " + axisFault.getMessage()), (Throwable)axisFault);
            throw new DataServiceFault(axisFault, "Error in retrieving user name from message context - " + axisFault.getMessage());
        }
    }

    @Override
    public void init(Map<String, String> authorizationProps) throws DataServiceFault {
        this.endUserClaim = authorizationProps.get(ENDUSER_CLAIM_PROPERTY_KEY);
    }

    private String extractUsernameFromJWT(MessageContext msgContext) throws UnsupportedEncodingException, AxisFault {
        String jwt;
        HttpServletRequest obj;
        if (this.endUserClaim == null || this.endUserClaim.isEmpty()) {
            this.endUserClaim = ENDUSER_CLAIM;
        }
        if ((obj = (HttpServletRequest)msgContext.getProperty(HTTP_SERVLET_REQUEST)) != null && (jwt = obj.getHeader(JWT_TOKEN_HEADER_NAME)) != null && this.validateSignature(jwt).booleanValue()) {
            String jwtToken = null;
            jwtToken = new String(Base64.decode((String)jwt), UTF_8_ENCODING);
            if (jwtToken != null) {
                String[] tempStr4 = jwtToken.split(this.endUserClaim + CLAIM_VALUE_SEPARATOR);
                String[] decoded = tempStr4[1].split(ESCAPED_DOUBLE_QUOTATION);
                System.out.println("tempStr4= " + tempStr4.toString());
                System.out.println("decoded=" + decoded.toString());
                return decoded[0];
            }
        }
        return null;
    }

    private Boolean validateSignature(String signedJWTToken) throws AxisFault {
        boolean isVerified = false;
        String[] split_string = signedJWTToken.split("\\.");
        String base64EncodedHeader = split_string[0];
        String base64EncodedBody = split_string[1];
        String base64EncodedSignature = split_string[2];
        String decodedHeader = new String(Base64Utils.decode((String)base64EncodedHeader));
        byte[] decodedSignature = Base64Utils.decode((String)base64EncodedSignature);
        Pattern pattern = Pattern.compile("^[^:]*:[^:]*:[^:]*:\"(.+)\"}$");
        Matcher matcher = pattern.matcher(decodedHeader);
        String base64EncodedCertThumb = null;
        if (matcher.find()) {
            base64EncodedCertThumb = matcher.group(1);
        }
        byte[] decodedCertThumb = Base64Utils.decode(base64EncodedCertThumb);
        KeyStore keystore = this.getKeyStore();
        Certificate publicCert = null;
        if (keystore != null) {
            publicCert = publicCerts.get(keystore);
            if (publicCert == null) {
                String alias = this.getAliasForX509CertThumb(decodedCertThumb, keystore);
                try {
                    publicCert = keystore.getCertificate(alias);
                }
                catch (KeyStoreException e) {
                    log.error((Object)"Error getting public certificate from keystore using alias");
                    throw new AxisFault("Error getting public certificate from keystore using alias");
                }
            }
        } else {
            log.error((Object)"No keystore found");
            throw new AxisFault("No keystore found");
        }
        if (publicCert != null) {
            try {
                Signature verifySig = null;
                verifySig = Signature.getInstance("SHA256withRSA");
                verifySig.initVerify(publicCert);
                verifySig.update((base64EncodedHeader + "." + base64EncodedBody).getBytes());
                isVerified = verifySig.verify(decodedSignature);
            }
            catch (NoSuchAlgorithmException e) {
                log.error((Object)"SHA256withRSA cannot be found");
                throw new AxisFault("SHA256withRSA cannot be found");
            }
            catch (InvalidKeyException e) {
                log.error((Object)"Invalid Key");
                throw new AxisFault("Invalid Key");
            }
            catch (SignatureException e) {
                log.error((Object)"Signature Object not initialized properly");
                throw new AxisFault("Signature Object not initialized properly");
            }
        } else {
            log.error((Object)"No public cert found");
            throw new AxisFault("No public cert found");
        }
        if (!isVerified) {
            log.error((Object)"Signature validation failed");
            throw new AxisFault("Signature validation failed");
        }
        return isVerified;
    }

    private KeyStore getKeyStore() throws AxisFault {
        String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        KeyStore keyStore = keyStores.get(tenantId);
        if (keyStore == null) {
            KeyStoreManager tenantKSM = KeyStoreManager.getInstance((int)tenantId);
            try {
                if (!tenantDomain.equals("carbon.super")) {
                    String ksName = tenantDomain.trim().replace(".", "-");
                    String jksName = ksName + ".jks";
                    keyStore = tenantKSM.getKeyStore(jksName);
                } else {
                    keyStore = tenantKSM.getPrimaryKeyStore();
                }
            }
            catch (Exception e) {
                log.error((Object)"Error getting keystore");
                throw new AxisFault("Error getting keystore");
            }
        }
        return keyStore;
    }

    private String getAliasForX509CertThumb(byte[] thumb, KeyStore keyStore) throws AxisFault {
        Certificate cert = null;
        MessageDigest sha = null;
        try {
            sha = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e1) {
            log.error((Object)"noSHA1availabe");
            throw new AxisFault("noSHA1availabe");
        }
        try {
            Enumeration<String> e = keyStore.aliases();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                Certificate[] certs = keyStore.getCertificateChain(alias);
                if (certs == null || certs.length == 0) {
                    cert = keyStore.getCertificate(alias);
                    if (cert == null) {
                        return null;
                    }
                } else {
                    cert = certs[0];
                }
                if (!(cert instanceof X509Certificate)) continue;
                sha.reset();
                try {
                    sha.update(cert.getEncoded());
                }
                catch (CertificateEncodingException e1) {
                    log.error((Object)"Error encoding certificate");
                    throw new AxisFault("Error encoding certificate");
                }
                byte[] data = sha.digest();
                if (!new String(thumb).equals(this.hexify(data))) continue;
                return alias;
            }
        }
        catch (KeyStoreException e) {
            log.error((Object)"KeyStore exception while getting alias for X509CertThumb");
            throw new AxisFault("KeyStore exception while getting alias for X509CertThumb");
        }
        return null;
    }

    private String hexify(byte[] bytes) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuffer buf = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            buf.append(hexDigits[(bytes[i] & 0xF0) >> 4]);
            buf.append(hexDigits[bytes[i] & 0xF]);
        }
        return buf.toString();
    }
}

