/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.description.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.description.config.Config;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.odata.ODataDataHandler;
import org.wso2.carbon.dataservices.core.odata.ODataServiceFault;

public class ExcelConfig
extends Config {
    private static final Log log = LogFactory.getLog(ExcelConfig.class);
    private String excelDataSourcePath = this.getProperty("excel_datasource").trim();

    public ExcelConfig(DataService dataService, String configId, Map<String, String> properties, boolean odataEnable) {
        super(dataService, configId, "EXCEL", properties, odataEnable);
    }

    public String getExcelDataSourcePath() {
        return this.excelDataSourcePath;
    }

    public Workbook createWorkbook() throws IOException, InvalidFormatException, DataServiceFault {
        InputStream ins = DBUtils.getInputStreamFromPath(this.getExcelDataSourcePath());
        Workbook wb = WorkbookFactory.create((InputStream)ins);
        return wb;
    }

    @Override
    public boolean isActive() {
        try {
            Workbook wb = this.createWorkbook();
            return wb != null;
        }
        catch (Exception e) {
            log.error((Object)"Error in checking Excel config availability", (Throwable)e);
            return false;
        }
    }

    @Override
    public void close() {
    }

    @Override
    public ODataDataHandler createODataHandler() throws ODataServiceFault {
        throw new ODataServiceFault("Expose as OData Service feature doesn't support for the " + this.getConfigId() + " Datasource.");
    }

    @Override
    public boolean isResultSetFieldsCaseSensitive() {
        return false;
    }
}

