/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.description.query;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.sql.DataSource;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.wso2.carbon.dataservices.common.DBConstants;
import org.wso2.carbon.dataservices.common.RDBMSUtils;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.description.config.Config;
import org.wso2.carbon.dataservices.core.description.config.JNDIConfig;
import org.wso2.carbon.dataservices.core.description.config.SQLCarbonDataSourceConfig;
import org.wso2.carbon.dataservices.core.description.event.EventTrigger;
import org.wso2.carbon.dataservices.core.description.query.CSVQuery;
import org.wso2.carbon.dataservices.core.description.query.CassandraQuery;
import org.wso2.carbon.dataservices.core.description.query.CustomQueryBasedDSQuery;
import org.wso2.carbon.dataservices.core.description.query.ExcelQuery;
import org.wso2.carbon.dataservices.core.description.query.GSpreadQuery;
import org.wso2.carbon.dataservices.core.description.query.MongoQuery;
import org.wso2.carbon.dataservices.core.description.query.Query;
import org.wso2.carbon.dataservices.core.description.query.RdfFileQuery;
import org.wso2.carbon.dataservices.core.description.query.SQLQuery;
import org.wso2.carbon.dataservices.core.description.query.SparqlEndpointQuery;
import org.wso2.carbon.dataservices.core.description.query.WebQuery;
import org.wso2.carbon.dataservices.core.engine.CallQuery;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.engine.OutputElementGroup;
import org.wso2.carbon.dataservices.core.engine.ParamValue;
import org.wso2.carbon.dataservices.core.engine.QueryParam;
import org.wso2.carbon.dataservices.core.engine.Result;
import org.wso2.carbon.dataservices.core.engine.SQLDialect;
import org.wso2.carbon.dataservices.core.engine.StaticOutputElement;
import org.wso2.carbon.dataservices.core.validation.Validator;
import org.wso2.carbon.dataservices.core.validation.ValidatorExt;
import org.wso2.carbon.dataservices.core.validation.standard.ArrayTypeValidator;
import org.wso2.carbon.dataservices.core.validation.standard.DoubleRangeValidator;
import org.wso2.carbon.dataservices.core.validation.standard.LengthValidator;
import org.wso2.carbon.dataservices.core.validation.standard.LongRangeValidator;
import org.wso2.carbon.dataservices.core.validation.standard.PatternValidator;
import org.wso2.carbon.dataservices.core.validation.standard.ScalarTypeValidator;

public class QueryFactory {
    private QueryFactory() {
    }

    public static Query createQuery(DataService dataService, OMElement queryEl) throws DataServiceFault {
        Query query;
        String configId = QueryFactory.getConfigId(queryEl);
        Config config = dataService.getConfig(configId);
        if (config == null) {
            throw new DataServiceFault("Invalid configId: " + configId + " in :- \n" + queryEl);
        }
        String sourceType = config.getType();
        if ("RDBMS".equals(sourceType) || "JNDI".equals(sourceType) || "CARBON_DATASOURCE".equals(sourceType) || "CUSTOM_TABULAR".equals(sourceType)) {
            query = QueryFactory.createSQLQuery(dataService, queryEl);
        } else if ("CSV".equals(sourceType)) {
            query = QueryFactory.createCSVQuery(dataService, queryEl);
        } else if ("EXCEL".equals(sourceType)) {
            query = QueryFactory.createExcelQuery(dataService, queryEl);
        } else if ("GDATA_SPREADSHEET".equals(sourceType)) {
            query = QueryFactory.createGSpreadQuery(dataService, queryEl);
        } else if ("RDF".equals(sourceType)) {
            query = QueryFactory.createRdfFileQuery(dataService, queryEl);
        } else if ("SPARQL".equals(sourceType)) {
            query = QueryFactory.createSparqlEndpointQuery(dataService, queryEl);
        } else if ("MongoDB".equals(sourceType)) {
            query = QueryFactory.createMongoQuery(dataService, queryEl);
        } else if ("WEB_CONFIG".equals(sourceType)) {
            query = QueryFactory.createWebQuery(dataService, queryEl);
        } else if ("CUSTOM_QUERY".equals(sourceType)) {
            query = QueryFactory.createCustomQuery(dataService, queryEl);
        } else if ("Cassandra".equals(sourceType)) {
            query = QueryFactory.createCassandraQuery(dataService, queryEl);
        } else {
            throw new DataServiceFault("Invalid configType: " + sourceType + " in :- \n" + queryEl);
        }
        return query;
    }

    private static String getConfigId(OMElement queryEl) {
        String configId = queryEl.getAttributeValue(new QName("useConfig"));
        if (configId == null) {
            configId = "default";
        }
        return configId;
    }

    private static String getQueryId(OMElement queryEl) {
        return queryEl.getAttributeValue(new QName("id"));
    }

    private static String getCustomQuery(OMElement queryEl) {
        return ((OMElement)queryEl.getChildrenWithLocalName("expression").next()).getText();
    }

    private static String getQueryVariable(OMElement queryEl) {
        return queryEl.getFirstChildWithName(new QName("scraperVariable")).getText();
    }

    private static String extractQueryInputNamespace(DataService dataService, Result result, OMElement queryEl) {
        String inputNamespace = queryEl.getAttributeValue(new QName("inputNamespace"));
        if (DBUtils.isEmptyString(inputNamespace)) {
            if (result != null) {
                inputNamespace = result.getNamespace();
            }
            if (DBUtils.isEmptyString(inputNamespace)) {
                inputNamespace = dataService.getDefaultNamespace();
            }
        }
        return inputNamespace;
    }

    private static RdfFileQuery createRdfFileQuery(DataService dataService, OMElement queryEl) throws DataServiceFault {
        String inputNamespace;
        Result result;
        EventTrigger[] eventTriggers;
        String sparql;
        String configId;
        String queryId;
        try {
            queryId = QueryFactory.getQueryId(queryEl);
            configId = QueryFactory.getConfigId(queryEl);
            sparql = queryEl.getFirstChildWithName(new QName("sparql")).getText();
            eventTriggers = QueryFactory.getEventTriggers(dataService, queryEl);
            result = QueryFactory.getResultFromQueryElement(dataService, queryEl);
            inputNamespace = QueryFactory.extractQueryInputNamespace(dataService, result, queryEl);
        }
        catch (Exception e) {
            throw new DataServiceFault(e, "Error in parsing SPARQL query element");
        }
        RdfFileQuery query = new RdfFileQuery(dataService, queryId, configId, sparql, QueryFactory.getQueryParamsFromQueryElement(queryEl), result, eventTriggers[0], eventTriggers[1], QueryFactory.extractAdvancedProps(queryEl), inputNamespace);
        return query;
    }

    private static SparqlEndpointQuery createSparqlEndpointQuery(DataService dataService, OMElement queryEl) throws DataServiceFault {
        String inputNamespace;
        Result result;
        EventTrigger[] eventTriggers;
        String sparql;
        String configId;
        String queryId;
        try {
            queryId = QueryFactory.getQueryId(queryEl);
            configId = QueryFactory.getConfigId(queryEl);
            sparql = queryEl.getFirstChildWithName(new QName("sparql")).getText();
            eventTriggers = QueryFactory.getEventTriggers(dataService, queryEl);
            result = QueryFactory.getResultFromQueryElement(dataService, queryEl);
            inputNamespace = QueryFactory.extractQueryInputNamespace(dataService, result, queryEl);
        }
        catch (Exception e) {
            throw new DataServiceFault(e, "Error in parsing SPARQL query element");
        }
        SparqlEndpointQuery query = new SparqlEndpointQuery(dataService, queryId, configId, sparql, QueryFactory.getQueryParamsFromQueryElement(queryEl), result, eventTriggers[0], eventTriggers[1], QueryFactory.extractAdvancedProps(queryEl), inputNamespace);
        return query;
    }

    private static MongoQuery createMongoQuery(DataService dataService, OMElement queryEl) throws DataServiceFault {
        String inputNamespace;
        Result result;
        EventTrigger[] eventTriggers;
        String expression;
        String configId;
        String queryId;
        try {
            queryId = QueryFactory.getQueryId(queryEl);
            configId = QueryFactory.getConfigId(queryEl);
            expression = ((OMElement)queryEl.getChildrenWithLocalName("expression").next()).getText();
            eventTriggers = QueryFactory.getEventTriggers(dataService, queryEl);
            result = QueryFactory.getResultFromQueryElement(dataService, queryEl);
            inputNamespace = QueryFactory.extractQueryInputNamespace(dataService, result, queryEl);
        }
        catch (Exception e) {
            throw new DataServiceFault(e, "Error in parsing Mongo query element");
        }
        MongoQuery query = new MongoQuery(dataService, queryId, configId, expression, QueryFactory.getQueryParamsFromQueryElement(queryEl), result, eventTriggers[0], eventTriggers[1], QueryFactory.extractAdvancedProps(queryEl), inputNamespace);
        return query;
    }

    private static EventTrigger[] getEventTriggers(DataService dataService, OMElement queryEl) {
        EventTrigger inputEventTrigger = null;
        EventTrigger outputEventTrigger = null;
        String inTrigId = queryEl.getAttributeValue(new QName("input-event-trigger"));
        String outTrigId = queryEl.getAttributeValue(new QName("output-event-trigger"));
        if (inTrigId != null) {
            inputEventTrigger = dataService.getEventTrigger(inTrigId);
        }
        if (outTrigId != null) {
            outputEventTrigger = dataService.getEventTrigger(outTrigId);
        }
        return new EventTrigger[]{inputEventTrigger, outputEventTrigger};
    }

    private static Map<String, String> extractAdvancedProps(OMElement queryEl) {
        OMElement propsEl = queryEl.getFirstChildWithName(new QName("properties"));
        HashMap<String, String> advancedProperties = propsEl != null ? RDBMSUtils.convertConfigPropsFromV2toV3(DBUtils.extractProperties(propsEl)) : new HashMap<String, String>();
        return advancedProperties;
    }

    private static String[] extractKeyColumns(OMElement queryEl) {
        String keyColumnsStr = queryEl.getAttributeValue(new QName("keyColumns"));
        if (!DBUtils.isEmptyString(keyColumnsStr)) {
            String[] columns = keyColumnsStr.split(",");
            for (int i = 0; i < columns.length; ++i) {
                columns[i] = columns[i].trim();
            }
            return columns;
        }
        return null;
    }

    private static Iterator<OMElement> getSQLQueryElements(OMElement queryEl) {
        return queryEl.getChildrenWithName(new QName("sql"));
    }

    private static String getDefaultSQLQuery(OMElement queryEl) {
        String defaultSQL = null;
        Iterator<OMElement> itr = QueryFactory.getSQLQueryElements(queryEl);
        while (itr.hasNext()) {
            OMElement sqlQuery = itr.next();
            if (sqlQuery.getAttributeValue(new QName("dialect")) != null) continue;
            defaultSQL = sqlQuery.getText();
            break;
        }
        return defaultSQL;
    }

    private static List<SQLDialect> getDialectList(OMElement queryEl) throws DataServiceFault {
        Iterator<OMElement> itr = QueryFactory.getSQLQueryElements(queryEl);
        boolean isRepeated = false;
        ArrayList<SQLDialect> dialectList = new ArrayList<SQLDialect>();
        while (itr.hasNext()) {
            String[] dbTypes;
            OMElement sqlQuery = itr.next();
            String sqlDialectValue = sqlQuery.getAttributeValue(new QName("dialect"));
            HashSet<String> dialectSet = new HashSet<String>();
            TreeSet<String> intersect = null;
            SQLDialect sqlDialect = new SQLDialect();
            if (sqlDialectValue == null) continue;
            for (String dbType : dbTypes = sqlDialectValue.split(",")) {
                dialectSet.add(dbType);
            }
            for (SQLDialect dialect : dialectList) {
                intersect = new TreeSet<String>(dialect.getSqlDialects());
                intersect.retainAll(dialectSet);
                if (intersect.isEmpty()) continue;
                isRepeated = true;
            }
            if (!isRepeated) {
                sqlDialect.setSqlDialects(dialectSet);
                sqlDialect.setSqlQuery(sqlQuery.getText());
                dialectList.add(sqlDialect);
                continue;
            }
            Iterator it = intersect.iterator();
            StringBuilder builder = new StringBuilder();
            while (it.hasNext()) {
                builder.append((String)it.next());
                if (!it.hasNext()) continue;
                builder.append(" ");
            }
            throw new DataServiceFault("SQL Dialect(s) repeated: " + builder.toString());
        }
        return dialectList;
    }

    public static String getSQLQueryForConnectionURL(OMElement queryEl, String connectionURL) throws DataServiceFault {
        String driver = null;
        String sql = null;
        if (connectionURL != null) {
            String[] urlProp = connectionURL.split(":");
            if (urlProp.length > 2) {
                driver = urlProp[1];
            }
            List<SQLDialect> dialectList = QueryFactory.getDialectList(queryEl);
            block0: for (SQLDialect dialect : dialectList) {
                for (String dialectName : dialect.getSqlDialects()) {
                    if (driver == null || !driver.equals(dialectName)) continue;
                    sql = dialect.getSqlQuery();
                    continue block0;
                }
            }
        }
        if (sql == null && (sql = QueryFactory.getDefaultSQLQuery(queryEl)) == null) {
            throw new DataServiceFault("The query with the query element :-\n" + queryEl + "\n does not have a matching query dialect for the given " + "data source, and also doesn't provide a default query");
        }
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getSQLQueryForDatasource(OMElement queryEl, DataService dataService, String configId) throws DataServiceFault, SQLException, XMLStreamException {
        Connection con = null;
        Config config = dataService.getConfig(configId);
        String connectionURL = config.getProperty("url");
        if (connectionURL == null && (connectionURL = DBUtils.getConnectionURL4XADataSource(config)) == null) {
            String jndiDataSource;
            block14: {
                String carbonDSURL = config.getProperty("carbon_datasource_name");
                if (carbonDSURL != null) {
                    SQLCarbonDataSourceConfig carbonDSConfig = (SQLCarbonDataSourceConfig)dataService.getConfig(configId);
                    try {
                        DataSource ds = carbonDSConfig.getDataSource();
                        if (ds != null) {
                            con = ds.getConnection();
                            try {
                                connectionURL = con.getMetaData().getURL();
                            }
                            catch (Exception ignore) {}
                            break block14;
                        }
                        throw new DataServiceFault("Data source referred by the name '" + carbonDSConfig.getDataSourceName() + "' does not exist");
                    }
                    finally {
                        if (con != null) {
                            con.close();
                        }
                    }
                }
            }
            if ((jndiDataSource = config.getProperty("jndi_resource_name")) != null) {
                JNDIConfig jndiConfig = (JNDIConfig)dataService.getConfig(configId);
                try {
                    con = jndiConfig.getDataSource().getConnection();
                    connectionURL = con.getMetaData().getURL();
                }
                finally {
                    if (con != null) {
                        con.close();
                    }
                }
            }
        }
        return QueryFactory.getSQLQueryForConnectionURL(queryEl, connectionURL);
    }

    private static SQLQuery createSQLQuery(DataService dataService, OMElement queryEl) throws DataServiceFault {
        String inputNamespace;
        Result result;
        String[] keyColumns;
        EventTrigger[] eventTriggers;
        String sql;
        String configId;
        String queryId;
        boolean returnGeneratedKeys = false;
        boolean isReturnUpdatedRowCount = false;
        try {
            String returnUpdatedRowCountStr;
            queryId = QueryFactory.getQueryId(queryEl);
            configId = QueryFactory.getConfigId(queryEl);
            sql = QueryFactory.getSQLQueryForDatasource(queryEl, dataService, configId);
            eventTriggers = QueryFactory.getEventTriggers(dataService, queryEl);
            String returnRowIdStr = queryEl.getAttributeValue(new QName("returnGeneratedKeys"));
            if (returnRowIdStr != null) {
                returnGeneratedKeys = Boolean.parseBoolean(returnRowIdStr);
            }
            if (null != (returnUpdatedRowCountStr = queryEl.getAttributeValue(new QName("returnUpdatedRowCount")))) {
                isReturnUpdatedRowCount = Boolean.parseBoolean(returnUpdatedRowCountStr);
            }
            keyColumns = QueryFactory.extractKeyColumns(queryEl);
            result = QueryFactory.getResultFromQueryElement(dataService, queryEl);
            inputNamespace = QueryFactory.extractQueryInputNamespace(dataService, result, queryEl);
        }
        catch (XMLStreamException e) {
            throw new DataServiceFault(e, "Error in parsing SQL query element");
        }
        catch (SQLException e) {
            throw new DataServiceFault(e, DBConstants.FaultCodes.CONNECTION_UNAVAILABLE_ERROR, e.getMessage());
        }
        SQLQuery query = new SQLQuery(dataService, queryId, configId, returnGeneratedKeys, isReturnUpdatedRowCount, keyColumns, sql, QueryFactory.getQueryParamsFromQueryElement(queryEl), result, eventTriggers[0], eventTriggers[1], QueryFactory.extractAdvancedProps(queryEl), inputNamespace);
        return query;
    }

    private static CSVQuery createCSVQuery(DataService dataService, OMElement queryEl) throws DataServiceFault {
        String inputNamespace;
        Result result;
        EventTrigger[] eventTriggers;
        String configId;
        String queryId;
        try {
            queryId = QueryFactory.getQueryId(queryEl);
            configId = QueryFactory.getConfigId(queryEl);
            eventTriggers = QueryFactory.getEventTriggers(dataService, queryEl);
            result = QueryFactory.getResultFromQueryElement(dataService, queryEl);
            inputNamespace = QueryFactory.extractQueryInputNamespace(dataService, result, queryEl);
        }
        catch (Exception e) {
            throw new DataServiceFault(e, "Error in parsing CSV query element");
        }
        CSVQuery query = new CSVQuery(dataService, queryId, QueryFactory.getQueryParamsFromQueryElement(queryEl), configId, result, eventTriggers[0], eventTriggers[1], QueryFactory.extractAdvancedProps(queryEl), inputNamespace);
        return query;
    }

    private static CassandraQuery createCassandraQuery(DataService dataService, OMElement queryEl) throws DataServiceFault {
        String inputNamespace;
        Result result;
        EventTrigger[] eventTriggers;
        String queryExpr;
        String configId;
        String queryId;
        try {
            queryId = QueryFactory.getQueryId(queryEl);
            configId = QueryFactory.getConfigId(queryEl);
            queryExpr = QueryFactory.getCassandraQueryExpression(queryEl);
            eventTriggers = QueryFactory.getEventTriggers(dataService, queryEl);
            result = QueryFactory.getResultFromQueryElement(dataService, queryEl);
            inputNamespace = QueryFactory.extractQueryInputNamespace(dataService, result, queryEl);
        }
        catch (Exception e) {
            throw new DataServiceFault(e, "Error in parsing Cassandra query element: " + queryEl.toString() + "\n - " + e.getMessage());
        }
        CassandraQuery query = new CassandraQuery(dataService, queryId, queryExpr, QueryFactory.getQueryParamsFromQueryElement(queryEl), result, configId, eventTriggers[0], eventTriggers[1], QueryFactory.extractAdvancedProps(queryEl), inputNamespace);
        return query;
    }

    private static String getCassandraQueryExpression(OMElement queryEl) throws DataServiceFault {
        OMElement el = queryEl.getFirstChildWithName(new QName("expression"));
        if (el == null) {
            throw new DataServiceFault("A Cassandra query must contain a 'expression' element");
        }
        return el.getText();
    }

    private static CustomQueryBasedDSQuery createCustomQuery(DataService dataService, OMElement queryEl) throws DataServiceFault {
        String inputNamespace;
        Result result;
        EventTrigger[] eventTriggers;
        String configId;
        String queryId;
        String expr;
        try {
            expr = QueryFactory.getCustomQuery(queryEl);
            queryId = QueryFactory.getQueryId(queryEl);
            configId = QueryFactory.getConfigId(queryEl);
            eventTriggers = QueryFactory.getEventTriggers(dataService, queryEl);
            result = QueryFactory.getResultFromQueryElement(dataService, queryEl);
            inputNamespace = QueryFactory.extractQueryInputNamespace(dataService, result, queryEl);
        }
        catch (Exception e) {
            throw new DataServiceFault(e, "Error in passing Web query element");
        }
        CustomQueryBasedDSQuery query = new CustomQueryBasedDSQuery(dataService, queryId, QueryFactory.getQueryParamsFromQueryElement(queryEl), result, configId, eventTriggers[0], eventTriggers[1], QueryFactory.extractAdvancedProps(queryEl), inputNamespace, expr);
        return query;
    }

    private static WebQuery createWebQuery(DataService dataService, OMElement queryEl) throws DataServiceFault {
        String inputNamespace;
        Result result;
        EventTrigger[] eventTriggers;
        String configId;
        String queryId;
        try {
            queryId = QueryFactory.getQueryId(queryEl);
            configId = QueryFactory.getConfigId(queryEl);
            eventTriggers = QueryFactory.getEventTriggers(dataService, queryEl);
            result = QueryFactory.getResultFromQueryElement(dataService, queryEl);
            inputNamespace = QueryFactory.extractQueryInputNamespace(dataService, result, queryEl);
        }
        catch (Exception e) {
            throw new DataServiceFault(e, "Error in passing Web query element");
        }
        WebQuery query = new WebQuery(dataService, queryId, QueryFactory.getQueryParamsFromQueryElement(queryEl), configId, result, eventTriggers[0], eventTriggers[1], QueryFactory.extractAdvancedProps(queryEl), QueryFactory.getQueryVariable(queryEl), inputNamespace);
        return query;
    }

    private static ExcelQuery createExcelQuery(DataService dataService, OMElement queryEl) throws DataServiceFault {
        String inputNamespace;
        Result result;
        EventTrigger[] eventTriggers;
        int headerRow;
        boolean hasHeader;
        int maxRowCount;
        int startingRow;
        String workbookName;
        String configId;
        String queryId;
        try {
            queryId = QueryFactory.getQueryId(queryEl);
            configId = QueryFactory.getConfigId(queryEl);
            OMElement excelEl = queryEl.getFirstChildWithName(new QName("excel"));
            workbookName = excelEl.getFirstChildWithName(new QName("workbookname")).getText();
            OMElement tmpStartingRow = excelEl.getFirstChildWithName(new QName("startingrow"));
            startingRow = tmpStartingRow != null ? Integer.parseInt(tmpStartingRow.getText()) : 1;
            OMElement tmpMaxRowCount = excelEl.getFirstChildWithName(new QName("maxrowcount"));
            maxRowCount = tmpMaxRowCount != null ? Integer.parseInt(tmpMaxRowCount.getText()) : -1;
            OMElement tmpHasHeader = excelEl.getFirstChildWithName(new QName("hasheader"));
            hasHeader = tmpHasHeader != null ? Boolean.parseBoolean(tmpHasHeader.getText()) : false;
            OMElement tmpHeaderRow = excelEl.getFirstChildWithName(new QName("headerrow"));
            headerRow = tmpHeaderRow != null ? Integer.parseInt(tmpHeaderRow.getText()) : 1;
            eventTriggers = QueryFactory.getEventTriggers(dataService, queryEl);
            result = QueryFactory.getResultFromQueryElement(dataService, queryEl);
            inputNamespace = QueryFactory.extractQueryInputNamespace(dataService, result, queryEl);
        }
        catch (Exception e) {
            throw new DataServiceFault(e, "Error in parsing GSpread query element");
        }
        ExcelQuery query = new ExcelQuery(dataService, queryId, QueryFactory.getQueryParamsFromQueryElement(queryEl), configId, workbookName, hasHeader, startingRow, headerRow, maxRowCount, result, eventTriggers[0], eventTriggers[1], QueryFactory.extractAdvancedProps(queryEl), inputNamespace);
        return query;
    }

    private static GSpreadQuery createGSpreadQuery(DataService dataService, OMElement queryEl) throws DataServiceFault {
        String inputNamespace;
        Result result;
        EventTrigger[] eventTriggers;
        int headerRow;
        boolean hasHeader;
        int maxRowCount;
        int startingRow;
        int worksheetNumber;
        String configId;
        String queryId;
        try {
            queryId = QueryFactory.getQueryId(queryEl);
            configId = QueryFactory.getConfigId(queryEl);
            OMElement gspreadEl = queryEl.getFirstChildWithName(new QName("gspread"));
            worksheetNumber = Integer.parseInt(gspreadEl.getFirstChildWithName(new QName("worksheetnumber")).getText());
            OMElement tmpStartingRow = gspreadEl.getFirstChildWithName(new QName("startingrow"));
            startingRow = tmpStartingRow != null ? Integer.parseInt(tmpStartingRow.getText()) : 1;
            OMElement tmpMaxRowCount = gspreadEl.getFirstChildWithName(new QName("maxrowcount"));
            maxRowCount = tmpMaxRowCount != null ? Integer.parseInt(tmpMaxRowCount.getText()) : -1;
            OMElement tmpHasHeader = gspreadEl.getFirstChildWithName(new QName("hasheader"));
            hasHeader = tmpHasHeader != null ? Boolean.parseBoolean(tmpHasHeader.getText()) : false;
            OMElement tmpHeaderRow = gspreadEl.getFirstChildWithName(new QName("headerrow"));
            headerRow = tmpHeaderRow != null ? Integer.parseInt(tmpHeaderRow.getText()) : 1;
            eventTriggers = QueryFactory.getEventTriggers(dataService, queryEl);
            result = QueryFactory.getResultFromQueryElement(dataService, queryEl);
            inputNamespace = QueryFactory.extractQueryInputNamespace(dataService, result, queryEl);
        }
        catch (Exception e) {
            throw new DataServiceFault(e, "Error in parsing GSpread query element");
        }
        GSpreadQuery query = new GSpreadQuery(dataService, queryId, QueryFactory.getQueryParamsFromQueryElement(queryEl), configId, worksheetNumber, hasHeader, startingRow, headerRow, maxRowCount, result, eventTriggers[0], eventTriggers[1], QueryFactory.extractAdvancedProps(queryEl), inputNamespace);
        return query;
    }

    private static Result getResultFromQueryElement(DataService dataService, OMElement queryEl) throws DataServiceFault {
        OMElement resEl = queryEl.getFirstChildWithName(new QName("result"));
        if (resEl == null) {
            return null;
        }
        OMAttribute datasourceIDAttribute = queryEl.getAttribute(new QName("useConfig"));
        boolean isResultSetFieldsCaseSensitive = datasourceIDAttribute != null ? dataService.getConfig(datasourceIDAttribute.getAttributeValue()).isResultSetFieldsCaseSensitive() : dataService.getConfigs().values().iterator().next().isResultSetFieldsCaseSensitive();
        String namespace = resEl.getAttributeValue(new QName("defaultNamespace"));
        if (namespace == null || namespace.trim().length() == 0) {
            namespace = dataService.getDefaultNamespace();
        }
        String xsltPath = resEl.getAttributeValue(new QName("xsltPath"));
        String outputType = resEl.getAttributeValue(new QName("outputType"));
        int resultType = 2;
        if (outputType == null || outputType.trim().length() == 0 || outputType.equals("xml")) {
            resultType = 2;
        } else if (outputType.equals("rdf")) {
            resultType = 1;
        } else if (outputType.equals("json")) {
            resultType = 3;
        }
        Result result = new Result(xsltPath, resultType);
        boolean useColumnNumbers = false;
        String useColumnNumbersStr = resEl.getAttributeValue(new QName("useColumnNumbers"));
        if (!DBUtils.isEmptyString(useColumnNumbersStr)) {
            useColumnNumbers = Boolean.parseBoolean(useColumnNumbersStr);
        }
        result.setUseColumnNumbers(useColumnNumbers);
        boolean escapeNonPrintableChar = false;
        String escapeNonPrintableCharStr = resEl.getAttributeValue(new QName("escapeNonPrintableChar"));
        if (!DBUtils.isEmptyString(escapeNonPrintableCharStr)) {
            escapeNonPrintableChar = Boolean.parseBoolean(escapeNonPrintableCharStr);
        }
        result.setEscapeNonPrintableChar(escapeNonPrintableChar);
        if (result.getResultType() == 2) {
            QueryFactory.populateXMLResult(result, dataService, resEl, namespace, isResultSetFieldsCaseSensitive);
        } else if (result.getResultType() == 1) {
            QueryFactory.populateRDFResult(result, dataService, resEl, namespace, isResultSetFieldsCaseSensitive);
        } else if (result.getResultType() == 3) {
            QueryFactory.populateJSONResult(result, dataService, resEl, QueryFactory.calculateJSONXMLQueryNS(namespace, queryEl.getAttributeValue(new QName("id"))), isResultSetFieldsCaseSensitive);
        }
        return result;
    }

    private static String calculateJSONXMLQueryNS(String originalNS, String queryName) {
        if (!originalNS.endsWith("/")) {
            originalNS = originalNS + "/";
        }
        return originalNS + queryName;
    }

    private static void populateRDFResult(Result result, DataService dataService, OMElement resEl, String namespace, boolean isCaseSensitive) throws DataServiceFault {
        result.setElementName("RDF");
        result.setRowName("Description");
        result.setNamespace(namespace);
        String rdfBaseURI = resEl.getAttributeValue(new QName("rdfBaseURI"));
        result.setRDFBaseURI(rdfBaseURI);
        OMElement groupEl = QueryFactory.createElement("element");
        QueryFactory.addRHSChildrenToLHS(groupEl, resEl);
        OutputElementGroup defGroup = QueryFactory.createOutputElementGroup(dataService, groupEl, namespace, result, 0, false, isCaseSensitive);
        result.setDefaultElementGroup(defGroup);
    }

    private static void populateXMLResult(Result result, DataService dataService, OMElement resEl, String namespace, boolean isCaseSensitive) throws DataServiceFault {
        result.setElementName(resEl.getAttributeValue(new QName("element")));
        result.setRowName(resEl.getAttributeValue(new QName("rowName")));
        result.setNamespace(namespace);
        OMElement groupEl = QueryFactory.createElement("element");
        QueryFactory.addRHSChildrenToLHS(groupEl, resEl);
        OutputElementGroup defGroup = QueryFactory.createOutputElementGroup(dataService, groupEl, namespace, result, 0, false, isCaseSensitive);
        result.setDefaultElementGroup(defGroup);
    }

    private static ResultEntryColumnInfo extractJSONResultColumnInfo(String value) throws DataServiceFault {
        return new ResultEntryColumnInfo(value);
    }

    private static JSONCallQueryParamsInfo extractJSONCallQueryParamInfo(String value) throws DataServiceFault {
        return new JSONCallQueryParamsInfo(value);
    }

    private static void addJSONMappingResultRecord(JSONObject obj, OMElement parentEl) throws DataServiceFault {
        for (String name : JSONObject.getNames((JSONObject)obj)) {
            Object item;
            try {
                item = obj.get(name);
            }
            catch (JSONException e) {
                throw new DataServiceFault(e, "Unexpected JSON parsing error: " + e.getMessage());
            }
            if (name.startsWith("@")) {
                QueryFactory.processJSONMappingCallQuery(name.substring(1), item, parentEl);
                continue;
            }
            QueryFactory.processJSONMappingResultColumn(name, item, parentEl);
        }
    }

    private static void processJSONMappingCallQuery(String name, Object item, OMElement parentEl) throws DataServiceFault {
        OMElement cqEl = QueryFactory.createElement("call-query");
        cqEl.addAttribute("href", name, null);
        parentEl.addChild((OMNode)cqEl);
        JSONCallQueryParamsInfo info = QueryFactory.extractJSONCallQueryParamInfo(item.toString());
        for (String[] wp : info.getWithParams()) {
            OMElement wpEl = QueryFactory.createElement("with-param");
            wpEl.addAttribute("name", wp[0], null);
            wpEl.addAttribute("query-param", wp[1], null);
            cqEl.addChild((OMNode)wpEl);
        }
    }

    private static void processJSONMappingResultColumn(String name, Object item, OMElement parentEl) throws DataServiceFault {
        OMElement childEl = QueryFactory.createElement("element");
        parentEl.addChild((OMNode)childEl);
        childEl.addAttribute("name", name, null);
        if (item instanceof JSONObject) {
            QueryFactory.addJSONMappingResultRecord((JSONObject)item, childEl);
        } else {
            if (item instanceof JSONArray) {
                throw new DataServiceFault("A JSON Array cannot be contained in the result records");
            }
            ResultEntryColumnInfo info = QueryFactory.extractJSONResultColumnInfo(item.toString());
            childEl.addAttribute("column", info.getName(), null);
            if (info.getDataType() != null) {
                childEl.addAttribute("xsdType", info.getDataType(), null);
            }
            if (info.getRequiredRoles() != null) {
                childEl.addAttribute("requiredRoles", info.getRequiredRoles(), null);
            }
        }
    }

    public static OMElement getJSONResultFromText(String jsonMapping) throws DataServiceFault {
        try {
            OMElement resultEl = QueryFactory.createElement("result");
            JSONObject resultObj = new JSONObject(jsonMapping);
            String[] topLevelNames = JSONObject.getNames((JSONObject)resultObj);
            if (topLevelNames == null || topLevelNames.length != 1) {
                throw new DataServiceFault("There must be exactly 1 top level object in the JSON mapping, found " + (topLevelNames != null ? topLevelNames.length : 0));
            }
            String wrapperName = topLevelNames[0];
            String rowName = null;
            Object rootObj = resultObj.get(wrapperName);
            if (rootObj instanceof JSONArray) {
                throw new DataServiceFault("The top level object cannot be an array");
            }
            if (rootObj instanceof JSONObject) {
                String[] secondLevelNames = JSONObject.getNames((JSONObject)((JSONObject)rootObj));
                if (secondLevelNames.length == 1) {
                    Object obj = ((JSONObject)rootObj).get(secondLevelNames[0]);
                    if (obj instanceof JSONArray) {
                        rowName = secondLevelNames[0];
                        JSONArray array = (JSONArray)obj;
                        if (array.length() != 1) {
                            throw new DataServiceFault("The JSON array should be of size 1, found " + array.length());
                        }
                        obj = array.get(0);
                        if (!(obj instanceof JSONObject)) {
                            throw new DataServiceFault("The JSON array element must be a JSON Object");
                        }
                        QueryFactory.addJSONMappingResultRecord((JSONObject)obj, resultEl);
                    } else {
                        QueryFactory.addJSONMappingResultRecord((JSONObject)rootObj, resultEl);
                    }
                } else {
                    QueryFactory.addJSONMappingResultRecord((JSONObject)rootObj, resultEl);
                }
            } else {
                throw new DataServiceFault("The top level object cannot be a simple type");
            }
            resultEl.addAttribute("element", wrapperName, null);
            if (rowName != null) {
                resultEl.addAttribute("rowName", rowName, null);
            }
            return resultEl;
        }
        catch (DataServiceFault e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataServiceFault(e, "Error in parsing JSON result mapping: " + e.getMessage());
        }
    }

    private static void populateJSONResult(Result result, DataService dataService, OMElement resultEl, String namespace, boolean isCaseSensitive) throws DataServiceFault {
        resultEl = QueryFactory.getJSONResultFromText(resultEl.getText());
        result.setResultType(2);
        QueryFactory.populateXMLResult(result, dataService, resultEl, namespace, isCaseSensitive);
    }

    private static OMElement createElement(String name) {
        OMFactory factory = DBUtils.getOMFactory();
        return factory.createOMElement(new QName(name));
    }

    private static void addRHSChildrenToLHS(OMElement lhs, OMElement rhs) {
        Iterator itr = rhs.getChildElements();
        while (itr.hasNext()) {
            OMElement el = (OMElement)itr.next();
            lhs.addChild((OMNode)el);
        }
    }

    private static boolean isElementGroup(OMElement el) {
        if (el.getQName().getLocalPart().equals("element")) {
            return el.getAttributeValue(new QName("column")) == null && el.getAttributeValue(new QName("query-param")) == null && el.getAttributeValue(new QName("value")) == null && el.getAttributeValue(new QName("rdf-ref-uri")) == null;
        }
        return false;
    }

    private static OutputElementGroup createOutputElementGroup(DataService dataService, OMElement groupEl, String parentNamespace, Result parentResult, int level, boolean optionalOverrideCurrent, boolean isCaseSensitive) throws DataServiceFault {
        boolean targetOptionalOverride;
        String name = groupEl.getAttributeValue(new QName("name"));
        String namespace = groupEl.getAttributeValue(new QName("namespace"));
        String arrayName = groupEl.getAttributeValue(new QName("arrayName"));
        int resultType = parentResult.getResultType();
        if (DBUtils.isEmptyString(namespace)) {
            namespace = parentNamespace;
        }
        Set<String> requiredRoles = QueryFactory.extractRequiredRoles(groupEl);
        OutputElementGroup elGroup = new OutputElementGroup(name, namespace, requiredRoles, arrayName);
        elGroup.setParentResult(parentResult);
        QName elQName = new QName("element");
        QName attrQName = new QName("attribute");
        QName cqQName = new QName("call-query");
        Iterator resElItr = groupEl.getChildElements();
        boolean bl = targetOptionalOverride = level == 0 && (parentResult.getRowName() == null || "".equals(parentResult.getRowName()));
        while (resElItr.hasNext()) {
            OMElement el = (OMElement)resElItr.next();
            if (el.getQName().equals(elQName) && QueryFactory.isElementGroup(el)) {
                elGroup.addOutputElementGroupEntry(QueryFactory.createOutputElementGroup(dataService, el, namespace, parentResult, ++level, targetOptionalOverride, isCaseSensitive));
                continue;
            }
            if (el.getQName().equals(elQName)) {
                elGroup.addElementEntry(QueryFactory.createStaticOutputElement(dataService, el, namespace, resultType, targetOptionalOverride, isCaseSensitive));
                continue;
            }
            if (el.getQName().equals(attrQName)) {
                elGroup.addAttributeEntry(QueryFactory.createStaticOutputElement(dataService, el, namespace, resultType, targetOptionalOverride, isCaseSensitive));
                continue;
            }
            if (!el.getQName().equals(cqQName)) continue;
            CallQuery callQuery = QueryFactory.createCallQuery(dataService, el, targetOptionalOverride);
            elGroup.addCallQueryEntry(callQuery);
            callQuery.setOptionalOverride(targetOptionalOverride);
        }
        elGroup.setOptionalOverride(optionalOverrideCurrent);
        return elGroup;
    }

    private static List<QueryParam> getQueryParamsFromQueryElement(OMElement queryEl) throws DataServiceFault {
        ArrayList<QueryParam> queryParams = new ArrayList<QueryParam>();
        Iterator paramItr = queryEl.getChildrenWithName(new QName("param"));
        int currentTmpOrdinal = 0;
        while (paramItr.hasNext()) {
            String paramType;
            int ordinal;
            OMElement paramEl = (OMElement)paramItr.next();
            String name = paramEl.getAttributeValue(new QName("name"));
            if (name != null) {
                name = name.trim();
            }
            String defaultValue = paramEl.getAttributeValue(new QName("defaultValue"));
            String ordinalStr = paramEl.getAttributeValue(new QName("ordinal"));
            if (ordinalStr != null && (ordinal = Integer.parseInt(ordinalStr)) > 0) {
                currentTmpOrdinal = Math.max(ordinal, currentTmpOrdinal);
            } else {
                ordinal = ++currentTmpOrdinal;
            }
            String sqlType = paramEl.getAttributeValue(new QName("sqlType"));
            String type = paramEl.getAttributeValue(new QName("type"));
            if (type == null || type.trim().length() == 0) {
                type = "IN";
            }
            if ((paramType = paramEl.getAttributeValue(new QName("paramType"))) == null || paramType.trim().length() == 0) {
                paramType = "SCALAR";
            }
            List<Validator> validators = QueryFactory.getValidators(paramType, paramEl);
            String structType = paramEl.getAttributeValue(new QName("structType"));
            queryParams.add(new QueryParam(name, sqlType, type, paramType, ordinal, defaultValue == null ? null : new ParamValue(defaultValue), structType, validators));
        }
        return queryParams;
    }

    private static List<Validator> getValidators(String paramType, OMElement paramEl) throws DataServiceFault {
        ArrayList<Validator> validators = new ArrayList<Validator>();
        if (paramType.equals("SCALAR")) {
            validators.add(ScalarTypeValidator.getInstance());
        } else if (paramType.equals("ARRAY")) {
            validators.add(ArrayTypeValidator.getInstance());
        }
        OMElement valEl = paramEl.getFirstChildWithName(new QName("validateLongRange"));
        if (valEl != null) {
            validators.add(QueryFactory.getLongRangeValidator(valEl));
        }
        if ((valEl = paramEl.getFirstChildWithName(new QName("validateDoubleRange"))) != null) {
            validators.add(QueryFactory.getDoubleRangeValidator(valEl));
        }
        if ((valEl = paramEl.getFirstChildWithName(new QName("validateLength"))) != null) {
            validators.add(QueryFactory.getLengthValidator(valEl));
        }
        if ((valEl = paramEl.getFirstChildWithName(new QName("validatePattern"))) != null) {
            validators.add(QueryFactory.getPatternValidator(valEl));
        }
        if ((valEl = paramEl.getFirstChildWithName(new QName("validateCustom"))) != null) {
            validators.add(QueryFactory.getCustomValidator(valEl));
        }
        return validators;
    }

    private static LongRangeValidator getLongRangeValidator(OMElement valEl) {
        String maxStr;
        long minimum = 0L;
        long maximum = 0L;
        boolean hasMin = false;
        boolean hasMax = false;
        String minStr = valEl.getAttributeValue(new QName("minimum"));
        if (minStr != null) {
            minimum = Long.parseLong(minStr);
            hasMin = true;
        }
        if ((maxStr = valEl.getAttributeValue(new QName("maximum"))) != null) {
            maximum = Long.parseLong(maxStr);
            hasMax = true;
        }
        LongRangeValidator validator = new LongRangeValidator(minimum, maximum, hasMin, hasMax);
        return validator;
    }

    private static DoubleRangeValidator getDoubleRangeValidator(OMElement valEl) {
        String maxStr;
        double minimum = 0.0;
        double maximum = 0.0;
        boolean hasMin = false;
        boolean hasMax = false;
        String minStr = valEl.getAttributeValue(new QName("minimum"));
        if (minStr != null) {
            minimum = Double.parseDouble(minStr);
            hasMin = true;
        }
        if ((maxStr = valEl.getAttributeValue(new QName("maximum"))) != null) {
            maximum = Double.parseDouble(maxStr);
            hasMax = true;
        }
        DoubleRangeValidator validator = new DoubleRangeValidator(minimum, maximum, hasMin, hasMax);
        return validator;
    }

    private static LengthValidator getLengthValidator(OMElement valEl) {
        String maxStr;
        int minimum = 0;
        int maximum = 0;
        boolean hasMin = false;
        boolean hasMax = false;
        String minStr = valEl.getAttributeValue(new QName("minimum"));
        if (minStr != null) {
            minimum = Integer.parseInt(minStr);
            hasMin = true;
        }
        if ((maxStr = valEl.getAttributeValue(new QName("maximum"))) != null) {
            maximum = Integer.parseInt(maxStr);
            hasMax = true;
        }
        LengthValidator validator = new LengthValidator(minimum, maximum, hasMin, hasMax);
        return validator;
    }

    private static PatternValidator getPatternValidator(OMElement valEl) {
        String regEx = valEl.getAttributeValue(new QName("pattern"));
        PatternValidator validator = new PatternValidator(regEx);
        return validator;
    }

    private static Validator getCustomValidator(OMElement valEl) throws DataServiceFault {
        String className = valEl.getAttributeValue(new QName("class"));
        try {
            Class<?> clazz = Class.forName(className);
            Validator validator = (Validator)clazz.newInstance();
            if (validator instanceof ValidatorExt) {
                Map<String, String> properties = QueryFactory.extractAdvancedProps(valEl);
                ((ValidatorExt)validator).init(properties);
            }
            return validator;
        }
        catch (Exception e) {
            throw new DataServiceFault(e, "Problem in creating custom validator class: " + className);
        }
    }

    private static StaticOutputElement createStaticOutputElement(DataService dataService, OMElement el, String namespace, int resultType, boolean optionalOverride, boolean isCaseSensitive) throws DataServiceFault {
        String ownNamespace;
        String name = el.getAttributeValue(new QName("name"));
        String paramType = "column";
        String param = el.getAttributeValue(new QName(paramType));
        if (param == null && (param = el.getAttributeValue(new QName(paramType = "query-param"))) == null && (param = el.getAttributeValue(new QName(paramType = "value"))) == null && (param = el.getAttributeValue(new QName(paramType = "rdf-ref-uri"))) == null) {
            throw new DataServiceFault("Invalid param type in output element:-\n " + el);
        }
        String originalParam = param;
        if (!"value".equals(paramType) && !isCaseSensitive) {
            param = param.toLowerCase();
        }
        if (!DBUtils.isEmptyString(ownNamespace = el.getAttributeValue(new QName("namespace")))) {
            namespace = ownNamespace;
        }
        String elementType = el.getLocalName();
        String xsdTypeStr = el.getAttributeValue(new QName("xsdType"));
        if (xsdTypeStr == null || xsdTypeStr.trim().length() == 0) {
            xsdTypeStr = "xs:string";
        }
        QName xsdType = QueryFactory.getXsdTypeQName(xsdTypeStr);
        String rdfRef = el.getAttributeValue(new QName("rdf-ref-uri"));
        int dataCategory = rdfRef == null || rdfRef.trim().length() == 0 ? 1 : 2;
        Set<String> requiredRoles = QueryFactory.extractRequiredRoles(el);
        String export = el.getAttributeValue(new QName("export"));
        String arrayName = el.getAttributeValue(new QName("arrayName"));
        if (arrayName != null && !isCaseSensitive) {
            arrayName = arrayName.toLowerCase();
        }
        int exportType = 1;
        String exportTypeStr = el.getAttributeValue(new QName("exportType"));
        if (exportTypeStr != null && "ARRAY".equals(exportTypeStr)) {
            exportType = 2;
        }
        String optionalStr = el.getAttributeValue(new QName("optional"));
        boolean optional = false;
        if (optionalStr != null) {
            optional = Boolean.parseBoolean(optionalStr);
        }
        StaticOutputElement soel = new StaticOutputElement(dataService, name, param, originalParam, paramType, elementType, namespace, xsdType, requiredRoles, dataCategory, resultType, export, exportType, arrayName);
        soel.setOptionalOverride(optionalOverride |= optional);
        return soel;
    }

    private static Set<String> extractRequiredRoles(OMElement outEl) {
        String[] values;
        String rrStr = outEl.getAttributeValue(new QName("requiredRoles"));
        if (rrStr == null || rrStr.trim().length() == 0) {
            return new HashSet<String>();
        }
        HashSet<String> requiredRoles = new HashSet<String>();
        for (String value : values = rrStr.split(",")) {
            requiredRoles.add(value.trim());
        }
        return requiredRoles;
    }

    public static QName getXsdTypeQName(String xsdTypeStr) {
        String[] vals = xsdTypeStr.split(":");
        if (vals.length == 1) {
            return new QName("http://www.w3.org/2001/XMLSchema", vals[0]);
        }
        return new QName("http://www.w3.org/2001/XMLSchema", vals[1], vals[0]);
    }

    public static List<CallQuery> createCallQueries(DataService dataService, Iterator<OMElement> callQueryElItr) throws DataServiceFault {
        ArrayList<CallQuery> callQueryList = new ArrayList<CallQuery>();
        while (callQueryElItr.hasNext()) {
            CallQuery callQuery = QueryFactory.createCallQuery(dataService, callQueryElItr.next(), false);
            callQueryList.add(callQuery);
        }
        return callQueryList;
    }

    private static CallQuery createCallQuery(DataService dataService, OMElement el, boolean optionalOverride) throws DataServiceFault {
        String queryId = el.getAttributeValue(new QName("href"));
        HashMap<String, CallQuery.WithParam> withParamList = new HashMap<String, CallQuery.WithParam>();
        Iterator wpItr = el.getChildrenWithName(new QName("with-param"));
        while (wpItr.hasNext()) {
            OMElement wpEl = (OMElement)wpItr.next();
            CallQuery.WithParam withParam = QueryFactory.createWithParam(wpEl);
            withParamList.put(withParam.getName(), withParam);
        }
        Set<String> requiredRoles = QueryFactory.extractRequiredRoles(el);
        CallQuery callQuery = new CallQuery(dataService, queryId, withParamList, requiredRoles);
        callQuery.setOptionalOverride(optionalOverride);
        return callQuery;
    }

    public static CallQuery createEmptyCallQuery(DataService dataService) {
        CallQuery callQuery = new CallQuery(dataService, "__dataservices_empty_query__", new HashMap<String, CallQuery.WithParam>(), new HashSet<String>());
        return callQuery;
    }

    public static CallQuery createEmptyBoxcarCallQuery(DataService dataService) {
        CallQuery callQuery = new CallQuery(dataService, "__dataservices_empty_end_boxcar_query__", new HashMap<String, CallQuery.WithParam>(), new HashSet<String>());
        return callQuery;
    }

    private static CallQuery.WithParam createWithParam(OMElement el) throws DataServiceFault {
        String name = el.getAttributeValue(new QName("name"));
        if (name != null) {
            name = name.trim();
        }
        String paramType = "column";
        String param = el.getAttributeValue(new QName(paramType));
        String originalParam = null;
        if (param == null && (param = el.getAttributeValue(new QName(paramType = "query-param"))) != null) {
            param = param.trim();
        }
        if (param == null) {
            throw new DataServiceFault("Invalid param type in with-param element:-\n " + el);
        }
        originalParam = param;
        param = param.toLowerCase();
        CallQuery.WithParam withParam = new CallQuery.WithParam(name, originalParam, param, paramType);
        return withParam;
    }

    private static class ResultEntryColumnInfo {
        private String name;
        private String dataType;
        private String requiredRoles;

        public ResultEntryColumnInfo(String value) throws DataServiceFault {
            value = value.trim();
            int index1 = value.indexOf(40);
            if (!value.startsWith("$")) {
                throw new DataServiceFault("A result entry column value must start with $, found: " + value);
            }
            if (index1 == -1) {
                this.name = value.substring(1);
            } else {
                String[] optionsTokens;
                this.name = value.substring(1, index1);
                int index2 = value.lastIndexOf(")");
                if (index2 == -1) {
                    throw new DataServiceFault("A result entry column value with options must end with ')', found: " + value);
                }
                String options = value.substring(index1 + 1, index2);
                for (String optionsToken : optionsTokens = options.split(";")) {
                    this.processOptionsToken(optionsToken);
                }
            }
        }

        private void processOptionsToken(String optionsToken) throws DataServiceFault {
            String[] tokens = optionsToken.split(":");
            if (tokens.length != 2) {
                throw new DataServiceFault("An option section must be separate by a single ':', found: " + optionsToken);
            }
            String name = tokens[0].trim();
            String value = tokens[1].trim();
            if ("requiredRoles".equals(name)) {
                this.requiredRoles = value;
            } else if ("type".equals(name)) {
                this.dataType = value;
            } else {
                throw new DataServiceFault("Unrecognized option type '" + name + "', " + "found: " + name);
            }
        }

        public String getName() {
            return this.name;
        }

        public String getRequiredRoles() {
            return this.requiredRoles;
        }

        public String getDataType() {
            return this.dataType;
        }
    }

    private static class JSONCallQueryParamsInfo {
        private List<String[]> withParams = new ArrayList<String[]>();

        public JSONCallQueryParamsInfo(String value) throws DataServiceFault {
            String[] wpTokens;
            value = value.trim();
            for (String wp : wpTokens = value.split(",")) {
                this.processWP(wp);
            }
        }

        private void processWP(String wp) throws DataServiceFault {
            String[] tokens = wp.split("->");
            if (tokens.length != 2) {
                throw new DataServiceFault("The nested query call parameters should be separated by a single '->', found: " + wp);
            }
            tokens[0] = tokens[0].trim();
            tokens[1] = tokens[1].trim();
            if (!tokens[0].startsWith("$")) {
                throw new DataServiceFault("The nested query call parameter LHS should be a reference to an existing column/query-param, which should start with a $, found: " + tokens[0]);
            }
            this.withParams.add(new String[]{tokens[0].substring(1), tokens[1]});
        }

        public List<String[]> getWithParams() {
            return this.withParams;
        }
    }
}

