/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.description.query;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axis2.databinding.types.Time;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.dataservices.common.DBConstants;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceConnection;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.TLConnectionStore;
import org.wso2.carbon.dataservices.core.description.config.SQLConfig;
import org.wso2.carbon.dataservices.core.description.event.EventTrigger;
import org.wso2.carbon.dataservices.core.description.query.ExpressionQuery;
import org.wso2.carbon.dataservices.core.description.query.SQLDataServicesConnection;
import org.wso2.carbon.dataservices.core.dispatch.BatchDataServiceRequest;
import org.wso2.carbon.dataservices.core.dispatch.BatchRequestParticipant;
import org.wso2.carbon.dataservices.core.dispatch.DispatchStatus;
import org.wso2.carbon.dataservices.core.engine.DataEntry;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.engine.InternalParam;
import org.wso2.carbon.dataservices.core.engine.InternalParamCollection;
import org.wso2.carbon.dataservices.core.engine.ParamValue;
import org.wso2.carbon.dataservices.core.engine.QueryParam;
import org.wso2.carbon.dataservices.core.engine.Result;
import org.wso2.carbon.dataservices.core.engine.ResultSetWrapper;

public class SQLQuery
extends ExpressionQuery
implements BatchRequestParticipant {
    private static final Log log = LogFactory.getLog(SQLQuery.class);
    public static final int DS_QUERY_TYPE_NORMAL = 1;
    public static final int DS_QUERY_TYPE_STORED_PROC = 2;
    public static final int ORACLE_REF_CURSOR_TYPE = -10;
    private SQLConfig config;
    private int queryType;
    private List<QueryParam> outQueryParams;
    private boolean hasOutParams;
    private boolean resultOnlyOutParams;
    private boolean hasRefCursor;
    private int paramCount;
    private FetchSizeProperty fetchSizeProperty;
    private boolean hasFetchDirection;
    private boolean hasFetchSize;
    private boolean hasMaxFieldSize;
    private boolean hasMaxRows;
    private boolean hasQueryTimeout;
    private int fetchDirection;
    private int fetchSize;
    private int maxFieldSize;
    private int maxRows;
    private int queryTimeout;
    private boolean returnGeneratedKeys;
    private boolean returnUpdatedRowCount;
    private String[] keyColumns;
    private boolean hasBatchQuerySupport;
    private DBConstants.AutoCommit autoCommit;
    private boolean forceStoredProc;
    private boolean forceJDBCBatchReqs;
    private Calendar calendar;
    private boolean timeConvertEnabled = true;
    private static ThreadLocal<Integer> currentRefCursorOrdinal = new ThreadLocal();
    private ThreadLocal<PreparedStatement> batchPreparedStatement = new ThreadLocal<PreparedStatement>(){

        @Override
        protected synchronized PreparedStatement initialValue() {
            return null;
        }
    };

    public SQLQuery(DataService dataService, String queryId, String configId, boolean returnGeneratedKeys, boolean returnUpdatedRowCount, String[] keyColumns, String query, List<QueryParam> queryParams, Result result, EventTrigger inputEventTrigger, EventTrigger outputEventTrigger, Map<String, String> advancedProperties, String inputNamespace) throws DataServiceFault {
        super(dataService, queryId, queryParams, query, result, configId, inputEventTrigger, outputEventTrigger, advancedProperties, inputNamespace);
        this.returnGeneratedKeys = returnGeneratedKeys;
        this.returnUpdatedRowCount = returnUpdatedRowCount;
        this.keyColumns = keyColumns;
        try {
            this.config = (SQLConfig)this.getDataService().getConfig(this.getConfigId());
        }
        catch (ClassCastException e) {
            throw new DataServiceFault(e, "Configuration is not an SQL config:" + this.getConfigId());
        }
        this.init(query);
    }

    public static int getCurrentRefCursorOrdinal() {
        return currentRefCursorOrdinal.get();
    }

    public static void setCurrentRefCursorOrdinal(int ordinal) {
        currentRefCursorOrdinal.set(ordinal);
    }

    @Override
    public void init(String query) throws DataServiceFault {
        super.init(query);
        this.processAdvancedProps(this.getAdvancedProperties());
        this.queryType = this.retrieveQueryType(this.getQuery());
        this.outQueryParams = this.extractOutQueryParams(this.getQueryParams());
        this.checkRefCursor(this.getQueryParams());
        this.hasOutParams = this.getOutQueryParams().size() > 0;
        String userTimeZone = System.getProperty("dss.timezone");
        if (userTimeZone == null || userTimeZone.isEmpty()) {
            userTimeZone = "UTC";
        }
        this.calendar = Calendar.getInstance(TimeZone.getTimeZone(userTimeZone));
        String legacyTimezoneMode = System.getProperty("dss.legacy.timezone.mode");
        if ("true".equalsIgnoreCase(legacyTimezoneMode)) {
            this.timeConvertEnabled = false;
        }
        this.resultOnlyOutParams = this.calculateResultOnlyOutParams();
        this.fetchSizeProperty = DBUtils.getChangeFetchSizeForRDBMS(this.getConfig().getProperty("url")) ? new FetchSizeProperty(true, Integer.MIN_VALUE) : new FetchSizeProperty(false, 0);
        try {
            this.hasBatchQuerySupport = this.getDataService().isBatchRequestsEnabled() && (this.isForceJDBCBatchReqs() || this.calculateBatchQuerySupport());
        }
        catch (DataServiceFault e) {
            this.hasBatchQuerySupport = false;
            log.warn((Object)("Unable to determine batch query support for query '" + this.getQueryId() + "' : " + e.getMessage() + " - batch query support is disabled."));
        }
    }

    private boolean calculateResultOnlyOutParams() {
        return this.getResult() != null && (this.hasRefCursor() || this.hasOutParams() && this.getResult().getDefaultElementGroup().getAllElements().size() + this.getResult().getDefaultElementGroup().getAttributeEntries().size() == this.getOutQueryParams().size());
    }

    private String extractStoredProcName(boolean skipFirstWord) {
        String sql = this.getQuery();
        String[] tokens = SQLQuery.removeSpaces(sql.split("\\s|\\(|\\["));
        if (skipFirstWord) {
            if (tokens.length < 2) {
                return null;
            }
            return tokens[1];
        }
        if (tokens.length < 1) {
            return null;
        }
        return tokens[0];
    }

    private static String[] removeSpaces(String[] vals) {
        ArrayList<String> result = new ArrayList<String>();
        for (String val : vals) {
            if (val.trim().length() <= 0) continue;
            result.add(val);
        }
        return result.toArray(new String[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getStoredProcFuncProps(String name) throws DataServiceFault, SQLException {
        Connection conn = (Connection)this.getConfig().createConnection()[0];
        DatabaseMetaData md = conn.getMetaData();
        ResultSet rs = null;
        boolean error = true;
        try {
            rs = md.getProcedureColumns(null, null, name, "%");
            Object[] resultMap = new Object[2];
            if (!rs.next()) {
                rs.close();
                rs = md.getFunctionColumns(null, null, name, "%");
            } else {
                rs.close();
                rs = md.getProcedureColumns(null, null, name, "%");
            }
            resultMap[0] = conn;
            resultMap[1] = rs;
            error = false;
            Object[] objectArray = resultMap;
            return objectArray;
        }
        finally {
            if (error) {
                this.releaseResources(rs, null);
            }
        }
    }

    private boolean calculateBatchQuerySupport() throws DataServiceFault {
        ArrayList<Connection> connections = new ArrayList<Connection>();
        if (this.getConfig().hasJDBCBatchUpdateSupport()) {
            if (this.getQueryType() == 2) {
                ResultSet rs = null;
                try {
                    Object[] resultMap = this.getStoredProcFuncProps(this.extractStoredProcName(true));
                    rs = (ResultSet)resultMap[1];
                    connections.add((Connection)resultMap[0]);
                    if (!rs.next()) {
                        resultMap = this.getStoredProcFuncProps(this.extractStoredProcName(false));
                        rs = (ResultSet)resultMap[1];
                        connections.add((Connection)resultMap[0]);
                        if (!rs.next()) {
                            throw new DataServiceFault("Cannot find metadata for the stored procedure");
                        }
                    }
                    StoredProcMetadataCollection mdCollection = new StoredProcMetadataCollection(rs);
                    for (StoredProcMetadataEntry entry : mdCollection.getEntries()) {
                        switch (entry.getColumnReturn()) {
                            case 1: {
                                break;
                            }
                            case 5: {
                                if (entry.getColumnDataType() == 4 || entry.getColumnDataType() == -5 || entry.getColumnDataType() == 3) break;
                                boolean bl = false;
                                return bl;
                            }
                            default: {
                                boolean bl = false;
                                return bl;
                            }
                        }
                    }
                    boolean bl = true;
                    return bl;
                }
                catch (Throwable e) {
                    throw new DataServiceFault("Error in retrieving database metadata.");
                }
                finally {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        for (Connection aCon : connections) {
                            aCon.close();
                        }
                    }
                    catch (SQLException ignore) {}
                }
            }
            return true;
        }
        return false;
    }

    public DBConstants.AutoCommit getAutoCommit() {
        return this.autoCommit;
    }

    public boolean hasBatchQuerySupport() {
        return this.hasBatchQuerySupport;
    }

    private PreparedStatement getBatchPreparedStatement() {
        return this.batchPreparedStatement.get();
    }

    private void setBatchPreparedStatement(PreparedStatement val) {
        this.batchPreparedStatement.set(val);
    }

    public String[] getKeyColumns() {
        return this.keyColumns;
    }

    public boolean isReturnGeneratedKeys() {
        return this.returnGeneratedKeys;
    }

    public boolean isReturnUpdatedRowCount() {
        return this.returnUpdatedRowCount;
    }

    public boolean isForceStoredProc() {
        return this.forceStoredProc;
    }

    public boolean isForceJDBCBatchReqs() {
        return this.forceJDBCBatchReqs;
    }

    private void processAdvancedProps(Map<String, String> props) throws DataServiceFault {
        String forceJDBCBatchRequests;
        if (props == null) {
            return;
        }
        String fetchDirectionProp = props.get("fetchDirection");
        if (!DBUtils.isEmptyString(fetchDirectionProp)) {
            if ("forward".equals(fetchDirectionProp = fetchDirectionProp.trim())) {
                this.fetchDirection = 1000;
            } else if ("reverse".equals(fetchDirectionProp)) {
                this.fetchDirection = 1001;
            } else {
                throw new DataServiceFault("Invalid fetch direction: " + fetchDirectionProp + ", valid values are {'" + "forward" + "', '" + "reverse" + "'}");
            }
            this.hasFetchDirection = true;
        } else {
            this.hasFetchDirection = false;
        }
        String fetchSizeProp = props.get("fetchSize");
        if (!DBUtils.isEmptyString(fetchSizeProp)) {
            fetchSizeProp = fetchSizeProp.trim();
            try {
                this.fetchSize = Integer.parseInt(fetchSizeProp);
            }
            catch (NumberFormatException e) {
                throw new DataServiceFault(e, "Invalid fetch size: " + fetchSizeProp + ", fetch size should be an integer");
            }
            this.hasFetchSize = true;
        } else {
            this.hasFetchSize = false;
        }
        String maxFieldSizeProp = props.get("maxFieldSize");
        if (!DBUtils.isEmptyString(maxFieldSizeProp)) {
            maxFieldSizeProp = maxFieldSizeProp.trim();
            try {
                this.maxFieldSize = Integer.parseInt(maxFieldSizeProp);
                if (this.maxFieldSize <= 0) {
                    throw new DataServiceFault("Invalid maximum field size: " + maxFieldSizeProp + ", maximum field size should be a positive integer");
                }
            }
            catch (NumberFormatException e) {
                throw new DataServiceFault(e, "Invalid maximum field size: " + maxFieldSizeProp + ", maximum field size should be a positive integer");
            }
            this.hasMaxFieldSize = true;
        } else {
            this.hasMaxFieldSize = false;
        }
        String maxRowsProp = props.get("maxRows");
        if (!DBUtils.isEmptyString(maxRowsProp)) {
            maxRowsProp = maxRowsProp.trim();
            try {
                this.maxRows = Integer.parseInt(maxRowsProp);
                if (this.maxRows <= 0) {
                    throw new DataServiceFault("Invalid maximum rows: " + maxRowsProp + ", maximum rows should be a positive integer");
                }
            }
            catch (NumberFormatException e) {
                throw new DataServiceFault(e, "Invalid maximum rows: " + maxRowsProp + ", maximum rows should be a positive integer");
            }
            this.hasMaxRows = true;
        } else {
            this.hasMaxRows = false;
        }
        String queryTimeoutProp = props.get("queryTimeout");
        if (!DBUtils.isEmptyString(queryTimeoutProp)) {
            queryTimeoutProp = queryTimeoutProp.trim();
            try {
                this.queryTimeout = Integer.parseInt(queryTimeoutProp);
                if (this.queryTimeout <= 0) {
                    throw new DataServiceFault("Invalid query timeout: " + queryTimeoutProp + ", query timeout be a positive integer");
                }
            }
            catch (NumberFormatException e) {
                throw new DataServiceFault(e, "Invalid query timeout: " + queryTimeoutProp + ", query timeout be a positive integer");
            }
            this.hasQueryTimeout = true;
        } else {
            this.hasQueryTimeout = false;
        }
        String autoCommitProp = props.get("autoCommit");
        if (!DBUtils.isEmptyString(autoCommitProp)) {
            autoCommitProp = autoCommitProp.trim();
            try {
                boolean acBool = Boolean.parseBoolean(autoCommitProp);
                if (acBool) {
                    this.autoCommit = DBConstants.AutoCommit.AUTO_COMMIT_ON;
                }
                this.autoCommit = DBConstants.AutoCommit.AUTO_COMMIT_OFF;
            }
            catch (Exception e) {
                throw new DataServiceFault(e, "Invalid autocommit value: " + autoCommitProp + ", autocommit should be a boolean value");
            }
        } else {
            this.autoCommit = this.getConfig().getAutoCommit();
        }
        String forceStoredProc = props.get("forceStoredProc");
        if (!DBUtils.isEmptyString(forceStoredProc)) {
            this.forceStoredProc = Boolean.parseBoolean(forceStoredProc);
        }
        if (!DBUtils.isEmptyString(forceJDBCBatchRequests = props.get("forceJDBCBatchRequests"))) {
            this.forceJDBCBatchReqs = Boolean.parseBoolean(forceJDBCBatchRequests);
        }
    }

    public boolean isHasFetchDirection() {
        return this.hasFetchDirection;
    }

    public boolean isHasFetchSize() {
        return this.hasFetchSize;
    }

    public boolean isHasMaxFieldSize() {
        return this.hasMaxFieldSize;
    }

    public boolean isHasMaxRows() {
        return this.hasMaxRows;
    }

    public boolean isHasQueryTimeout() {
        return this.hasQueryTimeout;
    }

    public int getFetchDirection() {
        return this.fetchDirection;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public int getMaxFieldSize() {
        return this.maxFieldSize;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public FetchSizeProperty getFetchSizeProperty() {
        return this.fetchSizeProperty;
    }

    private void checkRefCursor(List<QueryParam> queryParams) {
        for (QueryParam queryParam : queryParams) {
            if (!queryParam.getSqlType().equals("ORACLE_REF_CURSOR")) continue;
            this.hasRefCursor = true;
            return;
        }
    }

    public boolean hasOutParams() {
        return this.hasOutParams;
    }

    public boolean isResultOnlyOutParams() {
        return this.resultOnlyOutParams;
    }

    private List<QueryParam> extractOutQueryParams(List<QueryParam> queryParams) {
        ArrayList<QueryParam> inOutQueryParams = new ArrayList<QueryParam>();
        for (QueryParam queryParam : queryParams) {
            if (!this.isOutQueryParam(queryParam.getType(), queryParam.getSqlType())) continue;
            inOutQueryParams.add(queryParam);
        }
        return inOutQueryParams;
    }

    private boolean isOutQueryParam(String queryType, String sqlType) {
        return queryType.endsWith("OUT") && !sqlType.equals("ORACLE_REF_CURSOR");
    }

    public List<QueryParam> getOutQueryParams() {
        return this.outQueryParams;
    }

    public int getQueryType() {
        return this.queryType;
    }

    public SQLConfig getConfig() {
        return this.config;
    }

    private boolean isValidCreds(String[] creds) {
        return creds != null && creds.length > 1 && creds[0] != null;
    }

    public String[] lookupConnectionCredentials() throws DataServiceFault {
        if (this.getConfig().getPrimaryDynAuth() != null) {
            String user = DBUtils.getCurrentContextUsername(this.getDataService());
            String[] creds = this.getConfig().getPrimaryDynAuth().lookupCredentials(user);
            if (this.isValidCreds(creds)) {
                return creds;
            }
            if (this.getConfig().getSecondaryDynAuth() != null && this.isValidCreds(creds = this.getConfig().getSecondaryDynAuth().lookupCredentials(user))) {
                return creds;
            }
            creds = this.getConfig().getPrimaryDynAuth().lookupCredentials("*");
            if (this.isValidCreds(creds)) {
                return creds;
            }
            throw new DataServiceFault("A username/password mapping does not exist for the request user: " + user);
        }
        return new String[]{null, null};
    }

    private Connection createConnection(int queryLevel) throws DataServiceFault {
        try {
            Connection connection;
            String[] creds = this.lookupConnectionCredentials();
            DataServiceConnection dsCon = TLConnectionStore.getConnection(this.getConfigId(), creds[0], queryLevel);
            if (dsCon == null) {
                Object[] connInfo = this.getConfig().createConnection(creds[0], creds[1]);
                connection = (Connection)connInfo[0];
                boolean isXA = (Boolean)connInfo[1];
                dsCon = new SQLDataServicesConnection(connection, isXA);
                TLConnectionStore.addConnection(this.getConfigId(), creds[0], queryLevel, dsCon);
            } else {
                connection = ((SQLDataServicesConnection)dsCon).getJDBCConnection();
            }
            if (DispatchStatus.isInBatchBoxcarring() && !dsCon.isXA()) {
                this.setAutoCommit(connection, false);
            } else if (!dsCon.isXA()) {
                switch (this.getAutoCommit()) {
                    case AUTO_COMMIT_ON: {
                        this.setAutoCommit(connection, true);
                        break;
                    }
                    case AUTO_COMMIT_OFF: {
                        this.setAutoCommit(connection, false);
                        break;
                    }
                }
            }
            return connection;
        }
        catch (SQLException e) {
            throw new DataServiceFault(e, DBConstants.FaultCodes.DATABASE_ERROR, "Error in opening DBMS connection.");
        }
    }

    private int retrieveQueryType(String query) {
        if (this.isForceStoredProc()) {
            return 2;
        }
        return this.inferQueryType(query);
    }

    private int inferQueryType(String query) {
        query = query.trim().toUpperCase();
        for (String normalQueryType : DBConstants.SQL_NORMAL_QUERY_TYPES) {
            if (!query.startsWith(normalQueryType)) continue;
            return 1;
        }
        return 2;
    }

    private boolean isJDBCBatchRequest() {
        return DispatchStatus.isBatchRequest() && this.hasBatchQuerySupport();
    }

    private boolean isJDBCFirstBatchRequest() {
        return this.isJDBCBatchRequest() && DispatchStatus.getBatchRequestNumber() == 0;
    }

    private boolean isJDBCLastBatchRequest() {
        return this.isJDBCBatchRequest() && DispatchStatus.getBatchRequestNumber() + 1 >= DispatchStatus.getBatchRequestCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOutGeneratedKeys(Statement stmt, XMLStreamWriter xmlWriter, InternalParamCollection params, int queryLevel) throws DataServiceFault, SQLException {
        try (ResultSet krs = null;){
            krs = stmt.getGeneratedKeys();
            while (krs.next()) {
                DataEntry dataEntry = this.getDataEntryFromRS(new ResultSetWrapper(krs));
                this.writeResultEntry(xmlWriter, dataEntry, params, queryLevel);
            }
        }
    }

    private void writeOutUpdatedRowCount(Statement stmt, XMLStreamWriter xmlWriter, InternalParamCollection params, int queryLevel) throws DataServiceFault, SQLException {
        int updateCount = stmt.getUpdateCount();
        DataEntry dataEntry = new DataEntry();
        ParamValue param = new ParamValue(1);
        param.setScalarValue(Integer.toString(updateCount));
        dataEntry.addValue("1", param);
        this.writeResultEntry(xmlWriter, dataEntry, params, queryLevel);
    }

    private Object processPreNormalQuery(InternalParamCollection params, int queryLevel) throws DataServiceFault {
        QueryResultInfo queryResultInfo;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        boolean isError = false;
        try {
            Connection conn = this.createConnection(queryLevel);
            stmt = this.createProcessedPreparedStatement(1, params, conn);
            if (this.isJDBCFirstBatchRequest()) {
                this.setBatchPreparedStatement(stmt);
                BatchDataServiceRequest.addParticipant(this);
            }
            if (!this.hasResult() || this.hasResult() && (this.isReturnGeneratedKeys() || this.isReturnUpdatedRowCount())) {
                if (this.isJDBCBatchRequest()) {
                    if (this.isJDBCLastBatchRequest()) {
                        stmt.executeBatch();
                    }
                } else {
                    stmt.executeUpdate();
                }
            } else {
                rs = stmt.executeQuery();
            }
            queryResultInfo = new QueryResultInfo(stmt, rs);
        }
        catch (Throwable e) {
            try {
                isError = true;
                throw new DataServiceFault(e, DBConstants.FaultCodes.DATABASE_ERROR, "Error in 'SQLQuery.processPreNormalQuery': " + e.getMessage());
            }
            catch (Throwable throwable) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Stopping DB calls: ThreadID - " + Thread.currentThread().getId()));
                }
                if (isError) {
                    this.releaseResources(rs, this.isStatementClosable(isError) ? stmt : null);
                }
                throw throwable;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Stopping DB calls: ThreadID - " + Thread.currentThread().getId()));
        }
        if (isError) {
            this.releaseResources(rs, this.isStatementClosable(isError) ? stmt : null);
        }
        return queryResultInfo;
    }

    private void processPostNormalQuery(Object result, XMLStreamWriter xmlWriter, InternalParamCollection params, int queryLevel) throws DataServiceFault {
        QueryResultInfo resultInfo = (QueryResultInfo)result;
        PreparedStatement stmt = (PreparedStatement)resultInfo.getStatement();
        ResultSet rs = resultInfo.getResultSet();
        boolean isError = false;
        try {
            if (this.isJDBCFirstBatchRequest()) {
                this.setBatchPreparedStatement(stmt);
                BatchDataServiceRequest.addParticipant(this);
            }
            if (!this.hasResult() || this.hasResult() && (this.isReturnGeneratedKeys() || this.isReturnUpdatedRowCount())) {
                if (this.isJDBCBatchRequest()) {
                    if (this.isJDBCLastBatchRequest()) {
                        this.writeGeneratedElements(stmt, xmlWriter, params, queryLevel);
                    }
                } else {
                    this.writeGeneratedElements(stmt, xmlWriter, params, queryLevel);
                }
            } else {
                while (rs.next()) {
                    DataEntry dataEntry = this.getDataEntryFromRS(new ResultSetWrapper(rs));
                    this.writeResultEntry(xmlWriter, dataEntry, params, queryLevel);
                }
            }
            this.releaseResources(rs, this.isStatementClosable(isError) ? stmt : null);
        }
        catch (Throwable e) {
            try {
                log.error((Object)e.getMessage(), e);
                isError = true;
                throw new DataServiceFault(e, DBConstants.FaultCodes.DATABASE_ERROR, "Error in 'SQLQuery.processPostNormalQuery': " + e.getMessage());
            }
            catch (Throwable throwable) {
                this.releaseResources(rs, this.isStatementClosable(isError) ? stmt : null);
                throw throwable;
            }
        }
    }

    private void writeGeneratedElements(Statement stmt, XMLStreamWriter xmlWriter, InternalParamCollection params, int queryLevel) throws DataServiceFault, SQLException {
        if (this.isReturnUpdatedRowCount()) {
            this.writeOutUpdatedRowCount(stmt, xmlWriter, params, queryLevel);
        } else {
            this.writeOutGeneratedKeys(stmt, xmlWriter, params, queryLevel);
        }
    }

    private boolean isRSClosed(ResultSet rs) throws SQLException {
        try {
            return rs.isClosed();
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private Object processPreStoredProcQuery(InternalParamCollection params, int queryLevel) throws DataServiceFault {
        QueryResultInfo queryResultInfo;
        boolean isError = false;
        CallableStatement stmt = null;
        ResultSet rs = null;
        try {
            Connection conn = this.createConnection(queryLevel);
            stmt = (CallableStatement)this.createProcessedPreparedStatement(2, params, conn);
            if (this.isJDBCFirstBatchRequest()) {
                this.setBatchPreparedStatement(stmt);
                BatchDataServiceRequest.addParticipant(this);
            }
            if (!this.hasResult() || this.hasResult() && this.isReturnGeneratedKeys() || this.hasResult() && this.isReturnUpdatedRowCount()) {
                if (this.isJDBCBatchRequest()) {
                    if (this.isJDBCLastBatchRequest()) {
                        stmt.executeBatch();
                    }
                } else {
                    stmt.executeUpdate();
                }
            } else if (this.isResultOnlyOutParams()) {
                stmt.execute();
                if (this.hasRefCursor()) {
                    rs = (ResultSet)stmt.getObject(SQLQuery.getCurrentRefCursorOrdinal());
                }
            } else {
                rs = this.getFirstRSOfStoredProc(stmt);
            }
            queryResultInfo = new QueryResultInfo(stmt, rs);
        }
        catch (Exception e) {
            try {
                log.error((Object)e.getMessage(), (Throwable)e);
                isError = true;
                throw new DataServiceFault(e, DBConstants.FaultCodes.DATABASE_ERROR, "Error in 'SQLQuery.processStoredProcQuery': " + e.getMessage());
            }
            catch (Throwable throwable) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Stopping DB calls: ThreadID - " + Thread.currentThread().getId()));
                }
                if (isError) {
                    this.releaseResources(rs, this.isStatementClosable(isError) ? stmt : null);
                }
                throw throwable;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Stopping DB calls: ThreadID - " + Thread.currentThread().getId()));
        }
        if (isError) {
            this.releaseResources(rs, this.isStatementClosable(isError) ? stmt : null);
        }
        return queryResultInfo;
    }

    private void processPostStoredProcQuery(Object result, XMLStreamWriter xmlWriter, InternalParamCollection params, int queryLevel) throws DataServiceFault {
        QueryResultInfo resultInfo = (QueryResultInfo)result;
        boolean isError = false;
        CallableStatement stmt = (CallableStatement)resultInfo.getStatement();
        ResultSet rs = resultInfo.getResultSet();
        try {
            if (!this.hasResult() || this.hasResult() && this.isReturnGeneratedKeys() || this.hasResult() && this.isReturnUpdatedRowCount()) {
                if (this.isJDBCBatchRequest()) {
                    if (this.isJDBCLastBatchRequest()) {
                        this.writeGeneratedElements(stmt, xmlWriter, params, queryLevel);
                    }
                } else {
                    this.writeGeneratedElements(stmt, xmlWriter, params, queryLevel);
                }
            } else if (rs == null || this.isRSClosed(rs) || !rs.next()) {
                DataEntry outParamDataEntry;
                if (this.hasOutParams() && (outParamDataEntry = this.getDataEntryFromOutParams(stmt, this.extractRuntimeOutParams(params))) != null) {
                    this.writeResultEntry(xmlWriter, outParamDataEntry, params, queryLevel);
                }
            } else if (this.hasOutParams()) {
                List<DataEntry> entries = this.getAllDataEntriesFromRS(rs, true);
                DataEntry outParamDataEntry = this.getDataEntryFromOutParams(stmt, this.extractRuntimeOutParams(params));
                for (DataEntry dataEntry : entries) {
                    this.mergeDataEntries(dataEntry, outParamDataEntry);
                    this.writeResultEntry(xmlWriter, dataEntry, params, queryLevel);
                }
            } else {
                do {
                    DataEntry dataEntry = this.getDataEntryFromRS(new ResultSetWrapper(rs));
                    this.writeResultEntry(xmlWriter, dataEntry, params, queryLevel);
                } while (rs.next());
            }
            this.releaseResources(rs, this.isStatementClosable(isError) ? stmt : null);
        }
        catch (Exception e) {
            try {
                log.error((Object)e.getMessage(), (Throwable)e);
                isError = true;
                throw new DataServiceFault(e, DBConstants.FaultCodes.DATABASE_ERROR, "Error in 'SQLQuery.processStoredProcQuery': " + e.getMessage());
            }
            catch (Throwable throwable) {
                this.releaseResources(rs, this.isStatementClosable(isError) ? stmt : null);
                throw throwable;
            }
        }
    }

    private boolean isStatementClosable(boolean isError) {
        return isError || !this.isJDBCBatchRequest() || this.isJDBCLastBatchRequest();
    }

    private void releaseResources(ResultSet rs, Statement stmt) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private List<DataEntry> getAllDataEntriesFromRS(ResultSet rs, boolean rsNextAlreadyCalled) throws SQLException {
        ArrayList<DataEntry> entries = new ArrayList<DataEntry>();
        if (!rsNextAlreadyCalled && !rs.next()) {
            return entries;
        }
        do {
            entries.add(this.getDataEntryFromRS(new ResultSetWrapper(rs)));
        } while (rs.next());
        return entries;
    }

    private ResultSet getFirstRSOfStoredProc(CallableStatement stmt) throws SQLException {
        boolean resultAndNoUpdateCount = stmt.execute();
        ResultSet result = null;
        while (true) {
            if (!resultAndNoUpdateCount) {
                if (stmt.getUpdateCount() == -1) {
                    break;
                }
            } else {
                result = stmt.getResultSet();
                break;
            }
            try {
                resultAndNoUpdateCount = stmt.getMoreResults(2);
            }
            catch (SQLException e) {
                if (result != null) break;
                throw e;
            }
        }
        return result;
    }

    private void mergeDataEntries(DataEntry lhs, DataEntry rhs) {
        lhs.getData().putAll(rhs.getData());
    }

    private List<InternalParam> extractRuntimeOutParams(InternalParamCollection params) {
        ArrayList<InternalParam> result = new ArrayList<InternalParam>();
        for (InternalParam param : params.getParams()) {
            if (!this.isOutQueryParam(param.getType(), param.getSqlType())) continue;
            result.add(param);
        }
        return result;
    }

    private DataEntry getDataEntryFromOutParams(CallableStatement stmt, List<InternalParam> outParams) throws DataServiceFault {
        DataEntry dataEntry = new DataEntry();
        for (InternalParam param : outParams) {
            String name = param.getName();
            ParamValue value = this.getOutparameterValue(stmt, param.getSqlType(), param.getOrdinal());
            dataEntry.addValue(name, value);
        }
        return dataEntry;
    }

    private DataEntry getDataEntryFromRS(ResultSet rs) throws SQLException {
        DataEntry dataEntry = new DataEntry();
        ResultSetMetaData metaData = rs.getMetaData();
        int columnCount = metaData.getColumnCount();
        boolean useColumnNumbers = this.isUsingColumnNumbers();
        for (int i = 1; i <= columnCount; ++i) {
            ParamValue paramValue;
            int columnType = metaData.getColumnType(i);
            switch (columnType) {
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: 
                case 2005: 
                case 2011: {
                    String value = rs.getString(i);
                    paramValue = new ParamValue(value);
                    break;
                }
                case -6: 
                case 4: 
                case 5: {
                    String value = ConverterUtil.convertToString((int)rs.getInt(i));
                    paramValue = new ParamValue(rs.wasNull() ? null : value);
                    break;
                }
                case 8: {
                    String value = ConverterUtil.convertToString((double)rs.getDouble(i));
                    paramValue = new ParamValue(rs.wasNull() ? null : value);
                    break;
                }
                case 6: {
                    String value = ConverterUtil.convertToString((float)rs.getFloat(i));
                    paramValue = new ParamValue(rs.wasNull() ? null : value);
                    break;
                }
                case -7: 
                case 16: {
                    String value = ConverterUtil.convertToString((boolean)rs.getBoolean(i));
                    paramValue = new ParamValue(rs.wasNull() ? null : value);
                    break;
                }
                case 3: {
                    BigDecimal bigDecimal = rs.getBigDecimal(i);
                    String value = bigDecimal != null ? ConverterUtil.convertToString((BigDecimal)bigDecimal) : null;
                    paramValue = new ParamValue(value);
                    break;
                }
                case 92: {
                    java.sql.Time sqlTime = rs.getTime(i);
                    String value = sqlTime != null ? this.convertToTimeString(sqlTime) : null;
                    paramValue = new ParamValue(value);
                    break;
                }
                case 91: {
                    Date sqlDate = rs.getDate(i);
                    String value = sqlDate != null ? ConverterUtil.convertToString((java.util.Date)sqlDate) : null;
                    paramValue = new ParamValue(value);
                    break;
                }
                case 93: {
                    Timestamp sqlTimestamp = this.timeConvertEnabled ? rs.getTimestamp(i, this.calendar) : rs.getTimestamp(i);
                    String value = sqlTimestamp != null ? this.convertToTimestampString(sqlTimestamp) : null;
                    paramValue = new ParamValue(value);
                    break;
                }
                case 2004: {
                    Blob sqlBlob = rs.getBlob(i);
                    String value = sqlBlob != null ? this.getBase64StringFromInputStream(sqlBlob.getBinaryStream()) : null;
                    paramValue = new ParamValue(value);
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    InputStream binInStream = rs.getBinaryStream(i);
                    String value = binInStream != null ? this.getBase64StringFromInputStream(binInStream) : null;
                    paramValue = new ParamValue(value);
                    break;
                }
                case 2002: {
                    Struct udt = (Struct)rs.getObject(i);
                    paramValue = new ParamValue(udt);
                    break;
                }
                case 2003: {
                    paramValue = new ParamValue(2);
                    Array dataArray = (Array)rs.getObject(i);
                    if (dataArray == null) break;
                    paramValue = this.processSQLArray(dataArray, paramValue);
                    break;
                }
                case 2: {
                    BigDecimal bigDecimal = rs.getBigDecimal(i);
                    String value = bigDecimal != null ? ConverterUtil.convertToString((BigDecimal)bigDecimal) : null;
                    paramValue = new ParamValue(value);
                    break;
                }
                case -5: {
                    String value = ConverterUtil.convertToString((long)rs.getLong(i));
                    paramValue = new ParamValue(rs.wasNull() ? null : value);
                    break;
                }
                default: {
                    String value = rs.getString(i);
                    paramValue = new ParamValue(value);
                }
            }
            dataEntry.addValue(useColumnNumbers ? Integer.toString(i) : metaData.getColumnLabel(i), paramValue);
        }
        return dataEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParamValue processSQLArray(Array dataArray, ParamValue paramValue) throws SQLException {
        ResultSet rs = null;
        try {
            rs = dataArray.getResultSet();
            while (rs.next()) {
                Object arrayEl = rs.getObject(2);
                if (arrayEl instanceof Struct) {
                    paramValue.getArrayValue().add(new ParamValue((Struct)arrayEl));
                    continue;
                }
                if (arrayEl instanceof Array) {
                    paramValue.getArrayValue().add(this.processSQLArray((Array)arrayEl, new ParamValue(2)));
                    continue;
                }
                paramValue.getArrayValue().add(new ParamValue(String.valueOf(arrayEl)));
            }
            ParamValue paramValue2 = paramValue;
            return paramValue2;
        }
        finally {
            this.releaseResources(rs, null);
        }
    }

    private String convertToTimeString(java.sql.Time sqlTime) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(sqlTime.getTime());
        return new Time(cal).toString();
    }

    private String convertToTimestampString(Timestamp sqlTimestamp) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(sqlTimestamp.getTime());
        return ConverterUtil.convertToString((Calendar)cal);
    }

    private String getBase64StringFromInputStream(InputStream in) throws SQLException {
        String strData;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try {
            byte[] buff = new byte[512];
            int i = 0;
            while ((i = in.read(buff)) > 0) {
                byteOut.write(buff, 0, i);
            }
            in.close();
            byte[] base64Data = Base64.encodeBase64((byte[])byteOut.toByteArray());
            strData = new String(base64Data, "UTF-8");
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
        return strData;
    }

    private byte[] getBytesFromBase64String(String base64Str) throws SQLException {
        try {
            byte[] data = Base64.decodeBase64((byte[])base64Str.getBytes("UTF-8"));
            return data;
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    private Integer[] extractSQLParamIndices(String sql) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        char[] data = sql.toCharArray();
        for (int i = 0; i < data.length; ++i) {
            if (data[i] != '?') continue;
            result.add(i);
        }
        return result.toArray(new Integer[result.size()]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PreparedStatement createProcessedPreparedStatement(int queryType, InternalParamCollection params, Connection conn) throws DataServiceFault {
        try {
            boolean inTheMiddleOfABatch = false;
            PreparedStatement stmt = this.getBatchPreparedStatement();
            int currentParamCount = this.getParamCount();
            if (stmt == null) {
                Object[] result = this.processDynamicQuery(this.getQuery(), params);
                String dynamicSQL = (String)result[0];
                currentParamCount = (Integer)result[1];
                String processedSQL = this.createProcessedQuery(dynamicSQL, params, currentParamCount);
                if (log.isDebugEnabled()) {
                    String paramsStr = "";
                    for (int i = 1; i <= this.getParamCount(); ++i) {
                        paramsStr = paramsStr + params.getParam(i) + ",";
                    }
                    log.debug((Object)("Starting DB calls: for \"" + processedSQL + "\" with params - " + paramsStr + ", ThreadID - " + Thread.currentThread().getId()));
                }
                if (queryType == 1) {
                    stmt = this.isReturnGeneratedKeys() ? (this.getKeyColumns() != null ? conn.prepareStatement(processedSQL, this.getKeyColumns()) : conn.prepareStatement(processedSQL, 1)) : conn.prepareStatement(processedSQL);
                } else {
                    if (queryType != 2) throw new DataServiceFault("Unsupported query type: " + queryType);
                    stmt = conn.prepareCall(processedSQL);
                }
            } else {
                inTheMiddleOfABatch = true;
            }
            if (!inTheMiddleOfABatch) {
                if (this.isHasQueryTimeout()) {
                    stmt.setQueryTimeout(this.getQueryTimeout());
                }
                try {
                    if (this.isHasFetchDirection()) {
                        stmt.setFetchDirection(this.getFetchDirection());
                    }
                    if (this.isHasFetchSize()) {
                        stmt.setFetchSize(this.getFetchSize());
                    } else if (!this.hasOutParams() && this.getFetchSizeProperty().isChangeFetchSize()) {
                        stmt.setFetchSize(this.getFetchSizeProperty().getFetchSize());
                    }
                }
                catch (Throwable e) {
                    log.debug((Object)("Exception while setting fetch size: " + e.getMessage()), e);
                }
                if (this.isHasMaxFieldSize()) {
                    stmt.setMaxFieldSize(this.getMaxFieldSize());
                }
                if (this.isHasMaxRows()) {
                    stmt.setMaxRows(this.getMaxRows());
                }
            }
            int currentOrdinal = 0;
            for (int i = 1; i <= currentParamCount; ++i) {
                InternalParam param = params.getParam(i);
                ParamValue value = param.getValue();
                param.setOrdinal(currentOrdinal + 1);
                if (value != null && value.getValueType() == 2) {
                    for (ParamValue arrayElement : value.getArrayValue()) {
                        this.setParamInPreparedStatement(stmt, param, arrayElement == null ? null : arrayElement.toString(), queryType, currentOrdinal);
                        ++currentOrdinal;
                    }
                    continue;
                }
                this.setParamInPreparedStatement(stmt, param, value != null ? value.getScalarValue() : null, queryType, currentOrdinal);
                ++currentOrdinal;
            }
            if (!this.isJDBCBatchRequest()) return stmt;
            stmt.addBatch();
            return stmt;
        }
        catch (SQLException e) {
            throw new DataServiceFault(e, "Error in 'createProcessedPreparedStatement'");
        }
    }

    private void setParamInPreparedStatement(PreparedStatement stmt, InternalParam param, String value, int queryType, int index) throws SQLException, DataServiceFault {
        String paramName = param.getName();
        String sqlType = param.getSqlType();
        String paramType = param.getType();
        String structType = param.getStructType();
        if (sqlType == null) {
            this.setDefaultStringValue(value, paramType, stmt, index);
        } else if ("INTEGER".equals(sqlType)) {
            this.setIntValue(queryType, value, paramType, stmt, index);
        } else if ("STRING".equals(sqlType) || "UUID".equals(sqlType) || "INETADDRESS".equals(sqlType)) {
            this.setStringValue(queryType, value, paramType, stmt, index);
        } else if ("DOUBLE".equals(sqlType)) {
            this.setDoubleValue(queryType, value, paramType, stmt, index);
        } else if ("NUMERIC".equals(sqlType)) {
            this.setNumericValue(queryType, value, paramType, stmt, index);
        } else if ("BIT".equals(sqlType) || "BOOLEAN".equals(sqlType)) {
            this.setBitValue(queryType, value, paramType, stmt, index);
        } else if ("TINYINT".equals(sqlType)) {
            this.setTinyIntValue(queryType, value, paramType, stmt, index);
        } else if ("SMALLINT".equals(sqlType)) {
            this.setSmallIntValue(queryType, value, paramType, stmt, index);
        } else if ("BIGINT".equals(sqlType) || "VARINT".equals(sqlType)) {
            this.setBigIntValue(queryType, value, paramType, stmt, index);
        } else if ("REAL".equals(sqlType)) {
            this.setRealValue(queryType, value, paramType, stmt, index);
        } else if ("DATE".equals(sqlType)) {
            this.setDateValue(queryType, paramName, value, paramType, stmt, index);
        } else if ("TIMESTAMP".equals(sqlType)) {
            this.setTimestampValue(queryType, paramName, value, paramType, stmt, index);
        } else if ("TIME".equals(sqlType)) {
            this.setTimeValue(queryType, paramName, value, paramType, stmt, index);
        } else if ("BINARY".equals(sqlType)) {
            this.setBinaryValue(queryType, paramName, value, paramType, stmt, index);
        } else if ("BLOB".equals(sqlType)) {
            this.setBlobValue(queryType, paramName, value, paramType, stmt, index);
        } else if ("CLOB".equals(sqlType)) {
            this.setClobValue(queryType, paramName, value, paramType, stmt, index);
        } else if ("ORACLE_REF_CURSOR".equals(sqlType)) {
            this.setOracleRefCusor(stmt, index);
        } else if ("STRUCT".equals(sqlType)) {
            this.setUserDefinedType(stmt, index, paramType, structType);
        } else if ("ARRAY".equals(sqlType)) {
            this.setArrayValue(stmt, index, paramType, structType);
        } else {
            throw new DataServiceFault("[" + this.getDataService().getName() + "]  Found Unsupported data type : " + sqlType + " as input parameter.");
        }
    }

    private void setClobValue(int queryType, String paramName, String value, String paramType, PreparedStatement sqlQuery, int i) throws SQLException, DataServiceFault {
        if ("IN".equals(paramType)) {
            if (value == null) {
                sqlQuery.setNull(i + 1, 2005);
            } else {
                sqlQuery.setClob(i + 1, new BufferedReader(new StringReader(value)), value.length());
            }
        } else if ("INOUT".equals(paramType)) {
            if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, 2005);
            } else {
                ((CallableStatement)sqlQuery).setClob(i + 1, (Reader)new BufferedReader(new StringReader(value)), (long)value.length());
            }
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 2005);
        } else {
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 2005);
        }
    }

    private void setArrayValue(PreparedStatement sqlQuery, int i, String paramType, String structType) throws SQLException, DataServiceFault {
        if (!"OUT".equals(paramType)) {
            throw new DataServiceFault("IN or INOUT operations are not supported for SQL Arrays");
        }
        ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 2003, structType);
    }

    private void setDefaultStringValue(String value, String paramType, PreparedStatement sqlQuery, int i) throws SQLException {
        if ("IN".equals(paramType)) {
            sqlQuery.setString(i + 1, value);
        } else if ("INOUT".equals(paramType)) {
            sqlQuery.setString(i + 1, value);
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 12);
        } else {
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 12);
        }
    }

    private void setTimeValue(int queryType, String paramName, String value, String paramType, PreparedStatement sqlQuery, int i) throws SQLException, DataServiceFault {
        java.sql.Time time = null;
        try {
            if (value != null) {
                time = DBUtils.getTime(value);
            }
        }
        catch (ParseException e) {
            throw new DataServiceFault(e, "Incorrect Time format for parameter : " + paramName + ". Time should be in the format hh:mm:ss");
        }
        catch (DataServiceFault e) {
            throw new DataServiceFault(e, "Error processing parameter - " + paramName + ", Error - " + e.getMessage());
        }
        if ("IN".equals(paramType)) {
            if (queryType == 1) {
                if (value == null) {
                    sqlQuery.setNull(i + 1, 92);
                } else {
                    sqlQuery.setTime(i + 1, time);
                }
            } else if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, 92);
            } else {
                ((CallableStatement)sqlQuery).setTime(i + 1, time);
            }
        } else if ("INOUT".equals(paramType)) {
            if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, 92);
            } else {
                ((CallableStatement)sqlQuery).setTime(i + 1, time);
            }
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 92);
        } else {
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 92);
        }
    }

    private void setBinaryValue(int queryType, String paramName, String value, String paramType, PreparedStatement sqlQuery, int i) throws SQLException, DataServiceFault {
        if ("IN".equals(paramType)) {
            if (value == null) {
                sqlQuery.setNull(i + 1, -2);
            } else {
                byte[] data = this.getBytesFromBase64String(value);
                sqlQuery.setBinaryStream(i + 1, (InputStream)new ByteArrayInputStream(data), data.length);
            }
        } else if ("INOUT".equals(paramType)) {
            if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, -2);
            } else {
                byte[] data = this.getBytesFromBase64String(value);
                ((CallableStatement)sqlQuery).setBinaryStream(i + 1, (InputStream)new ByteArrayInputStream(data), data.length);
            }
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, -2);
        } else {
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, -2);
        }
    }

    private void setBlobValue(int queryType, String paramName, String value, String paramType, PreparedStatement sqlQuery, int i) throws SQLException, DataServiceFault {
        if ("IN".equals(paramType)) {
            if (value == null) {
                sqlQuery.setNull(i + 1, 2004);
            } else {
                byte[] data = this.getBytesFromBase64String(value);
                sqlQuery.setBlob(i + 1, new ByteArrayInputStream(data), data.length);
            }
        } else if ("INOUT".equals(paramType)) {
            if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, 2004);
            } else {
                byte[] data = this.getBytesFromBase64String(value);
                ((CallableStatement)sqlQuery).setBlob(i + 1, (InputStream)new ByteArrayInputStream(data), (long)data.length);
            }
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 2004);
        } else {
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 2004);
        }
    }

    private void setOracleRefCusor(PreparedStatement sqlQuery, int i) throws SQLException, DataServiceFault {
        ((CallableStatement)sqlQuery).registerOutParameter(i + 1, -10);
        SQLQuery.setCurrentRefCursorOrdinal(i + 1);
    }

    private void setUserDefinedType(PreparedStatement sqlQuery, int parameterIndex, String paramType, String structType) throws SQLException, DataServiceFault {
        if (!"OUT".equals(paramType)) {
            throw new DataServiceFault("IN or INOUT operations are not supported for User Defined Types");
        }
        ((CallableStatement)sqlQuery).registerOutParameter(parameterIndex + 1, 2002, structType.toUpperCase());
    }

    private void setTimestampValue(int queryType, String paramName, String value, String paramType, PreparedStatement sqlQuery, int i) throws DataServiceFault, SQLException {
        Timestamp timestamp = null;
        try {
            if (value != null) {
                timestamp = DBUtils.getTimestamp(value);
            }
        }
        catch (ParseException e) {
            throw new DataServiceFault(e, "Incorrect Timestamp format for parameter : " + paramName + ". Timestamp should be in one of following formats " + "yyyy-MM-dd'T'hh:mm:ss.sss'+'hh:mm, " + "yyyy-MM-dd'T'hh:mm:ss.sss'-'hh:mm, " + "yyyy-MM-dd'T'hh:mm:ss.sss'Z', " + "yyyy-MM-dd hh:mm:ss.SSSSSS or " + "yyyy-MM-dd hh:mm:ss");
        }
        catch (DataServiceFault e) {
            throw new DataServiceFault(e, "Error processing parameter - " + paramName + ", Error - " + e.getMessage());
        }
        if ("IN".equals(paramType)) {
            if (queryType == 1) {
                if (value == null) {
                    sqlQuery.setNull(i + 1, 93);
                } else if (this.timeConvertEnabled) {
                    sqlQuery.setTimestamp(i + 1, timestamp, this.calendar);
                } else {
                    sqlQuery.setTimestamp(i + 1, timestamp);
                }
            } else if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, 93);
            } else if (this.timeConvertEnabled) {
                ((CallableStatement)sqlQuery).setTimestamp(i + 1, timestamp, this.calendar);
            } else {
                ((CallableStatement)sqlQuery).setTimestamp(i + 1, timestamp);
            }
        } else if ("INOUT".equals(paramType)) {
            if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, 93);
            } else if (this.timeConvertEnabled) {
                ((CallableStatement)sqlQuery).setTimestamp(i + 1, timestamp, this.calendar);
            } else {
                ((CallableStatement)sqlQuery).setTimestamp(i + 1, timestamp);
            }
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 93);
        } else {
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 93);
        }
    }

    private void setDateValue(int queryType, String paramName, String value, String paramType, PreparedStatement sqlQuery, int i) throws SQLException, DataServiceFault {
        Date val = null;
        if (value != null) {
            val = DBUtils.getDate(value);
        }
        try {
            if ("IN".equals(paramType)) {
                if (queryType == 1) {
                    if (value == null) {
                        sqlQuery.setNull(i + 1, 91);
                    } else {
                        sqlQuery.setDate(i + 1, val);
                    }
                } else if (value == null) {
                    ((CallableStatement)sqlQuery).setNull(i + 1, 91);
                } else {
                    ((CallableStatement)sqlQuery).setDate(i + 1, val);
                }
            } else if ("INOUT".equals(paramType)) {
                if (value == null) {
                    ((CallableStatement)sqlQuery).setNull(i + 1, 91);
                } else {
                    ((CallableStatement)sqlQuery).setDate(i + 1, val);
                }
                ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 91);
            } else {
                ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 91);
            }
        }
        catch (IllegalArgumentException e) {
            throw new DataServiceFault(e, "Incorrect date format for parameter  : " + paramName + ". Date should be in yyyy-mm-dd format.");
        }
    }

    private void setRealValue(int queryType, String value, String paramType, PreparedStatement sqlQuery, int i) throws SQLException {
        Float val = null;
        if (value != null) {
            val = new Float(value);
        }
        if ("IN".equals(paramType)) {
            if (queryType == 1) {
                if (value == null) {
                    sqlQuery.setNull(i + 1, 6);
                } else {
                    sqlQuery.setFloat(i + 1, val.floatValue());
                }
            } else if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, 6);
            } else {
                ((CallableStatement)sqlQuery).setFloat(i + 1, val.floatValue());
            }
        } else if ("INOUT".equals(paramType)) {
            if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, 6);
            } else {
                ((CallableStatement)sqlQuery).setFloat(i + 1, val.floatValue());
            }
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 6);
        } else {
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 6);
        }
    }

    private void setBigIntValue(int queryType, String value, String paramType, PreparedStatement sqlQuery, int i) throws SQLException {
        Long val = null;
        if (value != null) {
            val = new Long(value);
        }
        if ("IN".equals(paramType)) {
            if (queryType == 1) {
                if (value == null) {
                    sqlQuery.setNull(i + 1, -5);
                } else {
                    sqlQuery.setLong(i + 1, val);
                }
            } else if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, -5);
            } else {
                ((CallableStatement)sqlQuery).setLong(i + 1, (long)val);
            }
        } else if ("INOUT".equals(paramType)) {
            if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, -5);
            } else {
                ((CallableStatement)sqlQuery).setLong(i + 1, (long)val);
            }
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, -5);
        } else {
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, -5);
        }
    }

    private void setSmallIntValue(int queryType, String value, String paramType, PreparedStatement sqlQuery, int i) throws SQLException {
        Short val = null;
        if (value != null) {
            val = new Short(value);
        }
        if ("IN".equals(paramType)) {
            if (queryType == 1) {
                if (value == null) {
                    sqlQuery.setNull(i + 1, 5);
                } else {
                    sqlQuery.setShort(i + 1, val);
                }
            } else if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, 5);
            } else {
                ((CallableStatement)sqlQuery).setShort(i + 1, (short)val);
            }
        } else if ("INOUT".equals(paramType)) {
            if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, 5);
            } else {
                ((CallableStatement)sqlQuery).setShort(i + 1, (short)val);
            }
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 5);
        } else {
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 5);
        }
    }

    private void setTinyIntValue(int queryType, String value, String paramType, PreparedStatement sqlQuery, int i) throws SQLException {
        Byte val = null;
        if (value != null) {
            val = new Byte(value);
        }
        if ("IN".equals(paramType)) {
            if (queryType == 1) {
                if (value == null) {
                    sqlQuery.setNull(i + 1, -6);
                } else {
                    sqlQuery.setByte(i + 1, val);
                }
            } else if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, -6);
            } else {
                ((CallableStatement)sqlQuery).setByte(i + 1, (byte)val);
            }
        } else if ("INOUT".equals(paramType)) {
            if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, -6);
            } else {
                ((CallableStatement)sqlQuery).setByte(i + 1, (byte)val);
            }
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, -6);
        } else {
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, -6);
        }
    }

    private void setBitValue(int queryType, String value, String paramType, PreparedStatement sqlQuery, int i) throws SQLException {
        Boolean val = null;
        if (value != null) {
            val = Boolean.valueOf(value);
        }
        if ("IN".equals(paramType)) {
            if (queryType == 1) {
                if (value == null) {
                    sqlQuery.setNull(i + 1, -7);
                } else {
                    sqlQuery.setBoolean(i + 1, val);
                }
            } else if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, -7);
            } else {
                ((CallableStatement)sqlQuery).setBoolean(i + 1, (boolean)val);
            }
        } else if ("INOUT".equals(paramType)) {
            if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, -7);
            } else {
                ((CallableStatement)sqlQuery).setBoolean(i + 1, (boolean)val);
            }
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, -7);
        } else {
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, -7);
        }
    }

    private void setNumericValue(int queryType, String value, String paramType, PreparedStatement sqlQuery, int i) throws SQLException {
        BigDecimal val = null;
        if (value != null) {
            val = new BigDecimal(value);
        }
        if ("IN".equals(paramType)) {
            if (queryType == 1) {
                if (value == null) {
                    sqlQuery.setNull(i + 1, 2);
                } else {
                    sqlQuery.setBigDecimal(i + 1, val);
                }
            } else if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, 2);
            } else {
                ((CallableStatement)sqlQuery).setBigDecimal(i + 1, val);
            }
        } else if ("INOUT".equals(paramType)) {
            if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, 2);
            } else {
                ((CallableStatement)sqlQuery).setBigDecimal(i + 1, val);
            }
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 2);
        } else {
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 2);
        }
    }

    private void setDoubleValue(int queryType, String value, String paramType, PreparedStatement sqlQuery, int i) throws SQLException {
        Double val = null;
        if (value != null) {
            val = Double.parseDouble(value);
        }
        if ("IN".equals(paramType)) {
            if (queryType == 1) {
                if (value == null) {
                    sqlQuery.setNull(i + 1, 8);
                } else {
                    sqlQuery.setDouble(i + 1, val);
                }
            } else if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, 8);
            } else {
                ((CallableStatement)sqlQuery).setDouble(i + 1, (double)val);
            }
        } else if ("INOUT".equals(paramType)) {
            if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, 8);
            } else {
                ((CallableStatement)sqlQuery).setDouble(i + 1, (double)val);
            }
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 8);
        } else {
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 8);
        }
    }

    private void setStringValue(int queryType, String value, String paramType, PreparedStatement sqlQuery, int i) throws SQLException {
        if ("IN".equals(paramType)) {
            if (queryType == 1) {
                if (value == null) {
                    sqlQuery.setNull(i + 1, 12);
                } else {
                    sqlQuery.setString(i + 1, value);
                }
            } else if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, 12);
            } else {
                ((CallableStatement)sqlQuery).setString(i + 1, value);
            }
        } else if ("INOUT".equals(paramType)) {
            if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, 12);
            } else {
                ((CallableStatement)sqlQuery).setString(i + 1, value);
            }
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 12);
        } else {
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 12);
        }
    }

    private void setIntValue(int queryType, String value, String paramType, PreparedStatement sqlQuery, int i) throws SQLException {
        Integer val = null;
        if (value != null) {
            val = Integer.parseInt(value);
        }
        if ("IN".equals(paramType)) {
            if (queryType == 1) {
                if (value == null) {
                    sqlQuery.setNull(i + 1, 4);
                } else {
                    sqlQuery.setInt(i + 1, val);
                }
            } else if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, 4);
            } else {
                ((CallableStatement)sqlQuery).setInt(i + 1, (int)val);
            }
        } else if ("INOUT".equals(paramType)) {
            if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, 4);
            } else {
                ((CallableStatement)sqlQuery).setInt(i + 1, (int)val);
            }
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 4);
        } else {
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 4);
        }
    }

    private ParamValue getOutparameterValue(CallableStatement cs, String type, int ordinal) throws DataServiceFault {
        try {
            if (type.equals("STRING")) {
                String elementValue = cs.getString(ordinal);
                return new ParamValue(elementValue == null ? null : elementValue.toString());
            }
            if (type.equals("DOUBLE")) {
                Double elementValue = cs.getDouble(ordinal);
                return new ParamValue(elementValue == null ? null : ConverterUtil.convertToString((Double)elementValue));
            }
            if (type.equals("BIGINT")) {
                Long elementValue = cs.getLong(ordinal);
                return new ParamValue(elementValue == null ? null : ConverterUtil.convertToString((Long)elementValue));
            }
            if (type.equals("INTEGER")) {
                Integer elementValue = cs.getInt(ordinal);
                return new ParamValue(elementValue == null ? null : ConverterUtil.convertToString((Integer)elementValue));
            }
            if (type.equals("TIME")) {
                java.sql.Time elementValue = cs.getTime(ordinal);
                return new ParamValue(elementValue == null ? null : this.convertToTimeString(elementValue));
            }
            if (type.equals("DATE")) {
                Date elementValue = cs.getDate(ordinal);
                return new ParamValue(elementValue == null ? null : ConverterUtil.convertToString((java.util.Date)elementValue));
            }
            if (type.equals("TIMESTAMP")) {
                Timestamp elementValue = this.timeConvertEnabled ? cs.getTimestamp(ordinal, this.calendar) : cs.getTimestamp(ordinal);
                return new ParamValue(elementValue == null ? null : this.convertToTimestampString(elementValue));
            }
            if (type.equals("BLOB")) {
                Blob elementValue = cs.getBlob(ordinal);
                return new ParamValue(elementValue == null ? null : this.getBase64StringFromInputStream(elementValue.getBinaryStream()));
            }
            if (type.equals("CLOB")) {
                Clob elementValue = cs.getClob(ordinal);
                return new ParamValue(elementValue == null ? null : this.deriveValueFromClob(elementValue));
            }
            if (type.equals("STRUCT")) {
                Object elementValue = cs.getObject(ordinal);
                return new ParamValue(elementValue == null ? null : (Struct)elementValue);
            }
            if (type.equals("ARRAY")) {
                Array dataArray = cs.getArray(ordinal);
                ParamValue paramValue = new ParamValue(2);
                if (dataArray != null) {
                    this.processSQLArray(dataArray, paramValue);
                }
                return paramValue;
            }
            if (type.equals("NUMERIC")) {
                BigDecimal elementValue = cs.getBigDecimal(ordinal);
                return new ParamValue(elementValue == null ? null : ConverterUtil.convertToString((BigDecimal)elementValue));
            }
            if (type.equals("BIT")) {
                Boolean elementValue = cs.getBoolean(ordinal);
                return new ParamValue(elementValue == null ? null : ConverterUtil.convertToString((Object)elementValue));
            }
            if (type.equals("TINYINT")) {
                Byte elementValue = cs.getByte(ordinal);
                return new ParamValue(elementValue == null ? null : ConverterUtil.convertToString((Byte)elementValue));
            }
            if (type.equals("SMALLINT")) {
                Short elementValue = cs.getShort(ordinal);
                return new ParamValue(elementValue == null ? null : ConverterUtil.convertToString((Short)elementValue));
            }
            if (type.equals("REAL")) {
                Float elementValue = Float.valueOf(cs.getFloat(ordinal));
                return new ParamValue(elementValue == null ? null : ConverterUtil.convertToString((Float)elementValue));
            }
            if (type.equals("BINARY")) {
                Blob elementValue = cs.getBlob(ordinal);
                return new ParamValue(elementValue == null ? null : this.getBase64StringFromInputStream(elementValue.getBinaryStream()));
            }
            throw new DataServiceFault("Unsupported data type: " + type);
        }
        catch (SQLException e) {
            throw new DataServiceFault(e, "Error in getting sql output parameter values.");
        }
    }

    private String deriveValueFromClob(Clob data) throws DataServiceFault {
        Reader r = null;
        try {
            int pos;
            StringBuilder sb = new StringBuilder();
            r = new BufferedReader(data.getCharacterStream());
            while ((pos = r.read()) != -1) {
                sb.append((char)pos);
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            throw new DataServiceFault(e, "Error occurred while reading CLOB value");
        }
        catch (SQLException e) {
            throw new DataServiceFault(e, "Error occurred while reading CLOB value");
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    public boolean hasRefCursor() {
        return this.hasRefCursor;
    }

    @Override
    public Object runPreQuery(InternalParamCollection params, int queryLevel) throws DataServiceFault {
        int type = this.getQueryType();
        if (type == 1) {
            return this.processPreNormalQuery(params, queryLevel);
        }
        if (type == 2) {
            return this.processPreStoredProcQuery(params, queryLevel);
        }
        throw new DataServiceFault("Unsupported query type: " + type);
    }

    @Override
    public void runPostQuery(Object result, XMLStreamWriter xmlWriter, InternalParamCollection params, int queryLevel) throws DataServiceFault {
        int type = this.getQueryType();
        if (type == 1) {
            this.processPostNormalQuery(result, xmlWriter, params, queryLevel);
        } else if (type == 2) {
            this.processPostStoredProcQuery(result, xmlWriter, params, queryLevel);
        } else {
            throw new DataServiceFault("Unsupported query type: " + type);
        }
    }

    @Override
    public void releaseBatchRequestResources() {
        this.batchPreparedStatement.set(null);
    }

    private void setAutoCommit(Connection conn, boolean autoCommit) throws SQLException {
        try {
            conn.setAutoCommit(autoCommit);
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public class FetchSizeProperty {
        private boolean changeFetchSize;
        private int fetchSize;

        public FetchSizeProperty(boolean changeFetchSize, int fetchSize) {
            this.changeFetchSize = changeFetchSize;
            this.fetchSize = fetchSize;
        }

        public boolean isChangeFetchSize() {
            return this.changeFetchSize;
        }

        public int getFetchSize() {
            return this.fetchSize;
        }
    }

    public class StoredProcMetadataEntry {
        private String procedureCatalog;
        private String procedureSchema;
        private String procedureName;
        private String columnName;
        private short columnReturn;
        private int columnDataType;
        private String columnReturnTypeName;
        private int columnPrecision;
        private int columnByteLength;
        private short columnScale;
        private short columnRadix;
        private short columnNullable;
        private String columnRemarks;

        public StoredProcMetadataEntry(String procedureCatalog, String procedureSchema, String procedureName, String columnName, short columnReturn, int columnDataType, String columnReturnTypeName, int columnPrecision, int columnByteLength, short columnScale, short columnRadix, short columnNullable, String columnRemarks) {
            this.procedureCatalog = procedureCatalog;
            this.procedureSchema = procedureSchema;
            this.procedureName = procedureName;
            this.columnName = columnName;
            this.columnReturn = columnReturn;
            this.columnDataType = columnDataType;
            this.columnReturnTypeName = columnReturnTypeName;
            this.columnPrecision = columnPrecision;
            this.columnByteLength = columnByteLength;
            this.columnScale = columnScale;
            this.columnRadix = columnRadix;
            this.columnNullable = columnNullable;
            this.columnRemarks = columnRemarks;
        }

        public String getProcedureCatalog() {
            return this.procedureCatalog;
        }

        public String getProcedureSchema() {
            return this.procedureSchema;
        }

        public String getProcedureName() {
            return this.procedureName;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public short getColumnReturn() {
            return this.columnReturn;
        }

        public int getColumnDataType() {
            return this.columnDataType;
        }

        public String getColumnReturnTypeName() {
            return this.columnReturnTypeName;
        }

        public int getColumnPrecision() {
            return this.columnPrecision;
        }

        public int getColumnByteLength() {
            return this.columnByteLength;
        }

        public short getColumnScale() {
            return this.columnScale;
        }

        public short getColumnRadix() {
            return this.columnRadix;
        }

        public short getColumnNullable() {
            return this.columnNullable;
        }

        public String getColumnRemarks() {
            return this.columnRemarks;
        }
    }

    private class StoredProcMetadataCollection {
        private List<StoredProcMetadataEntry> entries = new ArrayList<StoredProcMetadataEntry>();

        public StoredProcMetadataCollection(ResultSet rs) throws SQLException {
            do {
                this.entries.add(new StoredProcMetadataEntry(rs.getString(1), rs.getString(2), rs.getString(3), rs.getString(4), rs.getShort(5), rs.getInt(6), rs.getString(7), rs.getInt(8), rs.getInt(9), rs.getShort(10), rs.getShort(11), rs.getShort(12), rs.getString(13)));
            } while (rs.next());
        }

        public List<StoredProcMetadataEntry> getEntries() {
            return this.entries;
        }
    }

    private class QueryResultInfo {
        private Statement statement;
        private ResultSet resultSet;

        public QueryResultInfo(PreparedStatement statement, ResultSet resultSet) {
            this.statement = statement;
            this.resultSet = resultSet;
        }

        public Statement getStatement() {
            return this.statement;
        }

        public ResultSet getResultSet() {
            return this.resultSet;
        }
    }
}

