/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.description.xa;

import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.dataservices.core.DataServiceFault;

public class DSSXATransactionManager {
    private static final Log log = LogFactory.getLog(DSSXATransactionManager.class);
    private ThreadLocal<Boolean> beginTx = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    public TransactionManager transactionManager;

    public DSSXATransactionManager(TransactionManager userTx) {
        if (userTx == null) {
            log.warn((Object)"TransactionManager is not available");
        }
        this.transactionManager = userTx;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void begin() throws DataServiceFault {
        TransactionManager txManager = this.getTransactionManager();
        if (txManager == null) {
            return;
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"DXXATransactionManager.begin()");
            }
            txManager.begin();
            this.beginTx.set(true);
        }
        catch (Exception e) {
            throw new DataServiceFault(e, "Error from transaction manager in begin(): " + e.getMessage());
        }
    }

    public void commit() throws DataServiceFault {
        TransactionManager txManager = this.getTransactionManager();
        if (txManager == null) {
            return;
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"transactionManager.commit()");
            }
            txManager.commit();
        }
        catch (Exception e) {
            throw new DataServiceFault(e, "Error from transaction manager when committing: " + e.getMessage());
        }
        finally {
            this.beginTx.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        TransactionManager txManager = this.getTransactionManager();
        if (txManager == null) {
            return;
        }
        try {
            txManager.rollback();
        }
        catch (Exception e) {
            log.warn((Object)("Error from transaction manager when rollbacking: " + e.getMessage()), (Throwable)e);
        }
        finally {
            this.beginTx.set(false);
        }
    }

    public boolean isDTXInitiatedByUS() {
        return this.beginTx.get();
    }

    public boolean isInDTX() {
        TransactionManager txManager = this.getTransactionManager();
        if (txManager == null) {
            return false;
        }
        try {
            return txManager.getStatus() != 6;
        }
        catch (Exception e) {
            log.error((Object)"Error at 'hasNoActiveTransaction'", (Throwable)e);
            return false;
        }
    }
}

