/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.description.xa;

import java.lang.reflect.Method;
import java.util.Map;
import javax.sql.XADataSource;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.engine.DataService;

public class XADataSourceInfo {
    private XADataSource xaDataSource;
    private String className;
    private Map<String, String> properties;
    private DataService dataService;

    public XADataSourceInfo(DataService dataService, String className, Map<String, String> properties) throws DataServiceFault {
        this.className = className;
        this.properties = properties;
        this.dataService = dataService;
        if (!this.dataService.isServiceInactive()) {
            this.initXA();
        }
    }

    private void initXA() throws DataServiceFault {
        try {
            this.xaDataSource = (XADataSource)Class.forName(this.getClassName()).newInstance();
            this.assignProps(this.getXADataSource(), this.getProperties());
        }
        catch (Exception e) {
            throw new DataServiceFault(e, "Cannot create XADataSource instance using the class: " + this.getClassName());
        }
    }

    private void assignProps(Object obj, Map<String, String> props) throws DataServiceFault {
        for (Map.Entry<String, String> prop : props.entrySet()) {
            Method method = this.getSetterMethod(obj, this.getSetterMethodNameFromPropName(prop.getKey()));
            if (method == null) {
                throw new DataServiceFault("Setter method for property '" + prop.getKey() + "' cannot be found");
            }
            try {
                method.invoke(obj, this.convertStringToGivenType(prop.getValue(), method.getParameterTypes()[0]));
            }
            catch (Exception e) {
                throw new DataServiceFault(e, "Cannot invoke setter for property '" + prop.getKey() + "'");
            }
        }
    }

    private Object convertStringToGivenType(String value, Class<?> type) throws DataServiceFault {
        if (String.class.equals(type)) {
            return value;
        }
        if (Boolean.TYPE.equals(type) || Boolean.class.equals(type)) {
            return Boolean.parseBoolean(value);
        }
        if (Integer.TYPE.equals(type) || Integer.class.equals(type)) {
            return Integer.parseInt(value);
        }
        if (Short.TYPE.equals(type) || Short.class.equals(type)) {
            return Short.parseShort(value);
        }
        if (Byte.TYPE.equals(type) || Byte.class.equals(type)) {
            return Byte.parseByte(value);
        }
        if (Long.TYPE.equals(type) || Long.class.equals(type)) {
            return Long.parseLong(value);
        }
        if (Float.TYPE.equals(type) || Float.class.equals(type)) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (Double.TYPE.equals(type) || Double.class.equals(type)) {
            return Double.parseDouble(value);
        }
        throw new DataServiceFault("Cannot convert value: '" + value + "' to type: '" + type.getName() + "'");
    }

    private String getSetterMethodNameFromPropName(String propName) throws RuntimeException {
        if (DBUtils.isEmptyString(propName)) {
            throw new RuntimeException("Invalid property name");
        }
        return "set" + propName.substring(0, 1).toUpperCase() + propName.substring(1);
    }

    private Method getSetterMethod(Object obj, String name) {
        Method[] methods;
        for (Method method : methods = obj.getClass().getMethods()) {
            if (!method.getName().equals(name) || !method.getReturnType().equals(Void.TYPE) || method.getParameterTypes().length != 1) continue;
            return method;
        }
        return null;
    }

    public XADataSource getXADataSource() {
        return this.xaDataSource;
    }

    public String getClassName() {
        return this.className;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public DataService getDataService() {
        return this.dataService;
    }
}

