/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.dispatch;

public class DispatchStatus {
    private static ThreadLocal<Boolean> batchRequest = new ThreadLocal<Boolean>(){

        @Override
        protected synchronized Boolean initialValue() {
            return false;
        }
    };
    private static ThreadLocal<Boolean> boxcarringRequest = new ThreadLocal<Boolean>(){

        @Override
        protected synchronized Boolean initialValue() {
            return false;
        }
    };
    private static ThreadLocal<Integer> batchRequestCount = new ThreadLocal<Integer>(){

        @Override
        protected synchronized Integer initialValue() {
            return 0;
        }
    };
    private static ThreadLocal<Integer> batchRequestNumber = new ThreadLocal<Integer>(){

        @Override
        protected synchronized Integer initialValue() {
            return 0;
        }
    };

    public static void clearRequestStatus() {
        batchRequest.set(false);
        boxcarringRequest.set(false);
        batchRequestCount.set(0);
        batchRequestNumber.set(0);
    }

    public static void setBatchRequest() {
        batchRequest.set(true);
    }

    public static void setBoxcarringRequest() {
        boxcarringRequest.set(true);
    }

    public static boolean isBatchRequest() {
        return batchRequest.get();
    }

    public static int getBatchRequestCount() {
        return batchRequestCount.get();
    }

    public static void setBatchRequestCount(int val) {
        batchRequestCount.set(val);
    }

    public static int getBatchRequestNumber() {
        return batchRequestNumber.get();
    }

    public static void setBatchRequestNumber(int val) {
        batchRequestNumber.set(val);
    }

    public static boolean isBoxcarringRequest() {
        return boxcarringRequest.get();
    }

    public static boolean isInBatchBoxcarring() {
        return DispatchStatus.isBatchRequest() || DispatchStatus.isBoxcarringRequest();
    }

    public static boolean isFirstBatchRequest() {
        return batchRequestNumber.get() == 0;
    }

    public static boolean isLastBatchRequest() {
        return batchRequestNumber.get() + 1 >= batchRequestCount.get();
    }
}

