/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.dispatch;

import org.apache.axiom.om.OMElement;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.TLConnectionStore;
import org.wso2.carbon.dataservices.core.boxcarring.RequestBox;
import org.wso2.carbon.dataservices.core.boxcarring.TLParamStore;
import org.wso2.carbon.dataservices.core.dispatch.DataServiceRequest;
import org.wso2.carbon.dataservices.core.dispatch.DispatchStatus;
import org.wso2.carbon.dataservices.core.engine.DataService;

public class RequestBoxRequest
extends DataServiceRequest {
    private RequestBox requestBox = new RequestBox();

    public RequestBoxRequest(DataService dataService, String requestName) throws DataServiceFault {
        super(dataService, requestName);
    }

    public void addRequests(DataServiceRequest request) {
        this.requestBox.addRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OMElement processRequest() throws DataServiceFault {
        boolean error = true;
        try {
            DispatchStatus.setBoxcarringRequest();
            if (!this.getDataService().isInDTX()) {
                this.getDataService().getDSSTxManager().begin();
            }
            OMElement lastRequestResult = this.requestBox.execute();
            error = false;
            OMElement oMElement = lastRequestResult;
            return oMElement;
        }
        finally {
            this.finalizeTx(error);
            TLParamStore.clear();
        }
    }

    private void finalizeTx(boolean error) throws DataServiceFault {
        if (error) {
            if (this.getDataService().isInDTX()) {
                TLConnectionStore.rollbackNonXAConns();
                TLConnectionStore.closeAll();
                if (this.getDataService().getDSSTxManager().isDTXInitiatedByUS()) {
                    this.getDataService().getDSSTxManager().rollback();
                }
            } else {
                TLConnectionStore.rollbackAll();
                TLConnectionStore.closeAll();
            }
        } else {
            if (this.getDataService().isInDTX()) {
                TLConnectionStore.commitNonXAConns();
            } else {
                TLConnectionStore.commitAll();
            }
            TLConnectionStore.closeAll();
            if (this.getDataService().getDSSTxManager().isDTXInitiatedByUS()) {
                this.getDataService().getDSSTxManager().commit();
            }
        }
    }
}

