/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.engine;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.wso2.carbon.dataservices.common.DBConstants;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.engine.ParamValue;
import org.wso2.carbon.dataservices.core.validation.Validator;

public class QueryParam {
    private String name;
    private String sqlType;
    private String type;
    private String paramType;
    private Set<Integer> ordinals;
    private ParamValue defaultValue;
    private List<Validator> validators;
    private String structType;

    public QueryParam(String name, String sqlType, String type, String paramType, int ordinal, ParamValue defaultValue, String structType, List<Validator> validators) throws DataServiceFault {
        this.name = name;
        this.sqlType = sqlType;
        this.type = type;
        this.paramType = paramType;
        this.ordinals = new TreeSet<Integer>();
        this.ordinals.add(ordinal);
        this.defaultValue = defaultValue;
        this.structType = structType;
        this.validators = validators;
        this.validateQueryParam();
    }

    private void validateQueryParam() throws DataServiceFault {
        try {
            Class<DBConstants.DataTypes> typesInterface = DBConstants.DataTypes.class;
            Field[] typeFields = typesInterface.getFields();
            Class<DBConstants.XSDTypes> xsdTypesInterface = DBConstants.XSDTypes.class;
            Field[] xsdTypeFields = xsdTypesInterface.getFields();
            boolean typeFound = false;
            for (Field typeField : typeFields) {
                if (!typeField.get(null).equals(this.getSqlType())) continue;
                typeFound = true;
                break;
            }
            for (Field xsdtypeField : xsdTypeFields) {
                if (!xsdtypeField.get(null).equals(this.getSqlType())) continue;
                typeFound = true;
                break;
            }
            if (!typeFound) {
                throw new DataServiceFault("Invalid query param sqlType: '" + this.getSqlType() + "'.");
            }
            if (!("IN".equals(this.getType()) || "OUT".equals(this.getType()) || "INOUT".equals(this.getType()))) {
                throw new DataServiceFault("Invalid query param type: '" + this.getType() + "'.");
            }
            if (!"SCALAR".equals(this.getParamType()) && !"ARRAY".equals(this.getParamType())) {
                throw new DataServiceFault("Invalid query param type: '" + this.getParamType() + "'.");
            }
            if ("STRUCT".equals(this.getSqlType()) && ("".equals(this.getStructType()) || this.getStructType() == null)) {
                throw new DataServiceFault("Unable to find SQL type name corresponding to the specified Struct");
            }
        }
        catch (Exception e) {
            throw new DataServiceFault(e);
        }
    }

    public List<Validator> getValidators() {
        return this.validators;
    }

    public String getName() {
        return this.name;
    }

    public int getOrdinal() {
        return this.ordinals.iterator().next();
    }

    public Set<Integer> getOrdinals() {
        return this.ordinals;
    }

    public String getSqlType() {
        return this.sqlType;
    }

    public String getType() {
        return this.type;
    }

    public String getParamType() {
        return this.paramType;
    }

    public ParamValue getDefaultValue() {
        return this.defaultValue;
    }

    public String getStructType() {
        return this.structType;
    }

    public boolean hasDefaultValue() {
        return this.getDefaultValue() != null;
    }

    public void setOrdinal(int ordinal) {
        this.clearOrdinals();
        this.ordinals.add(ordinal);
    }

    public void addOrdinal(int ordinal) {
        this.ordinals.add(ordinal);
    }

    public void clearOrdinals() {
        this.ordinals.clear();
    }
}

