/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.odata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.provider.CsdlAbstractEdmProvider;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityContainer;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityContainerInfo;
import org.apache.olingo.commons.api.edm.provider.CsdlEntitySet;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityType;
import org.apache.olingo.commons.api.edm.provider.CsdlNavigationProperty;
import org.apache.olingo.commons.api.edm.provider.CsdlNavigationPropertyBinding;
import org.apache.olingo.commons.api.edm.provider.CsdlProperty;
import org.apache.olingo.commons.api.edm.provider.CsdlPropertyRef;
import org.apache.olingo.commons.api.edm.provider.CsdlSchema;
import org.wso2.carbon.dataservices.core.odata.NavigationTable;

public class EDMProvider
extends CsdlAbstractEdmProvider {
    private String namespace;
    private FullQualifiedName containerFullQName;
    private Map<String, HashSet<String>> oneToManyRelationList;
    private Map<String, HashSet<String>> manyToOneRelationList;
    private Map<String, CsdlEntityType> csdlEntityTypesMap;
    private List<CsdlSchema> csdlSchemaList;
    private CsdlEntityContainer csdlEntityContainer;
    private CsdlEntityContainerInfo csdlEntityContainerInfo;
    private Map<String, CsdlEntitySet> csdlEntitySetMap;

    public EDMProvider(List<String> tableList, String containerName, String namespace, Map<String, List<CsdlProperty>> propertiesMap, Map<String, List<CsdlPropertyRef>> pkeys, List<String> entitySet, Map<String, NavigationTable> navigationProperties) {
        this.containerFullQName = new FullQualifiedName(containerName, namespace);
        this.namespace = namespace;
        if (navigationProperties != null) {
            this.manyToOneRelationList = this.generateManyToOneRelationships(navigationProperties);
            this.oneToManyRelationList = this.generateOneToManyRelationships(navigationProperties);
        } else {
            this.manyToOneRelationList = null;
            this.oneToManyRelationList = null;
        }
        this.csdlEntityTypesMap = this.generateEntityTypes(propertiesMap, tableList, pkeys);
        this.csdlEntitySetMap = this.generateEntitySets(entitySet);
        this.csdlEntityContainer = this.generateCsdlEntityContainer();
        this.csdlEntityContainerInfo = this.generateCsdlEntityContainerInfo();
        this.csdlSchemaList = this.generateSchemaList();
    }

    private Map<String, CsdlEntityType> generateEntityTypes(Map<String, List<CsdlProperty>> properties, List<String> entityList, Map<String, List<CsdlPropertyRef>> pKeyList) {
        HashMap<String, CsdlEntityType> csdlEntityTypesMap = new HashMap<String, CsdlEntityType>();
        for (String entityTypeName : entityList) {
            List<CsdlPropertyRef> keys;
            CsdlEntityType entity = new CsdlEntityType();
            entity.setName(entityTypeName);
            for (CsdlProperty property : properties.get(entityTypeName)) {
                if (!EdmPrimitiveTypeKind.Stream.getFullQualifiedName().getFullQualifiedNameAsString().equals(property.getType())) continue;
                entity.setHasStream(true);
                break;
            }
            if ((keys = pKeyList.get(entityTypeName)).size() != 0) {
                entity.setKey(keys);
            }
            entity.setProperties(properties.get(entityTypeName));
            ArrayList<CsdlNavigationProperty> navigationProperties = new ArrayList<CsdlNavigationProperty>();
            if (this.oneToManyRelationList != null) {
                CsdlNavigationProperty navProp;
                if (this.oneToManyRelationList.get(entityTypeName) != null) {
                    for (String navigation : this.oneToManyRelationList.get(entityTypeName)) {
                        navProp = new CsdlNavigationProperty();
                        navProp.setName(navigation);
                        navProp.setType(new FullQualifiedName(this.namespace, navigation));
                        navProp.setCollection(true);
                        navProp.setPartner(entityTypeName);
                        navigationProperties.add(navProp);
                    }
                }
                if (this.manyToOneRelationList.get(entityTypeName) != null) {
                    for (String navigation : this.manyToOneRelationList.get(entityTypeName)) {
                        navProp = new CsdlNavigationProperty();
                        navProp.setName(navigation);
                        navProp.setType(new FullQualifiedName(this.namespace, navigation));
                        navProp.setPartner(entityTypeName);
                        navigationProperties.add(navProp);
                    }
                }
                if (!navigationProperties.isEmpty()) {
                    entity.setNavigationProperties(navigationProperties);
                }
            }
            csdlEntityTypesMap.put(entityTypeName, entity);
        }
        return csdlEntityTypesMap;
    }

    private Map<String, CsdlEntitySet> generateEntitySets(List<String> entitySetList) {
        HashMap<String, CsdlEntitySet> csdlEntitySetsMap = new HashMap<String, CsdlEntitySet>();
        for (String entitySetName : entitySetList) {
            CsdlEntitySet entitySet = new CsdlEntitySet();
            entitySet.setType(new FullQualifiedName(this.namespace, entitySetName));
            entitySet.setName(entitySetName);
            if (this.oneToManyRelationList != null) {
                CsdlNavigationPropertyBinding navPropBinding = new CsdlNavigationPropertyBinding();
                ArrayList<CsdlNavigationPropertyBinding> navPropBindingList = new ArrayList<CsdlNavigationPropertyBinding>();
                if (this.oneToManyRelationList.get(entitySetName) != null) {
                    for (String navigation : this.oneToManyRelationList.get(entitySetName)) {
                        navPropBinding.setTarget(navigation);
                        navPropBinding.setPath(navigation);
                        navPropBindingList.add(navPropBinding);
                    }
                }
                if (this.manyToOneRelationList.get(entitySetName) != null) {
                    for (String navigation : this.manyToOneRelationList.get(entitySetName)) {
                        navPropBinding.setTarget(navigation);
                        navPropBinding.setPath(navigation);
                        navPropBindingList.add(navPropBinding);
                    }
                }
                if (!navPropBindingList.isEmpty()) {
                    entitySet.setNavigationPropertyBindings(navPropBindingList);
                }
            }
            csdlEntitySetsMap.put(entitySetName, entitySet);
        }
        return csdlEntitySetsMap;
    }

    private List<CsdlSchema> generateSchemaList() {
        ArrayList<CsdlSchema> schemaList = new ArrayList<CsdlSchema>();
        CsdlSchema schema = new CsdlSchema();
        schema.setNamespace(this.namespace);
        if (!this.csdlEntityTypesMap.isEmpty()) {
            schema.setEntityTypes(new ArrayList<CsdlEntityType>(this.csdlEntityTypesMap.values()));
        }
        schema.setEntityContainer(this.csdlEntityContainer);
        schemaList.add(schema);
        return schemaList;
    }

    private CsdlEntityContainer generateCsdlEntityContainer() {
        CsdlEntityContainer container = new CsdlEntityContainer();
        container.setName(this.containerFullQName.getName());
        container.setEntitySets(new ArrayList<CsdlEntitySet>(this.csdlEntitySetMap.values()));
        return container;
    }

    private CsdlEntityContainerInfo generateCsdlEntityContainerInfo() {
        return new CsdlEntityContainerInfo().setContainerName(this.containerFullQName);
    }

    public CsdlEntityType getEntityType(FullQualifiedName entityTypeName) {
        return this.csdlEntityTypesMap.get(entityTypeName.getName());
    }

    public CsdlEntitySet getEntitySet(FullQualifiedName entityContainer, String entitySetName) {
        if (this.containerFullQName.equals((Object)entityContainer)) {
            return this.csdlEntitySetMap.get(entitySetName);
        }
        return null;
    }

    public List<CsdlSchema> getSchemas() {
        return this.csdlSchemaList;
    }

    public CsdlEntityContainer getEntityContainer() {
        return this.csdlEntityContainer;
    }

    public CsdlEntityContainerInfo getEntityContainerInfo(FullQualifiedName entityContainerName) {
        if (entityContainerName == null || this.containerFullQName.equals((Object)entityContainerName)) {
            return this.csdlEntityContainerInfo;
        }
        return null;
    }

    private Map<String, HashSet<String>> generateOneToManyRelationships(Map<String, NavigationTable> navigationProperties) {
        HashMap<String, HashSet<String>> relationship = new HashMap<String, HashSet<String>>();
        for (String tableName : navigationProperties.keySet()) {
            relationship.put(tableName, new HashSet<String>(navigationProperties.get(tableName).getTables()));
        }
        return relationship;
    }

    private Map<String, HashSet<String>> generateManyToOneRelationships(Map<String, NavigationTable> navigationProperties) {
        HashMap<String, HashSet<String>> relationship = new HashMap<String, HashSet<String>>();
        for (String exportedTableName : navigationProperties.keySet()) {
            for (String importedTableName : navigationProperties.get(exportedTableName).getTables()) {
                HashSet<String> tableList = (HashSet<String>)relationship.get(importedTableName);
                if (tableList == null) {
                    tableList = new HashSet<String>();
                    relationship.put(importedTableName, tableList);
                }
                tableList.add(exportedTableName);
            }
        }
        return relationship;
    }
}

