/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.odata;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.data.Link;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.ValueType;
import org.apache.olingo.commons.api.edm.EdmBindingTarget;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmKeyPropertyRef;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.api.edm.provider.CsdlEdmProvider;
import org.apache.olingo.commons.api.edm.provider.CsdlProperty;
import org.apache.olingo.commons.api.edm.provider.CsdlPropertyRef;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ODataServerError;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriInfoResource;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceAction;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.api.uri.UriResourceFunction;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.queryoption.CountOption;
import org.apache.olingo.server.api.uri.queryoption.FilterOption;
import org.apache.olingo.server.api.uri.queryoption.OrderByOption;
import org.apache.olingo.server.api.uri.queryoption.SkipOption;
import org.apache.olingo.server.api.uri.queryoption.SkipTokenOption;
import org.apache.olingo.server.api.uri.queryoption.TopOption;
import org.apache.olingo.server.core.ContentNegotiatorException;
import org.apache.olingo.server.core.ServiceHandler;
import org.apache.olingo.server.core.requests.ActionRequest;
import org.apache.olingo.server.core.requests.DataRequest;
import org.apache.olingo.server.core.requests.FunctionRequest;
import org.apache.olingo.server.core.requests.MediaRequest;
import org.apache.olingo.server.core.requests.MetadataRequest;
import org.apache.olingo.server.core.requests.ServiceDocumentRequest;
import org.apache.olingo.server.core.responses.CountResponse;
import org.apache.olingo.server.core.responses.EntityResponse;
import org.apache.olingo.server.core.responses.EntitySetResponse;
import org.apache.olingo.server.core.responses.MetadataResponse;
import org.apache.olingo.server.core.responses.NoContentResponse;
import org.apache.olingo.server.core.responses.PrimitiveValueResponse;
import org.apache.olingo.server.core.responses.PropertyResponse;
import org.apache.olingo.server.core.responses.ServiceDocumentResponse;
import org.apache.olingo.server.core.responses.ServiceResponse;
import org.apache.olingo.server.core.responses.ServiceResponseVisior;
import org.apache.olingo.server.core.responses.StreamResponse;
import org.apache.olingo.server.core.uri.parser.UriParserException;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.odata.DataColumn;
import org.wso2.carbon.dataservices.core.odata.EDMProvider;
import org.wso2.carbon.dataservices.core.odata.NavigationKeys;
import org.wso2.carbon.dataservices.core.odata.ODataDataHandler;
import org.wso2.carbon.dataservices.core.odata.ODataEntry;
import org.wso2.carbon.dataservices.core.odata.ODataServiceFault;
import org.wso2.carbon.dataservices.core.odata.QueryHandler;

public class ODataAdapter
implements ServiceHandler {
    private static final Log log = LogFactory.getLog(ODataAdapter.class);
    private static final String EMPTY_E_TAG = "*";
    private static final String ODATA_MAX_PAGE_SIZE = "odata.maxpagesize";
    private ServiceMetadata serviceMetadata;
    private final ODataDataHandler dataHandler;
    private CsdlEdmProvider edmProvider;
    private String namespace;
    private ThreadLocal<Boolean> batchRequest = new ThreadLocal<Boolean>(){

        @Override
        protected synchronized Boolean initialValue() {
            return false;
        }
    };

    public ODataAdapter(ODataDataHandler dataHandler, String namespace, String configID) throws ODataServiceFault {
        this.dataHandler = dataHandler;
        this.namespace = namespace;
        this.edmProvider = this.initializeEdmProvider(configID);
    }

    public void init(OData odata, ServiceMetadata serviceMetadata) {
        this.serviceMetadata = serviceMetadata;
    }

    public void readMetadata(MetadataRequest request, MetadataResponse response) throws ODataApplicationException, ODataLibraryException {
        response.writeMetadata();
    }

    public void readServiceDocument(ServiceDocumentRequest request, ServiceDocumentResponse response) throws ODataApplicationException, ODataLibraryException {
        response.writeServiceDocument(request.getODataRequest().getRawBaseUri());
    }

    private EntityDetails process(DataRequest request) throws ODataApplicationException {
        EntityCollection entitySet = null;
        Entity entity = null;
        EntityDetails details = new EntityDetails();
        String baseURL = request.getODataRequest().getRawBaseUri();
        try {
            if (request.isSingleton()) {
                log.error((Object)new ODataServiceFault("Singletons are not supported."));
                throw new ODataApplicationException("Singletons are not supported.", HttpStatusCode.NOT_ACCEPTABLE.getStatusCode(), Locale.ENGLISH);
            }
            EdmEntitySet edmEntitySet = request.getEntitySet();
            EdmEntityType entityType = edmEntitySet.getEntityType();
            List keys = request.getKeyPredicates();
            if (keys != null && !keys.isEmpty()) {
                entity = this.getEntity(entityType, keys, baseURL);
                if (this.getETagMatchedEntity(request.getETag(), this.getIfMatch(request), entity) != null) {
                    details.eTagMatched = true;
                }
            } else {
                entitySet = this.getEntityCollection(edmEntitySet.getName(), baseURL);
            }
            if (!request.getNavigations().isEmpty() && entity != null) {
                for (UriResourceNavigation nav : request.getNavigations()) {
                    if (nav.isCollection()) {
                        entitySet = this.getNavigableEntitySet(this.serviceMetadata, entity, nav, baseURL);
                    } else {
                        Entity parentEntity = entity;
                        entity = this.getNavigableEntity(this.serviceMetadata, parentEntity, nav, baseURL);
                    }
                    entityType = nav.getProperty().getType();
                }
            }
            details.entity = entity;
            details.entitySet = entitySet;
            details.entityType = entityType;
            UriInfo uriInfo = request.getUriInfo();
            EdmEntitySet edmEntitySet2 = this.getEdmEntitySet((UriInfoResource)uriInfo);
            FilterOption filterOption = uriInfo.getFilterOption();
            CountOption countOption = uriInfo.getCountOption();
            OrderByOption orderByOption = uriInfo.getOrderByOption();
            SkipOption skipOption = uriInfo.getSkipOption();
            TopOption topOption = uriInfo.getTopOption();
            SkipTokenOption skipTokenOption = uriInfo.getSkipTokenOption();
            if (filterOption != null) {
                QueryHandler.applyFilterSystemQuery(filterOption, details.entitySet, (EdmBindingTarget)edmEntitySet2);
            }
            if (countOption != null) {
                QueryHandler.applyCountSystemQueryOption(countOption, details.entitySet);
            }
            if (orderByOption != null) {
                QueryHandler.applyOrderByOption(orderByOption, details.entitySet, (EdmBindingTarget)edmEntitySet2);
            }
            if (skipOption != null) {
                QueryHandler.applySkipSystemQueryHandler(skipOption, details.entitySet);
            }
            if (topOption != null) {
                QueryHandler.applyTopSystemQueryOption(topOption, details.entitySet);
            }
            if (skipTokenOption != null) {
                int pageSize = request.getOdata().createPreferences((Collection)request.getODataRequest().getHeaders("Prefer")).getMaxPageSize();
                QueryHandler.applyServerSidePaging(skipTokenOption, details.entitySet, edmEntitySet2, baseURL, pageSize);
            }
            return details;
        }
        catch (ODataServiceFault dataServiceFault) {
            log.error((Object)("Error in processing the read request. : " + dataServiceFault.getMessage()), (Throwable)dataServiceFault);
            throw new ODataApplicationException(dataServiceFault.getMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.ENGLISH);
        }
    }

    private EdmEntitySet getEdmEntitySet(UriInfoResource uriInfo) throws ODataApplicationException {
        EdmEntitySet entitySet;
        List resourcePaths = uriInfo.getUriResourceParts();
        this.blockTypeFilters((UriResource)resourcePaths.get(0));
        if (resourcePaths.get(0) instanceof UriResourceEntitySet) {
            entitySet = ((UriResourceEntitySet)resourcePaths.get(0)).getEntitySet();
        } else if (resourcePaths.get(0) instanceof UriResourceFunction) {
            entitySet = ((UriResourceFunction)resourcePaths.get(0)).getFunctionImport().getReturnedEntitySet();
        } else if (resourcePaths.get(0) instanceof UriResourceAction) {
            entitySet = ((UriResourceAction)resourcePaths.get(0)).getActionImport().getReturnedEntitySet();
        } else {
            throw new ODataApplicationException("Invalid resource type.", HttpStatusCode.NOT_IMPLEMENTED.getStatusCode(), Locale.ROOT);
        }
        int navigationCount = 0;
        while (entitySet != null && ++navigationCount < resourcePaths.size() && resourcePaths.get(navigationCount) instanceof UriResourceNavigation) {
            UriResourceNavigation uriResourceNavigation = (UriResourceNavigation)resourcePaths.get(navigationCount);
            this.blockTypeFilters((UriResource)uriResourceNavigation);
            if (uriResourceNavigation.getProperty().containsTarget()) {
                throw new ODataApplicationException("Containment navigation is not supported.", HttpStatusCode.NOT_IMPLEMENTED.getStatusCode(), Locale.ROOT);
            }
            EdmBindingTarget target = entitySet.getRelatedBindingTarget(uriResourceNavigation.getProperty().getName());
            if (target == null) continue;
            if (target instanceof EdmEntitySet) {
                entitySet = (EdmEntitySet)target;
                continue;
            }
            throw new ODataApplicationException("Singletons are not supported.", HttpStatusCode.NOT_IMPLEMENTED.getStatusCode(), Locale.ROOT);
        }
        return entitySet;
    }

    private void blockTypeFilters(UriResource uriResource) throws ODataApplicationException {
        if (uriResource instanceof UriResourceEntitySet && (((UriResourceEntitySet)uriResource).getTypeFilterOnCollection() != null || ((UriResourceEntitySet)uriResource).getTypeFilterOnEntry() != null) || uriResource instanceof UriResourceFunction && (((UriResourceFunction)uriResource).getTypeFilterOnCollection() != null || ((UriResourceFunction)uriResource).getTypeFilterOnEntry() != null) || uriResource instanceof UriResourceNavigation && (((UriResourceNavigation)uriResource).getTypeFilterOnCollection() != null || ((UriResourceNavigation)uriResource).getTypeFilterOnEntry() != null)) {
            throw new ODataApplicationException("Type filters are not supported.", HttpStatusCode.NOT_IMPLEMENTED.getStatusCode(), Locale.ROOT);
        }
    }

    private boolean getIfMatch(DataRequest request) {
        boolean ifMatch = false;
        if (request.getHeader("If-None-Match") == null) {
            ifMatch = true;
        }
        return ifMatch;
    }

    public <T extends ServiceResponse> void read(final DataRequest request, T response) throws ODataApplicationException, ODataLibraryException {
        final EntityDetails details = this.process(request);
        response.accepts(new ServiceResponseVisior(){

            public void visit(CountResponse response) throws ODataApplicationException, SerializerException {
                response.writeCount(details.entitySet.getCount().intValue());
            }

            public void visit(PrimitiveValueResponse response) throws ODataApplicationException, SerializerException {
                EdmProperty edmProperty = request.getUriResourceProperty().getProperty();
                Property property = details.entity.getProperty(edmProperty.getName());
                response.write(property.getValue());
            }

            public void visit(PropertyResponse response) throws ODataApplicationException, SerializerException {
                EdmProperty edmProperty = request.getUriResourceProperty().getProperty();
                Property property = details.entity.getProperty(edmProperty.getName());
                response.writeProperty(edmProperty.getType(), property);
            }

            public void visit(StreamResponse response) throws ODataApplicationException {
                EdmProperty edmProperty = request.getUriResourceProperty().getProperty();
                Property property = details.entity.getProperty(edmProperty.getName());
                response.writeStreamResponse((InputStream)new ByteArrayInputStream((byte[])property.getValue()), ContentType.APPLICATION_OCTET_STREAM);
            }

            public void visit(EntitySetResponse response) throws ODataApplicationException, SerializerException {
                if (request.getPreference(ODataAdapter.ODATA_MAX_PAGE_SIZE) != null) {
                    response.writeHeader("Preference-Applied", "odata.maxpagesize=" + request.getPreference(ODataAdapter.ODATA_MAX_PAGE_SIZE));
                }
                if (details.entity == null && !request.getNavigations().isEmpty()) {
                    response.writeReadEntitySet(details.entityType, new EntityCollection());
                } else {
                    response.writeReadEntitySet(details.entityType, details.entitySet);
                }
            }

            public void visit(EntityResponse response) throws ODataApplicationException, SerializerException {
                if (details.entity == null) {
                    if (details.eTagMatched) {
                        response.writeNoContent(true);
                    } else {
                        response.writeNotFound(true);
                    }
                } else if (details.eTagMatched) {
                    response.writeReadEntity(details.entityType, details.entity);
                } else {
                    response.getODataResponse().setStatusCode(HttpStatusCode.PRECONDITION_FAILED.getStatusCode());
                }
            }
        });
    }

    public void createEntity(DataRequest request, Entity entity, EntityResponse response) throws ODataApplicationException {
        EdmEntitySet edmEntitySet = request.getEntitySet();
        String baseURL = request.getODataRequest().getRawBaseUri();
        try {
            entity.setId(new URI(EntityResponse.buildLocation((String)baseURL, (Entity)entity, (String)edmEntitySet.getName(), (EdmEntityType)edmEntitySet.getEntityType())));
            Entity created = this.createEntityInTable(edmEntitySet.getEntityType(), entity);
            response.writeCreatedEntity(edmEntitySet, created);
        }
        catch (URISyntaxException | SerializerException | ODataServiceFault e) {
            response.writeNotModified();
            log.error((Object)("Error occurred while creating entity. :" + e.getMessage()), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEntity(DataRequest request, Entity changes, boolean merge, String eTag, EntityResponse response) throws ODataApplicationException {
        List keys = request.getKeyPredicates();
        EdmEntityType entityType = request.getEntitySet().getEntityType();
        String baseUrl = request.getODataRequest().getRawBaseUri();
        try {
            if (EMPTY_E_TAG.equals(eTag)) {
                this.updateEntity(entityType, changes, keys, merge);
                response.writeUpdatedEntity();
            } else {
                this.initializeTransactionalConnection();
                Entity entity = this.getEntity(request.getEntitySet().getEntityType(), keys, baseUrl);
                if (entity == null) {
                    response.writeNotFound(true);
                    if (log.isDebugEnabled()) {
                        StringBuilder message = new StringBuilder();
                        message.append("Entity couldn't find , For ");
                        for (UriParameter parameter : keys) {
                            message.append(parameter.getName()).append(" = ").append(parameter.getText()).append(" ,");
                        }
                        message.append(".");
                        log.debug((Object)message);
                    }
                } else {
                    entity = this.getETagMatchedEntity(eTag, this.getIfMatch(request), entity);
                    if (entity != null) {
                        boolean result = this.updateEntityWithETagMatched(entityType, changes, entity, merge);
                        if (result) {
                            response.writeUpdatedEntity();
                        } else {
                            response.writeNotModified();
                        }
                    } else {
                        response.writeError(new ODataServerError().setStatusCode(HttpStatusCode.PRECONDITION_FAILED.getStatusCode()).setMessage("E-Tag checksum didn't match."));
                    }
                }
            }
        }
        catch (DataServiceFault e) {
            response.writeNotModified();
            log.error((Object)("Error occurred while updating entity. :" + e.getMessage()), (Throwable)e);
        }
        finally {
            if (!EMPTY_E_TAG.equals(eTag)) {
                try {
                    this.finalizeTransactionalConnection();
                }
                catch (DataServiceFault e) {
                    response.writeNotModified();
                    log.error((Object)("Error occurred while updating entity. :" + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    public void upsertEntity(DataRequest request, Entity entity, boolean merge, String entityETag, EntityResponse response) throws ODataLibraryException, ODataApplicationException {
        EdmEntitySet edmEntitySet = request.getEntitySet();
        String baseUrl = request.getODataRequest().getRawBaseUri();
        try {
            Entity currentEntity = this.getEntity(edmEntitySet.getEntityType(), request.getKeyPredicates(), baseUrl);
            if (currentEntity == null) {
                this.createEntity(request, entity, response);
            } else {
                this.updateEntity(request, entity, merge, entityETag, response);
            }
        }
        catch (ODataServiceFault e) {
            response.writeNotModified();
            log.error((Object)("Error occurred while upserting entity. :" + e.getMessage()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteEntity(DataRequest request, String eTag, EntityResponse response) throws ODataApplicationException {
        List keys = request.getKeyPredicates();
        EdmEntityType entityType = request.getEntitySet().getEntityType();
        String baseUrl = request.getODataRequest().getRawBaseUri();
        try {
            boolean result;
            ODataEntry deleteEntity = this.wrapKeyParamToDataEntry(keys);
            if (!EMPTY_E_TAG.equals(eTag)) {
                this.initializeTransactionalConnection();
                Entity entity = this.getEntity(request.getEntitySet().getEntityType(), keys, baseUrl);
                if (entity == null) {
                    response.writeNotFound(true);
                    if (log.isDebugEnabled()) {
                        StringBuilder message = new StringBuilder();
                        message.append("Entity couldn't find , For ");
                        for (UriParameter parameter : keys) {
                            message.append(parameter.getName()).append(" = ").append(parameter.getText()).append(" ,");
                        }
                        message.append(".");
                        log.debug((Object)message);
                    }
                    return;
                }
                entity = this.getETagMatchedEntity(eTag, this.getIfMatch(request), entity);
                if (entity == null) {
                    response.writeError(new ODataServerError().setStatusCode(HttpStatusCode.PRECONDITION_FAILED.getStatusCode()).setMessage("E-Tag checksum didn't match."));
                    return;
                }
                deleteEntity = this.wrapEntityToDataEntry(entityType, entity);
            }
            if (result = this.dataHandler.deleteEntityInTable(entityType.getName(), deleteEntity)) {
                response.writeDeletedEntityOrReference();
            } else if (!EMPTY_E_TAG.equals(eTag)) {
                response.writeNotModified();
            } else {
                response.writeNotFound(true);
            }
        }
        catch (DataServiceFault e) {
            response.writeNotModified();
            log.error((Object)("Error occurred while deleting entity. :" + e.getMessage()), (Throwable)e);
        }
        finally {
            if (!EMPTY_E_TAG.equals(eTag)) {
                try {
                    this.finalizeTransactionalConnection();
                }
                catch (DataServiceFault e) {
                    response.writeNotModified();
                    log.error((Object)("Error occurred while deleting entity. :" + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateProperty(DataRequest request, Property property, boolean merge, String entityETag, PropertyResponse response) throws ODataApplicationException, ContentNegotiatorException {
        if (!property.isComplex()) {
            EdmEntityType entityType = request.getEntitySet().getEntityType();
            String baseUrl = request.getODataRequest().getRawBaseUri();
            List keys = request.getKeyPredicates();
            ODataEntry entry = new ODataEntry();
            for (UriParameter key : keys) {
                String value = key.getText();
                if (value.startsWith("'") && value.endsWith("'")) {
                    value = value.substring(1, value.length() - 1);
                }
                entry.addValue(key.getName(), value);
            }
            entry.addValue(property.getName(), this.readPrimitiveValueInString(entityType.getStructuralProperty(property.getName()), property.getValue()));
            try {
                if (EMPTY_E_TAG.equals(entityETag)) {
                    this.dataHandler.updateEntityInTable(entityType.getName(), entry);
                    if (property.getValue() == null) {
                        response.writePropertyDeleted();
                        return;
                    }
                    response.writePropertyUpdated();
                    return;
                }
                this.initializeTransactionalConnection();
                Entity entity = this.getEntity(request.getEntitySet().getEntityType(), keys, baseUrl);
                if (entity == null) {
                    response.writeNotFound(true);
                    if (!log.isDebugEnabled()) return;
                    StringBuilder message = new StringBuilder();
                    message.append("Entity couldn't find , For ");
                    for (UriParameter parameter : keys) {
                        message.append(parameter.getName()).append(" = ").append(parameter.getText()).append(" ,");
                    }
                    message.append(".");
                    log.debug((Object)message);
                    return;
                }
                entity = this.getETagMatchedEntity(entityETag, this.getIfMatch(request), entity);
                if (entity != null) {
                    this.dataHandler.updateEntityInTableTransactional(entityType.getName(), this.wrapEntityToDataEntry(entityType, entity), entry);
                    if (property.getValue() == null) {
                        response.writePropertyDeleted();
                        return;
                    }
                    response.writePropertyUpdated();
                    return;
                }
                response.writeError(new ODataServerError().setStatusCode(HttpStatusCode.PRECONDITION_FAILED.getStatusCode()).setMessage("E-Tag checksum didn't match."));
                return;
            }
            catch (DataServiceFault e) {
                response.writeNotModified();
                log.error((Object)("Error occurred while updating property. :" + e.getMessage()), (Throwable)e);
                return;
            }
            finally {
                if (!EMPTY_E_TAG.equals(entityETag)) {
                    try {
                        this.finalizeTransactionalConnection();
                    }
                    catch (DataServiceFault e) {
                        response.writeNotModified();
                        log.error((Object)("Error occurred while updating property. :" + e.getMessage()), (Throwable)e);
                    }
                }
            }
        }
        response.writeNotModified();
        if (!log.isDebugEnabled()) return;
        log.debug((Object)"Only Primitive type properties are allowed to update.");
    }

    public <T extends ServiceResponse> void invoke(FunctionRequest request, HttpMethod method, T response) throws ODataApplicationException {
        response.getODataResponse().setStatusCode(HttpStatusCode.NOT_IMPLEMENTED.getStatusCode());
    }

    public <T extends ServiceResponse> void invoke(ActionRequest request, String eTag, T response) throws ODataApplicationException {
        response.getODataResponse().setStatusCode(HttpStatusCode.NOT_IMPLEMENTED.getStatusCode());
    }

    public void readMediaStream(MediaRequest request, StreamResponse response) throws ODataApplicationException, ContentNegotiatorException {
        response.getODataResponse().setStatusCode(HttpStatusCode.NOT_IMPLEMENTED.getStatusCode());
    }

    public void upsertMediaStream(MediaRequest request, String entityETag, InputStream mediaContent, NoContentResponse response) throws ODataApplicationException {
        response.writeNotImplemented();
    }

    public void upsertStreamProperty(DataRequest request, String entityETag, InputStream streamContent, NoContentResponse response) throws ODataApplicationException {
        EdmEntitySet edmEntitySet = request.getEntitySet();
        List keys = request.getKeyPredicates();
        EdmProperty property = request.getUriResourceProperty().getProperty();
        this.modifyStreamProperties(request.getODataRequest(), entityETag, streamContent, response, edmEntitySet, keys, property);
    }

    private void modifyStreamProperties(ODataRequest request, String entityETag, InputStream streamContent, NoContentResponse response, EdmEntitySet edmEntitySet, List<UriParameter> keys, EdmProperty property) throws ODataApplicationException {
        String baseUrl = request.getRawBaseUri();
        EdmEntityType entityType = edmEntitySet.getEntityType();
        String tableName = entityType.getName();
        try {
            ODataEntry entry = new ODataEntry();
            for (UriParameter key : keys) {
                entry.addValue(key.getName(), key.getText());
            }
            if (streamContent == null) {
                entry.addValue(property.getName(), null);
                boolean deleted = false;
                if (EMPTY_E_TAG.equals(entityETag)) {
                    deleted = this.dataHandler.updateEntityInTable(tableName, entry);
                } else {
                    Entity entity = this.getEntity(edmEntitySet.getEntityType(), keys, baseUrl);
                    if (entity != null) {
                        if (entityETag.equals(entity.getETag())) {
                            deleted = this.dataHandler.updateEntityInTableTransactional(tableName, this.wrapEntityToDataEntry(entityType, entity), entry);
                        } else {
                            response.writePreConditionFailed();
                        }
                    }
                }
                if (deleted) {
                    response.writeNoContent();
                } else {
                    response.writeNotFound();
                }
            } else {
                byte[] bytes = IOUtils.toByteArray((InputStream)streamContent);
                entry.addValue(property.getName(), this.getBase64StringFromBytes(bytes));
                boolean updated = false;
                if (EMPTY_E_TAG.equals(entityETag)) {
                    updated = this.dataHandler.updateEntityInTable(tableName, entry);
                } else {
                    Entity entity = this.getEntity(edmEntitySet.getEntityType(), keys, baseUrl);
                    if (entity != null) {
                        if (entityETag.equals(entity.getETag())) {
                            updated = this.dataHandler.updateEntityInTableTransactional(tableName, this.wrapEntityToDataEntry(entityType, entity), entry);
                        } else {
                            response.writePreConditionFailed();
                        }
                    }
                }
                if (updated) {
                    response.writeNoContent();
                } else {
                    response.writeServerError(true);
                }
            }
        }
        catch (IOException | ODataServiceFault e) {
            response.writeNotModified();
            log.error((Object)("Error occurred while upserting the property. :" + e.getMessage()), (Throwable)e);
        }
    }

    public void addReference(DataRequest request, String entityETag, URI referenceId, NoContentResponse response) throws ODataApplicationException {
        this.updateReference(request, entityETag, referenceId, response);
    }

    private ODataEntry getKeyPredicatesFromReference(String referenceID, String navigation) throws ODataServiceFault {
        if (!referenceID.substring(referenceID.lastIndexOf(47), referenceID.length()).contains(navigation)) {
            throw new ODataServiceFault("Reference is not compatible.");
        }
        int fIndex = referenceID.lastIndexOf(40);
        int lIndex = referenceID.lastIndexOf(41);
        String resource = referenceID.substring(fIndex + 1, lIndex);
        ODataEntry foreignKeys = new ODataEntry();
        if (resource.contains(",")) {
            String[] params;
            for (String param : params = resource.split(",")) {
                String[] keyValues = param.split("=");
                if (keyValues[1].startsWith("'") && keyValues[1].endsWith("'")) {
                    keyValues[1] = keyValues[1].substring(1, keyValues[1].length() - 1);
                }
                foreignKeys.addValue(keyValues[0], keyValues[1]);
            }
        } else if (this.dataHandler.getPrimaryKeys().get(navigation).size() == 1) {
            if (resource.startsWith("'") && resource.endsWith("'")) {
                resource = resource.substring(1, resource.length() - 1);
            }
            foreignKeys.addValue(this.dataHandler.getPrimaryKeys().get(navigation).get(0), resource);
        } else {
            throw new ODataServiceFault("Wrong number of key properties in reference id.");
        }
        return foreignKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateReference(DataRequest request, String entityETag, URI updateId, NoContentResponse response) throws ODataApplicationException {
        String rootTable = request.getEntitySet().getName();
        String baseUrl = request.getODataRequest().getRawBaseUri();
        List rootKeys = request.getUriResourceEntitySet().getKeyPredicates();
        String navigationTable = ((UriResourceNavigation)request.getNavigations().getFirst()).getProperty().getName();
        String referenceID = updateId.getPath();
        try {
            ODataEntry navigationKeys = this.getKeyPredicatesFromReference(referenceID, navigationTable);
            if (!EMPTY_E_TAG.equals(entityETag)) {
                this.initializeTransactionalConnection();
                Entity entity = this.getEntity(request.getEntitySet().getEntityType(), rootKeys, baseUrl);
                if (entity == null) {
                    response.writeNotFound();
                    if (log.isDebugEnabled()) {
                        StringBuilder message = new StringBuilder();
                        message.append("Entity couldn't find , For ");
                        for (UriParameter parameter : rootKeys) {
                            message.append(parameter.getName()).append(" = ").append(parameter.getText()).append(" ,");
                        }
                        message.append(".");
                        log.debug((Object)message);
                    }
                    return;
                }
                entity = this.getETagMatchedEntity(entityETag, this.getIfMatch(request), entity);
                if (entity == null) {
                    response.writePreConditionFailed();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Entity didn't match for the E-Tag checksum. " + entityETag));
                    }
                    return;
                }
            }
            this.dataHandler.updateReference(rootTable, this.wrapKeyParamToDataEntry(rootKeys), navigationTable, navigationKeys);
            response.writeNoContent();
        }
        catch (ODataServiceFault e) {
            response.writeNotModified();
            log.error((Object)("Error occurred while updating the reference. :" + e.getMessage()), (Throwable)e);
        }
        finally {
            if (!EMPTY_E_TAG.equals(entityETag)) {
                try {
                    this.finalizeTransactionalConnection();
                }
                catch (ODataServiceFault e) {
                    response.writeNotModified();
                    log.error((Object)("Error occurred while updating the reference. :" + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteReference(DataRequest request, URI deleteId, String entityETag, NoContentResponse response) throws ODataApplicationException, UriParserException {
        String rootTable = request.getEntitySet().getName();
        List rootKeys = request.getUriResourceEntitySet().getKeyPredicates();
        String baseUrl = request.getODataRequest().getRawBaseUri();
        String navigationTable = ((UriResourceNavigation)request.getNavigations().getFirst()).getProperty().getName();
        try {
            ODataEntry navigationKeys;
            if (deleteId == null) {
                navigationKeys = null;
            } else {
                String referenceID = deleteId.getPath();
                navigationKeys = this.getKeyPredicatesFromReference(referenceID, navigationTable);
            }
            if (!EMPTY_E_TAG.equals(entityETag)) {
                this.initializeTransactionalConnection();
                Entity entity = this.getEntity(request.getEntitySet().getEntityType(), rootKeys, baseUrl);
                if (entity == null) {
                    response.writeNotFound();
                    if (log.isDebugEnabled()) {
                        StringBuilder message = new StringBuilder();
                        message.append("Entity couldn't find , For ");
                        for (UriParameter parameter : rootKeys) {
                            message.append(parameter.getName()).append(" = ").append(parameter.getText()).append(" ,");
                        }
                        message.append(".");
                        log.debug((Object)message);
                    }
                    return;
                }
                entity = this.getETagMatchedEntity(entityETag, this.getIfMatch(request), entity);
                if (entity == null) {
                    response.writePreConditionFailed();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Entity didn't match for the E-Tag checksum. " + entityETag));
                    }
                    return;
                }
            }
            this.dataHandler.deleteReference(rootTable, this.wrapKeyParamToDataEntry(rootKeys), navigationTable, navigationKeys);
            response.writeNoContent();
        }
        catch (ODataServiceFault e) {
            response.writeNotModified();
            log.error((Object)("Error occurred while deleting the reference. :" + e.getMessage()), (Throwable)e);
        }
        finally {
            if (!EMPTY_E_TAG.equals(entityETag)) {
                try {
                    this.finalizeTransactionalConnection();
                }
                catch (ODataServiceFault e) {
                    response.writeNotModified();
                    log.error((Object)("Error occurred while deleting the reference. :" + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    public void anyUnsupported(ODataRequest request, ODataResponse response) throws ODataApplicationException {
        response.setStatusCode(HttpStatusCode.NOT_IMPLEMENTED.getStatusCode());
    }

    public String startTransaction() {
        try {
            this.dataHandler.openTransaction();
            this.batchRequest.set(true);
        }
        catch (ODataServiceFault e) {
            log.error((Object)("Error occurred while starting the transaction. :" + e.getMessage()), (Throwable)e);
            throw new RuntimeException(e);
        }
        return "1";
    }

    public void commit(String txnId) {
        try {
            this.dataHandler.commitTransaction();
            this.batchRequest.set(false);
        }
        catch (ODataServiceFault e) {
            log.error((Object)("Error occurred while committing the transaction. :" + e.getMessage()), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void rollback(String txnId) {
        try {
            this.dataHandler.rollbackTransaction();
            this.batchRequest.set(false);
        }
        catch (ODataServiceFault e) {
            log.error((Object)("Error occurred while rollbacking the transaction. :" + e.getMessage()), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void crossJoin(DataRequest dataRequest, List<String> entitySetNames, ODataResponse response) {
        response.setStatusCode(HttpStatusCode.NOT_IMPLEMENTED.getStatusCode());
    }

    private EntityCollection createEntityCollectionFromDataEntryList(String tableName, List<ODataEntry> entries, String baseURL) throws ODataServiceFault {
        try {
            EntityCollection entitySet = new EntityCollection();
            int count = 0;
            for (ODataEntry entry : entries) {
                Entity entity = new Entity();
                for (DataColumn column : this.dataHandler.getTableMetadata().get(tableName).values()) {
                    String columnName = column.getColumnName();
                    entity.addProperty(this.createPrimitive(column.getColumnType(), columnName, entry.getValue(columnName)));
                }
                EdmEntityType entityType = this.serviceMetadata.getEdm().getEntityType(new FullQualifiedName(this.namespace, tableName));
                entity.setId(new URI(EntityResponse.buildLocation((String)baseURL, (Entity)entity, (String)entityType.getName(), (EdmEntityType)entityType)));
                entity.setETag(entry.getValue("ETag"));
                entity.setType(new FullQualifiedName(this.namespace, tableName).getFullQualifiedNameAsString());
                entitySet.getEntities().add(entity);
                ++count;
            }
            entitySet.setCount(Integer.valueOf(count));
            return entitySet;
        }
        catch (URISyntaxException e) {
            throw new ODataServiceFault(e, "Error occurred when creating id for the entity. :" + e.getMessage());
        }
        catch (ParseException e) {
            throw new ODataServiceFault(e, "Error occurred when creating a property for the entity. :" + e.getMessage());
        }
    }

    private Entity createEntityInTable(EdmEntityType entityType, Entity entity) throws ODataServiceFault {
        try {
            if (!entity.getNavigationBindings().isEmpty()) {
                this.initializeTransactionalConnection();
            }
            String rootTable = entityType.getName();
            String eTag = this.dataHandler.insertEntityToTable(rootTable, this.wrapEntityToDataEntry(entityType, entity));
            if (!entity.getNavigationBindings().isEmpty()) {
                ODataEntry rootKeys = this.getKeyPredicatesFromReference(entity.getId().toASCIIString(), rootTable);
                for (Link reference : entity.getNavigationBindings()) {
                    String navigationTable = reference.getTitle();
                    if (reference.getBindingLinks().isEmpty()) {
                        ODataEntry navigationKeys = this.getKeyPredicatesFromReference(reference.getBindingLink(), navigationTable);
                        this.dataHandler.updateReference(rootTable, rootKeys, navigationTable, navigationKeys);
                        continue;
                    }
                    for (String urlId : reference.getBindingLinks()) {
                        ODataEntry navigationKeys = this.getKeyPredicatesFromReference(urlId, navigationTable);
                        this.dataHandler.updateReference(rootTable, rootKeys, navigationTable, navigationKeys);
                    }
                }
            }
            entity.setETag(eTag);
            Entity entity2 = entity;
            return entity2;
        }
        catch (ODataApplicationException | ODataServiceFault e) {
            throw new ODataServiceFault(e.getMessage());
        }
        finally {
            if (!entity.getNavigationBindings().isEmpty()) {
                this.finalizeTransactionalConnection();
            }
        }
    }

    private ODataEntry wrapEntityToDataEntry(EdmEntityType entityType, Entity entity) throws ODataApplicationException {
        ODataEntry entry = new ODataEntry();
        for (Property property : entity.getProperties()) {
            EdmProperty propertyType = (EdmProperty)entityType.getProperty(property.getName());
            entry.addValue(property.getName(), this.readPrimitiveValueInString(propertyType, property.getValue()));
        }
        return entry;
    }

    private ODataEntry wrapPropertiesToDataEntry(EdmEntityType entityType, List<Property> properties, Map<String, EdmProperty> propertyTypes) throws ODataApplicationException {
        ODataEntry entry = new ODataEntry();
        for (Property property : properties) {
            EdmProperty propertyType = propertyTypes.get(property.getName());
            entry.addValue(property.getName(), this.readPrimitiveValueInString(propertyType, property.getValue()));
        }
        return entry;
    }

    private ODataEntry wrapKeyParamToDataEntry(List<UriParameter> keys) {
        ODataEntry entry = new ODataEntry();
        for (UriParameter key : keys) {
            String value = key.getText();
            if (value.startsWith("'") && value.endsWith("'")) {
                value = value.substring(1, value.length() - 1);
            }
            entry.addValue(key.getName(), value);
        }
        return entry;
    }

    public CsdlEdmProvider getEdmProvider() {
        return this.edmProvider;
    }

    private byte[] getBytesFromBase64String(String base64Str) throws ODataServiceFault {
        try {
            return Base64.decodeBase64((byte[])base64Str.getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw new ODataServiceFault(e.getMessage());
        }
    }

    private String getBase64StringFromBytes(byte[] data) throws ODataServiceFault {
        byte[] base64Data = Base64.encodeBase64((byte[])data);
        try {
            return new String(base64Data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ODataServiceFault(e, "Error in encoding result binary data: " + e.getMessage());
        }
    }

    private boolean updateEntityWithETagMatched(EdmEntityType edmEntityType, Entity entity, Entity existingEntity, boolean merge) throws ODataApplicationException, DataServiceFault {
        List oldProperties = existingEntity.getProperties();
        ODataEntry newProperties = new ODataEntry();
        HashMap<String, EdmProperty> propertyMap = new HashMap<String, EdmProperty>();
        for (String property : edmEntityType.getPropertyNames()) {
            Property updateProperty = entity.getProperty(property);
            EdmProperty propertyType = (EdmProperty)edmEntityType.getProperty(property);
            if (this.isKey(edmEntityType, property)) {
                propertyMap.put(property, (EdmProperty)edmEntityType.getProperty(property));
                continue;
            }
            if (updateProperty == null) {
                if (merge) {
                    propertyMap.put(property, (EdmProperty)edmEntityType.getProperty(property));
                    continue;
                }
                propertyMap.put(property, (EdmProperty)edmEntityType.getProperty(property));
                newProperties.addValue(property, null);
                continue;
            }
            propertyMap.put(property, (EdmProperty)edmEntityType.getProperty(property));
            newProperties.addValue(property, this.readPrimitiveValueInString(propertyType, updateProperty.getValue()));
        }
        return this.dataHandler.updateEntityInTableTransactional(edmEntityType.getName(), this.wrapPropertiesToDataEntry(edmEntityType, oldProperties, propertyMap), newProperties);
    }

    private boolean isKey(EdmEntityType edmEntityType, String propertyName) {
        List keyPropertyRefs = edmEntityType.getKeyPropertyRefs();
        for (EdmKeyPropertyRef propRef : keyPropertyRefs) {
            if (!propRef.getName().equals(propertyName)) continue;
            return true;
        }
        return false;
    }

    private EntityCollection getEntityCollection(String tableName, String baseUrl) throws ODataServiceFault {
        return this.createEntityCollectionFromDataEntryList(tableName, this.dataHandler.readTable(tableName), baseUrl);
    }

    private List<Entity> getMatch(EdmEntityType entityType, UriParameter param, List<Entity> entityList) throws ODataApplicationException, ODataServiceFault {
        ArrayList<Entity> list = new ArrayList<Entity>();
        for (Entity entity : entityList) {
            EdmProperty property = (EdmProperty)entityType.getProperty(param.getName());
            EdmType type = property.getType();
            if (type.getKind() == EdmTypeKind.PRIMITIVE) {
                Object match = this.readPrimitiveValue(property, param.getText());
                Property entityValue = entity.getProperty(param.getName());
                if (match != null) {
                    if (!match.equals(entityValue.asPrimitive())) continue;
                    list.add(entity);
                    continue;
                }
                if (null != entityValue.asPrimitive()) continue;
                list.add(entity);
                continue;
            }
            throw new ODataServiceFault("Complex elements are not supported, couldn't compare complex objects.");
        }
        return list;
    }

    private Object readPrimitiveValue(EdmProperty edmProperty, String value) throws ODataApplicationException {
        if (value == null) {
            return null;
        }
        try {
            if (value.startsWith("'") && value.endsWith("'")) {
                value = value.substring(1, value.length() - 1);
            }
            EdmPrimitiveType edmPrimitiveType = (EdmPrimitiveType)edmProperty.getType();
            Class<?> javaClass = this.getJavaClassForPrimitiveType(edmProperty, edmPrimitiveType);
            return edmPrimitiveType.valueOfString(value, Boolean.valueOf(edmProperty.isNullable()), edmProperty.getMaxLength(), edmProperty.getPrecision(), edmProperty.getScale(), Boolean.valueOf(edmProperty.isUnicode()), javaClass);
        }
        catch (EdmPrimitiveTypeException e) {
            throw new ODataApplicationException("Invalid value: " + value + " for property: " + edmProperty.getName(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.getDefault());
        }
    }

    private String readPrimitiveValueInString(EdmProperty edmProperty, Object value) throws ODataApplicationException {
        if (value == null) {
            return null;
        }
        try {
            EdmPrimitiveType edmPrimitiveType = (EdmPrimitiveType)edmProperty.getType();
            return edmPrimitiveType.valueToString(value, Boolean.valueOf(edmProperty.isNullable()), edmProperty.getMaxLength(), edmProperty.getPrecision(), edmProperty.getScale(), Boolean.valueOf(edmProperty.isUnicode()));
        }
        catch (EdmPrimitiveTypeException e) {
            throw new ODataApplicationException("Invalid value: " + value + " for property: " + edmProperty.getName(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.getDefault());
        }
    }

    private Class<?> getJavaClassForPrimitiveType(EdmProperty edmProperty, EdmPrimitiveType edmPrimitiveType) {
        Class javaClass = edmProperty.getMapping() != null && edmProperty.getMapping().getMappedJavaClass() != null ? edmProperty.getMapping().getMappedJavaClass() : edmPrimitiveType.getDefaultType();
        edmPrimitiveType.getDefaultType();
        return javaClass;
    }

    private Entity getEntity(EdmEntityType entityType, List<UriParameter> keys, String baseUrl) throws ODataApplicationException, ODataServiceFault {
        EntityCollection entityCollection = this.createEntityCollectionFromDataEntryList(entityType.getName(), this.dataHandler.readTableWithKeys(entityType.getName(), this.wrapKeyParamToDataEntry(keys)), baseUrl);
        return this.getEntity(entityType, entityCollection, keys);
    }

    private Entity getEntity(EdmEntityType entityType, EntityCollection entityCollection, List<UriParameter> keys) throws ODataApplicationException, ODataServiceFault {
        List<Entity> search = null;
        if (entityCollection.getEntities().isEmpty()) {
            if (log.isDebugEnabled()) {
                StringBuilder message = new StringBuilder();
                message.append("Entity collection was null , For ");
                for (UriParameter parameter : keys) {
                    message.append(parameter.getName()).append(" = ").append(parameter.getText()).append(" ,");
                }
                message.append(".");
                log.debug((Object)message);
            }
            return null;
        }
        for (UriParameter param : keys) {
            search = this.getMatch(entityType, param, entityCollection.getEntities());
        }
        if (search == null) {
            return null;
        }
        return (Entity)search.get(0);
    }

    private Entity getETagMatchedEntity(String eTag, boolean ifMatch, Entity entity) {
        Entity finalEntity = null;
        if (entity != null) {
            if ((entity.getETag().equals(eTag) || EMPTY_E_TAG.equals(eTag)) && ifMatch) {
                finalEntity = entity;
            } else if (!entity.getETag().equals(eTag) && !ifMatch) {
                finalEntity = entity;
            }
        }
        if (finalEntity == null && entity != null && !EMPTY_E_TAG.equals(eTag) && log.isDebugEnabled()) {
            log.debug((Object)"E-Tag doesn't matched with existing entity.");
        }
        return finalEntity;
    }

    private EntityCollection getNavigableEntitySet(ServiceMetadata metadata, Entity parentEntity, UriResourceNavigation navigation, String url) throws ODataServiceFault, ODataApplicationException {
        EdmEntityType type = metadata.getEdm().getEntityType(new FullQualifiedName(parentEntity.getType()));
        String linkName = navigation.getProperty().getName();
        ArrayList<Property> properties = new ArrayList<Property>();
        HashMap<String, EdmProperty> propertyMap = new HashMap<String, EdmProperty>();
        for (NavigationKeys keys : this.dataHandler.getNavigationProperties().get(type.getName()).getNavigationKeys(linkName)) {
            if (parentEntity.getProperty(keys.getPrimaryKey()) == null) continue;
            Property property = parentEntity.getProperty(keys.getPrimaryKey());
            propertyMap.put(keys.getForeignKey(), (EdmProperty)type.getProperty(property.getName()));
            property.setName(keys.getForeignKey());
            properties.add(property);
        }
        EntityCollection results = this.createEntityCollectionFromDataEntryList(linkName, this.dataHandler.readTableWithKeys(linkName, this.wrapPropertiesToDataEntry(type, properties, propertyMap)), url);
        return results;
    }

    private Entity getNavigableEntity(ServiceMetadata metadata, Entity parentEntity, UriResourceNavigation navigation, String baseUrl) throws ODataApplicationException, ODataServiceFault {
        EdmEntityType type = metadata.getEdm().getEntityType(new FullQualifiedName(parentEntity.getType()));
        String linkName = navigation.getProperty().getName();
        ArrayList<Property> properties = new ArrayList<Property>();
        HashMap<String, EdmProperty> propertyMap = new HashMap<String, EdmProperty>();
        for (NavigationKeys keys : this.dataHandler.getNavigationProperties().get(linkName).getNavigationKeys(type.getName())) {
            if (parentEntity.getProperty(keys.getForeignKey()) == null) continue;
            Property property = parentEntity.getProperty(keys.getForeignKey());
            propertyMap.put(keys.getPrimaryKey(), (EdmProperty)type.getProperty(property.getName()));
            property.setName(keys.getPrimaryKey());
            properties.add(property);
        }
        EntityCollection results = this.createEntityCollectionFromDataEntryList(linkName, this.dataHandler.readTableWithKeys(linkName, this.wrapPropertiesToDataEntry(type, properties, propertyMap)), baseUrl);
        if (!results.getEntities().isEmpty()) {
            return (Entity)results.getEntities().get(0);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Reference is not found.");
        }
        return null;
    }

    private Map<String, List<CsdlPropertyRef>> getKeysCsdlMap() throws ODataServiceFault {
        HashMap<String, List<CsdlPropertyRef>> keyMap = new HashMap<String, List<CsdlPropertyRef>>();
        for (String tableName : this.dataHandler.getTableList()) {
            ArrayList<CsdlPropertyRef> propertyList = new ArrayList<CsdlPropertyRef>();
            for (String element : this.dataHandler.getPrimaryKeys().get(tableName)) {
                propertyList.add(new CsdlPropertyRef().setName(element));
            }
            keyMap.put(tableName, propertyList);
        }
        return keyMap;
    }

    private List<CsdlProperty> getProperties(String tableName) {
        ArrayList<CsdlProperty> properties = new ArrayList<CsdlProperty>();
        for (DataColumn column : this.dataHandler.getTableMetadata().get(tableName).values()) {
            CsdlProperty property = new CsdlProperty();
            property.setName(column.getColumnName());
            DataColumn.ODataDataType columnType = column.getColumnType();
            switch (columnType) {
                case INT32: {
                    property.setType(EdmPrimitiveTypeKind.Int32.getFullQualifiedName());
                    property.setNullable(column.isNullable());
                    property.setMaxLength(Integer.valueOf(column.getMaxLength()));
                    break;
                }
                case INT16: {
                    property.setType(EdmPrimitiveTypeKind.Int16.getFullQualifiedName());
                    property.setNullable(column.isNullable());
                    property.setMaxLength(Integer.valueOf(column.getMaxLength()));
                    break;
                }
                case DOUBLE: {
                    property.setType(EdmPrimitiveTypeKind.Double.getFullQualifiedName());
                    property.setPrecision(Integer.valueOf(column.getPrecision()));
                    property.setScale(Integer.valueOf(column.getScale()));
                    property.setNullable(column.isNullable());
                    break;
                }
                case STRING: {
                    property.setType(EdmPrimitiveTypeKind.String.getFullQualifiedName());
                    property.setMaxLength(Integer.valueOf(column.getMaxLength()));
                    property.setNullable(column.isNullable());
                    break;
                }
                case BOOLEAN: {
                    property.setType(EdmPrimitiveTypeKind.Boolean.getFullQualifiedName());
                    property.setNullable(column.isNullable());
                    property.setMaxLength(Integer.valueOf(column.getMaxLength()));
                    break;
                }
                case BINARY: {
                    property.setType(EdmPrimitiveTypeKind.Binary.getFullQualifiedName());
                    property.setNullable(column.isNullable());
                    property.setMaxLength(Integer.valueOf(column.getMaxLength()));
                    break;
                }
                case BYTE: {
                    property.setType(EdmPrimitiveTypeKind.Byte.getFullQualifiedName());
                    property.setNullable(column.isNullable());
                    property.setMaxLength(Integer.valueOf(column.getMaxLength()));
                    break;
                }
                case SBYTE: {
                    property.setType(EdmPrimitiveTypeKind.SByte.getFullQualifiedName());
                    property.setNullable(column.isNullable());
                    property.setMaxLength(Integer.valueOf(column.getMaxLength()));
                    break;
                }
                case DATE: {
                    property.setType(EdmPrimitiveTypeKind.Date.getFullQualifiedName());
                    property.setNullable(column.isNullable());
                    property.setMaxLength(Integer.valueOf(column.getMaxLength()));
                    break;
                }
                case DURATION: {
                    property.setType(EdmPrimitiveTypeKind.Duration.getFullQualifiedName());
                    property.setNullable(column.isNullable());
                    property.setMaxLength(Integer.valueOf(column.getMaxLength()));
                    break;
                }
                case DECIMAL: {
                    property.setType(EdmPrimitiveTypeKind.Decimal.getFullQualifiedName());
                    property.setPrecision(Integer.valueOf(column.getPrecision()));
                    property.setScale(Integer.valueOf(column.getScale()));
                    property.setNullable(column.isNullable());
                    property.setMaxLength(Integer.valueOf(column.getMaxLength()));
                    break;
                }
                case SINGLE: {
                    property.setType(EdmPrimitiveTypeKind.Single.getFullQualifiedName());
                    property.setPrecision(Integer.valueOf(column.getPrecision()));
                    property.setNullable(column.isNullable());
                    property.setMaxLength(Integer.valueOf(column.getMaxLength()));
                    property.setScale(Integer.valueOf(column.getScale()));
                    break;
                }
                case TIMEOFDAY: {
                    property.setType(EdmPrimitiveTypeKind.TimeOfDay.getFullQualifiedName());
                    property.setNullable(column.isNullable());
                    property.setMaxLength(Integer.valueOf(column.getMaxLength()));
                    break;
                }
                case INT64: {
                    property.setType(EdmPrimitiveTypeKind.Int64.getFullQualifiedName());
                    property.setNullable(column.isNullable());
                    property.setMaxLength(Integer.valueOf(column.getMaxLength()));
                    break;
                }
                case DATE_TIMEOFFSET: {
                    property.setType(EdmPrimitiveTypeKind.DateTimeOffset.getFullQualifiedName());
                    property.setNullable(column.isNullable());
                    property.setMaxLength(Integer.valueOf(column.getMaxLength()));
                    break;
                }
                case GUID: {
                    property.setType(EdmPrimitiveTypeKind.Guid.getFullQualifiedName());
                    property.setNullable(column.isNullable());
                    property.setMaxLength(Integer.valueOf(column.getMaxLength()));
                    break;
                }
                case STREAM: {
                    property.setType(EdmPrimitiveTypeKind.Stream.getFullQualifiedName());
                    property.setNullable(column.isNullable());
                    property.setMaxLength(Integer.valueOf(column.getMaxLength()));
                    break;
                }
                case GEOGRAPHY: {
                    property.setType(EdmPrimitiveTypeKind.Geography.getFullQualifiedName());
                    property.setNullable(column.isNullable());
                    property.setMaxLength(Integer.valueOf(column.getMaxLength()));
                    break;
                }
                case GEOGRAPHY_POINT: {
                    property.setType(EdmPrimitiveTypeKind.GeographyPoint.getFullQualifiedName());
                    property.setNullable(column.isNullable());
                    property.setMaxLength(Integer.valueOf(column.getMaxLength()));
                    break;
                }
                case GEOGRAPHY_LINE_STRING: {
                    property.setType(EdmPrimitiveTypeKind.GeographyLineString.getFullQualifiedName());
                    property.setNullable(column.isNullable());
                    property.setMaxLength(Integer.valueOf(column.getMaxLength()));
                    break;
                }
                case GEOGRAPHY_POLYGON: {
                    property.setType(EdmPrimitiveTypeKind.GeographyPolygon.getFullQualifiedName());
                    property.setNullable(column.isNullable());
                    property.setMaxLength(Integer.valueOf(column.getMaxLength()));
                    break;
                }
                case GEOGRAPHY_MULTIPOINT: {
                    property.setType(EdmPrimitiveTypeKind.GeographyMultiPoint.getFullQualifiedName());
                    property.setNullable(column.isNullable());
                    property.setMaxLength(Integer.valueOf(column.getMaxLength()));
                    break;
                }
                case GEOGRAPHY_MULTILINE_STRING: {
                    property.setType(EdmPrimitiveTypeKind.GeographyMultiLineString.getFullQualifiedName());
                    property.setNullable(column.isNullable());
                    property.setMaxLength(Integer.valueOf(column.getMaxLength()));
                    break;
                }
                case GEOGRAPHY_MULTIPOLYGON: {
                    property.setType(EdmPrimitiveTypeKind.GeographyMultiPolygon.getFullQualifiedName());
                    property.setNullable(column.isNullable());
                    property.setMaxLength(Integer.valueOf(column.getMaxLength()));
                    break;
                }
                case GEOGRAPHY_COLLECTION: {
                    property.setType(EdmPrimitiveTypeKind.GeographyCollection.getFullQualifiedName());
                    property.setNullable(column.isNullable());
                    property.setMaxLength(Integer.valueOf(column.getMaxLength()));
                    break;
                }
                case GEOMETRY: {
                    property.setType(EdmPrimitiveTypeKind.Geometry.getFullQualifiedName());
                    property.setNullable(column.isNullable());
                    property.setMaxLength(Integer.valueOf(column.getMaxLength()));
                    break;
                }
                case GEOMETRY_POINT: {
                    property.setType(EdmPrimitiveTypeKind.GeometryPoint.getFullQualifiedName());
                    property.setNullable(column.isNullable());
                    property.setMaxLength(Integer.valueOf(column.getMaxLength()));
                    break;
                }
                case GEOMETRY_LINE_STRING: {
                    property.setType(EdmPrimitiveTypeKind.GeometryLineString.getFullQualifiedName());
                    property.setNullable(column.isNullable());
                    property.setMaxLength(Integer.valueOf(column.getMaxLength()));
                    break;
                }
                case GEOMETRY_POLYGON: {
                    property.setType(EdmPrimitiveTypeKind.GeometryPolygon.getFullQualifiedName());
                    property.setNullable(column.isNullable());
                    property.setMaxLength(Integer.valueOf(column.getMaxLength()));
                    break;
                }
                case GEOMETRY_MULTIPOINT: {
                    property.setType(EdmPrimitiveTypeKind.GeometryMultiPoint.getFullQualifiedName());
                    property.setNullable(column.isNullable());
                    property.setMaxLength(Integer.valueOf(column.getMaxLength()));
                    break;
                }
                case GEOMETRY_MULTILINE_STRING: {
                    property.setType(EdmPrimitiveTypeKind.GeometryMultiLineString.getFullQualifiedName());
                    property.setNullable(column.isNullable());
                    property.setMaxLength(Integer.valueOf(column.getMaxLength()));
                    break;
                }
                case GEOMETRY_MULTIPOLYGON: {
                    property.setType(EdmPrimitiveTypeKind.GeometryMultiPolygon.getFullQualifiedName());
                    property.setNullable(column.isNullable());
                    property.setMaxLength(Integer.valueOf(column.getMaxLength()));
                    break;
                }
                case GEOMETRY_COLLECTION: {
                    property.setType(EdmPrimitiveTypeKind.GeometryMultiPolygon.getFullQualifiedName());
                    property.setNullable(column.isNullable());
                    property.setMaxLength(Integer.valueOf(column.getMaxLength()));
                    break;
                }
                default: {
                    property.setType(EdmPrimitiveTypeKind.String.getFullQualifiedName());
                    property.setMaxLength(Integer.valueOf(column.getMaxLength()));
                    property.setNullable(column.isNullable());
                    property.setUnicode(false);
                }
            }
            properties.add(property);
        }
        return properties;
    }

    private Map<String, List<CsdlProperty>> getPropertiesMap() {
        HashMap<String, List<CsdlProperty>> propertiesMap = new HashMap<String, List<CsdlProperty>>();
        for (String tableName : this.dataHandler.getTableList()) {
            propertiesMap.put(tableName, this.getProperties(tableName));
        }
        return propertiesMap;
    }

    private Property createPrimitive(DataColumn.ODataDataType columnType, String name, String paramValue) throws ODataServiceFault, ParseException {
        Object value;
        String propertyType;
        switch (columnType) {
            case INT32: {
                propertyType = EdmPrimitiveTypeKind.Int32.getFullQualifiedName().getFullQualifiedNameAsString();
                value = paramValue == null ? null : Integer.valueOf(ConverterUtil.convertToInt((String)paramValue));
                break;
            }
            case INT16: {
                propertyType = EdmPrimitiveTypeKind.Int16.getFullQualifiedName().getFullQualifiedNameAsString();
                value = paramValue == null ? null : Byte.valueOf(ConverterUtil.convertToByte((String)paramValue));
                break;
            }
            case DOUBLE: {
                propertyType = EdmPrimitiveTypeKind.Double.getFullQualifiedName().getFullQualifiedNameAsString();
                value = paramValue == null ? null : Double.valueOf(ConverterUtil.convertToDouble((String)paramValue));
                break;
            }
            case STRING: {
                propertyType = EdmPrimitiveTypeKind.String.getFullQualifiedName().getFullQualifiedNameAsString();
                value = paramValue;
                break;
            }
            case BOOLEAN: {
                propertyType = EdmPrimitiveTypeKind.Boolean.getFullQualifiedName().getFullQualifiedNameAsString();
                value = paramValue == null ? null : Boolean.valueOf(ConverterUtil.convertToBoolean((String)paramValue));
                break;
            }
            case BINARY: {
                propertyType = EdmPrimitiveTypeKind.Binary.getFullQualifiedName().getFullQualifiedNameAsString();
                value = paramValue == null ? null : this.getBytesFromBase64String(paramValue);
                break;
            }
            case BYTE: {
                propertyType = EdmPrimitiveTypeKind.Byte.getFullQualifiedName().getFullQualifiedNameAsString();
                value = paramValue;
                break;
            }
            case SBYTE: {
                propertyType = EdmPrimitiveTypeKind.SByte.getFullQualifiedName().getFullQualifiedNameAsString();
                value = paramValue;
                break;
            }
            case DATE: {
                propertyType = EdmPrimitiveTypeKind.Date.getFullQualifiedName().getFullQualifiedNameAsString();
                value = ConverterUtil.convertToDate((String)paramValue);
                break;
            }
            case DURATION: {
                propertyType = EdmPrimitiveTypeKind.Duration.getFullQualifiedName().getFullQualifiedNameAsString();
                value = paramValue;
                break;
            }
            case DECIMAL: {
                propertyType = EdmPrimitiveTypeKind.Decimal.getFullQualifiedName().getFullQualifiedNameAsString();
                value = paramValue == null ? null : ConverterUtil.convertToBigDecimal((String)paramValue);
                break;
            }
            case SINGLE: {
                propertyType = EdmPrimitiveTypeKind.Single.getFullQualifiedName().getFullQualifiedNameAsString();
                value = paramValue == null ? null : Float.valueOf(ConverterUtil.convertToFloat((String)paramValue));
                break;
            }
            case TIMEOFDAY: {
                propertyType = EdmPrimitiveTypeKind.TimeOfDay.getFullQualifiedName().getFullQualifiedNameAsString();
                value = paramValue == null ? null : ConverterUtil.convertToTime((String)paramValue).getAsCalendar();
                break;
            }
            case INT64: {
                propertyType = EdmPrimitiveTypeKind.Int64.getFullQualifiedName().getFullQualifiedNameAsString();
                value = paramValue == null ? null : Long.valueOf(ConverterUtil.convertToLong((String)paramValue));
                break;
            }
            case DATE_TIMEOFFSET: {
                propertyType = EdmPrimitiveTypeKind.DateTimeOffset.getFullQualifiedName().getFullQualifiedNameAsString();
                value = ConverterUtil.convertToDateTime((String)paramValue);
                break;
            }
            case GUID: {
                propertyType = EdmPrimitiveTypeKind.Guid.getFullQualifiedName().getFullQualifiedNameAsString();
                value = paramValue;
                break;
            }
            case STREAM: {
                propertyType = EdmPrimitiveTypeKind.Stream.getFullQualifiedName().getFullQualifiedNameAsString();
                value = paramValue;
                break;
            }
            case GEOGRAPHY: {
                propertyType = EdmPrimitiveTypeKind.Geography.getFullQualifiedName().getFullQualifiedNameAsString();
                value = paramValue;
                break;
            }
            case GEOGRAPHY_POINT: {
                propertyType = EdmPrimitiveTypeKind.GeographyPoint.getFullQualifiedName().getFullQualifiedNameAsString();
                value = paramValue;
                break;
            }
            case GEOGRAPHY_LINE_STRING: {
                propertyType = EdmPrimitiveTypeKind.GeographyLineString.getFullQualifiedName().getFullQualifiedNameAsString();
                value = paramValue;
                break;
            }
            case GEOGRAPHY_POLYGON: {
                propertyType = EdmPrimitiveTypeKind.GeographyPolygon.getFullQualifiedName().getFullQualifiedNameAsString();
                value = paramValue;
                break;
            }
            case GEOGRAPHY_MULTIPOINT: {
                propertyType = EdmPrimitiveTypeKind.GeographyMultiPoint.getFullQualifiedName().getFullQualifiedNameAsString();
                value = paramValue;
                break;
            }
            case GEOGRAPHY_MULTILINE_STRING: {
                propertyType = EdmPrimitiveTypeKind.GeographyMultiLineString.getFullQualifiedName().getFullQualifiedNameAsString();
                value = paramValue;
                break;
            }
            case GEOGRAPHY_MULTIPOLYGON: {
                propertyType = EdmPrimitiveTypeKind.GeographyMultiPolygon.getFullQualifiedName().getFullQualifiedNameAsString();
                value = paramValue;
                break;
            }
            case GEOGRAPHY_COLLECTION: {
                propertyType = EdmPrimitiveTypeKind.GeographyCollection.getFullQualifiedName().getFullQualifiedNameAsString();
                value = paramValue;
                break;
            }
            case GEOMETRY: {
                propertyType = EdmPrimitiveTypeKind.Geometry.getFullQualifiedName().getFullQualifiedNameAsString();
                value = paramValue;
                break;
            }
            case GEOMETRY_POINT: {
                propertyType = EdmPrimitiveTypeKind.GeometryPoint.getFullQualifiedName().getFullQualifiedNameAsString();
                value = paramValue;
                break;
            }
            case GEOMETRY_LINE_STRING: {
                propertyType = EdmPrimitiveTypeKind.GeometryLineString.getFullQualifiedName().getFullQualifiedNameAsString();
                value = paramValue;
                break;
            }
            case GEOMETRY_POLYGON: {
                propertyType = EdmPrimitiveTypeKind.GeometryPolygon.getFullQualifiedName().getFullQualifiedNameAsString();
                value = paramValue;
                break;
            }
            case GEOMETRY_MULTIPOINT: {
                propertyType = EdmPrimitiveTypeKind.GeometryMultiPoint.getFullQualifiedName().getFullQualifiedNameAsString();
                value = paramValue;
                break;
            }
            case GEOMETRY_MULTILINE_STRING: {
                propertyType = EdmPrimitiveTypeKind.GeographyMultiLineString.getFullQualifiedName().getFullQualifiedNameAsString();
                value = paramValue;
                break;
            }
            case GEOMETRY_MULTIPOLYGON: {
                propertyType = EdmPrimitiveTypeKind.GeometryMultiPolygon.getFullQualifiedName().getFullQualifiedNameAsString();
                value = paramValue;
                break;
            }
            case GEOMETRY_COLLECTION: {
                propertyType = EdmPrimitiveTypeKind.GeometryCollection.getFullQualifiedName().getFullQualifiedNameAsString();
                value = paramValue;
                break;
            }
            default: {
                propertyType = EdmPrimitiveTypeKind.String.getFullQualifiedName().getFullQualifiedNameAsString();
                value = paramValue;
            }
        }
        return new Property(propertyType, name, ValueType.PRIMITIVE, value);
    }

    private void updateEntity(EdmEntityType edmEntityType, Entity entity, List<UriParameter> keys, boolean merge) throws DataServiceFault, ODataApplicationException {
        ODataEntry entry = new ODataEntry();
        for (UriParameter key : keys) {
            String value = key.getText();
            if (value.startsWith("'") && value.endsWith("'")) {
                value = value.substring(1, value.length() - 1);
            }
            entry.addValue(key.getName(), value);
        }
        for (String property : edmEntityType.getPropertyNames()) {
            Property updateProperty = entity.getProperty(property);
            if (this.isKey(edmEntityType, property)) continue;
            if (updateProperty == null) {
                if (merge) continue;
                entry.addValue(property, null);
                continue;
            }
            EdmProperty propertyType = (EdmProperty)edmEntityType.getProperty(property);
            entry.addValue(property, this.readPrimitiveValueInString(propertyType, updateProperty.getValue()));
        }
        this.dataHandler.updateEntityInTable(edmEntityType.getName(), entry);
    }

    private CsdlEdmProvider initializeEdmProvider(String configID) throws ODataServiceFault {
        return new EDMProvider(this.dataHandler.getTableList(), configID, this.namespace, this.getPropertiesMap(), this.getKeysCsdlMap(), this.dataHandler.getTableList(), this.dataHandler.getNavigationProperties());
    }

    private void initializeTransactionalConnection() throws ODataServiceFault {
        if (!this.batchRequest.get().booleanValue()) {
            this.dataHandler.openTransaction();
        }
    }

    private void finalizeTransactionalConnection() throws ODataServiceFault {
        if (!this.batchRequest.get().booleanValue()) {
            this.dataHandler.commitTransaction();
        }
    }

    private static class EntityDetails {
        EntityCollection entitySet = null;
        Entity entity = null;
        EdmEntityType entityType;
        boolean eTagMatched = false;

        private EntityDetails() {
        }
    }
}

