/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.odata.expression;

import java.util.List;
import java.util.Locale;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.edm.EdmBindingTarget;
import org.apache.olingo.commons.api.edm.EdmEnumType;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.UriInfoResource;
import org.apache.olingo.server.api.uri.UriResourceLambdaAll;
import org.apache.olingo.server.api.uri.UriResourceLambdaAny;
import org.apache.olingo.server.api.uri.UriResourceProperty;
import org.apache.olingo.server.api.uri.queryoption.expression.BinaryOperatorKind;
import org.apache.olingo.server.api.uri.queryoption.expression.Expression;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitException;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitor;
import org.apache.olingo.server.api.uri.queryoption.expression.Literal;
import org.apache.olingo.server.api.uri.queryoption.expression.MethodKind;
import org.apache.olingo.server.api.uri.queryoption.expression.UnaryOperatorKind;
import org.wso2.carbon.dataservices.core.odata.expression.operand.TypedOperand;
import org.wso2.carbon.dataservices.core.odata.expression.operand.UntypedOperand;
import org.wso2.carbon.dataservices.core.odata.expression.operand.VisitorOperand;
import org.wso2.carbon.dataservices.core.odata.expression.operation.BinaryOperator;
import org.wso2.carbon.dataservices.core.odata.expression.operation.MethodCallOperator;
import org.wso2.carbon.dataservices.core.odata.expression.operation.UnaryOperator;

public class ExpressionVisitorImpl
implements ExpressionVisitor<VisitorOperand> {
    private final Entity entity;

    public ExpressionVisitorImpl(Entity entity, EdmBindingTarget bindingTarget) {
        this.entity = entity;
    }

    public VisitorOperand visitBinaryOperator(BinaryOperatorKind operator, VisitorOperand left, VisitorOperand right) throws ExpressionVisitException, ODataApplicationException {
        BinaryOperator binaryOperator = new BinaryOperator(left, right);
        switch (operator) {
            case AND: {
                return binaryOperator.andOperator();
            }
            case OR: {
                return binaryOperator.orOperator();
            }
            case EQ: {
                return binaryOperator.equalsOperator();
            }
            case NE: {
                return binaryOperator.notEqualsOperator();
            }
            case GE: {
                return binaryOperator.greaterEqualsOperator();
            }
            case GT: {
                return binaryOperator.greaterThanOperator();
            }
            case LE: {
                return binaryOperator.lessEqualsOperator();
            }
            case LT: {
                return binaryOperator.lessThanOperator();
            }
            case ADD: 
            case SUB: 
            case MUL: 
            case DIV: 
            case MOD: {
                return binaryOperator.arithmeticOperator(operator);
            }
        }
        return this.throwNotImplemented();
    }

    public VisitorOperand visitUnaryOperator(UnaryOperatorKind operator, VisitorOperand operand) throws ExpressionVisitException, ODataApplicationException {
        UnaryOperator unaryOperator = new UnaryOperator(operand);
        switch (operator) {
            case MINUS: {
                return unaryOperator.minusOperation();
            }
            case NOT: {
                return unaryOperator.notOperation();
            }
        }
        return this.throwNotImplemented();
    }

    public VisitorOperand visitMethodCall(MethodKind methodCall, List<VisitorOperand> parameters) throws ExpressionVisitException, ODataApplicationException {
        MethodCallOperator methodCallOperation = new MethodCallOperator(parameters);
        switch (methodCall) {
            case ENDSWITH: {
                return methodCallOperation.endsWith();
            }
            case INDEXOF: {
                return methodCallOperation.indexOf();
            }
            case STARTSWITH: {
                return methodCallOperation.startsWith();
            }
            case TOLOWER: {
                return methodCallOperation.toLower();
            }
            case TOUPPER: {
                return methodCallOperation.toUpper();
            }
            case TRIM: {
                return methodCallOperation.trim();
            }
            case SUBSTRING: {
                return methodCallOperation.substring();
            }
            case CONTAINS: {
                return methodCallOperation.contains();
            }
            case CONCAT: {
                return methodCallOperation.concat();
            }
            case LENGTH: {
                return methodCallOperation.length();
            }
            case YEAR: {
                return methodCallOperation.year();
            }
            case MONTH: {
                return methodCallOperation.month();
            }
            case DAY: {
                return methodCallOperation.day();
            }
            case HOUR: {
                return methodCallOperation.hour();
            }
            case MINUTE: {
                return methodCallOperation.minute();
            }
            case SECOND: {
                return methodCallOperation.second();
            }
            case FRACTIONALSECONDS: {
                return methodCallOperation.fractionalSeconds();
            }
            case ROUND: {
                return methodCallOperation.round();
            }
            case FLOOR: {
                return methodCallOperation.floor();
            }
            case CEILING: {
                return methodCallOperation.ceiling();
            }
        }
        return this.throwNotImplemented();
    }

    public VisitorOperand visitLambdaExpression(String lambdaFunction, String lambdaVariable, Expression expression) throws ExpressionVisitException, ODataApplicationException {
        return this.throwNotImplemented();
    }

    public VisitorOperand visitLiteral(Literal literal) throws ExpressionVisitException, ODataApplicationException {
        return new UntypedOperand(literal.getText());
    }

    public VisitorOperand visitMember(UriInfoResource member) throws ExpressionVisitException, ODataApplicationException {
        List uriResourceParts = member.getUriResourceParts();
        int size = uriResourceParts.size();
        if (uriResourceParts.get(0) instanceof UriResourceProperty) {
            EdmProperty currentEdmProperty = ((UriResourceProperty)uriResourceParts.get(0)).getProperty();
            Property currentProperty = this.entity.getProperty(currentEdmProperty.getName());
            return new TypedOperand(currentProperty.getValue(), currentEdmProperty.getType(), currentEdmProperty);
        }
        if (uriResourceParts.get(size - 1) instanceof UriResourceLambdaAll) {
            return this.throwNotImplemented();
        }
        if (uriResourceParts.get(size - 1) instanceof UriResourceLambdaAny) {
            return this.throwNotImplemented();
        }
        return this.throwNotImplemented();
    }

    public VisitorOperand visitAlias(String aliasName) throws ExpressionVisitException, ODataApplicationException {
        return this.throwNotImplemented();
    }

    public VisitorOperand visitTypeLiteral(EdmType type) throws ExpressionVisitException, ODataApplicationException {
        return this.throwNotImplemented();
    }

    public VisitorOperand visitLambdaReference(String variableName) throws ExpressionVisitException, ODataApplicationException {
        return this.throwNotImplemented();
    }

    public VisitorOperand visitEnum(EdmEnumType type, List<String> enumValues) throws ExpressionVisitException, ODataApplicationException {
        return this.throwNotImplemented();
    }

    private VisitorOperand throwNotImplemented() throws ODataApplicationException {
        throw new ODataApplicationException("Not implemented", HttpStatusCode.NOT_IMPLEMENTED.getStatusCode(), Locale.ROOT);
    }
}

