/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.odata.expression.operand;

import java.math.BigDecimal;
import java.util.Locale;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataApplicationException;
import org.wso2.carbon.dataservices.core.odata.expression.ODataConstants;
import org.wso2.carbon.dataservices.core.odata.expression.operand.VisitorOperand;

public class TypedOperand
extends VisitorOperand {
    private final EdmType type;
    private final EdmProperty edmProperty;

    public TypedOperand(Object value, EdmType type) {
        super(value);
        this.type = type;
        this.edmProperty = null;
    }

    public TypedOperand(Object value, EdmType type, EdmProperty edmProperty) {
        super(value);
        this.type = type;
        this.edmProperty = edmProperty;
    }

    @Override
    public TypedOperand asTypedOperand() throws ODataApplicationException {
        if (!this.isNull() && this.value.getClass() != this.getDefaultType((EdmPrimitiveType)this.type)) {
            return this.asTypedOperand((EdmPrimitiveType)this.type);
        }
        return this;
    }

    @Override
    public TypedOperand asTypedOperand(EdmPrimitiveType ... asTypes) throws ODataApplicationException {
        if (this.is(ODataConstants.primitiveNull)) {
            return this;
        }
        if (this.isNull()) {
            return new TypedOperand(null, (EdmType)asTypes[0]);
        }
        Object newValue = null;
        for (EdmPrimitiveType asType : asTypes) {
            if (asType.equals(ODataConstants.primitiveDouble) || asType.equals(ODataConstants.primitiveSingle) || asType.equals(ODataConstants.primitiveDecimal)) {
                try {
                    newValue = new BigDecimal(this.value.toString());
                }
                catch (NumberFormatException e) {}
            } else {
                try {
                    String literal = this.getLiteral(this.value);
                    newValue = this.tryCast(literal, asType);
                }
                catch (EdmPrimitiveTypeException e) {
                    // empty catch block
                }
            }
            if (newValue == null) continue;
            return new TypedOperand(newValue, (EdmType)asType);
        }
        throw new ODataApplicationException("Cast failed", HttpStatusCode.BAD_REQUEST.getStatusCode(), Locale.ROOT);
    }

    public TypedOperand castToCommonType(VisitorOperand otherOperand) throws ODataApplicationException {
        TypedOperand other = otherOperand.asTypedOperand();
        EdmType oType = other.getType();
        if (this.type == oType && this.value != null && other.getValue() != null && this.value.getClass() == other.getValue().getClass()) {
            return this;
        }
        if (this.is(ODataConstants.primitiveNull) || other.is(ODataConstants.primitiveNull)) {
            return this;
        }
        if (this.type.equals(ODataConstants.primitiveDouble) || oType.equals(ODataConstants.primitiveDouble)) {
            return this.asTypedOperand(ODataConstants.primitiveDouble);
        }
        if (this.type.equals(ODataConstants.primitiveSingle) || oType.equals(ODataConstants.primitiveSingle)) {
            return this.asTypedOperand(ODataConstants.primitiveSingle);
        }
        if (this.type.equals(ODataConstants.primitiveDecimal) || oType.equals(ODataConstants.primitiveDecimal)) {
            return this.asTypedOperand(ODataConstants.primitiveDecimal);
        }
        if (this.type.equals(ODataConstants.primitiveInt64) || oType.equals(ODataConstants.primitiveInt64)) {
            return this.asTypedOperand(ODataConstants.primitiveInt64);
        }
        if (this.type.equals(ODataConstants.primitiveInt32) || oType.equals(ODataConstants.primitiveInt32)) {
            return this.asTypedOperand(ODataConstants.primitiveInt32);
        }
        if (this.type.equals(ODataConstants.primitiveInt16) || oType.equals(ODataConstants.primitiveInt16)) {
            return this.asTypedOperand(ODataConstants.primitiveInt16);
        }
        return this.asTypedOperand((EdmPrimitiveType)this.type);
    }

    public EdmType getType() {
        return this.type;
    }

    public <T> T getTypedValue(Class<T> clazz) {
        return clazz.cast(this.value);
    }

    public boolean isNull() {
        return this.is(ODataConstants.primitiveNull) || this.value == null;
    }

    public boolean isIntegerType() {
        return this.is(ODataConstants.primitiveNull, ODataConstants.primitiveByte, ODataConstants.primitiveSByte, ODataConstants.primitiveInt16, ODataConstants.primitiveInt32, ODataConstants.primitiveInt64);
    }

    public boolean isDecimalType() {
        return this.is(ODataConstants.primitiveNull, ODataConstants.primitiveSingle, ODataConstants.primitiveDouble, ODataConstants.primitiveDecimal);
    }

    public boolean is(EdmPrimitiveType ... types) {
        for (EdmPrimitiveType type : types) {
            if (!type.equals(this.type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public EdmProperty getEdmProperty() {
        return this.edmProperty;
    }

    private String getLiteral(Object value) throws EdmPrimitiveTypeException {
        EdmProperty edmProperty = this.getEdmProperty();
        String uriLiteral = edmProperty != null ? ((EdmPrimitiveType)this.type).valueToString(value, Boolean.valueOf(edmProperty.isNullable()), edmProperty.getMaxLength(), edmProperty.getPrecision(), edmProperty.getScale(), Boolean.valueOf(edmProperty.isUnicode())) : ((EdmPrimitiveType)this.type).valueToString(value, null, null, null, null, null);
        return ((EdmPrimitiveType)this.type).toUriLiteral(uriLiteral);
    }
}

