/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.odata.expression.operand;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.server.api.ODataApplicationException;
import org.wso2.carbon.dataservices.core.odata.expression.ODataConstants;
import org.wso2.carbon.dataservices.core.odata.expression.operand.TypedOperand;

public abstract class VisitorOperand {
    private static final HashMap<EdmType, Class<?>> defaultTypeMapping = new HashMap();
    protected Object value;

    public VisitorOperand(Object value) {
        this.value = value;
        defaultTypeMapping.put((EdmType)ODataConstants.primitiveByte, BigInteger.class);
        defaultTypeMapping.put((EdmType)ODataConstants.primitiveSByte, BigInteger.class);
        defaultTypeMapping.put((EdmType)ODataConstants.primitiveInt16, BigInteger.class);
        defaultTypeMapping.put((EdmType)ODataConstants.primitiveInt32, BigInteger.class);
        defaultTypeMapping.put((EdmType)ODataConstants.primitiveInt64, BigInteger.class);
        defaultTypeMapping.put((EdmType)ODataConstants.primitiveSingle, BigDecimal.class);
        defaultTypeMapping.put((EdmType)ODataConstants.primitiveDouble, BigDecimal.class);
        defaultTypeMapping.put((EdmType)ODataConstants.primitiveDecimal, BigDecimal.class);
    }

    public abstract TypedOperand asTypedOperand() throws ODataApplicationException;

    public abstract TypedOperand asTypedOperand(EdmPrimitiveType[] var1) throws ODataApplicationException;

    public abstract EdmProperty getEdmProperty();

    public Object getValue() {
        return this.value;
    }

    protected Object castTo(String value, EdmPrimitiveType type) throws EdmPrimitiveTypeException {
        EdmProperty edmProperty = this.getEdmProperty();
        if (edmProperty != null) {
            return type.valueOfString(value, Boolean.valueOf(edmProperty.isNullable()), edmProperty.getMaxLength(), edmProperty.getPrecision(), edmProperty.getScale(), Boolean.valueOf(edmProperty.isUnicode()), this.getDefaultType(type));
        }
        return type.valueOfString(value, null, null, null, null, null, this.getDefaultType(type));
    }

    protected Class<?> getDefaultType(EdmPrimitiveType type) {
        return defaultTypeMapping.get(type) != null ? defaultTypeMapping.get(type) : type.getDefaultType();
    }

    protected Object tryCast(String literal, EdmPrimitiveType type) {
        try {
            return this.castTo(type.fromUriLiteral(literal), type);
        }
        catch (EdmPrimitiveTypeException e) {
            return null;
        }
    }
}

