/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.odata.expression.operation;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataApplicationException;
import org.wso2.carbon.dataservices.core.odata.expression.ODataConstants;
import org.wso2.carbon.dataservices.core.odata.expression.operand.TypedOperand;
import org.wso2.carbon.dataservices.core.odata.expression.operand.VisitorOperand;

public class UnaryOperator {
    private final TypedOperand operand;

    public UnaryOperator(VisitorOperand operand) throws ODataApplicationException {
        this.operand = operand.asTypedOperand();
    }

    public VisitorOperand minusOperation() throws ODataApplicationException {
        if (this.operand.isNull()) {
            return this.operand;
        }
        if (this.operand.isIntegerType()) {
            return new TypedOperand(this.operand.getTypedValue(BigInteger.class).negate(), this.operand.getType());
        }
        if (this.operand.isDecimalType() || this.operand.is(ODataConstants.primitiveDuration)) {
            return new TypedOperand(this.operand.getTypedValue(BigDecimal.class).negate(), this.operand.getType());
        }
        throw new ODataApplicationException("Unsupported type", HttpStatusCode.BAD_REQUEST.getStatusCode(), Locale.ROOT);
    }

    public VisitorOperand notOperation() throws ODataApplicationException {
        if (this.operand.isNull()) {
            return this.operand;
        }
        if (this.operand.is(ODataConstants.primitiveBoolean)) {
            return new TypedOperand(this.operand.getTypedValue(Boolean.class) == false, this.operand.getType());
        }
        throw new ODataApplicationException("Unsupported type", HttpStatusCode.BAD_REQUEST.getStatusCode(), Locale.ROOT);
    }
}

