/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.script;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.sql.DataSource;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.auth.UserStoreAuthorizationProvider;
import org.wso2.carbon.dataservices.core.description.config.SQLCarbonDataSourceConfig;
import org.wso2.carbon.dataservices.core.description.operation.Operation;
import org.wso2.carbon.dataservices.core.description.query.Query;
import org.wso2.carbon.dataservices.core.description.query.QueryFactory;
import org.wso2.carbon.dataservices.core.description.query.SQLQuery;
import org.wso2.carbon.dataservices.core.engine.CallQuery;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.engine.OutputElementGroup;
import org.wso2.carbon.dataservices.core.engine.QueryParam;
import org.wso2.carbon.dataservices.core.engine.Result;
import org.wso2.carbon.dataservices.core.engine.StaticOutputElement;
import org.wso2.carbon.dataservices.core.internal.DataServicesDSComponent;
import org.wso2.carbon.dataservices.core.script.DSSqlTypes;
import org.wso2.carbon.dataservices.core.script.DynamicSqlUtils;
import org.wso2.carbon.dataservices.core.validation.Validator;
import org.wso2.carbon.ndatasource.common.DataSourceException;
import org.wso2.carbon.ndatasource.core.CarbonDataSource;
import org.wso2.carbon.ndatasource.core.DataSourceService;

public class DSGenerator {
    private static final String AUTOINCREMENT_COLUMN = "IS_AUTOINCREMENT";
    private static final String IDENTITY_COLUMN = "Identity";
    private static final String IS_AUTOINCREMENT = "YES";
    private static Log log = LogFactory.getLog(DSGenerator.class);
    private DataService generatedService;
    private List<DataService> generatedServiceList;
    private List<String> DSErrorList = new ArrayList<String>();

    public DSGenerator(String dataSourceId, String dbName, String[] schemas, String[] tableNames, boolean singleService, String nameSpace, String serviceName) throws Exception {
        try (Connection connection = null;){
            String[] tableNameList = tableNames;
            if (dataSourceId != null) {
                connection = DSGenerator.createConnection(dataSourceId);
                DatabaseMetaData metaObject = connection.getMetaData();
                if (tableNameList.length == 0) {
                    tableNameList = DSGenerator.getTableList(connection, dbName, schemas);
                }
                if (singleService) {
                    this.generatedService = this.generateService(dataSourceId, dbName, schemas, tableNameList, metaObject, nameSpace, serviceName);
                } else {
                    this.generatedServiceList = this.generateServices(dataSourceId, dbName, schemas, tableNameList, metaObject, nameSpace);
                }
            }
        }
    }

    public List<String> getDSErrorList() {
        return this.DSErrorList;
    }

    private static Connection createConnection(String dataSourceId) throws SQLException, DataServiceFault {
        CarbonDataSource cds;
        DataSourceService dataSourceService = DataServicesDSComponent.getDataSourceService();
        try {
            cds = dataSourceService.getDataSource(dataSourceId);
        }
        catch (DataSourceException e) {
            throw new DataServiceFault(e, "Error in retrieving data source: " + e.getMessage());
        }
        if (cds == null) {
            throw new DataServiceFault("DataSource '" + dataSourceId + "' is not available.");
        }
        Object ds = cds.getDSObject();
        if (!(ds instanceof DataSource)) {
            throw new DataServiceFault("DataSource '" + dataSourceId + "' is not an RDBMS data source.");
        }
        return ((DataSource)ds).getConnection();
    }

    private DataService generateService(String datasourceId, String dbName, String[] schemas, String[] tableNames, DatabaseMetaData metaData, String serviceNamespace, String serviceName) throws DataServiceFault, SQLException {
        DataService dataService = new DataService(serviceName, "single service for whole database", null, null, "active", false, false, null);
        dataService.setAuthorizationProvider(new UserStoreAuthorizationProvider());
        this.setConfig(dataService, datasourceId);
        if (DBUtils.isEmptyString(serviceNamespace)) {
            dataService.setServiceNamespace("http://ws.wso2.org/dataservice");
        } else {
            dataService.setServiceNamespace(serviceNamespace);
        }
        if (schemas.length != 0) {
            for (String schema : schemas) {
                this.makeService(dbName, tableNames, metaData, dataService, schema);
            }
        } else {
            String schema = null;
            this.makeService(dbName, tableNames, metaData, dataService, schema);
        }
        return dataService;
    }

    private List<DataService> generateServices(String datasourceId, String dbName, String[] schemas, String[] tableNames, DatabaseMetaData metaData, String serviceNamespace) throws SQLException, DataServiceFault {
        ArrayList<DataService> serviceList = new ArrayList<DataService>();
        if (schemas.length != 0) {
            for (String schema : schemas) {
                this.makeServices(dbName, tableNames, metaData, serviceList, schema, datasourceId, serviceNamespace);
            }
        } else {
            String schema = null;
            this.makeServices(dbName, tableNames, metaData, serviceList, schema, datasourceId, serviceNamespace);
        }
        return serviceList;
    }

    private void makeService(String dbName, String[] tableNames, DatabaseMetaData metaData, DataService dataService, String schema) throws SQLException {
        for (String tableName : tableNames) {
            String tablePrimaryKey = "";
            try {
                tablePrimaryKey = this.getPrimaryKey(metaData, dbName, schema, tableName);
            }
            catch (SQLException e) {
                throw new SQLException("Cannot create the service : " + e.getMessage());
            }
            this.addOperations(dataService, schema, metaData, dbName, tableName, tablePrimaryKey);
        }
    }

    private void makeServices(String dbName, String[] tableNames, DatabaseMetaData metaData, List<DataService> dataServiceList, String schema, String datasourceId, String serviceNamespace) throws SQLException, DataServiceFault {
        for (String tableName : tableNames) {
            String serviceName = tableName + "_DataService";
            DataService dataService = new DataService(serviceName, "multiple services per each table", null, null, "active", false, false, null);
            dataService.setAuthorizationProvider(new UserStoreAuthorizationProvider());
            if (DBUtils.isEmptyString(serviceNamespace)) {
                dataService.setServiceNamespace("http://ws.wso2.org/dataservice");
            } else {
                dataService.setServiceNamespace(serviceNamespace);
            }
            this.setConfig(dataService, datasourceId);
            String tablePrimaryKey = "";
            try {
                tablePrimaryKey = this.getPrimaryKey(metaData, dbName, schema, tableName);
            }
            catch (SQLException e) {
                throw new SQLException("Cannot create the service : " + e.getMessage());
            }
            this.addOperations(dataService, schema, metaData, dbName, tableName, tablePrimaryKey);
            dataServiceList.add(dataService);
        }
    }

    private void addOperations(DataService dataService, String schema, DatabaseMetaData metaData, String dbName, String tableName, String tablePrimaryKey) {
        String defError;
        try {
            this.addInsertOperation(dataService, schema, metaData, dbName, tableName);
        }
        catch (Exception e) {
            e.printStackTrace();
            defError = "Insert operation not created";
            this.addError(defError);
            log.warn((Object)defError, (Throwable)e);
        }
        try {
            this.addSelectAllOperation(dataService, schema, metaData, dbName, tableName, tablePrimaryKey);
        }
        catch (Exception e) {
            defError = "select all operation not created";
            this.addError(defError);
            log.warn((Object)defError, (Throwable)e);
        }
        if (tablePrimaryKey != null) {
            try {
                this.addUpdateOperation(dataService, schema, metaData, dbName, tableName, tablePrimaryKey);
            }
            catch (Exception e) {
                defError = "update operation not created";
                this.addError(defError);
                log.warn((Object)defError, (Throwable)e);
            }
            try {
                this.addDeleteOperation(dataService, schema, metaData, dbName, tableName, tablePrimaryKey);
            }
            catch (Exception e) {
                defError = "delete operation not created";
                this.addError(defError);
                log.warn((Object)defError, (Throwable)e);
            }
            try {
                this.addSelectWithKeyOperation(dataService, schema, metaData, dbName, tableName, tablePrimaryKey);
            }
            catch (Exception e) {
                defError = "select with key Operation not created";
                this.addError(defError);
                log.warn((Object)defError, (Throwable)e);
            }
        } else {
            String defError2 = "Primary key does not exists";
            log.warn((Object)defError2);
        }
    }

    public static String[] getTableList(String datasourceId, String dbName, String[] schemas) throws DataServiceFault {
        Connection connection = null;
        try {
            if (datasourceId != null) {
                connection = DSGenerator.createConnection(datasourceId);
                String[] stringArray = DSGenerator.getTableList(connection, dbName, schemas);
                return stringArray;
            }
            String[] stringArray = null;
            return stringArray;
        }
        catch (SQLException e) {
            throw new DataServiceFault("Error in retrieving table list : " + e.getMessage());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    public static String[] getTableList(String url, String driver, String userName, String password, String dbName, String[] schemas) throws DataServiceFault {
        Connection connection = null;
        try {
            if (url != null && driver != null && userName != null && password != null) {
                Class.forName(driver);
                connection = !userName.isEmpty() ? DriverManager.getConnection(url, userName, password) : DriverManager.getConnection(url);
                String[] stringArray = DSGenerator.getTableList(connection, dbName, schemas);
                return stringArray;
            }
            String[] stringArray = null;
            return stringArray;
        }
        catch (ClassNotFoundException e) {
            throw new DataServiceFault("Error in retrieving table list, Error loading Driver class : " + e.getMessage());
        }
        catch (SQLException e) {
            throw new DataServiceFault("Error in retrieving table list : " + e.getMessage());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    public static String[] getTableList(Connection connection, String dbName, String[] schemas) throws SQLException {
        if (connection != null) {
            List<Object> tableList = new ArrayList();
            DatabaseMetaData mObject = connection.getMetaData();
            if (schemas.length != 0) {
                tableList = DSGenerator.getTableNamesList(mObject, dbName, schemas[0]);
                if (tableList.size() == 0) {
                    tableList = DSGenerator.getTableNamesList(mObject, null, schemas[0]);
                }
            } else {
                tableList = DSGenerator.getTableNamesList(mObject, dbName, null);
            }
            return tableList.toArray(new String[tableList.size()]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getTableNamesList(DatabaseMetaData mObject, String dbName, String schema) throws SQLException {
        try (ResultSet tableNamesList = null;){
            ArrayList<String> tableList = new ArrayList<String>();
            tableNamesList = mObject.getTables(dbName, schema, null, null);
            while (tableNamesList.next()) {
                tableList.add(tableNamesList.getString("TABLE_NAME"));
            }
            ArrayList<String> arrayList = tableList;
            return arrayList;
        }
    }

    public static String[] getSchemas(String datasourceId) throws Exception {
        try (Connection connection = null;){
            if (datasourceId != null) {
                connection = DSGenerator.createConnection(datasourceId);
                String[] stringArray = DSGenerator.getSchemas(connection);
                return stringArray;
            }
            String[] stringArray = null;
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getSchemas(Connection connection) throws Exception {
        try (ResultSet schemas = null;){
            if (connection != null) {
                String[] str;
                ArrayList<String> schemaList = new ArrayList<String>();
                DatabaseMetaData mObject = connection.getMetaData();
                schemas = mObject.getSchemas();
                while (schemas.next()) {
                    schemaList.add(schemas.getString("TABLE_SCHEM"));
                }
                String[] stringArray = str = schemaList.toArray(new String[schemaList.size()]);
                return stringArray;
            }
            String[] stringArray = null;
            return stringArray;
        }
    }

    private void setConfig(DataService dataServiceObject, String carbonSourceId) throws DataServiceFault {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("carbon_datasource_name", carbonSourceId);
        SQLCarbonDataSourceConfig config = new SQLCarbonDataSourceConfig(dataServiceObject, "default", properties);
        dataServiceObject.addConfig(config);
    }

    private void addError(String error) {
        this.DSErrorList.add(error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPrimaryKey(DatabaseMetaData meta, String dbName, String schema, String tableName) throws SQLException {
        String pKey = null;
        try (ResultSet resultSet = null;){
            resultSet = meta.getPrimaryKeys(dbName, schema, tableName);
            if (resultSet.next()) {
                resultSet = meta.getPrimaryKeys(dbName, schema, tableName);
            } else {
                try {
                    resultSet = meta.getPrimaryKeys(null, schema, tableName);
                }
                catch (SQLException e) {
                    log.error((Object)"Failed to extract primary key info ", (Throwable)e);
                    throw new SQLException("Failed to extract primary key info");
                }
            }
            if (resultSet.next()) {
                String string = pKey = resultSet.getString("COLUMN_NAME");
                return string;
            }
        }
        return pKey;
    }

    private ResultSet getColumnNames(DatabaseMetaData metaData, String schema, String dbName, String tableName, String columnNamePattern) throws SQLException {
        ResultSet columnNames = metaData.getColumns(dbName, schema, tableName, columnNamePattern);
        columnNames = columnNames.next() ? metaData.getColumns(dbName, schema, tableName, columnNamePattern) : metaData.getColumns(null, schema, tableName, columnNamePattern);
        return columnNames;
    }

    private boolean isAutoIncrementField(ResultSet columnNames) throws SQLException {
        try {
            String autoIncrString = columnNames.getString(AUTOINCREMENT_COLUMN);
            if (IS_AUTOINCREMENT.equalsIgnoreCase(autoIncrString)) {
                return true;
            }
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        try {
            Boolean identity = columnNames.getBoolean(IDENTITY_COLUMN);
            if (identity != null) {
                return identity;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInsertOperation(DataService dataServiceObject, String schema, DatabaseMetaData metaData, String dbName, String tableName) throws DataServiceFault, SQLException {
        try (ResultSet columnNames = null;){
            HashMap<String, CallQuery.WithParam> paramMap = new HashMap<String, CallQuery.WithParam>();
            ArrayList<String> paramList = new ArrayList<String>();
            columnNames = this.getColumnNames(metaData, schema, dbName, tableName, null);
            while (columnNames.next()) {
                if (this.isAutoIncrementField(columnNames)) continue;
                String name = columnNames.getString("COLUMN_NAME");
                CallQuery.WithParam withParam = new CallQuery.WithParam(name, name, name, "query-param");
                paramMap.put(name, withParam);
                paramList.add(name);
            }
            HashSet<String> requiredRoles = new HashSet<String>();
            String queryId = "insert_" + tableName + "_query";
            String OpName = "insert_" + tableName + "_operation";
            CallQuery callQuery = new CallQuery(dataServiceObject, queryId, paramMap, requiredRoles);
            Operation op = new Operation(dataServiceObject, OpName, null, callQuery, false, null, false, false);
            dataServiceObject.addOperation(op);
            dataServiceObject.addQuery(this.getInsertQuery(paramList, queryId, tableName, dataServiceObject, metaData, dbName, schema));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUpdateOperation(DataService dataServiceObject, String schema, DatabaseMetaData metaData, String dbName, String tableName, String pKey) throws SQLException, DataServiceFault {
        try (ResultSet columnNames = null;){
            HashMap<String, CallQuery.WithParam> paramMap = new HashMap<String, CallQuery.WithParam>();
            ArrayList<String> paramList = new ArrayList<String>();
            columnNames = this.getColumnNames(metaData, schema, dbName, tableName, null);
            while (columnNames.next()) {
                String name = columnNames.getString("COLUMN_NAME");
                if (name.equals(pKey)) continue;
                CallQuery.WithParam withParam1 = new CallQuery.WithParam(name, name, name, "query-param");
                paramMap.put(name, withParam1);
                paramList.add(name);
            }
            CallQuery.WithParam withParam2 = new CallQuery.WithParam(pKey, pKey, pKey, "query-param");
            paramMap.put(pKey, withParam2);
            paramList.add(pKey);
            HashSet<String> requiredRoles = new HashSet<String>();
            String queryId = "update_" + tableName + "_query";
            String OpName = "update_" + tableName + "_operation";
            CallQuery callQuery = new CallQuery(dataServiceObject, queryId, paramMap, requiredRoles);
            Operation operation = new Operation(dataServiceObject, OpName, null, callQuery, false, null, false, false);
            dataServiceObject.addOperation(operation);
            dataServiceObject.addQuery(this.getUpdateQuery(paramList, pKey, queryId, tableName, dataServiceObject, metaData, dbName, schema));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDeleteOperation(DataService dataServiceObject, String schema, DatabaseMetaData metaData, String dbName, String tableName, String pKey) throws SQLException, DataServiceFault, NullPointerException {
        try (ResultSet columnNames = null;){
            HashMap<String, CallQuery.WithParam> paramMap = new HashMap<String, CallQuery.WithParam>();
            ArrayList<String> paramList = new ArrayList<String>();
            columnNames = this.getColumnNames(metaData, schema, dbName, tableName, null);
            while (columnNames.next()) {
                String name = columnNames.getString("COLUMN_NAME");
                if (!pKey.equals(name)) continue;
                CallQuery.WithParam withParam = new CallQuery.WithParam(pKey, pKey, pKey, "query-param");
                paramMap.put(pKey, withParam);
                paramList.add(pKey);
            }
            HashSet<String> requiredRoles = new HashSet<String>();
            String queryId = "delete_" + tableName + "_query";
            String OpName = "delete_" + tableName + "_operation";
            CallQuery callQuery = new CallQuery(dataServiceObject, queryId, paramMap, requiredRoles);
            Operation operation = new Operation(dataServiceObject, OpName, null, callQuery, false, null, false, false);
            dataServiceObject.addOperation(operation);
            dataServiceObject.addQuery(this.getDeleteQuery(paramList, pKey, queryId, tableName, dataServiceObject, metaData, dbName, schema));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSelectWithKeyOperation(DataService dataServiceObject, String schema, DatabaseMetaData metaData, String dbName, String tableName, String pKey) throws SQLException, DataServiceFault, NullPointerException {
        try (ResultSet columnNames = null;){
            HashMap<String, CallQuery.WithParam> paramMap = new HashMap<String, CallQuery.WithParam>();
            ArrayList<String> paramList = new ArrayList<String>();
            columnNames = this.getColumnNames(metaData, schema, dbName, tableName, null);
            String colomNames = "";
            int i = 0;
            while (columnNames.next()) {
                String name = columnNames.getString("COLUMN_NAME");
                colomNames = i == 0 ? " " + name : colomNames + ", " + name;
                ++i;
                if (!pKey.equals(name)) continue;
                CallQuery.WithParam withParam = new CallQuery.WithParam(pKey, pKey, pKey, "query-param");
                paramMap.put(pKey, withParam);
                paramList.add(pKey);
            }
            HashSet<String> requiredRoles = new HashSet<String>();
            String queryId = "select_with_key_" + tableName + "_query";
            String OpName = "select_with_key_" + tableName + "_operation";
            CallQuery callQuery = new CallQuery(dataServiceObject, queryId, paramMap, requiredRoles);
            Operation operation = new Operation(dataServiceObject, OpName, null, callQuery, false, null, false, false);
            dataServiceObject.addOperation(operation);
            dataServiceObject.addQuery(this.getSelectWithKeyQuery(paramList, pKey, queryId, tableName, dataServiceObject, metaData, dbName, schema, colomNames));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSelectAllOperation(DataService dataServiceObject, String schema, DatabaseMetaData metaData, String dbName, String tableName, String pKey) throws SQLException, DataServiceFault, NullPointerException {
        try (ResultSet columnNames = null;){
            HashMap<String, CallQuery.WithParam> paramMap = new HashMap<String, CallQuery.WithParam>();
            ArrayList<String> paramList = new ArrayList<String>();
            columnNames = this.getColumnNames(metaData, schema, dbName, tableName, null);
            String colomNames = "";
            int i = 0;
            while (columnNames.next()) {
                String name = columnNames.getString("COLUMN_NAME");
                colomNames = i == 0 ? " " + name : colomNames + ", " + name;
                ++i;
            }
            paramMap.clear();
            HashSet<String> requiredRoles = new HashSet<String>();
            String queryId = "select_all_" + tableName + "_query";
            String OpName = "select_all_" + tableName + "_operation";
            CallQuery callQuery = new CallQuery(dataServiceObject, queryId, paramMap, requiredRoles);
            Operation operation = new Operation(dataServiceObject, OpName, null, callQuery, false, null, false, false);
            dataServiceObject.addOperation(operation);
            dataServiceObject.addQuery(this.getSelectAllQuery(paramList, queryId, tableName, dataServiceObject, metaData, dbName, schema, colomNames));
        }
    }

    private Query getUpdateQuery(List<String> pList, String tablePrimaryKey, String queryId, String tableName, DataService dataServiceObject, DatabaseMetaData metaData, String dbName, String schema) throws IllegalArgumentException, DataServiceFault, SQLException {
        DynamicSqlUtils sqlStatement = new DynamicSqlUtils();
        String query = sqlStatement.getUpdateStatement(tableName, schema, pList, tablePrimaryKey);
        Result result = null;
        HashMap<String, String> advanceProp = new HashMap<String, String>();
        return new SQLQuery(dataServiceObject, queryId, "default", false, false, null, query, this.getQueryParamList(metaData, dbName, schema, tableName, pList), result, null, null, advanceProp, null);
    }

    private Query getDeleteQuery(List<String> pList, String tablePrimaryKey, String queryId, String tableName, DataService dataServiceObject, DatabaseMetaData metaData, String dbName, String schema) throws IllegalArgumentException, DataServiceFault, SQLException {
        DynamicSqlUtils sqlStatement = new DynamicSqlUtils();
        String query = sqlStatement.getDeleteStatement(tableName, schema, tablePrimaryKey);
        Result result = null;
        HashMap<String, String> advanceProp = new HashMap<String, String>();
        return new SQLQuery(dataServiceObject, queryId, "default", false, false, null, query, this.getQueryParamList(metaData, dbName, schema, tableName, pList), result, null, null, advanceProp, null);
    }

    private SQLQuery getInsertQuery(List<String> param, String queryId, String tableName, DataService dataServiceObject, DatabaseMetaData metaData, String dbName, String schema) throws IllegalArgumentException, DataServiceFault, SQLException {
        DynamicSqlUtils sqlStatementCreator = new DynamicSqlUtils();
        String query = sqlStatementCreator.getInsertStatement(tableName, schema, param);
        Result result = null;
        HashMap<String, String> advanceProp = new HashMap<String, String>();
        return new SQLQuery(dataServiceObject, queryId, "default", false, false, null, query, this.getQueryParamList(metaData, dbName, schema, tableName, param), result, null, null, advanceProp, null);
    }

    private Query getSelectAllQuery(List<String> param, String queryId, String tableName, DataService dataServiceObject, DatabaseMetaData metaData, String dbName, String schema, String colomNames) throws IllegalArgumentException, DataServiceFault, SQLException {
        DynamicSqlUtils sqlStatement = new DynamicSqlUtils();
        String query = sqlStatement.getSelectAll(tableName, schema, colomNames);
        Result result = this.getResult(dataServiceObject, metaData, dbName, schema, tableName);
        HashMap<String, String> advanceProp = new HashMap<String, String>();
        return new SQLQuery(dataServiceObject, queryId, "default", false, false, null, query, this.getQueryParamList(metaData, dbName, schema, tableName, param), result, null, null, advanceProp, null);
    }

    private Query getSelectWithKeyQuery(List<String> param, String tablePrimaryKey, String queryId, String tableName, DataService dataServiceObject, DatabaseMetaData metaData, String dbName, String schema, String colomNames) throws IllegalArgumentException, DataServiceFault, SQLException {
        DynamicSqlUtils sqlStatement = new DynamicSqlUtils();
        String query = sqlStatement.getSelectByKey(tableName, schema, tablePrimaryKey, colomNames);
        Result result = this.getResult(dataServiceObject, metaData, dbName, schema, tableName);
        HashMap<String, String> advanceProp = new HashMap<String, String>();
        return new SQLQuery(dataServiceObject, queryId, "default", false, false, null, query, this.getQueryParamList(metaData, dbName, schema, tableName, param), result, null, null, advanceProp, null);
    }

    private List<QueryParam> getQueryParamList(DatabaseMetaData metaData, String dbName, String schema, String tableName, List<String> param) throws IllegalArgumentException, SQLException, DataServiceFault {
        ArrayList<QueryParam> paramList = new ArrayList<QueryParam>();
        int ordinal = 1;
        for (String pName : param) {
            String sqlType = "";
            ResultSet rs = this.getColumnNames(metaData, schema, dbName, tableName, pName);
            while (rs.next()) {
                int type = rs.getInt("DATA_TYPE");
                if (-1 == type || -16 == type || -15 == type || 2009 == type || 1111 == type) {
                    type = 1;
                }
                sqlType = DSSqlTypes.getDefinedTypes().get(type);
            }
            ArrayList<Validator> validator = new ArrayList<Validator>();
            QueryParam queryParam = new QueryParam(pName, sqlType, "IN", "SCALAR", ordinal, null, null, validator);
            paramList.add(queryParam);
            ++ordinal;
        }
        return paramList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result getResult(DataService dataServiceObject, DatabaseMetaData metaData, String dbName, String schema, String tableName) throws DataServiceFault, IllegalArgumentException, SQLException {
        try (ResultSet columnNames = null;){
            String rowElementName = tableName + "Collection";
            Result result = new Result(rowElementName, tableName, null, null, 2);
            columnNames = this.getColumnNames(metaData, schema, dbName, tableName, null);
            OutputElementGroup defGroup = new OutputElementGroup(null, null, null, null);
            while (columnNames.next()) {
                String columnName = columnNames.getString("COLUMN_NAME");
                int typeInt = columnNames.getInt("DATA_TYPE");
                if (-1 == typeInt || -16 == typeInt || -15 == typeInt || 2009 == typeInt || 1111 == typeInt) {
                    typeInt = 1;
                }
                String type = DSSqlTypes.getQNameType(typeInt);
                QName qName = QueryFactory.getXsdTypeQName(type);
                HashSet<String> requiredRoles = new HashSet<String>();
                StaticOutputElement outputElement = new StaticOutputElement(dataServiceObject, columnName, columnName, columnName, "column", "element", null, qName, requiredRoles, 0, 0, null, 1, null);
                defGroup.addAttributeEntry(outputElement);
            }
            result.setDefaultElementGroup(defGroup);
            Result result2 = result;
            return result2;
        }
    }

    public DataService getGeneratedService() {
        return this.generatedService;
    }

    public List<DataService> getGeneratedServiceList() {
        return this.generatedServiceList;
    }
}

