/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.admin;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.activation.DataHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.dataservices.core.WSDLToDataService;
import org.wso2.carbon.dataservices.core.admin.DataServiceAdmin;

public class DataServiceFileUploader
extends DataServiceAdmin {
    private static final Log log = LogFactory.getLog(DataServiceFileUploader.class);

    public String uploadService(String fileName, String serviceHierarchy, DataHandler dataHandler) throws Exception {
        try {
            byte[] data = this.getByteArrayFromInputStream(dataHandler.getInputStream());
            String serviceContents = new String(data);
            String serviceName = fileName;
            int index = fileName.lastIndexOf("." + this.getDataServiceFileExtension());
            if (index != -1) {
                serviceName = serviceName.substring(0, index);
            }
            this.saveDataService(serviceName, serviceHierarchy, serviceContents);
        }
        catch (Exception e) {
            throw new Exception("Failed to upload the service archive " + fileName, e);
        }
        return "successful";
    }

    public String uploadWSDL(String fileName, DataHandler dataHandler) throws Exception {
        WSDLToDataService.deployDataService(this.getAxisConfig(), this.getByteArrayFromInputStream(dataHandler.getInputStream()));
        return "successful";
    }

    public String urlWsdlUpload(String url) throws Exception {
        URLConnection conn = new URL(url).openConnection();
        WSDLToDataService.deployDataService(this.getAxisConfig(), this.getByteArrayFromInputStream(conn.getInputStream()));
        return "successful";
    }

    private byte[] getByteArrayFromInputStream(InputStream in) throws Exception {
        int i;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        byte[] buff = new byte[512];
        while ((i = in.read(buff)) > 0) {
            byteOut.write(buff, 0, i);
        }
        in.close();
        return byteOut.toByteArray();
    }
}

