/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.custom.datasource;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.dataservices.core.custom.datasource.CustomDataSourceBase;
import org.wso2.carbon.ndatasource.common.DataSourceException;
import org.wso2.carbon.ndatasource.common.spi.DataSourceReader;
import org.wso2.carbon.ndatasource.core.utils.DataSourceUtils;
import org.wso2.carbon.ndatasource.rdbms.RDBMSConfiguration;
import org.wso2.carbon.utils.CarbonUtils;

public abstract class AbstractCustomDataSourceReader
implements DataSourceReader {
    private static final Log log = LogFactory.getLog(AbstractCustomDataSourceReader.class);

    public abstract String getType();

    public Object createDataSource(String xmlConfiguration, boolean isDataSourceFactoryReference) throws DataSourceException {
        CustomDataSourceInfo dsInfo = this.loadConfig(xmlConfiguration);
        try {
            CustomDataSourceBase customDS = (CustomDataSourceBase)Class.forName(dsInfo.getCustomDataSourceClass()).newInstance();
            Map<String, String> dsProps = this.extractProps(dsInfo);
            this.populateStandardProps(dsProps);
            customDS.init(dsProps);
            return customDS;
        }
        catch (Exception e) {
            throw new DataSourceException(e.getMessage(), e);
        }
    }

    private void populateStandardProps(Map<String, String> dsProps) {
        String dsInfo = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId() + "###" + DataSourceUtils.getCurrentDataSourceId();
        dsProps.put("__DATASOURCE_ID__", UUID.nameUUIDFromBytes(dsInfo.getBytes(Charset.forName("UTF-8"))).toString());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Custom Carbon Data Source; ID: " + dsInfo + " UUID:" + dsProps.get("__DATASOURCE_ID__")));
        }
    }

    private Map<String, String> extractProps(CustomDataSourceInfo dsInfo) {
        HashMap<String, String> props = new HashMap<String, String>();
        for (RDBMSConfiguration.DataSourceProperty prop : dsInfo.getCustomDataSourceProps()) {
            props.put(prop.getName(), prop.getValue());
        }
        return props;
    }

    private CustomDataSourceInfo loadConfig(String xmlConfiguration) throws DataSourceException {
        if (xmlConfiguration == null || xmlConfiguration.trim().length() == 0) {
            throw new DataSourceException("Invalid Data Services Custom DS Configuration");
        }
        try {
            xmlConfiguration = CarbonUtils.replaceSystemVariablesInXml((String)xmlConfiguration);
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{CustomDataSourceInfo.class});
            return (CustomDataSourceInfo)ctx.createUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(xmlConfiguration.getBytes()));
        }
        catch (Exception e) {
            throw new DataSourceException("Error in creating custom data source info: " + e.getMessage(), e);
        }
    }

    public boolean testDataSourceConnection(String xmlConfiguration) throws DataSourceException {
        return false;
    }

    @XmlRootElement(name="configuration")
    public static class CustomDataSourceInfo {
        private String customDataSourceClass;
        private List<RDBMSConfiguration.DataSourceProperty> customDataSourceProps;

        public String getCustomDataSourceClass() {
            return this.customDataSourceClass;
        }

        public void setCustomDataSourceClass(String customDataSourceClass) {
            this.customDataSourceClass = customDataSourceClass;
        }

        @XmlElementWrapper(name="customDataSourceProps")
        @XmlElement(name="property")
        public List<RDBMSConfiguration.DataSourceProperty> getCustomDataSourceProps() {
            return this.customDataSourceProps;
        }

        public void setCustomDataSourceProps(List<RDBMSConfiguration.DataSourceProperty> customDataSourceProps) {
            this.customDataSourceProps = customDataSourceProps;
        }
    }
}

