/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.description.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.description.event.EventTrigger;
import org.wso2.carbon.dataservices.core.description.query.Query;
import org.wso2.carbon.dataservices.core.description.query.SQLQuery;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.engine.InternalParam;
import org.wso2.carbon.dataservices.core.engine.InternalParamCollection;
import org.wso2.carbon.dataservices.core.engine.ParamValue;
import org.wso2.carbon.dataservices.core.engine.QueryParam;
import org.wso2.carbon.dataservices.core.engine.Result;

public abstract class ExpressionQuery
extends Query {
    private String query;
    private List<String> namedParamNames;
    private int paramCount;
    private static final String QUESTION_MARK = "?";

    public ExpressionQuery(DataService dataService, String queryId, List<QueryParam> queryParams, String query, Result result, String configId, EventTrigger inputEventTrigger, EventTrigger outputEventTrigger, Map<String, String> advancedProperties, String inputNamespace) {
        super(dataService, queryId, queryParams, result, configId, inputEventTrigger, outputEventTrigger, advancedProperties, inputNamespace);
        this.query = query;
    }

    public String getQuery() {
        return this.query;
    }

    public int getParamCount() {
        return this.paramCount;
    }

    protected void init(String query) throws DataServiceFault {
        this.processNamedParams(query);
        this.query = this.createPreprocessedQueryFromQueryString(query);
        this.paramCount = this.calculateParamCount(this.query);
    }

    private void processNamedParams(String query) {
        HashMap<String, QueryParam> paramMap = new HashMap<String, QueryParam>();
        for (QueryParam param : this.getQueryParams()) {
            paramMap.put(param.getName(), param);
        }
        List<String> paramNames = this.extractParamNames(query, paramMap.keySet());
        this.namedParamNames = new ArrayList<String>();
        HashSet<String> checkedQueryParams = new HashSet<String>();
        HashSet<Integer> processedOrdinalsForNamedParams = new HashSet<Integer>();
        for (int i = 0; i < paramNames.size(); ++i) {
            String tmpParamName;
            QueryParam tmpParam;
            String tmp = paramNames.get(i);
            if (tmp.equals(QUESTION_MARK) || (tmpParam = (QueryParam)paramMap.get(tmpParamName = tmp)) == null) continue;
            if (!checkedQueryParams.contains(tmpParamName)) {
                tmpParam.clearOrdinals();
                checkedQueryParams.add(tmpParamName);
            }
            this.namedParamNames.add(tmpParamName);
            int tmpOrdinal = i + 1;
            tmpParam.addOrdinal(tmpOrdinal);
            processedOrdinalsForNamedParams.add(tmpOrdinal);
        }
        this.cleanupProcessedNamedParams(checkedQueryParams, processedOrdinalsForNamedParams, paramMap);
    }

    private void cleanupProcessedNamedParams(Set<String> checkedQueryParams, Set<Integer> processedOrdinalsForNamedParams, Map<String, QueryParam> paramMap) {
        for (String paramName : paramMap.keySet()) {
            QueryParam tmpQueryParam;
            if (checkedQueryParams.contains(paramName) || !processedOrdinalsForNamedParams.contains((tmpQueryParam = paramMap.get(paramName)).getOrdinal())) continue;
            tmpQueryParam.setOrdinal(0);
        }
    }

    private void sortStringsByLength(List<String> values) {
        Collections.sort(values, new Comparator<String>(){

            @Override
            public int compare(String lhs, String rhs) {
                return lhs.length() - rhs.length();
            }
        });
    }

    private String createPreprocessedQueryFromQueryString(String query) {
        ArrayList<String> values = new ArrayList<String>(this.namedParamNames);
        this.sortStringsByLength(values);
        Collections.reverse(values);
        for (String val : values) {
            query = query.replaceAll(":" + val, QUESTION_MARK);
        }
        return query;
    }

    private List<String> extractParamNames(String query, Set<String> queryParams) {
        boolean doubleQuoteExists = false;
        boolean singleQuoteExists = false;
        ArrayList<String> paramNames = new ArrayList<String>();
        for (int i = 0; i < query.length(); ++i) {
            String tmpParam;
            if (query.charAt(i) == '\'') {
                singleQuoteExists = !singleQuoteExists;
                continue;
            }
            if (query.charAt(i) == '\"') {
                doubleQuoteExists = !doubleQuoteExists;
                continue;
            }
            if (query.charAt(i) == '?' && !doubleQuoteExists && !singleQuoteExists) {
                paramNames.add(QUESTION_MARK);
                continue;
            }
            if (query.charAt(i) != ':' || doubleQuoteExists || singleQuoteExists || i + 1 >= query.length() || !queryParams.contains(tmpParam = query.substring(i + 1, query.length()).split(" |,|\\)|\\(|:|\\r|\\n|\\.")[0])) continue;
            paramNames.add(tmpParam);
        }
        return paramNames;
    }

    private int calculateParamCount(String query) {
        int n = 0;
        boolean doubleQuoteExists = false;
        boolean singleQuoteExists = false;
        for (char ch : query.toCharArray()) {
            if (ch == '\'') {
                singleQuoteExists = !singleQuoteExists;
                continue;
            }
            if (ch == '\"') {
                doubleQuoteExists = !doubleQuoteExists;
                continue;
            }
            if (ch != '?' || doubleQuoteExists || singleQuoteExists) continue;
            ++n;
        }
        return n;
    }

    protected boolean isDynamicQuery(InternalParamCollection params) {
        boolean isDynamicQuery = false;
        for (int i = 1; i <= params.getData().size(); ++i) {
            InternalParam tmpParam = params.getParam(i);
            if (!"QUERY_STRING".equals(tmpParam.getSqlType())) continue;
            isDynamicQuery = true;
            break;
        }
        return isDynamicQuery;
    }

    protected String createProcessedQuery(String query, InternalParamCollection params, int paramCount) {
        String currentQuery = query;
        int start = 0;
        for (int i = 1; i <= paramCount; ++i) {
            InternalParam param = params.getParam(i);
            if (param == null) continue;
            ParamValue value = param.getValue();
            int count = value != null && value.getValueType() == 2 ? value.getArrayValue().size() : 1;
            Object[] vals = this.expandQuery(start, count, currentQuery);
            start = (Integer)vals[0];
            currentQuery = (String)vals[1];
        }
        return currentQuery;
    }

    private Object[] expandQuery(int start, int count, String query) {
        StringBuilder result = new StringBuilder();
        int n = query.length();
        boolean doubleQuoteExists = false;
        boolean singleQuoteExists = false;
        int end = n;
        for (int i = start; i < n; ++i) {
            if (query.charAt(i) == '\'') {
                singleQuoteExists = !singleQuoteExists;
                continue;
            }
            if (query.charAt(i) == '\"') {
                doubleQuoteExists = !doubleQuoteExists;
                continue;
            }
            if (query.charAt(i) != '?' || doubleQuoteExists || singleQuoteExists) continue;
            result.append(query.substring(0, i));
            result.append(this.generateQuestionMarks(count));
            end = result.length() + 1;
            if (i + 1 >= n) break;
            result.append(query.substring(i + 1));
            break;
        }
        return new Object[]{end, result.toString()};
    }

    private String generateQuestionMarks(int n) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            builder.append(QUESTION_MARK);
            if (i + 1 >= n) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    protected Object[] processDynamicQuery(String query, InternalParamCollection params) {
        Integer[] paramIndices = this.extractQueryParamIndices(query);
        HashMap<Integer, QueryParam> tempParams = new HashMap<Integer, QueryParam>();
        int currentOrdinalDiff = 0;
        int currentParamIndexDiff = 0;
        int resultParamCount = this.paramCount;
        for (QueryParam queryParam : this.getQueryParams()) {
            tempParams.put(queryParam.getOrdinal(), queryParam);
        }
        for (int i = 1; i <= this.paramCount; ++i) {
            InternalParam tmpParam = params.getParam(i);
            if (tmpParam == null && ((SQLQuery)this).getSqlQueryType() != SQLQuery.QueryType.UPDATE) {
                throw new RuntimeException("Parameters are not Defined Correctly, missing parameter ordinal - " + i);
            }
            if (tmpParam == null && !((QueryParam)tempParams.get(i)).isOptional()) {
                throw new RuntimeException("Parameters are not Defined Correctly, missing parameter ordinal - " + i);
            }
            if (tmpParam != null && !((QueryParam)tempParams.get(i)).isOptional() && "QUERY_STRING".equals(tmpParam.getSqlType())) {
                int paramIndex = paramIndices[i - 1] + currentParamIndexDiff;
                String tmpValue = params.getParam(i).getValue().getScalarValue();
                currentParamIndexDiff += tmpValue.length() - 1;
                query = paramIndex + 1 < query.length() ? query.substring(0, paramIndex) + tmpValue + query.substring(paramIndex + 1) : query.substring(0, paramIndex) + tmpValue;
                params.remove(i);
                ++currentOrdinalDiff;
                --resultParamCount;
                continue;
            }
            if (params.getParam(i) == null) continue;
            params.remove(i);
            tmpParam.setOrdinal(i - currentOrdinalDiff);
            params.addParam(tmpParam);
        }
        return new Object[]{query, resultParamCount};
    }

    private Integer[] extractQueryParamIndices(String query) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        boolean doubleQuoteExists = false;
        boolean singleQuoteExists = false;
        char[] data = query.toCharArray();
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == '\'') {
                singleQuoteExists = !singleQuoteExists;
                continue;
            }
            if (data[i] == '\"') {
                doubleQuoteExists = !doubleQuoteExists;
                continue;
            }
            if (data[i] != '?' || doubleQuoteExists || singleQuoteExists) continue;
            result.add(i);
        }
        return result.toArray(new Integer[result.size()]);
    }
}

