/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.engine;

import java.util.Set;
import org.apache.axis2.databinding.types.NCName;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.XSLTTransformer;
import org.wso2.carbon.dataservices.core.engine.OutputElementGroup;

public class Result {
    private String elementName;
    private String rowName;
    private String namespace;
    private XSLTTransformer xsltTransformer;
    private int resultType;
    private String rdfBaseURI;
    private OutputElementGroup defaultElementGroup;
    private boolean xsAny;
    private boolean useColumnNumbers;
    private boolean escapeNonPrintableChar;

    public Result(String xsltPath, int resultType) throws DataServiceFault {
        this(null, null, null, xsltPath, resultType);
    }

    public Result(String elementName, String rowName, String namespace, String xsltPath, int resultType) throws DataServiceFault {
        this.elementName = elementName;
        this.rowName = rowName;
        this.resultType = resultType;
        this.namespace = namespace;
        this.validateElementName(this.elementName);
        this.validateRowName(this.rowName);
        if (xsltPath != null) {
            try {
                this.xsltTransformer = new XSLTTransformer(xsltPath);
            }
            catch (Exception e) {
                throw new DataServiceFault(e, "Error in XSLT Transformation initialization in Result");
            }
        }
    }

    private void validateElementName(String elementName) throws DataServiceFault {
        if (this.resultType != 1 && this.elementName != null && this.elementName.trim().length() > 0 && !NCName.isValid((String)this.elementName)) {
            throw new DataServiceFault("Invalid wrapper element name: '" + this.elementName + "', must be an NCName.");
        }
    }

    private void validateRowName(String rowName) throws DataServiceFault {
        if (this.resultType != 1 && this.rowName != null && this.rowName.length() != 0 && !NCName.isValid((String)this.rowName)) {
            throw new DataServiceFault("Invalid row name: '" + this.rowName + "', must be an NCName.");
        }
    }

    public boolean isUseColumnNumbers() {
        return this.useColumnNumbers;
    }

    public void setUseColumnNumbers(boolean useColumnNumbers) {
        this.useColumnNumbers = useColumnNumbers;
    }

    public boolean isXsAny() {
        return this.xsAny;
    }

    public void setXsAny(boolean xsAny) {
        this.xsAny = xsAny;
    }

    public void setDefaultElementGroup(OutputElementGroup defaultElementGroup) {
        this.defaultElementGroup = defaultElementGroup;
    }

    public OutputElementGroup getDefaultElementGroup() {
        return this.defaultElementGroup;
    }

    public void setRDFBaseURI(String rdfBaseURI) {
        this.rdfBaseURI = rdfBaseURI;
    }

    public String getRDFBaseURI() {
        return this.rdfBaseURI;
    }

    public int getResultType() {
        return this.resultType;
    }

    public void setResultType(int resultType) {
        this.resultType = resultType;
    }

    public void applyUserRoles(Set<String> userRoles) {
        this.getDefaultElementGroup().applyUserRoles(userRoles);
    }

    public XSLTTransformer getXsltTransformer() {
        return this.xsltTransformer;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getElementName() {
        return this.elementName;
    }

    public void setElementName(String elementName) throws DataServiceFault {
        this.validateElementName(elementName);
        this.elementName = elementName;
    }

    public String getRowName() {
        return this.rowName;
    }

    public void setRowName(String rowName) throws DataServiceFault {
        this.validateRowName(rowName);
        this.rowName = rowName;
    }

    public boolean isEscapeNonPrintableChar() {
        return this.escapeNonPrintableChar;
    }

    public void setEscapeNonPrintableChar(boolean escapeNonPrintableChar) {
        this.escapeNonPrintableChar = escapeNonPrintableChar;
    }
}

