/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.odata.expression.operation;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataApplicationException;
import org.wso2.carbon.dataservices.core.odata.ODataConstants;
import org.wso2.carbon.dataservices.core.odata.expression.operand.TypedOperand;
import org.wso2.carbon.dataservices.core.odata.expression.operand.VisitorOperand;
import org.wso2.carbon.dataservices.core.odata.expression.primitive.EdmNull;

public class MethodCallOperator {
    private final List<VisitorOperand> parameters;

    public MethodCallOperator(List<VisitorOperand> parameters) {
        this.parameters = parameters;
    }

    public VisitorOperand endsWith() throws ODataApplicationException {
        return this.stringFunction(new StringFunction(){

            @Override
            public Object perform(List<String> params) {
                return params.get(0).endsWith(params.get(1));
            }
        }, (EdmType)ODataConstants.primitiveBoolean);
    }

    public VisitorOperand indexOf() throws ODataApplicationException {
        return this.stringFunction(new StringFunction(){

            @Override
            public Object perform(List<String> params) {
                return params.get(0).indexOf(params.get(1));
            }
        }, (EdmType)ODataConstants.primitiveInt32);
    }

    public VisitorOperand startsWith() throws ODataApplicationException {
        return this.stringFunction(new StringFunction(){

            @Override
            public Object perform(List<String> params) {
                return params.get(0).startsWith(params.get(1));
            }
        }, (EdmType)ODataConstants.primitiveBoolean);
    }

    public VisitorOperand toLower() throws ODataApplicationException {
        return this.stringFunction(new StringFunction(){

            @Override
            public Object perform(List<String> params) {
                return params.get(0).toLowerCase();
            }
        }, (EdmType)ODataConstants.primitiveString);
    }

    public VisitorOperand toUpper() throws ODataApplicationException {
        return this.stringFunction(new StringFunction(){

            @Override
            public Object perform(List<String> params) {
                return params.get(0).toUpperCase();
            }
        }, (EdmType)ODataConstants.primitiveString);
    }

    public VisitorOperand trim() throws ODataApplicationException {
        return this.stringFunction(new StringFunction(){

            @Override
            public Object perform(List<String> params) {
                return params.get(0).trim();
            }
        }, (EdmType)ODataConstants.primitiveString);
    }

    public VisitorOperand substring() throws ODataApplicationException {
        TypedOperand valueOperand = this.parameters.get(0).asTypedOperand();
        TypedOperand startOperand = this.parameters.get(1).asTypedOperand();
        if (valueOperand.isNull() || startOperand.isNull()) {
            return new TypedOperand(null, (EdmType)ODataConstants.primitiveString);
        }
        if (valueOperand.is(ODataConstants.primitiveString) && startOperand.isIntegerType()) {
            String value = valueOperand.getTypedValue(String.class);
            int start = Math.min(startOperand.getTypedValue(BigInteger.class).intValue(), value.length());
            start = start < 0 ? 0 : start;
            int end = value.length();
            if (this.parameters.size() == 3) {
                TypedOperand lengthOperand = this.parameters.get(2).asTypedOperand();
                if (lengthOperand.isNull()) {
                    return new TypedOperand(null, (EdmType)ODataConstants.primitiveString);
                }
                if (lengthOperand.isIntegerType()) {
                    end = Math.min(start + lengthOperand.getTypedValue(BigInteger.class).intValue(), value.length());
                    end = end < 0 ? 0 : end;
                } else {
                    throw new ODataApplicationException("Third substring parameter should be Edm.Int32", HttpStatusCode.BAD_REQUEST.getStatusCode(), Locale.ROOT);
                }
            }
            return new TypedOperand(value.substring(start, end), (EdmType)ODataConstants.primitiveString);
        }
        throw new ODataApplicationException("Substring has invalid parameters. First parameter should be Edm.String, second parameter should be Edm.Int32", HttpStatusCode.BAD_REQUEST.getStatusCode(), Locale.ROOT);
    }

    public VisitorOperand contains() throws ODataApplicationException {
        return this.stringFunction(new StringFunction(){

            @Override
            public Object perform(List<String> params) {
                return params.get(0).contains(params.get(1));
            }
        }, (EdmType)ODataConstants.primitiveBoolean);
    }

    public VisitorOperand concat() throws ODataApplicationException {
        return this.stringFunction(new StringFunction(){

            @Override
            public Object perform(List<String> params) {
                return params.get(0) + params.get(1);
            }
        }, (EdmType)ODataConstants.primitiveString);
    }

    public VisitorOperand length() throws ODataApplicationException {
        return this.stringFunction(new StringFunction(){

            @Override
            public Object perform(List<String> params) {
                return params.get(0).length();
            }
        }, (EdmType)ODataConstants.primitiveInt32);
    }

    public VisitorOperand year() throws ODataApplicationException {
        return this.dateFunction(new DateFunction(){

            @Override
            public Object perform(Calendar calendar, TypedOperand operand) {
                return calendar.get(1);
            }
        }, (EdmType)ODataConstants.primitiveInt32, ODataConstants.primitiveDateTimeOffset, ODataConstants.primitiveDate);
    }

    public VisitorOperand month() throws ODataApplicationException {
        return this.dateFunction(new DateFunction(){

            @Override
            public Object perform(Calendar calendar, TypedOperand operand) {
                return calendar.get(2) + 1;
            }
        }, (EdmType)ODataConstants.primitiveInt32, ODataConstants.primitiveDateTimeOffset, ODataConstants.primitiveDate);
    }

    public VisitorOperand day() throws ODataApplicationException {
        return this.dateFunction(new DateFunction(){

            @Override
            public Object perform(Calendar calendar, TypedOperand operand) {
                return calendar.get(5);
            }
        }, (EdmType)ODataConstants.primitiveInt32, ODataConstants.primitiveDateTimeOffset, ODataConstants.primitiveDate);
    }

    public VisitorOperand hour() throws ODataApplicationException {
        return this.dateFunction(new DateFunction(){

            @Override
            public Object perform(Calendar calendar, TypedOperand operand) {
                return calendar.get(11);
            }
        }, (EdmType)ODataConstants.primitiveInt32, ODataConstants.primitiveDateTimeOffset, ODataConstants.primitiveTimeOfDay);
    }

    public VisitorOperand minute() throws ODataApplicationException {
        return this.dateFunction(new DateFunction(){

            @Override
            public Object perform(Calendar calendar, TypedOperand operand) {
                return calendar.get(12);
            }
        }, (EdmType)ODataConstants.primitiveInt32, ODataConstants.primitiveDateTimeOffset, ODataConstants.primitiveTimeOfDay);
    }

    public VisitorOperand second() throws ODataApplicationException {
        return this.dateFunction(new DateFunction(){

            @Override
            public Object perform(Calendar calendar, TypedOperand operand) {
                return calendar.get(13);
            }
        }, (EdmType)ODataConstants.primitiveInt32, ODataConstants.primitiveDateTimeOffset, ODataConstants.primitiveTimeOfDay);
    }

    public VisitorOperand fractionalSeconds() throws ODataApplicationException {
        return this.dateFunction(new DateFunction(){

            @Override
            public Object perform(Calendar calendar, TypedOperand operand) {
                if (operand.getValue() instanceof Timestamp) {
                    return new BigDecimal(operand.getTypedValue(Timestamp.class).getNanos()).divide(BigDecimal.valueOf(1000000000L));
                }
                return new BigDecimal(calendar.get(14)).divide(BigDecimal.valueOf(1000L));
            }
        }, (EdmType)ODataConstants.primitiveDecimal, ODataConstants.primitiveDateTimeOffset, ODataConstants.primitiveTimeOfDay);
    }

    public VisitorOperand round() throws ODataApplicationException {
        TypedOperand operand = this.parameters.get(0).asTypedOperand();
        if (operand.isNull()) {
            return operand;
        }
        if (operand.isDecimalType()) {
            return new TypedOperand(operand.getTypedValue(BigDecimal.class).round(new MathContext(1, RoundingMode.HALF_UP)), operand.getType());
        }
        throw new ODataApplicationException("Invalid type", HttpStatusCode.BAD_REQUEST.getStatusCode(), Locale.ROOT);
    }

    public VisitorOperand floor() throws ODataApplicationException {
        TypedOperand operand = this.parameters.get(0).asTypedOperand();
        if (operand.isNull()) {
            return operand;
        }
        if (operand.isDecimalType()) {
            return new TypedOperand(operand.getTypedValue(BigDecimal.class).round(new MathContext(1, RoundingMode.FLOOR)), operand.getType());
        }
        throw new ODataApplicationException("Invalid type", HttpStatusCode.BAD_REQUEST.getStatusCode(), Locale.ROOT);
    }

    public VisitorOperand ceiling() throws ODataApplicationException {
        TypedOperand operand = this.parameters.get(0).asTypedOperand();
        if (operand.isNull()) {
            return operand;
        }
        if (operand.isDecimalType()) {
            return new TypedOperand(operand.getTypedValue(BigDecimal.class).round(new MathContext(1, RoundingMode.CEILING)), operand.getType());
        }
        throw new ODataApplicationException("Invalid type", HttpStatusCode.BAD_REQUEST.getStatusCode(), Locale.ROOT);
    }

    private VisitorOperand dateFunction(DateFunction function, EdmType returnType, EdmPrimitiveType ... expectedTypes) throws ODataApplicationException {
        TypedOperand operand = this.parameters.get(0).asTypedOperand();
        if (operand.isNull()) {
            return new TypedOperand(null, (EdmType)EdmNull.getInstance());
        }
        if (operand.is(expectedTypes)) {
            Calendar calendar;
            if (operand.is(ODataConstants.primitiveDate)) {
                calendar = operand.getTypedValue(Calendar.class);
            } else if (operand.is(ODataConstants.primitiveDateTimeOffset)) {
                Timestamp timestamp = operand.getTypedValue(Timestamp.class);
                calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                calendar.setTimeInMillis(timestamp.getTime());
            } else if (operand.is(ODataConstants.primitiveTimeOfDay)) {
                calendar = operand.getTypedValue(Calendar.class);
            } else {
                throw new ODataApplicationException("Invalid type", HttpStatusCode.BAD_REQUEST.getStatusCode(), Locale.ROOT);
            }
            return new TypedOperand(function.perform(calendar, operand), returnType);
        }
        throw new ODataApplicationException("Invalid type", HttpStatusCode.BAD_REQUEST.getStatusCode(), Locale.ROOT);
    }

    private VisitorOperand stringFunction(StringFunction function, EdmType returnValue) throws ODataApplicationException {
        List<String> stringParameters = this.getParametersAsString();
        if (stringParameters.contains(null)) {
            return new TypedOperand(null, (EdmType)EdmNull.getInstance());
        }
        return new TypedOperand(function.perform(stringParameters), returnValue);
    }

    private List<String> getParametersAsString() throws ODataApplicationException {
        ArrayList<String> result = new ArrayList<String>();
        for (VisitorOperand param : this.parameters) {
            TypedOperand operand = param.asTypedOperand();
            if (operand.isNull()) {
                result.add(null);
                continue;
            }
            if (operand.is(ODataConstants.primitiveString)) {
                result.add(operand.getTypedValue(String.class));
                continue;
            }
            throw new ODataApplicationException("Invalid parameter. Expected Edm.String", HttpStatusCode.BAD_REQUEST.getStatusCode(), Locale.ROOT);
        }
        return result;
    }

    private static interface DateFunction {
        public Object perform(Calendar var1, TypedOperand var2);
    }

    private static interface StringFunction {
        public Object perform(List<String> var1);
    }
}

