/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.custom.datasource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.custom.datasource.CustomQueryBasedDS;
import org.wso2.carbon.dataservices.core.custom.datasource.DataColumn;
import org.wso2.carbon.dataservices.core.custom.datasource.DataRow;
import org.wso2.carbon.dataservices.core.custom.datasource.FixedDataRow;
import org.wso2.carbon.dataservices.core.custom.datasource.QueryResult;
import org.wso2.carbon.dataservices.core.engine.InternalParam;

public class EchoDataSource
implements CustomQueryBasedDS {
    private static final Log log = LogFactory.getLog(EchoDataSource.class);

    @Override
    public void init(Map<String, String> props) throws DataServiceFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Echo DataSource Props:" + props));
        }
    }

    @Override
    public void close() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Closing Echo DataSource");
        }
    }

    @Override
    public QueryResult executeQuery(String query, List<InternalParam> params) throws DataServiceFault {
        return new EchoQueryResult(query, params);
    }

    public class EchoQueryResult
    implements QueryResult {
        private String[] data;
        private int current = 1;
        private List<InternalParam> params;

        public EchoQueryResult(String query, List<InternalParam> params) {
            this.data = query.split(";");
            this.params = params;
        }

        @Override
        public List<DataColumn> getDataColumns() throws DataServiceFault {
            String[] columns;
            ArrayList<DataColumn> result = new ArrayList<DataColumn>();
            for (String column : columns = this.data[0].split(",")) {
                result.add(new DataColumn(column));
            }
            return result;
        }

        @Override
        public boolean hasNext() throws DataServiceFault {
            return this.current < this.data.length;
        }

        @Override
        public DataRow next() throws DataServiceFault {
            List<DataColumn> dataColumns = this.getDataColumns();
            String[] cols = this.data[this.current].split(",");
            HashMap<String, String> rowData = new HashMap<String, String>();
            for (int i = 0; i < cols.length; ++i) {
                for (int j = 0; j < this.params.size(); ++j) {
                    cols[i] = cols[i].replaceAll(":" + this.params.get(j).getName(), this.params.get(j).getValue().getValueAsString());
                }
                rowData.put(dataColumns.get(i).getName(), cols[i]);
            }
            ++this.current;
            return new FixedDataRow(rowData);
        }
    }
}

