/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.engine;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.commons.io.output.NullOutputStream;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.engine.ParamValue;

public class DSOMDataSource
implements OMDataSource {
    private static final int XMLREADER_DEFAULT_MESSAGE_SIZE = 1024;
    private DataService dataService;
    private String opName;
    private Map<String, ParamValue> params;

    public DSOMDataSource(DataService dataService, String opName, Map<String, ParamValue> params) {
        this.dataService = dataService;
        this.opName = opName;
        this.params = params;
    }

    public DataService getDataService() {
        return this.dataService;
    }

    public String getOpName() {
        return this.opName;
    }

    public Map<String, ParamValue> getParams() {
        return this.params;
    }

    public void executeInOnly() throws XMLStreamException {
        XMLStreamWriter xmlWriter = DBUtils.getXMLOutputFactory().createXMLStreamWriter((OutputStream)new NullOutputStream());
        this.serialize(xmlWriter);
    }

    public void serialize(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        XMLStreamWriter xmlWriter = DBUtils.getXMLOutputFactory().createXMLStreamWriter(output);
        this.serialize(xmlWriter);
    }

    public void serialize(Writer writer, OMOutputFormat format) throws XMLStreamException {
        XMLStreamWriter xmlWriter = DBUtils.getXMLOutputFactory().createXMLStreamWriter(writer);
        this.serialize(xmlWriter);
    }

    public void execute(XMLStreamWriter xmlWriter) throws XMLStreamException {
        try {
            this.getDataService().invoke(xmlWriter, this.getOpName(), this.getParams());
            if (xmlWriter != null) {
                xmlWriter.flush();
            }
        }
        catch (DataServiceFault e) {
            throw new XMLStreamException(e.getMessage(), e);
        }
    }

    public void serialize(XMLStreamWriter xmlWriter) throws XMLStreamException {
        this.execute(xmlWriter);
    }

    public XMLStreamReader getReader() throws XMLStreamException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream(1024);
        XMLStreamWriter xmlWriter = DBUtils.getXMLOutputFactory().createXMLStreamWriter(byteOut);
        this.serialize(xmlWriter);
        xmlWriter.close();
        ByteArrayInputStream byteIn = new ByteArrayInputStream(byteOut.toByteArray());
        return DBUtils.getXMLInputFactory().createXMLStreamReader(byteIn);
    }
}

