/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.odata;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TableMetadata;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.apache.commons.codec.binary.Base64;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.odata.DataColumn;
import org.wso2.carbon.dataservices.core.odata.NavigationTable;
import org.wso2.carbon.dataservices.core.odata.ODataDataHandler;
import org.wso2.carbon.dataservices.core.odata.ODataEntry;
import org.wso2.carbon.dataservices.core.odata.ODataServiceFault;
import org.wso2.carbon.dataservices.core.odata.ODataUtils;

public class CassandraDataHandler
implements ODataDataHandler {
    private Map<String, Map<String, DataColumn>> tableMetaData;
    private Map<String, List<String>> primaryKeys;
    private final String configID;
    private List<String> tableList;
    private final Session session;
    private final String keyspace;
    private ThreadLocal<Boolean> transactionAvailable = new ThreadLocal<Boolean>(){

        @Override
        protected synchronized Boolean initialValue() {
            return false;
        }
    };
    private static final int RECORD_INSERT_STATEMENTS_CACHE_SIZE = 10000;
    private Map<String, PreparedStatement> preparedStatementMap = Collections.synchronizedMap(new LinkedHashMap<String, PreparedStatement>(){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, PreparedStatement> eldest) {
            return super.size() > 10000;
        }
    });

    public CassandraDataHandler(String configID, Session session, String keyspace) {
        this.configID = configID;
        this.session = session;
        this.keyspace = keyspace;
        this.tableList = this.generateTableList();
        this.primaryKeys = this.generatePrimaryKeyList();
        this.tableMetaData = this.generateMetaData();
    }

    @Override
    public List<ODataEntry> readTable(String tableName) throws ODataServiceFault {
        SimpleStatement statement = new SimpleStatement("Select * from " + this.keyspace + "." + tableName);
        ResultSet resultSet = this.session.execute((Statement)statement);
        Iterator iterator = resultSet.iterator();
        ArrayList<ODataEntry> entryList = new ArrayList<ODataEntry>();
        ColumnDefinitions columnDefinitions = resultSet.getColumnDefinitions();
        while (iterator.hasNext()) {
            ODataEntry dataEntry = this.createDataEntryFromRow(tableName, (Row)iterator.next(), columnDefinitions);
            entryList.add(dataEntry);
        }
        return entryList;
    }

    @Override
    public List<ODataEntry> readTableWithKeys(String tableName, ODataEntry keys) throws ODataServiceFault {
        List cassandraTableMetaData = this.session.getCluster().getMetadata().getKeyspace(this.keyspace).getTable(tableName).getColumns();
        List<String> pKeys = this.primaryKeys.get(tableName);
        String query = this.createReadSqlWithKeys(tableName, keys);
        ArrayList<Object> values = new ArrayList<Object>();
        for (String column : this.tableMetaData.get(tableName).keySet()) {
            if (!keys.getNames().contains(column) || !pKeys.contains(column)) continue;
            this.bindParams(column, keys.getValue(column), values, cassandraTableMetaData);
        }
        PreparedStatement statement = this.preparedStatementMap.get(query);
        if (statement == null) {
            statement = this.session.prepare(query);
            this.preparedStatementMap.put(query, statement);
        }
        ResultSet resultSet = this.session.execute((Statement)statement.bind(values.toArray()));
        ArrayList<ODataEntry> entryList = new ArrayList<ODataEntry>();
        Iterator iterator = resultSet.iterator();
        ColumnDefinitions definitions = resultSet.getColumnDefinitions();
        while (iterator.hasNext()) {
            ODataEntry dataEntry = this.createDataEntryFromRow(tableName, (Row)iterator.next(), definitions);
            entryList.add(dataEntry);
        }
        return entryList;
    }

    @Override
    public ODataEntry insertEntityToTable(String tableName, ODataEntry entity) throws ODataServiceFault {
        List cassandraTableMetaData = this.session.getCluster().getMetadata().getKeyspace(this.keyspace).getTable(tableName).getColumns();
        for (String pkey : this.primaryKeys.get(tableName)) {
            if (!this.tableMetaData.get(tableName).get(pkey).getColumnType().equals((Object)DataColumn.ODataDataType.GUID) || entity.getValue(pkey) != null) continue;
            UUID uuid = UUID.randomUUID();
            entity.addValue(pkey, uuid.toString());
        }
        String query = this.createInsertCQL(tableName, entity);
        ArrayList<Object> values = new ArrayList<Object>();
        for (DataColumn column : this.tableMetaData.get(tableName).values()) {
            String columnName = column.getColumnName();
            if (!entity.getNames().contains(columnName) || entity.getValue(columnName) == null) continue;
            this.bindParams(columnName, entity.getValue(columnName), values, cassandraTableMetaData);
        }
        PreparedStatement statement = this.preparedStatementMap.get(query);
        if (statement == null) {
            statement = this.session.prepare(query);
            this.preparedStatementMap.put(query, statement);
        }
        this.session.execute((Statement)statement.bind(values.toArray()));
        entity.addValue("E_TAG", ODataUtils.generateETag(this.configID, tableName, entity));
        return entity;
    }

    @Override
    public boolean deleteEntityInTable(String tableName, ODataEntry entity) throws ODataServiceFault {
        if (this.transactionAvailable.get().booleanValue()) {
            return this.deleteEntityInTableTransactional(tableName, entity);
        }
        return this.deleteEntityTableNonTransactional(tableName, entity);
    }

    private boolean deleteEntityTableNonTransactional(String tableName, ODataEntry entity) throws ODataServiceFault {
        List cassandraTableMetaData = this.session.getCluster().getMetadata().getKeyspace(this.keyspace).getTable(tableName).getColumns();
        List<String> pKeys = this.primaryKeys.get(tableName);
        String query = this.createDeleteCQL(tableName);
        ArrayList<Object> values = new ArrayList<Object>();
        for (String column : pKeys) {
            if (!entity.getNames().contains(column)) continue;
            this.bindParams(column, entity.getValue(column), values, cassandraTableMetaData);
        }
        PreparedStatement statement = this.preparedStatementMap.get(query);
        if (statement == null) {
            statement = this.session.prepare(query);
            this.preparedStatementMap.put(query, statement);
        }
        ResultSet result = this.session.execute((Statement)statement.bind(values.toArray()));
        return result.wasApplied();
    }

    private boolean deleteEntityInTableTransactional(String tableName, ODataEntry entity) throws ODataServiceFault {
        List cassandraTableMetaData = this.session.getCluster().getMetadata().getKeyspace(this.keyspace).getTable(tableName).getColumns();
        List<String> pKeys = this.primaryKeys.get(tableName);
        String query = this.createDeleteTransactionalCQL(tableName, entity);
        ArrayList<Object> values = new ArrayList<Object>();
        for (String column : entity.getNames()) {
            if (!pKeys.contains(column)) continue;
            this.bindParams(column, entity.getValue(column), values, cassandraTableMetaData);
        }
        for (String column : entity.getNames()) {
            if (pKeys.contains(column)) continue;
            this.bindParams(column, entity.getValue(column), values, cassandraTableMetaData);
        }
        PreparedStatement statement = this.preparedStatementMap.get(query);
        if (statement == null) {
            statement = this.session.prepare(query);
            this.preparedStatementMap.put(query, statement);
        }
        ResultSet result = this.session.execute((Statement)statement.bind(values.toArray()));
        return result.wasApplied();
    }

    @Override
    public boolean updateEntityInTable(String tableName, ODataEntry newProperties) throws ODataServiceFault {
        List cassandraTableMetaData = this.session.getCluster().getMetadata().getKeyspace(this.keyspace).getTable(tableName).getColumns();
        List<String> pKeys = this.primaryKeys.get(tableName);
        String query = this.createUpdateEntityCQL(tableName, newProperties);
        ArrayList<Object> values = new ArrayList<Object>();
        for (String column : newProperties.getNames()) {
            if (!this.tableMetaData.get(tableName).keySet().contains(column) || pKeys.contains(column)) continue;
            this.bindParams(column, newProperties.getValue(column), values, cassandraTableMetaData);
        }
        for (String column : newProperties.getNames()) {
            if (!pKeys.contains(column)) continue;
            this.bindParams(column, newProperties.getValue(column), values, cassandraTableMetaData);
        }
        PreparedStatement statement = this.preparedStatementMap.get(query);
        if (statement == null) {
            statement = this.session.prepare(query);
            this.preparedStatementMap.put(query, statement);
        }
        ResultSet result = this.session.execute((Statement)statement.bind(values.toArray()));
        return result.wasApplied();
    }

    @Override
    public boolean updateEntityInTableTransactional(String tableName, ODataEntry oldProperties, ODataEntry newProperties) throws ODataServiceFault {
        List cassandraTableMetaData = this.session.getCluster().getMetadata().getKeyspace(this.keyspace).getTable(tableName).getColumns();
        List<String> pKeys = this.primaryKeys.get(tableName);
        String query = this.createUpdateEntityTransactionalCQL(tableName, oldProperties, newProperties);
        ArrayList<Object> values = new ArrayList<Object>();
        for (String column : newProperties.getNames()) {
            if (!this.tableMetaData.get(tableName).keySet().contains(column) || pKeys.contains(column)) continue;
            this.bindParams(column, newProperties.getValue(column), values, cassandraTableMetaData);
        }
        for (String column : oldProperties.getNames()) {
            if (!pKeys.contains(column)) continue;
            this.bindParams(column, oldProperties.getValue(column), values, cassandraTableMetaData);
        }
        for (String column : oldProperties.getNames()) {
            if (pKeys.contains(column)) continue;
            this.bindParams(column, oldProperties.getValue(column), values, cassandraTableMetaData);
        }
        PreparedStatement statement = this.preparedStatementMap.get(query);
        if (statement == null) {
            statement = this.session.prepare(query);
            this.preparedStatementMap.put(query, statement);
        }
        ResultSet result = this.session.execute((Statement)statement.bind(values.toArray()));
        return result.wasApplied();
    }

    @Override
    public Map<String, Map<String, DataColumn>> getTableMetadata() {
        return this.tableMetaData;
    }

    @Override
    public List<String> getTableList() {
        return this.tableList;
    }

    @Override
    public Map<String, List<String>> getPrimaryKeys() {
        return this.primaryKeys;
    }

    @Override
    public Map<String, NavigationTable> getNavigationProperties() {
        return null;
    }

    @Override
    public void openTransaction() throws ODataServiceFault {
        this.transactionAvailable.set(true);
    }

    @Override
    public void commitTransaction() {
        this.transactionAvailable.set(false);
    }

    @Override
    public void rollbackTransaction() throws ODataServiceFault {
        this.transactionAvailable.set(false);
    }

    @Override
    public void updateReference(String rootTableName, ODataEntry rootTableKeys, String navigationTable, ODataEntry navigationTableKeys) throws ODataServiceFault {
        throw new ODataServiceFault("Cassandra datasources doesn't support references.");
    }

    @Override
    public void deleteReference(String rootTableName, ODataEntry rootTableKeys, String navigationTable, ODataEntry navigationTableKeys) throws ODataServiceFault {
        throw new ODataServiceFault("Cassandra datasources doesn't support references.");
    }

    private ODataEntry createDataEntryFromRow(String tableName, Row row, ColumnDefinitions columnDefinitions) throws ODataServiceFault {
        ODataEntry entry = new ODataEntry();
        try {
            for (int i = 0; i < columnDefinitions.size(); ++i) {
                String paramValue;
                String columnName = columnDefinitions.getName(i);
                DataType columnType = columnDefinitions.getType(i);
                switch (columnType.getName()) {
                    case ASCII: {
                        paramValue = row.getString(i);
                        break;
                    }
                    case BIGINT: {
                        paramValue = row.isNull(i) ? null : ConverterUtil.convertToString((long)row.getLong(i));
                        break;
                    }
                    case BLOB: {
                        paramValue = this.base64EncodeByteBuffer(row.getBytes(i));
                        break;
                    }
                    case BOOLEAN: {
                        paramValue = row.isNull(i) ? null : ConverterUtil.convertToString((boolean)row.getBool(i));
                        break;
                    }
                    case COUNTER: {
                        paramValue = row.isNull(i) ? null : ConverterUtil.convertToString((long)row.getLong(i));
                        break;
                    }
                    case DECIMAL: {
                        paramValue = row.isNull(i) ? null : ConverterUtil.convertToString((BigDecimal)row.getDecimal(i));
                        break;
                    }
                    case DOUBLE: {
                        paramValue = row.isNull(i) ? null : ConverterUtil.convertToString((double)row.getDouble(i));
                        break;
                    }
                    case FLOAT: {
                        paramValue = row.isNull(i) ? null : ConverterUtil.convertToString((float)row.getFloat(i));
                        break;
                    }
                    case INET: {
                        paramValue = row.getInet(i).toString();
                        break;
                    }
                    case INT: {
                        paramValue = row.isNull(i) ? null : ConverterUtil.convertToString((int)row.getInt(i));
                        break;
                    }
                    case TEXT: {
                        paramValue = row.getString(i);
                        break;
                    }
                    case TIMESTAMP: {
                        paramValue = row.isNull(i) ? null : ConverterUtil.convertToString((Object)row.getDate(i));
                        break;
                    }
                    case UUID: {
                        paramValue = row.isNull(i) ? null : ConverterUtil.convertToString((Object)row.getUUID(i));
                        break;
                    }
                    case VARCHAR: {
                        paramValue = row.getString(i);
                        break;
                    }
                    case VARINT: {
                        paramValue = row.isNull(i) ? null : ConverterUtil.convertToString((BigInteger)row.getVarint(i));
                        break;
                    }
                    case TIMEUUID: {
                        paramValue = row.isNull(i) ? null : ConverterUtil.convertToString((Object)row.getUUID(i));
                        break;
                    }
                    case LIST: {
                        paramValue = row.isNull(i) ? null : Arrays.toString(row.getList(i, Object.class).toArray());
                        break;
                    }
                    case SET: {
                        paramValue = row.isNull(i) ? null : row.getSet(i, Object.class).toString();
                        break;
                    }
                    case MAP: {
                        paramValue = row.isNull(i) ? null : row.getMap(i, Object.class, Object.class).toString();
                        break;
                    }
                    case UDT: {
                        paramValue = row.isNull(i) ? null : row.getUDTValue(i).toString();
                        break;
                    }
                    case TUPLE: {
                        paramValue = row.isNull(i) ? null : row.getTupleValue(i).toString();
                        break;
                    }
                    case CUSTOM: {
                        paramValue = row.isNull(i) ? null : this.base64EncodeByteBuffer(row.getBytes(i));
                        break;
                    }
                    default: {
                        paramValue = row.getString(i);
                    }
                }
                entry.addValue(columnName, paramValue);
            }
        }
        catch (DataServiceFault e) {
            throw new ODataServiceFault(e, "Error occurred when creating OData entry. :" + e.getMessage());
        }
        entry.addValue("ETag", ODataUtils.generateETag(this.configID, tableName, entry));
        return entry;
    }

    private List<String> generateTableList() {
        ArrayList<String> tableList = new ArrayList<String>();
        for (TableMetadata tableMetadata : this.session.getCluster().getMetadata().getKeyspace(this.keyspace).getTables()) {
            tableList.add(tableMetadata.getName());
        }
        return tableList;
    }

    private Map<String, List<String>> generatePrimaryKeyList() {
        HashMap<String, List<String>> primaryKeyMap = new HashMap<String, List<String>>();
        for (String tableName : this.tableList) {
            ArrayList<String> primaryKey = new ArrayList<String>();
            for (ColumnMetadata columnMetadata : this.session.getCluster().getMetadata().getKeyspace(this.keyspace).getTable(tableName).getPrimaryKey()) {
                primaryKey.add(columnMetadata.getName());
            }
            primaryKeyMap.put(tableName, primaryKey);
        }
        return primaryKeyMap;
    }

    private Map<String, Map<String, DataColumn>> generateMetaData() {
        HashMap<String, Map<String, DataColumn>> metadata = new HashMap<String, Map<String, DataColumn>>();
        for (String tableName : this.tableList) {
            HashMap<String, DataColumn> dataColumnMap = new HashMap<String, DataColumn>();
            for (ColumnMetadata columnMetadata : this.session.getCluster().getMetadata().getKeyspace(this.keyspace).getTable(tableName).getColumns()) {
                DataColumn dataColumn = this.primaryKeys.get(tableName).contains(columnMetadata.getName()) ? new DataColumn(columnMetadata.getName(), this.getDataType(columnMetadata.getType().getName()), false) : new DataColumn(columnMetadata.getName(), this.getDataType(columnMetadata.getType().getName()), true);
                dataColumnMap.put(dataColumn.getColumnName(), dataColumn);
            }
            metadata.put(tableName, dataColumnMap);
        }
        return metadata;
    }

    private void bindParams(String columnName, String value, List<Object> values, List<ColumnMetadata> metaData) throws ODataServiceFault {
        DataType.Name dataType = null;
        for (ColumnMetadata columnMetadata : metaData) {
            if (!columnMetadata.getName().equals(columnName)) continue;
            dataType = columnMetadata.getType().getName();
            break;
        }
        if (dataType == null) {
            throw new ODataServiceFault("Error occurred when binding data. DataType was missing for " + columnName + " column.");
        }
        try {
            switch (dataType) {
                case ASCII: 
                case TEXT: 
                case VARCHAR: 
                case TIMEUUID: {
                    values.add(value);
                    break;
                }
                case UUID: {
                    values.add(value == null ? null : UUID.fromString(value));
                    break;
                }
                case BIGINT: {
                    values.add(value == null ? null : Long.valueOf(Long.parseLong(value)));
                    break;
                }
                case COUNTER: 
                case VARINT: {
                    values.add(value == null ? null : value);
                    break;
                }
                case BLOB: {
                    values.add(value == null ? null : this.base64DecodeByteBuffer(value));
                    break;
                }
                case BOOLEAN: {
                    values.add(value == null ? null : Boolean.valueOf(Boolean.parseBoolean(value)));
                    break;
                }
                case DECIMAL: {
                    values.add(value == null ? null : new BigDecimal(value));
                    break;
                }
                case DOUBLE: {
                    values.add(value == null ? null : Double.valueOf(Double.parseDouble(value)));
                    break;
                }
                case FLOAT: {
                    values.add(value == null ? null : Float.valueOf(Float.parseFloat(value)));
                    break;
                }
                case INT: {
                    values.add(value == null ? null : Integer.valueOf(Integer.parseInt(value)));
                    break;
                }
                case TIMESTAMP: {
                    values.add(value == null ? null : DBUtils.getTimestamp(value));
                    break;
                }
                case TIME: {
                    values.add(value == null ? null : DBUtils.getTime(value));
                    break;
                }
                case DATE: {
                    values.add(value == null ? null : DBUtils.getDate(value));
                    break;
                }
                default: {
                    values.add(value);
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new ODataServiceFault(e, "Error occurred when binding data. :" + e.getMessage());
        }
    }

    private DataColumn.ODataDataType getDataType(DataType.Name dataTypeName) {
        DataColumn.ODataDataType dataType;
        switch (dataTypeName) {
            case ASCII: 
            case TEXT: 
            case VARCHAR: 
            case TIMEUUID: {
                dataType = DataColumn.ODataDataType.STRING;
                break;
            }
            case UUID: {
                dataType = DataColumn.ODataDataType.GUID;
                break;
            }
            case BIGINT: 
            case COUNTER: 
            case VARINT: {
                dataType = DataColumn.ODataDataType.INT64;
                break;
            }
            case BLOB: {
                dataType = DataColumn.ODataDataType.BINARY;
                break;
            }
            case BOOLEAN: {
                dataType = DataColumn.ODataDataType.BOOLEAN;
                break;
            }
            case DECIMAL: 
            case FLOAT: {
                dataType = DataColumn.ODataDataType.DECIMAL;
                break;
            }
            case DOUBLE: {
                dataType = DataColumn.ODataDataType.DOUBLE;
                break;
            }
            case INT: {
                dataType = DataColumn.ODataDataType.INT32;
                break;
            }
            case TIMESTAMP: {
                dataType = DataColumn.ODataDataType.DATE_TIMEOFFSET;
                break;
            }
            case TIME: {
                dataType = DataColumn.ODataDataType.TIMEOFDAY;
                break;
            }
            case DATE: {
                dataType = DataColumn.ODataDataType.DATE;
                break;
            }
            default: {
                dataType = DataColumn.ODataDataType.STRING;
            }
        }
        return dataType;
    }

    private String createUpdateEntityCQL(String tableName, ODataEntry newProperties) {
        List<String> pKeys = this.primaryKeys.get(tableName);
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ").append(tableName).append(" SET ");
        boolean propertyMatch = false;
        for (String column : newProperties.getNames()) {
            if (pKeys.contains(column)) continue;
            if (propertyMatch) {
                sql.append(",");
            }
            sql.append(column).append(" = ").append(" ? ");
            propertyMatch = true;
        }
        sql.append(" WHERE ");
        propertyMatch = false;
        for (String key : pKeys) {
            if (propertyMatch) {
                sql.append(" AND ");
            }
            sql.append(key).append(" = ").append(" ? ");
            propertyMatch = true;
        }
        return sql.toString();
    }

    private String createUpdateEntityTransactionalCQL(String tableName, ODataEntry oldProperties, ODataEntry newProperties) {
        List<String> pKeys = this.primaryKeys.get(tableName);
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ").append(tableName).append(" SET ");
        boolean propertyMatch = false;
        for (String column : newProperties.getNames()) {
            if (pKeys.contains(column)) continue;
            if (propertyMatch) {
                sql.append(",");
            }
            sql.append(column).append(" = ").append(" ? ");
            propertyMatch = true;
        }
        sql.append(" WHERE ");
        propertyMatch = false;
        for (String key : pKeys) {
            if (propertyMatch) {
                sql.append(" AND ");
            }
            sql.append(key).append(" = ").append(" ? ");
            propertyMatch = true;
        }
        sql.append(" IF ");
        propertyMatch = false;
        for (String column : oldProperties.getNames()) {
            if (pKeys.contains(column)) continue;
            if (propertyMatch) {
                sql.append(" AND ");
            }
            sql.append(column).append(" = ").append(" ? ");
            propertyMatch = true;
        }
        return sql.toString();
    }

    private String createInsertCQL(String tableName, ODataEntry entry) {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ").append(tableName).append(" (");
        boolean propertyMatch = false;
        for (DataColumn column : this.tableMetaData.get(tableName).values()) {
            if (entry.getValue(column.getColumnName()) == null) continue;
            if (propertyMatch) {
                sql.append(",");
            }
            sql.append(column.getColumnName());
            propertyMatch = true;
        }
        sql.append(" ) VALUES ( ");
        propertyMatch = false;
        for (DataColumn column : this.tableMetaData.get(tableName).values()) {
            if (entry.getValue(column.getColumnName()) == null) continue;
            if (propertyMatch) {
                sql.append(",");
            }
            sql.append(" ? ");
            propertyMatch = true;
        }
        sql.append(" ) ");
        return sql.toString();
    }

    private String createReadSqlWithKeys(String tableName, ODataEntry keys) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT * FROM ").append(tableName).append(" WHERE ");
        boolean propertyMatch = false;
        for (DataColumn column : this.tableMetaData.get(tableName).values()) {
            if (keys.getValue(column.getColumnName()) == null) continue;
            if (propertyMatch) {
                sql.append(" AND ");
            }
            sql.append(column.getColumnName()).append(" = ").append(" ? ");
            propertyMatch = true;
        }
        return sql.toString();
    }

    private String createDeleteCQL(String tableName) {
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM ").append(tableName).append(" WHERE ");
        List<String> pKeys = this.primaryKeys.get(tableName);
        boolean propertyMatch = false;
        for (String key : pKeys) {
            if (propertyMatch) {
                sql.append(" AND ");
            }
            sql.append(key).append(" = ").append(" ? ");
            propertyMatch = true;
        }
        return sql.toString();
    }

    private String createDeleteTransactionalCQL(String tableName, ODataEntry entry) {
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM ").append(tableName).append(" WHERE ");
        List<String> pKeys = this.primaryKeys.get(tableName);
        boolean propertyMatch = false;
        for (String key : entry.getNames()) {
            if (!pKeys.contains(key)) continue;
            if (propertyMatch) {
                sql.append(" AND ");
            }
            sql.append(key).append(" = ").append(" ? ");
            propertyMatch = true;
        }
        sql.append(" IF ");
        propertyMatch = false;
        for (String column : entry.getNames()) {
            if (pKeys.contains(column)) continue;
            if (propertyMatch) {
                sql.append(" AND ");
            }
            sql.append(column).append(" = ").append(" ? ");
            propertyMatch = true;
        }
        return sql.toString();
    }

    private String base64EncodeByteBuffer(ByteBuffer byteBuffer) throws ODataServiceFault {
        byte[] data = byteBuffer.array();
        byte[] base64Data = Base64.encodeBase64((byte[])data);
        try {
            return new String(base64Data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ODataServiceFault(e, "Error in encoding result binary data: " + e.getMessage());
        }
    }

    private ByteBuffer base64DecodeByteBuffer(String data) throws ODataServiceFault {
        try {
            byte[] buff = Base64.decodeBase64((byte[])data.getBytes("UTF-8"));
            ByteBuffer result = ByteBuffer.allocate(buff.length);
            result.put(buff);
            return result;
        }
        catch (UnsupportedEncodingException e) {
            throw new ODataServiceFault(e, "Error in decoding input base64 data: " + e.getMessage());
        }
    }
}

