/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.WSDL11ToAxisServiceBuilder;
import org.apache.axis2.description.WSDL20ToAxisServiceBuilder;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.schema.CompilerOptions;
import org.apache.axis2.schema.SchemaCompilationException;
import org.apache.axis2.schema.SchemaCompiler;
import org.apache.axis2.util.XMLPrettyPrinter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.XmlSchemaAttribute;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.auth.UserStoreAuthorizationProvider;
import org.wso2.carbon.dataservices.core.description.config.Config;
import org.wso2.carbon.dataservices.core.description.config.RDBMSConfig;
import org.wso2.carbon.dataservices.core.description.operation.Operation;
import org.wso2.carbon.dataservices.core.description.query.SQLQuery;
import org.wso2.carbon.dataservices.core.engine.CallQuery;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.engine.DataServiceSerializer;
import org.wso2.carbon.dataservices.core.engine.OutputElementGroup;
import org.wso2.carbon.dataservices.core.engine.QueryParam;
import org.wso2.carbon.dataservices.core.engine.Result;
import org.wso2.carbon.dataservices.core.engine.StaticOutputElement;
import org.wso2.carbon.dataservices.core.validation.Validator;

public class WSDLToDataService {
    private static final Log log = LogFactory.getLog(WSDLToDataService.class);
    private static final String WSDL20_ROOT_ELEMENT = "description";

    private WSDLToDataService() {
    }

    private static boolean isWSDL20(byte[] wsdlContent) throws DataServiceFault {
        try {
            return AXIOMUtil.stringToOM((String)new String(wsdlContent, "UTF-8")).getLocalName().equals(WSDL20_ROOT_ELEMENT);
        }
        catch (Exception e) {
            throw new DataServiceFault(e);
        }
    }

    public static void deployDataService(AxisConfiguration axisConfig, byte[] wsdlContent) throws DataServiceFault {
        try {
            AxisService axisService = WSDLToDataService.getAxisServiceFromWSDL(wsdlContent);
            String serviceName = axisService.getName();
            DataService dataService = WSDLToDataService.createDataServiceFromAxisService(axisService);
            String dsContents = DataServiceSerializer.serializeDataService(dataService).toString();
            WSDLToDataService.writeToRepository(axisConfig, serviceName, dsContents);
        }
        catch (DataServiceFault e) {
            log.error((Object)"Error in deploying contract first data service", (Throwable)e);
            throw e;
        }
    }

    private static AxisService getAxisServiceFromWSDL(byte[] wsdlContent) throws DataServiceFault {
        try {
            ByteArrayInputStream byteIn = new ByteArrayInputStream(wsdlContent);
            AxisService axisService = WSDLToDataService.isWSDL20(wsdlContent) ? new WSDL20ToAxisServiceBuilder((InputStream)byteIn, null, null).populateService() : new WSDL11ToAxisServiceBuilder((InputStream)byteIn, null, null).populateService();
            return axisService;
        }
        catch (AxisFault e) {
            String message = "Error in getting AxisService from WSDL";
            throw new DataServiceFault(e, message);
        }
    }

    private static void writeToRepository(AxisConfiguration axisConfig, String serviceName, String dsContents) throws DataServiceFault {
        try {
            URL repositoryURL = axisConfig.getRepository();
            String dataservicesFile = repositoryURL.getPath() + File.separator + "dataservices" + File.separator + serviceName + "." + "dbs";
            File parentFile = new File(dataservicesFile).getParentFile();
            if (!parentFile.exists()) {
                parentFile.mkdirs();
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(dataservicesFile));
            writer.write(dsContents);
            writer.close();
            XMLPrettyPrinter.prettify((File)new File(dataservicesFile));
        }
        catch (IOException e) {
            String message = "Error in writing the contract first data service to the repository";
            throw new DataServiceFault(e, message);
        }
    }

    private static Config getDummyConfig(DataService dataService, String configId) throws DataServiceFault {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("driverClassName", null);
        props.put("url", null);
        props.put("username", null);
        props.put("password", null);
        RDBMSConfig config = new RDBMSConfig(dataService, configId, props);
        return config;
    }

    private static String extractServiceNameFromHeirachicalName(String name) {
        int lastIndex = name.length() - 1;
        int index = name.lastIndexOf(92);
        if (index != -1 && index < lastIndex) {
            return name.substring(index + 1);
        }
        index = name.lastIndexOf(47);
        if (index != -1 && index < lastIndex) {
            return name.substring(index + 1);
        }
        return name;
    }

    private static DataService createDataServiceFromAxisService(AxisService axisService) throws DataServiceFault {
        HashMap elementMap;
        Map modelMap;
        DataService dataService = new DataService(WSDLToDataService.extractServiceNameFromHeirachicalName(axisService.getName()), null, null, null, "inactive", false, false, null);
        dataService.setAuthorizationProvider(new UserStoreAuthorizationProvider());
        String dummyConfigId = "default";
        dataService.addConfig(WSDLToDataService.getDummyConfig(dataService, dummyConfigId));
        try {
            CompilerOptions options = new CompilerOptions();
            SchemaCompiler schemaCompiler = new SchemaCompiler(options);
            schemaCompiler.compile((List)axisService.getSchema());
            modelMap = schemaCompiler.getProcessedModelMap();
            elementMap = schemaCompiler.getProcessedElementMap();
        }
        catch (SchemaCompilationException e) {
            throw new DataServiceFault(e, "Error in schema compile");
        }
        Iterator axisOperations = axisService.getOperations();
        while (axisOperations.hasNext()) {
            AxisOperation axisOperation = (AxisOperation)axisOperations.next();
            String operationName = axisOperation.getName().getLocalPart();
            String queryId = operationName + "Query";
            List<QueryParam> queryParams = WSDLToDataService.getQueryParamsFromAxisOperation(modelMap, elementMap, axisOperation);
            dataService.addQuery(new SQLQuery(dataService, queryId, dummyConfigId, false, false, null, "dummy", queryParams, WSDLToDataService.getResultFromAxisOperation(dataService, axisOperation), null, null, new HashMap<String, String>(), dataService.getServiceNamespace()));
            dataService.addOperation(new Operation(dataService, operationName, null, WSDLToDataService.getOperationCallQueryFromQueryParams(dataService, queryId, queryParams), false, null, false, false));
        }
        return dataService;
    }

    private static CallQuery getOperationCallQueryFromQueryParams(DataService dataService, String queryId, List<QueryParam> queryParams) throws DataServiceFault {
        HashMap<String, CallQuery.WithParam> withParams = new HashMap<String, CallQuery.WithParam>();
        for (QueryParam qp : queryParams) {
            withParams.put(qp.getName(), new CallQuery.WithParam(qp.getName(), qp.getName(), qp.getName(), "query-param"));
        }
        return new CallQuery(dataService, queryId, withParams, new HashSet<String>());
    }

    private static AxisMessage getAxisMessageFromOperation(AxisOperation axisOperation, String direction) {
        Iterator msgs = axisOperation.getMessages();
        AxisMessage tmpAxisMessage = null;
        while (msgs.hasNext()) {
            tmpAxisMessage = (AxisMessage)msgs.next();
            if (!tmpAxisMessage.getDirection().equals(direction)) continue;
            return tmpAxisMessage;
        }
        return null;
    }

    public static void printDOM(Document dom) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            DOMSource domSource = new DOMSource(dom);
            StreamResult streamResult = new StreamResult(System.out);
            transformer.transform(domSource, streamResult);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static List<QueryParam> getQueryParamsFromAxisOperation(Map<QName, Document> modelMap, Map<QName, String> elementMap, AxisOperation axisOperation) throws DataServiceFault {
        AxisMessage axisMessage = WSDLToDataService.getAxisMessageFromOperation(axisOperation, "in");
        if (axisMessage == null) {
            throw new DataServiceFault("Valid in message cannot be found for the operation '" + axisOperation.getName() + "'");
        }
        XmlSchemaElement inMsgElement = axisMessage.getSchemaElement();
        if (inMsgElement == null) {
            return new ArrayList<QueryParam>();
        }
        XmlSchemaType inMsgType = inMsgElement.getSchemaType();
        if (!(inMsgType instanceof XmlSchemaComplexType)) {
            throw new DataServiceFault("Xmlschema complex type is expected for the in message of the operation '" + axisOperation.getName() + "'");
        }
        QName inMsgTypeName = inMsgElement.getQName();
        String elementName = elementMap.get(inMsgTypeName);
        Document operationDoc = modelMap.get(new QName(inMsgTypeName.getNamespaceURI(), elementName));
        ModelBean operationBean = WSDLToDataService.createModelBean(modelMap, operationDoc);
        ArrayList<QueryParam> queryParams = new ArrayList<QueryParam>();
        List<ModelProperty> props = operationBean.getProperties();
        int count = props.size();
        for (int i = 0; i < count; ++i) {
            ModelProperty prop = props.get(i);
            String tmpType = prop.getSimpleType();
            if (tmpType == null) {
                if (prop.getType().isSimple()) {
                    tmpType = prop.getType().getProperties().get(0).getSimpleType();
                } else {
                    throw new DataServiceFault("A list of elements with simple types are expected at the in message of the operation '" + axisOperation.getName() + "'");
                }
            }
            queryParams.add(new QueryParam(prop.getName(), DBUtils.getSQLTypeFromXsdType(tmpType), "IN", prop.isArray() ? "ARRAY" : "SCALAR", i + 1, null, null, new ArrayList<Validator>(), false, false));
        }
        return queryParams;
    }

    private static Result getResultFromAxisOperation(DataService dataService, AxisOperation axisOperation) throws DataServiceFault {
        XmlSchemaComplexType dataFieldsType;
        AxisMessage axisMessage = WSDLToDataService.getAxisMessageFromOperation(axisOperation, "out");
        if (axisMessage == null) {
            return null;
        }
        String elementName = null;
        String rowName = null;
        String namespace = null;
        XmlSchemaElement wrapperSchemaElement = axisMessage.getSchemaElement();
        elementName = wrapperSchemaElement.getName();
        namespace = wrapperSchemaElement.getQName().getNamespaceURI();
        XmlSchemaType wrapperSchemaType = wrapperSchemaElement.getSchemaType();
        if (!(wrapperSchemaType instanceof XmlSchemaComplexType)) {
            throw new DataServiceFault("Xmlschema complex type is expected for the out message of the operation '" + axisOperation.getName() + "'");
        }
        XmlSchemaComplexType wrapperSchemaComplexType = (XmlSchemaComplexType)wrapperSchemaType;
        if (WSDLToDataService.hasResultRowName(wrapperSchemaComplexType)) {
            rowName = WSDLToDataService.getResultRowName(wrapperSchemaComplexType);
            dataFieldsType = WSDLToDataService.getRowNameBasedSchemaComplexType(wrapperSchemaComplexType);
        } else {
            dataFieldsType = wrapperSchemaComplexType;
        }
        Result result = new Result(elementName, rowName, namespace, null, 2);
        OutputElementGroup defGroup = new OutputElementGroup(null, null, null, null);
        XmlSchemaObjectCollection dataSchemaObjects = WSDLToDataService.getSchemaObjectsFromComplexType(dataFieldsType);
        int count = dataSchemaObjects.getCount();
        for (int i = 0; i < count; ++i) {
            XmlSchemaObject sequenceDataObject = dataSchemaObjects.getItem(i);
            if (sequenceDataObject instanceof XmlSchemaElement) {
                XmlSchemaElement sequenceDataElement = (XmlSchemaElement)sequenceDataObject;
                if (!(sequenceDataElement.getSchemaType() instanceof XmlSchemaSimpleType)) {
                    throw new DataServiceFault("Xmlschema sequence's data fields at the out message of the operation '" + axisOperation.getName() + "' should only contain xml elements with simple types");
                }
                defGroup.addElementEntry(new StaticOutputElement(dataService, sequenceDataElement.getName(), sequenceDataElement.getName(), sequenceDataElement.getName(), "column", "element", namespace, sequenceDataElement.getSchemaTypeName(), new HashSet<String>(), 1, 2, null, 1, null));
                continue;
            }
            if (sequenceDataObject instanceof XmlSchemaAttribute) {
                XmlSchemaAttribute sequenceDataAttr = (XmlSchemaAttribute)sequenceDataObject;
                defGroup.addElementEntry(new StaticOutputElement(dataService, sequenceDataAttr.getName(), sequenceDataAttr.getName(), sequenceDataAttr.getName(), "column", "attribute", namespace, sequenceDataAttr.getSchemaTypeName(), new HashSet<String>(), 1, 2, null, 1, null));
                continue;
            }
            throw new DataServiceFault("Xmlschema sequence at the out message's data field section of the operation '" + axisOperation.getName() + "' should only contain xml elements/attributes");
        }
        result.setDefaultElementGroup(defGroup);
        return result;
    }

    private static boolean hasResultRowName(XmlSchemaComplexType wrapperSchemaComplexType) {
        XmlSchemaParticle wrapperSchemaParticle = wrapperSchemaComplexType.getParticle();
        if (!(wrapperSchemaParticle instanceof XmlSchemaSequence)) {
            return false;
        }
        XmlSchemaSequence wrapperSchemaSequence = (XmlSchemaSequence)wrapperSchemaParticle;
        XmlSchemaObjectCollection objects = wrapperSchemaSequence.getItems();
        if (objects.getCount() != 1) {
            return false;
        }
        XmlSchemaObject schemaObject = objects.getItem(0);
        if (!(schemaObject instanceof XmlSchemaElement)) {
            return false;
        }
        XmlSchemaElement schemaElement = (XmlSchemaElement)schemaObject;
        if (!(((XmlSchemaComplexType)schemaElement.getSchemaType()).getParticle() instanceof XmlSchemaSequence)) {
            return false;
        }
        return wrapperSchemaComplexType.getAttributes().getCount() <= 0;
    }

    private static String getResultRowName(XmlSchemaComplexType wrapperSchemaComplexType) {
        return ((XmlSchemaElement)((XmlSchemaSequence)wrapperSchemaComplexType.getParticle()).getItems().getItem(0)).getName();
    }

    private static XmlSchemaComplexType getRowNameBasedSchemaComplexType(XmlSchemaComplexType wrapperSchemaComplexType) {
        return (XmlSchemaComplexType)((XmlSchemaElement)((XmlSchemaSequence)wrapperSchemaComplexType.getParticle()).getItems().getItem(0)).getSchemaType();
    }

    private static XmlSchemaObjectCollection getSchemaObjectsFromComplexType(XmlSchemaComplexType schemaComplexType) {
        int i;
        int c;
        XmlSchemaObjectCollection collection = new XmlSchemaObjectCollection();
        XmlSchemaSequence sequence = (XmlSchemaSequence)schemaComplexType.getParticle();
        if (sequence != null) {
            XmlSchemaObjectCollection seqItems = sequence.getItems();
            c = seqItems.getCount();
            for (i = 0; i < c; ++i) {
                collection.add(seqItems.getItem(i));
            }
        }
        XmlSchemaObjectCollection attrItems = schemaComplexType.getAttributes();
        c = attrItems.getCount();
        for (i = 0; i < c; ++i) {
            collection.add(attrItems.getItem(i));
        }
        return collection;
    }

    private static ModelBean createModelBean(Map<QName, Document> modelMap, QName typeName) {
        return WSDLToDataService.createModelBean(modelMap, modelMap.get(typeName));
    }

    private static ModelBean createModelBean(Map<QName, Document> modelMap, Document doc) {
        ModelBean bean = new ModelBean();
        if (doc == null) {
            return null;
        }
        Node beanEl = doc.getFirstChild();
        NamedNodeMap beanAttrs = beanEl.getAttributes();
        bean.setName(beanAttrs.getNamedItem("originalName").getNodeValue());
        bean.setNsURI(beanAttrs.getNamedItem("nsuri").getNodeValue());
        Node isSimpleNode = beanAttrs.getNamedItem("simple");
        if (isSimpleNode != null) {
            bean.setSimple("yes".equals(isSimpleNode.getNodeValue()));
        } else {
            bean.setSimple(false);
        }
        NodeList propsElList = beanEl.getChildNodes();
        int count = propsElList.getLength();
        for (int i = 0; i < count; ++i) {
            Node propEl = propsElList.item(i);
            bean.addProperty(WSDLToDataService.createModelProperty(modelMap, propEl));
        }
        return bean;
    }

    private static ModelProperty createModelProperty(Map<QName, Document> modelMap, Node propEl) {
        ModelProperty property = new ModelProperty();
        NamedNodeMap propAttrs = propEl.getAttributes();
        property.setName(propAttrs.getNamedItem("name").getNodeValue());
        Node isArrayNode = propAttrs.getNamedItem("array");
        if (isArrayNode != null) {
            property.setArray("yes".equals(isArrayNode.getNodeValue()));
        } else {
            property.setArray(false);
        }
        Node isPrimitiveNode = propAttrs.getNamedItem("primitive");
        boolean primitive = isPrimitiveNode != null ? "yes".equals(isPrimitiveNode.getNodeValue()) : false;
        Node isSimpleNode = propAttrs.getNamedItem("simple");
        boolean simple = isSimpleNode != null ? "yes".equals(isSimpleNode.getNodeValue()) : false;
        ModelBean type = null;
        if (!primitive && !simple) {
            type = WSDLToDataService.createModelBean(modelMap, new QName(propAttrs.getNamedItem("nsuri").getNodeValue(), propAttrs.getNamedItem("shorttypename").getNodeValue()));
        }
        if (type != null) {
            property.setType(type);
        } else {
            property.setSimpleType(propAttrs.getNamedItem("shorttypename").getNodeValue());
        }
        return property;
    }

    public static class ModelProperty {
        private String name;
        private boolean array;
        private String simpleType;
        private ModelBean type;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isArray() {
            return this.array;
        }

        public void setArray(boolean array) {
            this.array = array;
        }

        public String getSimpleType() {
            return this.simpleType;
        }

        public void setSimpleType(String simpleType) {
            this.simpleType = simpleType;
        }

        public ModelBean getType() {
            return this.type;
        }

        public void setType(ModelBean type) {
            this.type = type;
        }

        public String toString() {
            StringBuffer buff = new StringBuffer();
            buff.append("{\n");
            buff.append("Name:" + this.getName() + "\n");
            buff.append("IsArray:" + this.isArray() + "\n");
            if (this.getType() != null) {
                buff.append("Type:" + this.getType() + "\n");
            } else {
                buff.append("Type:" + this.getSimpleType());
            }
            buff.append("}\n");
            return buff.toString();
        }
    }

    public static class ModelBean {
        private boolean simple;
        private String nsURI;
        private String name;
        private List<ModelProperty> properties = new ArrayList<ModelProperty>();

        public boolean isSimple() {
            return this.simple;
        }

        public void setSimple(boolean simple) {
            this.simple = simple;
        }

        public String getNsURI() {
            return this.nsURI;
        }

        public void setNsURI(String nsURI) {
            this.nsURI = nsURI;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<ModelProperty> getProperties() {
            return this.properties;
        }

        public void setProperties(List<ModelProperty> properties) {
            this.properties = properties;
        }

        public void addProperty(ModelProperty property) {
            this.getProperties().add(property);
        }

        public String toString() {
            StringBuffer buff = new StringBuffer();
            buff.append("{\n");
            buff.append("Name:" + this.getName() + "\n");
            buff.append("NsURI:" + this.getNsURI() + "\n");
            buff.append("Properties: {\n");
            List<ModelProperty> propsList = this.getProperties();
            int count = propsList.size();
            for (int i = 0; i < count; ++i) {
                buff.append(propsList.get(i).toString());
                if (i + 1 >= count) continue;
                buff.append(",\n");
            }
            buff.append("}\n");
            buff.append("}\n");
            return buff.toString();
        }
    }
}

