/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.description.config;

import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.custom.datasource.CustomQueryDataSourceReader;
import org.wso2.carbon.dataservices.core.custom.datasource.CustomTabularDataSourceReader;
import org.wso2.carbon.dataservices.core.description.config.CSVConfig;
import org.wso2.carbon.dataservices.core.description.config.CassandraConfig;
import org.wso2.carbon.dataservices.core.description.config.Config;
import org.wso2.carbon.dataservices.core.description.config.CustomQueryCarbonDataSourceConfig;
import org.wso2.carbon.dataservices.core.description.config.ExcelConfig;
import org.wso2.carbon.dataservices.core.description.config.GSpreadConfig;
import org.wso2.carbon.dataservices.core.description.config.InlineCustomQueryBasedDSConfig;
import org.wso2.carbon.dataservices.core.description.config.JNDIConfig;
import org.wso2.carbon.dataservices.core.description.config.MongoConfig;
import org.wso2.carbon.dataservices.core.description.config.RDBMSConfig;
import org.wso2.carbon.dataservices.core.description.config.RDFConfig;
import org.wso2.carbon.dataservices.core.description.config.SQLCarbonDataSourceConfig;
import org.wso2.carbon.dataservices.core.description.config.SparqlEndpointConfig;
import org.wso2.carbon.dataservices.core.description.config.TabularDataBasedConfig;
import org.wso2.carbon.dataservices.core.description.config.WebConfig;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.internal.DataServicesDSComponent;
import org.wso2.carbon.ndatasource.core.CarbonDataSource;
import org.wso2.carbon.ndatasource.core.DataSourceService;

public class ConfigFactory {
    private ConfigFactory() {
    }

    public static Config createConfig(DataService dataService, OMElement configEl) throws DataServiceFault {
        Map<String, String> properties = DBUtils.extractProperties(configEl);
        String configId = ConfigFactory.getConfigId(configEl);
        String configType = ConfigFactory.getConfigType(properties);
        boolean odataEnable = ConfigFactory.isODataEnable(configEl);
        if ("RDBMS".equals(configType)) {
            return ConfigFactory.getRDBMSConfig(dataService, configId, properties, odataEnable);
        }
        if ("JNDI".equals(configType)) {
            return ConfigFactory.getJNDIConfig(dataService, configId, properties, odataEnable);
        }
        if ("MongoDB".equals(configType)) {
            return ConfigFactory.getMongoConfig(dataService, configId, properties, odataEnable);
        }
        if ("EXCEL".equals(configType)) {
            return ConfigFactory.getExcelConfig(dataService, configId, properties, odataEnable);
        }
        if ("RDF".equals(configType)) {
            return ConfigFactory.getRDFConfig(dataService, configId, properties, odataEnable);
        }
        if ("SPARQL".equals(configType)) {
            return ConfigFactory.getSparqlEndpointConfig(dataService, configId, properties, odataEnable);
        }
        if ("CSV".equals(configType)) {
            return ConfigFactory.getCSVConfig(dataService, configId, properties, odataEnable);
        }
        if ("GDATA_SPREADSHEET".equals(configType)) {
            return ConfigFactory.getGSpreadConfig(dataService, configId, properties, odataEnable);
        }
        if ("CARBON_DATASOURCE".equals(configType)) {
            return ConfigFactory.getCarbonDataSourceConfig(dataService, configId, properties, odataEnable);
        }
        if ("WEB_CONFIG".equals(configType)) {
            return ConfigFactory.getWebConfig(dataService, configId, properties, odataEnable);
        }
        if ("CUSTOM_TABULAR".equals(configType)) {
            return ConfigFactory.getCustomTabularConfig(dataService, configId, properties, odataEnable);
        }
        if ("CUSTOM_QUERY".equals(configType)) {
            return ConfigFactory.getCustomQueryConfig(dataService, configId, properties, odataEnable);
        }
        if ("Cassandra".equals(configType)) {
            return ConfigFactory.getCassandraConfig(dataService, configId, properties, odataEnable);
        }
        return null;
    }

    private static RDBMSConfig getRDBMSConfig(DataService dataService, String configId, Map<String, String> properties, boolean odataEnable) throws DataServiceFault {
        RDBMSConfig config = new RDBMSConfig(dataService, configId, properties, odataEnable);
        return config;
    }

    private static JNDIConfig getJNDIConfig(DataService dataService, String configId, Map<String, String> properties, boolean odataEnable) throws DataServiceFault {
        JNDIConfig config = new JNDIConfig(dataService, configId, properties, odataEnable);
        return config;
    }

    private static MongoConfig getMongoConfig(DataService dataService, String configId, Map<String, String> properties, boolean odataEnable) throws DataServiceFault {
        MongoConfig config = new MongoConfig(dataService, configId, properties, odataEnable);
        return config;
    }

    private static ExcelConfig getExcelConfig(DataService dataService, String configId, Map<String, String> properties, boolean odataEnable) throws DataServiceFault {
        ExcelConfig config = new ExcelConfig(dataService, configId, properties, odataEnable);
        return config;
    }

    private static RDFConfig getRDFConfig(DataService dataService, String configId, Map<String, String> properties, boolean odataEnable) throws DataServiceFault {
        RDFConfig config = new RDFConfig(dataService, configId, properties, odataEnable);
        return config;
    }

    private static SparqlEndpointConfig getSparqlEndpointConfig(DataService dataService, String configId, Map<String, String> properties, boolean odataEnable) throws DataServiceFault {
        SparqlEndpointConfig config = new SparqlEndpointConfig(dataService, configId, properties, odataEnable);
        return config;
    }

    private static CSVConfig getCSVConfig(DataService dataService, String configId, Map<String, String> properties, boolean odataEnable) throws DataServiceFault {
        CSVConfig config = new CSVConfig(dataService, configId, properties, odataEnable);
        return config;
    }

    private static CassandraConfig getCassandraConfig(DataService dataService, String configId, Map<String, String> properties, boolean odataEnable) throws DataServiceFault {
        CassandraConfig config = new CassandraConfig(dataService, configId, properties, odataEnable);
        return config;
    }

    private static WebConfig getWebConfig(DataService dataService, String configId, Map<String, String> properties, boolean odataEnable) throws DataServiceFault {
        WebConfig config = new WebConfig(dataService, configId, properties, odataEnable);
        return config;
    }

    private static TabularDataBasedConfig getCustomTabularConfig(DataService dataService, String configId, Map<String, String> properties, boolean odataEnable) throws DataServiceFault {
        TabularDataBasedConfig config = new TabularDataBasedConfig(dataService, configId, properties, odataEnable);
        return config;
    }

    private static InlineCustomQueryBasedDSConfig getCustomQueryConfig(DataService dataService, String configId, Map<String, String> properties, boolean odataEnable) throws DataServiceFault {
        InlineCustomQueryBasedDSConfig config = new InlineCustomQueryBasedDSConfig(dataService, configId, properties, odataEnable);
        return config;
    }

    private static GSpreadConfig getGSpreadConfig(DataService dataService, String configId, Map<String, String> properties, boolean odataEnable) throws DataServiceFault {
        GSpreadConfig config = new GSpreadConfig(dataService, configId, properties, odataEnable);
        return config;
    }

    private static Config getCarbonDataSourceConfig(DataService dataService, String configId, Map<String, String> properties, boolean odataEnable) throws DataServiceFault {
        DataSourceService dataSourceService = DataServicesDSComponent.getDataSourceService();
        try {
            String name = properties.get("carbon_datasource_name");
            CarbonDataSource cds = dataSourceService.getDataSource(name);
            if (cds == null) {
                throw new DataServiceFault("The Carbon data source '" + name + "' cannot be found");
            }
            String dsType = cds.getDSMInfo().getDefinition().getType();
            if ("RDBMS".equals(dsType) || CustomTabularDataSourceReader.DATA_SOURCE_TYPE.equals(dsType)) {
                return new SQLCarbonDataSourceConfig(dataService, configId, properties, odataEnable);
            }
            if (CustomQueryDataSourceReader.DATA_SOURCE_TYPE.equals(dsType)) {
                return new CustomQueryCarbonDataSourceConfig(dataService, configId, properties, odataEnable);
            }
            throw new DataServiceFault("Unsupported Carbon data source type '" + dsType + "'");
        }
        catch (DataServiceFault e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataServiceFault(e, "Error in creating Carbon data source: " + e.getMessage());
        }
    }

    private static String getConfigId(OMElement configEl) {
        String configId = configEl.getAttributeValue(new QName("id"));
        if (configId == null) {
            configId = "default";
        }
        return configId;
    }

    private static boolean isODataEnable(OMElement configEl) {
        String odataConfig = configEl.getAttributeValue(new QName("enableOData"));
        if (odataConfig == null) {
            return false;
        }
        return Boolean.valueOf(odataConfig);
    }

    private static String getConfigType(Map<String, String> properties) throws DataServiceFault {
        if (properties.get("driverClassName") != null || properties.get("org.wso2.ws.dataservice.driver") != null || properties.get("dataSourceClassName") != null || properties.get("org.wso2.ws.dataservice.xa_datasource_class") != null) {
            return "RDBMS";
        }
        if (properties.get("excel_datasource") != null) {
            return "EXCEL";
        }
        if (properties.get("rdf_datasource") != null) {
            return "RDF";
        }
        if (properties.get("sparql_datasource") != null) {
            return "SPARQL";
        }
        if (properties.get("csv_datasource") != null) {
            return "CSV";
        }
        if (properties.get("jndi_resource_name") != null) {
            return "JNDI";
        }
        if (properties.get("mongoDB_servers") != null) {
            return "MongoDB";
        }
        if (properties.get("gspread_datasource") != null) {
            return "GDATA_SPREADSHEET";
        }
        if (properties.get("carbon_datasource_name") != null) {
            return "CARBON_DATASOURCE";
        }
        if (properties.get("web_harvest_config") != null) {
            return "WEB_CONFIG";
        }
        if (properties.get("custom_tabular_datasource_class") != null) {
            return "CUSTOM_TABULAR";
        }
        if (properties.get("custom_query_datasource_class") != null) {
            return "CUSTOM_QUERY";
        }
        if (properties.get("cassandraServers") != null) {
            return "Cassandra";
        }
        throw new DataServiceFault("Cannot create config with properties: " + properties);
    }
}

