/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.description.query;

import au.com.bytecode.opencsv.CSVReader;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.description.config.CSVConfig;
import org.wso2.carbon.dataservices.core.description.event.EventTrigger;
import org.wso2.carbon.dataservices.core.description.query.Query;
import org.wso2.carbon.dataservices.core.engine.DataEntry;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.engine.InternalParamCollection;
import org.wso2.carbon.dataservices.core.engine.ParamValue;
import org.wso2.carbon.dataservices.core.engine.QueryParam;
import org.wso2.carbon.dataservices.core.engine.Result;

public class CSVQuery
extends Query {
    private static final Log log = LogFactory.getLog(CSVQuery.class);
    private CSVConfig config;

    public CSVQuery(DataService dataService, String queryId, List<QueryParam> queryParams, String configId, Result result, EventTrigger inputEventTrigger, EventTrigger outputEventTrigger, Map<String, String> advancedProperties, String inputNamespace) throws DataServiceFault {
        super(dataService, queryId, queryParams, result, configId, inputEventTrigger, outputEventTrigger, advancedProperties, inputNamespace);
        try {
            this.config = (CSVConfig)this.getDataService().getConfig(this.getConfigId());
        }
        catch (ClassCastException e) {
            throw new DataServiceFault(e, "Configuration is not a CSV config:" + this.getConfigId());
        }
    }

    public CSVConfig getConfig() {
        return this.config;
    }

    @Override
    public Object runPreQuery(InternalParamCollection params, int queryLevel) throws DataServiceFault {
        CSVReader reader = null;
        boolean isError = false;
        try {
            CSVReader cSVReader = reader = this.getConfig().createCSVReader();
            return cSVReader;
        }
        catch (Exception e) {
            isError = true;
            throw new DataServiceFault(e, "Error in CSVQuery.runQuery.");
        }
        finally {
            if (reader != null && isError) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    log.error((Object)"Error in closing CSV reader", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void runPostQuery(Object result, XMLStreamWriter xmlWriter, InternalParamCollection params, int queryLevel) throws DataServiceFault {
        CSVReader reader = null;
        boolean isError = false;
        try {
            String[] record;
            reader = (CSVReader)result;
            int maxCount = this.getConfig().getMaxRowCount();
            int i = 0;
            Map<Integer, String> columnsMap = this.getConfig().getColumnMappings();
            boolean useColumnNumbers = this.isUsingColumnNumbers();
            while ((record = reader.readNext()) != null) {
                if (maxCount != -1 && i >= maxCount) {
                    break;
                }
                DataEntry dataEntry = new DataEntry();
                for (int j = 0; j < record.length; ++j) {
                    dataEntry.addValue(useColumnNumbers ? Integer.toString(j + 1) : columnsMap.get(j + 1), new ParamValue(record[j]));
                }
                this.writeResultEntry(xmlWriter, dataEntry, params, queryLevel);
                ++i;
            }
        }
        catch (Exception e) {
            isError = true;
            throw new DataServiceFault(e, "Error in CSVQuery.runQuery.");
        }
        finally {
            if (reader != null || isError) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    log.error((Object)"Error in closing CSV reader", (Throwable)e);
                }
            }
        }
    }
}

